/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenActionUtil {
    private MavenActionUtil() {
    }

    public static boolean hasProject(DataContext context2) {
        return CommonDataKeys.PROJECT.getData(context2) != null;
    }

    @Nullable
    public static Project getProject(DataContext context2) {
        return (Project)CommonDataKeys.PROJECT.getData(context2);
    }

    public static boolean isMavenizedProject(DataContext context2) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project == null) {
            return false;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstanceIfCreated(project);
        if (mavenProjectsManager == null) {
            return false;
        }
        return mavenProjectsManager.isMavenizedProject();
    }

    @Nullable
    public static MavenProject getMavenProject(DataContext context2) {
        MavenProject result;
        MavenProjectsManager manager = MavenActionUtil.getProjectsManager(context2);
        if (manager == null) {
            return null;
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context2);
        if (file2 != null && (result = manager.findProject(file2)) != null) {
            return result;
        }
        Module module = ExternalSystemActionUtil.getModule((DataContext)context2);
        if (module != null && (result = manager.findProject(module)) != null) {
            return result;
        }
        return null;
    }

    @Nullable
    public static MavenProjectsManager getProjectsManager(DataContext context2) {
        Project project = MavenActionUtil.getProject(context2);
        if (project == null) {
            return null;
        }
        return MavenProjectsManager.getInstanceIfCreated(project);
    }

    public static boolean isMavenProjectFile(VirtualFile file2) {
        return file2 != null && !file2.isDirectory() && file2.isInLocalFileSystem() && MavenUtil.isPomFile(file2);
    }

    public static List<MavenProject> getMavenProjects(DataContext context2) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project == null) {
            return Collections.emptyList();
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(context2);
        if (virtualFiles == null || virtualFiles.length == 0) {
            return Collections.emptyList();
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstanceIfCreated(project);
        if (projectsManager == null || !projectsManager.isMavenizedProject()) {
            return Collections.emptyList();
        }
        LinkedHashSet<MavenProject> res = new LinkedHashSet<MavenProject>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile file2 : virtualFiles) {
            MavenProject mavenProject;
            if (file2.isDirectory()) {
                VirtualFile contentRoot = fileIndex.getContentRootForFile(file2);
                if (!file2.equals(contentRoot)) {
                    return Collections.emptyList();
                }
                Module module = fileIndex.getModuleForFile(file2);
                if (module == null || !projectsManager.isMavenizedModule(module)) {
                    return Collections.emptyList();
                }
                mavenProject = projectsManager.findProject(module);
            } else {
                mavenProject = projectsManager.findProject(file2);
            }
            if (mavenProject == null) {
                return Collections.emptyList();
            }
            res.add(mavenProject);
        }
        return new ArrayList<MavenProject>(res);
    }

    public static List<VirtualFile> getMavenProjectsFiles(DataContext context2) {
        return MavenUtil.collectFiles(MavenActionUtil.getMavenProjects(context2));
    }
}

