/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.completion.backend.split;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.platform.completion.backend.split.BackendCompletionLoggerKt;
import com.intellij.platform.completion.backend.split.BackendCompletionSession;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequest;
import com.intellij.platform.completion.common.protocol.RpcCompletionRequestId;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import fleet.util.UID;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0012J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0012H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/completion/backend/split/BackendCompletionService;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lfleet/util/UID;", "Lcom/intellij/platform/completion/backend/split/BackendCompletionSession;", "lastSession", "Ljava/util/concurrent/atomic/AtomicReference;", "createSession", "request", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequest;", "findSession", "Lcom/intellij/platform/completion/common/protocol/RpcCompletionRequestId;", "closeSession", "", "evictAfter10Sec", "session", "getLastSession", "closeCurrentSession", "Companion", "intellij.platform.completion.backend.split"})
public final class BackendCompletionService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<UID, BackendCompletionSession> sessions;
    @NotNull
    private final AtomicReference<BackendCompletionSession> lastSession;

    public BackendCompletionService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.sessions = new ConcurrentHashMap();
        this.lastSession = new AtomicReference<Object>(null);
    }

    @NotNull
    public final BackendCompletionSession createSession(@NotNull RpcCompletionRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.closeCurrentSession();
        BackendCompletionSession session = BackendCompletionSession.Companion.create(request, CoroutineScopeKt.childScope$default((CoroutineScope)this.coroutineScope, (String)("BackendCompletionSession id=" + request.getId()), null, (boolean)false, (int)6, null), this.project);
        ((Map)this.sessions).put(request.getId().getId(), session);
        this.lastSession.set(session);
        return session;
    }

    @Nullable
    public final BackendCompletionSession findSession(@NotNull RpcCompletionRequestId request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.sessions.get(request.getId());
    }

    public final void closeSession(@NotNull RpcCompletionRequestId request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        BackendCompletionSession backendCompletionSession = this.sessions.get(request.getId());
        if (backendCompletionSession == null) {
            BackendCompletionService $this$closeSession_u24lambda_u240 = this;
            boolean bl = false;
            BackendCompletionLoggerKt.getBcLogger().error("No session found for request: " + request);
            return;
        }
        BackendCompletionSession session = backendCompletionSession;
        session.stop();
        this.evictAfter10Sec(session, request);
    }

    private final void evictAfter10Sec(BackendCompletionSession session, RpcCompletionRequestId request) {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, session, request, null){
            int label;
            final /* synthetic */ BackendCompletionService this$0;
            final /* synthetic */ BackendCompletionSession $session;
            final /* synthetic */ RpcCompletionRequestId $request;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                this.$request = $request;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        BackendCompletionService.access$getLastSession$p(this.this$0).compareAndSet(this.$session, null);
                        BackendCompletionService.access$getSessions$p(this.this$0).remove(this.$request.getId());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final BackendCompletionSession getLastSession() {
        return this.lastSession.get();
    }

    private final void closeCurrentSession() {
        BackendCompletionSession backendCompletionSession = this.lastSession.get();
        if (backendCompletionSession == null || (backendCompletionSession = backendCompletionSession.getRequest()) == null || (backendCompletionSession = backendCompletionSession.getId()) == null) {
            return;
        }
        BackendCompletionSession id = backendCompletionSession;
        this.closeSession((RpcCompletionRequestId)id);
    }

    public static final /* synthetic */ AtomicReference access$getLastSession$p(BackendCompletionService $this) {
        return $this.lastSession;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(BackendCompletionService $this) {
        return $this.sessions;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/completion/backend/split/BackendCompletionService$Companion;", "", "<init>", "()V", "getInstanceAsync", "Lcom/intellij/platform/completion/backend/split/BackendCompletionService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.completion.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendCompletionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendCompletionService.kt\ncom/intellij/platform/completion/backend/split/BackendCompletionService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n75#2:81\n*S KotlinDebug\n*F\n+ 1 BackendCompletionService.kt\ncom/intellij/platform/completion/backend/split/BackendCompletionService$Companion\n*L\n77#1:81\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super BackendCompletionService> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
            return ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(BackendCompletionService.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

