/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.diagram;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.diagrams.perspectives.beans.SpringElementWrapperBase;
import com.intellij.spring.integration.model.jam.SpringIntegrationJamMethodEndpoint;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringIntegrationMessageEndpointWrapper
extends SpringElementWrapperBase<SpringIntegrationJamMethodEndpoint> {
    private static final String PSI_CLASS = "containingClass";
    private static final String PSI_METHOD = "method";
    private static final String OFFSET = "offset";
    private final Module myModule;

    private SpringIntegrationMessageEndpointWrapper(@NotNull SpringIntegrationJamMethodEndpoint pointer, Module module) {
        if (pointer == null) {
            SpringIntegrationMessageEndpointWrapper.$$$reportNull$$$0(0);
        }
        super((Object)pointer);
        this.myModule = module;
    }

    public static SpringIntegrationMessageEndpointWrapper createMessageEndpointWrapper(SpringIntegrationJamMethodEndpoint pointer, Module module) {
        return new SpringIntegrationMessageEndpointWrapper(pointer, module);
    }

    public String getName() {
        return ((PsiMethod)((SpringIntegrationJamMethodEndpoint)this.getWrapped()).getPsiElement()).getName();
    }

    @NotNull
    public CommonSpringModel getProcessingSpringModel(boolean localModel) {
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(((SpringIntegrationJamMethodEndpoint)this.getWrapped()).getPsiElement());
        if (commonSpringModel == null) {
            SpringIntegrationMessageEndpointWrapper.$$$reportNull$$$0(1);
        }
        return commonSpringModel;
    }

    @NotNull
    public String getFqn() {
        SmartList pairs = new SmartList();
        SpringIntegrationJamMethodEndpoint endpoint = (SpringIntegrationJamMethodEndpoint)this.getWrapped();
        PsiMethod psiMethod = (PsiMethod)endpoint.getPsiElement();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null) {
            pairs.add(Pair.create((Object)PSI_CLASS, (Object)containingClass.getQualifiedName()));
            pairs.add(Pair.create((Object)PSI_METHOD, (Object)psiMethod.getName()));
            pairs.add(Pair.create((Object)OFFSET, (Object)Integer.toString(psiMethod.getTextOffset())));
            String string = StringUtil.join((Collection)pairs, pair -> (String)pair.first + "=" + (String)pair.second, (String)";");
            if (string == null) {
                SpringIntegrationMessageEndpointWrapper.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "<unknown>";
    }

    public Icon getIcon() {
        return ElementPresentationManager.getIcon((Object)this.getWrapped());
    }

    @Nullable
    public Module getModule() {
        return this.myModule;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/integration/diagram/SpringIntegrationMessageEndpointWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/integration/diagram/SpringIntegrationMessageEndpointWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingSpringModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

