/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.inspectionKts.ui;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationProvider;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.inspectionKts.ui.InspectionKtsBanner;
import org.jetbrains.qodana.inspectionKts.ui.InspectionKtsBannerKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/inspectionKts/ui/InspectionKtsBannerProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.qodana.inspectionKts"})
public final class InspectionKtsBannerProvider
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.endsWith$default((String)string, (String)"inspection.kts", (boolean)false, (int)2, null)) {
            return null;
        }
        return arg_0 -> InspectionKtsBannerProvider.collectNotificationData$lambda$0(file2, project, arg_0);
    }

    private static final InspectionKtsBanner collectNotificationData$lambda$0$0(Path $filePath, Project $project, FileEditor $fileEditor) {
        return new InspectionKtsBanner($filePath, $project, $fileEditor);
    }

    private static final InspectionKtsBanner collectNotificationData$lambda$0(VirtualFile $file, Project $project, FileEditor fileEditor) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (!(fileEditor instanceof UserDataHolderEx)) {
            return null;
        }
        try {
            path = $file.toNioPath();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Path path2;
            try {
                String string = $file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Path path3 = Paths.get(string, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                path2 = path3;
            }
            catch (InvalidPathException invalidPathException) {
                return null;
            }
            path = path2;
        }
        Path path4 = path;
        Intrinsics.checkNotNull((Object)path4);
        Path filePath = path4;
        Lazy newBanner = LazyKt.lazy(() -> InspectionKtsBannerProvider.collectNotificationData$lambda$0$0(filePath, $project, fileEditor));
        Object object = ((UserDataHolderEx)fileEditor).putUserDataIfAbsent(InspectionKtsBannerKt.access$getINSPECTION_KTS_BANNER_KEY$p(), (Object)newBanner);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"putUserDataIfAbsent(...)");
        Lazy currentBanner = (Lazy)object;
        return (InspectionKtsBanner)((Object)currentBanner.getValue());
    }
}

