/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.problemsView.tree.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\t\u0010\u0010\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0017\u001a\u00020\u0018H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/qodana/ui/problemsView/tree/model/ModuleData;", "", "project", "Lcom/intellij/openapi/project/Project;", "modulePath", "Ljava/nio/file/Path;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;Lcom/intellij/openapi/module/Module;)V", "getModulePath", "()Ljava/nio/file/Path;", "getModule", "()Lcom/intellij/openapi/module/Module;", "modulePathRelativeToProject", "getModulePathRelativeToProject", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nModuleData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleData.kt\norg/jetbrains/qodana/ui/problemsView/tree/model/ModuleData\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,20:1\n1#2:21\n*E\n"})
public final class ModuleData {
    @NotNull
    private final Project project;
    @NotNull
    private final Path modulePath;
    @NotNull
    private final Module module;
    @NotNull
    private final Path modulePathRelativeToProject;

    public ModuleData(@NotNull Project project, @NotNull Path modulePath, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.project = project;
        this.modulePath = modulePath;
        this.module = module;
        this.modulePathRelativeToProject = this.modulePathRelativeToProject(this.project);
    }

    @NotNull
    public final Path getModulePath() {
        return this.modulePath;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final Path getModulePathRelativeToProject() {
        return this.modulePathRelativeToProject;
    }

    private final Path modulePathRelativeToProject(Project project) {
        Object object;
        block5: {
            block4: {
                object = project.getBasePath();
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                Path path = Paths.get(it, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                object = path;
                if (path != null) break block5;
            }
            VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
            object = virtualFile != null ? virtualFile.toNioPath() : null;
            if (object == null) {
                Path path = Paths.get("", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                return path;
            }
        }
        Object projectNioPath = object;
        Path path = projectNioPath.relativize(this.modulePath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        return path;
    }

    private final Project component1() {
        return this.project;
    }

    @NotNull
    public final Path component2() {
        return this.modulePath;
    }

    @NotNull
    public final Module component3() {
        return this.module;
    }

    @NotNull
    public final ModuleData copy(@NotNull Project project, @NotNull Path modulePath, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new ModuleData(project, modulePath, module);
    }

    public static /* synthetic */ ModuleData copy$default(ModuleData moduleData, Project project, Path path, Module module, int n, Object object) {
        if ((n & 1) != 0) {
            project = moduleData.project;
        }
        if ((n & 2) != 0) {
            path = moduleData.modulePath;
        }
        if ((n & 4) != 0) {
            module = moduleData.module;
        }
        return moduleData.copy(project, path, module);
    }

    @NotNull
    public String toString() {
        return "ModuleData(project=" + this.project + ", modulePath=" + this.modulePath + ", module=" + this.module + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + ((Object)this.modulePath).hashCode();
        result2 = result2 * 31 + this.module.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModuleData)) {
            return false;
        }
        ModuleData moduleData = (ModuleData)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)moduleData.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.modulePath, (Object)moduleData.modulePath)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.module, (Object)moduleData.module);
    }
}

