/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.yaml;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import icons.QodanaIcons;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;
import org.jetbrains.qodana.yaml.QodanaLookupElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/yaml/QodanaProfileLookupElement;", "Lorg/jetbrains/qodana/yaml/QodanaLookupElement;", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;)V", "getProfile", "()Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "Companion", "intellij.qodana"})
public final class QodanaProfileLookupElement
extends QodanaLookupElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QodanaInspectionProfile profile;
    @NotNull
    private static final Map<String, String> PROFILE_DESCRIPTIONS;

    public QodanaProfileLookupElement(@NotNull QodanaInspectionProfile profile2) {
        Intrinsics.checkNotNullParameter((Object)((Object)profile2), (String)"profile");
        String string = profile2.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = profile2.getDescription();
        if (string2 == null && (string2 = PROFILE_DESCRIPTIONS.get(profile2.getDisplayName())) == null) {
            string2 = "";
        }
        super(string, string2);
        this.profile = profile2;
    }

    @NotNull
    public final QodanaInspectionProfile getProfile() {
        return this.profile;
    }

    @Override
    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.renderElement(presentation);
        presentation.setIcon(QodanaIcons.Icons.Qodana);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"qodana.recommended", (Object)"Default profile including needed inspections"), TuplesKt.to((Object)"qodana.starter", (Object)"Lighter version of qodana.recommended profile that does not include heavy inspections"), TuplesKt.to((Object)"qodana.sanity", (Object)"Only sanity checks are included"), TuplesKt.to((Object)"empty", (Object)"No inspections included")};
        PROFILE_DESCRIPTIONS = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/qodana/yaml/QodanaProfileLookupElement$Companion;", "", "<init>", "()V", "PROFILE_DESCRIPTIONS", "", "", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

