/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.telephony;

import com.intellij.cwm.plugin.CodeWithMeBackendBundle;
import com.intellij.cwm.plugin.join.BackendJoinLinkManager;
import com.intellij.cwm.plugin.join.JoinLinkData;
import com.intellij.cwm.plugin.telephony.BackendTelephonyManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ExperimentalUI;
import com.jetbrains.rd.platform.codeWithMe.statistics.CodeWithMeLifecycleUsagesCollector;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/cwm/plugin/telephony/EnableVoiceCallAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.cwm.plugin"})
public final class EnableVoiceCallAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackendTelephonyManager manager = BackendTelephonyManager.Companion.getInstance(project2);
        boolean newValue = (Boolean)manager.isTelephonyEnabled().getValue() == false;
        manager.isTelephonyEnabled().set((Object)newValue);
        CodeWithMeLifecycleUsagesCollector.CodeWithMeLifecycleLogger.INSTANCE.onTelephonyEnabledFromAction(e.getProject(), newValue);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        String url;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null || ExperimentalUI.Companion.isNewUI()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        BackendJoinLinkManager rdServerManager = BackendJoinLinkManager.Companion.getInstance(project);
        URI joinLink = rdServerManager.getExistingJoinLink();
        if (joinLink == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        JoinLinkData joinLinkData = rdServerManager.getJoinLinkData();
        String string = url = joinLinkData != null ? joinLinkData.getTelephonyUrl() : null;
        if (url == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        BackendTelephonyManager manager = BackendTelephonyManager.Companion.getInstance(project);
        if (((Boolean)manager.isTelephonyEnabled().getValue()).booleanValue()) {
            e.getPresentation().setIcon(AllIcons.CodeWithMe.CwmDisableCall);
            e.getPresentation().setText(CodeWithMeBackendBundle.INSTANCE.message("action.DisableVoiceCallAction.disable.text", new Object[0]));
        } else {
            e.getPresentation().setIcon(AllIcons.CodeWithMe.CwmEnableCall);
            e.getPresentation().setText(CodeWithMeBackendBundle.INSTANCE.message("action.DisableVoiceCallAction.enable.text", new Object[0]));
        }
    }
}

