/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.kotlin;

import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultilineSupporter;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u0007*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\tH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter;", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultilineSupporter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "isMultilineSuitable", "", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "areSimpleLines", "lines", "Lkotlin/ranges/IntRange;", "limitRange", "Lcom/intellij/openapi/util/TextRange;", "findScope", "Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter$Scope;", "checkComplexDeclaration", "Scope", "intellij.fullLine.kotlin"})
@SourceDebugExtension(value={"SMAP\nKotlinMultilineSupporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMultilineSupporter.kt\ncom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,97:1\n1088#2,2:98\n1#3:100\n66#4,2:101\n*S KotlinDebug\n*F\n+ 1 KotlinMultilineSupporter.kt\ncom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter\n*L\n40#1:98,2\n70#1:101,2\n*E\n"})
public final class KotlinMultilineSupporter
implements MLCompletionMultilineSupporter {
    @NotNull
    private final MLCompletionEnclosuresDefinition enclosuresDefinition;

    public KotlinMultilineSupporter(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        this.enclosuresDefinition = enclosuresDefinition;
    }

    @Override
    public boolean isMultilineSuitable(@NotNull PsiElement element, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Scope scope = this.findScope(element);
        if (scope == null) {
            return this.checkComplexDeclaration(element, document, offset);
        }
        Scope scope2 = scope;
        int startLine = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)scope2.getElement())));
        int endLine = document.getLineNumber(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)scope2.getElement())));
        int currentLine = document.getLineNumber(offset);
        if (currentLine < startLine && scope2.getStatements().isEmpty()) {
            return true;
        }
        IntRange intRange = new IntRange(currentLine + 1, endLine);
        TextRange textRange = scope2.getElement().getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return this.areSimpleLines(document, intRange, textRange);
    }

    private final boolean areSimpleLines(Document $this$areSimpleLines, IntRange lines, TextRange limitRange) {
        boolean bl;
        block2: {
            if (lines.isEmpty()) {
                return true;
            }
            int startOffset = $this$areSimpleLines.getLineStartOffset(lines.getFirst());
            int endOffset = $this$areSimpleLines.getLineEndOffset(lines.getLast());
            String string = $this$areSimpleLines.getText(new TextRange(startOffset, endOffset).intersection(limitRange));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            CharSequence $this$all$iv = string;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it) || this.enclosuresDefinition.isEnclosure(it)) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl;
    }

    private final Scope findScope(PsiElement $this$findScope) {
        Scope scope;
        block13: {
            for (PsiElement element : SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)$this$findScope, (boolean)true), KotlinMultilineSupporter::findScope$lambda$0)) {
                Scope scope2;
                Scope scope3;
                boolean bl = false;
                PsiElement psiElement = element;
                if (psiElement instanceof KtBlockExpression) {
                    scope3 = new Scope.Block((KtBlockExpression)element);
                } else if (psiElement instanceof KtFunctionLiteral) {
                    Scope.Block block;
                    if (((KtFunctionLiteral)element).getBodyBlockExpression() != null) {
                        boolean bl2 = false;
                        block = new Scope.Block(it);
                    } else {
                        block = null;
                    }
                    scope3 = block;
                } else if (psiElement instanceof KtFunction) {
                    Scope.Expression expression;
                    KtExpression body = ((KtFunction)element).getBodyExpression();
                    if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)body), (PsiElement)$this$findScope, (boolean)true)) {
                        if (body != null) {
                            boolean bl3 = false;
                            expression = new Scope.Expression((KtExpression)it);
                        } else {
                            expression = null;
                        }
                    } else {
                        expression = element instanceof KtPrimaryConstructor ? new Scope.Expression((KtExpression)((KtPrimaryConstructor)element).getContainingClassOrObject()) : new Scope.Expression((KtExpression)element);
                    }
                    scope3 = expression;
                } else {
                    scope3 = null;
                }
                if ((scope2 = scope3) == null) continue;
                scope = scope2;
                break block13;
            }
            scope = null;
        }
        return scope;
    }

    private final boolean checkComplexDeclaration(PsiElement element, Document document, int offset) {
        int currentLine;
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtDeclaration ktDeclaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtDeclaration.class, (boolean)true);
        if (ktDeclaration == null) {
            return true;
        }
        KtDeclaration declaration = ktDeclaration;
        int startLine = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)declaration)));
        if (startLine != (currentLine = document.getLineNumber(offset))) {
            return true;
        }
        int endLine = document.getLineNumber(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)declaration)));
        IntRange intRange = new IntRange(startLine + 1, endLine);
        TextRange textRange = declaration.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return this.areSimpleLines(document, intRange, textRange);
    }

    private static final boolean findScope$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof KtClassBody);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\bb\u0018\u00002\u00020\u0001:\u0002\n\u000bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter$Scope;", "", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "statements", "", "getStatements", "()Ljava/util/List;", "Block", "Expression", "intellij.fullLine.kotlin"})
    private static interface Scope {
        @NotNull
        public KtExpression getElement();

        @NotNull
        public List<KtExpression> getStatements();

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter$Scope$Block;", "Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter$Scope;", "element", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtBlockExpression;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "statements", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getStatements", "()Ljava/util/List;", "intellij.fullLine.kotlin"})
        public static final class Block
        implements Scope {
            @NotNull
            private final KtBlockExpression element;

            public Block(@NotNull KtBlockExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.element = element;
            }

            @NotNull
            public KtBlockExpression getElement() {
                return this.element;
            }

            @Override
            @NotNull
            public List<KtExpression> getStatements() {
                List list2 = this.getElement().getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                return list2;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter$Scope$Expression;", "Lcom/intellij/ml/inline/completion/kotlin/KotlinMultilineSupporter$Scope;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getElement", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "statements", "", "getStatements", "()Ljava/util/List;", "intellij.fullLine.kotlin"})
        public static final class Expression
        implements Scope {
            @NotNull
            private final KtExpression element;

            public Expression(@NotNull KtExpression element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.element = element;
            }

            @Override
            @NotNull
            public KtExpression getElement() {
                return this.element;
            }

            @Override
            @NotNull
            public List<KtExpression> getStatements() {
                return CollectionsKt.listOf((Object)this.getElement());
            }
        }
    }
}

