/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.TypeScriptTypeGuardFixHelper;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSTooltipWithHtmlHighlighter;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorChain;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTemplateLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypesAssignableError;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeJSDocTypeFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptInsertTypeGuardFix;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSTypeChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;
    private static final int ERROR_COUNT_LIMIT = 3;

    public JSTypeChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSTypeChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public final void registerProblem(PsiElement place, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (message == null) {
            JSTypeChecker.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            JSTypeChecker.$$$reportNull$$$0(2);
        }
        this.myReporter.registerProblem(place, null, message, highlightType, fixes);
    }

    public final void registerProblem(PsiElement place, TextRange rangeWithin, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (message == null) {
            JSTypeChecker.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            JSTypeChecker.$$$reportNull$$$0(4);
        }
        this.myReporter.registerProblem(place, rangeWithin, message, highlightType, fixes);
    }

    public final void checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable String type, @NotNull String problemKey, @Nullable PsiElement typeOwner, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(5);
        }
        if ("*".equals(type) || type == null || expr == null) {
            return;
        }
        this.checkExpressionIsAssignableToTypeAndReportError(expr, JSTypeParser.createType((Project)expr.getProject(), (String)type, (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)expr)), problemKey, typeOwner, widenLiteralTypes);
    }

    public final boolean checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable JSType jsType, @NotNull String problemKey, @Nullable PsiElement typeOwner, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(6);
        }
        ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)expr);
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, jsType, typeOwner, problemKey, context, widenLiteralTypes);
    }

    public boolean checkExpressionIsAssignableToTypeAndReportError(@Nullable JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable ProcessingContext context, boolean widenLiteralTypes) {
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(7);
        }
        if (JSTypeChecker.canSkipTypeChecking((PsiElement)expr, jsType)) {
            return true;
        }
        return (Boolean)JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)expr, () -> {
            JSType expressionJSType = this.getExpressionTypeForChecking(expr, widenLiteralTypes);
            return this.checkExpressionIsAssignableToTypeAndReportError(expr, jsType, typeOwner, problemKey, context, expressionJSType);
        });
    }

    public boolean checkExpressionIsAssignableToTypeAndReportError(JSExpression expr, @Nullable JSType jsType, @Nullable PsiElement typeOwner, @NotNull String problemKey, @Nullable ProcessingContext context, @Nullable JSType expressionJSType) {
        PsiElement typeOfTarget;
        String typeOfImmediateTarget;
        boolean isActionScript;
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(8);
        }
        if (expressionJSType == null) {
            return true;
        }
        if (this.skipByExpressionType(expr, expressionJSType)) {
            return true;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)expr);
        boolean isTypescript = holder != null && holder.isTypeScript;
        boolean bl = isActionScript = holder != null && holder.isECMA4;
        if (!isTypescript && expressionJSType instanceof JSNamedType && ((JSNamedType)expressionJSType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        if (!expressionJSType.isSourceStrict() && !isActionScript) {
            return true;
        }
        if (JSResolveUtil.isAssignableJSType((JSType)jsType, (JSType)expressionJSType, (ProcessingContext)context)) {
            if (isActionScript && jsType != null && ValidateTypesUtil.checkIfNullIsAssignedToNumeric(expr, jsType, expressionJSType)) {
                this.registerProblem((PsiElement)expr, JavaScriptBundle.message((String)"javascript.expression.type.implicitly.coerced.to.unrelated.type", (Object[])new Object[]{jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE), expressionJSType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.getFixes(expr, jsType, typeOwner, expressionJSType, context, holder).toArray(LocalQuickFix.EMPTY_ARRAY));
                return false;
            }
            return true;
        }
        if (holder != null && holder.isJavaScript() && JSResolveUtil.isPredefinedExtensibleType((JSType)expressionJSType) && JSResolveUtil.isAssignableJSType((JSType)expressionJSType, (JSType)jsType, (ProcessingContext)context)) {
            return true;
        }
        PsiElement expressionTypeSource = expressionJSType.getSourceElement();
        PsiElement parent = JSUtils.getParentSkipParentheses((PsiElement)expressionTypeSource);
        if (expressionTypeSource instanceof JSObjectLiteralExpression && !(parent instanceof JSArgumentList) && !(parent instanceof JSReturnStatement) && !(parent instanceof JSFunctionExpression) && ((JSObjectLiteralExpression)expressionTypeSource).getFirstProperty() == null && JSTypeUtils.getValuableType((JSType)jsType, (PsiElement)expr) instanceof JSRecordType) {
            return true;
        }
        JSExpression exprToCheckForProxy = expr;
        if (exprToCheckForProxy instanceof JSCallExpression) {
            exprToCheckForProxy = ((JSCallExpression)exprToCheckForProxy).getMethodExpression();
            if (expr instanceof JSNewExpression && exprToCheckForProxy instanceof JSArrayLiteralExpression) {
                exprToCheckForProxy = null;
            }
        }
        if (exprToCheckForProxy instanceof JSReferenceExpression) {
            exprToCheckForProxy = ((JSReferenceExpression)exprToCheckForProxy).getQualifier();
        }
        if (exprToCheckForProxy != null && !(exprToCheckForProxy instanceof JSLiteralExpression) && !isTypescript && (typeOfImmediateTarget = ActionScriptResolveUtil.getQualifiedExpressionType((JSExpression)exprToCheckForProxy, (PsiFile)expr.getContainingFile())) != null && (typeOfTarget = JSResolveUtil.findType((String)typeOfImmediateTarget, (PsiElement)exprToCheckForProxy, (boolean)true)) instanceof JSClass) {
            if ("XML".equals(typeOfImmediateTarget) || "XMLList".equals(typeOfImmediateTarget) || (holder == null || holder.isJavaScript()) && typeOfTarget instanceof XmlBackedJSClass && expr instanceof JSThisExpression) {
                return true;
            }
            JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage((Language)FlexSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
            PsiElement parentClass = resolver.findClassByQName("flash.utils.Proxy", typeOfTarget.getResolveScope());
            if (parentClass instanceof JSClass && JSInheritanceUtil.isParentClass((JSClass)((JSClass)typeOfTarget), (JSClass)((JSClass)parentClass), (boolean)false)) {
                return true;
            }
        }
        AssignableInfoData infoData = JSTypeChecker.buildAssignableErrorMessage((PsiElement)expr, jsType, expressionJSType, holder, problemKey, context);
        String message = infoData.message;
        Collection<LocalQuickFix> fixes = this.getFixes(expr, jsType, typeOwner, expressionJSType, context, holder);
        this.registerProblem((PsiElement)expr, infoData.range, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)expr), (LocalQuickFix[])ArrayUtil.mergeCollections(fixes, infoData.fixes(), LocalQuickFix[]::new));
        return false;
    }

    @InspectionMessage
    @Nullable
    public static String getErrorMessageIfTypeNotAssignableToType(@NotNull PsiElement element, @Nullable JSType target, @NotNull JSType source, @Nullable DialectOptionHolder optionHolder, @NotNull String problemKey) {
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(9);
        }
        if (source == null) {
            JSTypeChecker.$$$reportNull$$$0(10);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(11);
        }
        if (JSTypeChecker.canSkipTypeChecking(element, target)) {
            return null;
        }
        ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)element);
        if (JSResolveUtil.isAssignableJSType((JSType)target, (JSType)source, (ProcessingContext)context)) {
            return null;
        }
        AssignableInfoData infoData = JSTypeChecker.buildAssignableErrorMessage(element, target, source, optionHolder, problemKey, context);
        return infoData.message;
    }

    public void checkTypeIsAssignableToTypeAndReportError(@NotNull PsiElement element, @NotNull JSType target, @NotNull JSType source, @NotNull String problemKey) {
        String message;
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(12);
        }
        if (target == null) {
            JSTypeChecker.$$$reportNull$$$0(13);
        }
        if (source == null) {
            JSTypeChecker.$$$reportNull$$$0(14);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(15);
        }
        if ((message = JSTypeChecker.getErrorMessageIfTypeNotAssignableToType(element, target, source, DialectDetector.dialectOfElement((PsiElement)element), problemKey)) == null) {
            return;
        }
        this.registerProblem(element, null, message, ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem(element), new LocalQuickFix[0]);
    }

    protected boolean skipByExpressionType(@NotNull JSExpression expr, @Nullable JSType expressionJSType) {
        if (expr == null) {
            JSTypeChecker.$$$reportNull$$$0(16);
        }
        return false;
    }

    @Nullable
    private JSType getExpressionTypeForChecking(@Nullable JSExpression expr, boolean widenLiteralTypes) {
        JSType expressionJSType = this.getExpressionType(expr);
        if (expr != null && widenLiteralTypes) {
            JSType contextual = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)expr, (JSExpectedTypeKind)JSExpectedTypeKind.CONTEXTUAL);
            return JSTypeUtils.expandEnumAndLiteralTypeByExpectedType((JSType)expressionJSType, (JSType)contextual);
        }
        return expressionJSType;
    }

    @Nullable
    protected JSType getExpressionType(JSExpression expr) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType((JSExpression)expr);
        return JSCompositeTypeFactory.optimizeTypeIfComposite((JSType)evaluatedType);
    }

    protected static boolean canSkipTypeChecking(@Nullable PsiElement element, @Nullable JSType jsType) {
        if (jsType == null || element == null || jsType instanceof JSAnyType || jsType instanceof JSStubBasedExpressionType && ((JSStubBasedExpressionType)jsType).findAssociatedExpression() == element) {
            return true;
        }
        if (jsType.isJavaScript() && (jsType instanceof JSNullType || jsType instanceof JSUndefinedType)) {
            return true;
        }
        if (jsType instanceof JSNamedType && ((JSNamedType)jsType).isStaticOrInstance() == JSContext.STATIC) {
            return true;
        }
        return !jsType.isEcma() && !jsType.isSourceStrict() && !JSTypeUtils.hasFunctionType((JSType)jsType, (boolean)false, (PsiElement)element);
    }

    public void checkIfProperTypeReference(JSExpression rOperand) {
    }

    @NotNull
    protected Collection<LocalQuickFix> getFixes(JSExpression expr, @NotNull JSType declaredJSType, @Nullable PsiElement elementToChangeTypeOf, @NotNull JSType expressionJSType, ProcessingContext context, @Nullable DialectOptionHolder holder) {
        JSType promiseArg;
        if (declaredJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(17);
        }
        if (expressionJSType == null) {
            JSTypeChecker.$$$reportNull$$$0(18);
        }
        if (expr instanceof JSSpreadExpression) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeChecker.$$$reportNull$$$0(19);
            }
            return list;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        String expressionType = JSTypeChecker.formatTypeForFix(expressionJSType, holder);
        String declaredTypeText = JSTypeChecker.formatTypeForFix(declaredJSType, holder);
        if (holder != null && (holder.isTypeScript && declaredJSType instanceof JSNamedType && !(declaredJSType instanceof JSPrimitiveLiteralType) || holder.isECMA4)) {
            LocalQuickFix insertCastFix = ValidateTypesUtil.jsInsertCastFix(declaredTypeText, expr);
            if (holder.isTypeScript) {
                if (declaredJSType.isDirectlyAssignableType(expressionJSType, context) || expressionJSType.isDirectlyAssignableType(declaredJSType, context)) {
                    fixes.add(insertCastFix);
                    fixes.add((LocalQuickFix)new TypeScriptInsertTypeGuardFix((PsiElement)expr, declaredJSType, new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, null, null, false, true)));
                    fixes.add((LocalQuickFix)new TypeScriptInsertTypeGuardFix((PsiElement)expr, declaredJSType, new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.Ternary, null, null, false, true)));
                } else if (declaredJSType instanceof JSPrimitiveType && !(declaredJSType instanceof JSLiteralType) && expressionJSType instanceof JSPrimitiveType) {
                    fixes.add(JSFixFactory.getInstance().jsInsertPrimitiveWrapperFix(declaredTypeText, expr));
                }
                if (expressionJSType instanceof JSUnionType) {
                    List types = ((JSUnionType)expressionJSType).getTypes();
                    boolean hasNullOrUndefined = false;
                    boolean hasOurType = false;
                    boolean hasOtherTypes = false;
                    for (JSType part : types) {
                        if (part.isEquivalentTo(declaredJSType, null, true)) {
                            hasOurType = true;
                            continue;
                        }
                        if (part instanceof JSNullType || part instanceof JSUndefinedType) {
                            hasNullOrUndefined = true;
                            continue;
                        }
                        hasOtherTypes = true;
                    }
                    if (hasNullOrUndefined && hasOurType && !hasOtherTypes) {
                        TypeScriptTypeGuardFixHelper.JSTypeGuardFixData data = new TypeScriptTypeGuardFixHelper.JSTypeGuardFixData(TypeGuardSurroundKind.IfStatement, null, null, true, TypeScriptTypeGuardFixHelper.canSimplifyNullCheck(Collections.singletonList(declaredJSType)));
                        fixes.add((LocalQuickFix)new TypeScriptInsertTypeGuardFix((PsiElement)expr, (JSType)JSNamedTypeFactory.createNullType((JSTypeSource)expressionJSType.getSource()), data));
                    }
                }
            } else {
                fixes.add(insertCastFix);
            }
        }
        if (holder != null && holder.isTypeScript && expr instanceof JSObjectLiteralExpression && !(declaredJSType instanceof JSPrimitiveType)) {
            if (ContainerUtil.exists((Iterable)declaredJSType.asRecordType().getProperties(), JSRecordType.PropertySignature::isOptional)) {
                fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, true));
            }
            fixes.add(JSFixFactory.getInstance().createImplementMembersFix(expr, false));
        }
        if (expressionJSType instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType((JSType)expressionJSType) && (promiseArg = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)((JSGenericTypeImpl)expressionJSType), t -> true, (boolean)false)) != null && declaredJSType.isDirectlyAssignableType(promiseArg, context)) {
            fixes.add(JSFixFactory.getInstance().createInsertAwaitFix(expr, false));
        }
        ContainerUtil.addIfNotNull(fixes, (Object)ValidateTypesUtil.tryCreateInheritanceFix(declaredTypeText, expressionType, (PsiElement)expr));
        boolean hasTypes = DialectDetector.hasFeature((PsiElement)elementToChangeTypeOf, (JSLanguageFeature)JSLanguageFeature.TYPES);
        if (elementToChangeTypeOf instanceof JSVariable) {
            JSVariable variable = (JSVariable)elementToChangeTypeOf;
            if (expressionJSType instanceof JSVoidType) {
                ArrayList<LocalQuickFix> arrayList = fixes;
                if (arrayList == null) {
                    JSTypeChecker.$$$reportNull$$$0(20);
                }
                return arrayList;
            }
            boolean hasJSDoc = variable.hasJSDoc();
            if (elementToChangeTypeOf instanceof JSParameter) {
                JSParameter parameter = (JSParameter)elementToChangeTypeOf;
                JSFunction function = parameter.getDeclaringFunction();
                if (function != null) {
                    boolean bl = hasJSDoc = hasJSDoc || function.hasJSDoc();
                    if (hasTypes) {
                        if (expr.getParent() instanceof JSArgumentList) {
                            fixes.add(JSFixFactory.getInstance().changeSignatureFix(function, (JSArgumentList)expr.getParent()));
                        } else {
                            fixes.add(JSTypeChecker.changeSignatureForSingleParameterFix(function, Objects.requireNonNull(parameter.getName()), expressionType));
                        }
                    }
                }
            } else if (hasTypes) {
                fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)variable, expressionType, "javascript.fix.change.type"));
            }
            if (!hasTypes && declaredJSType.isSourceStrict() && hasJSDoc) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)variable, expressionJSType));
            }
        } else if (elementToChangeTypeOf instanceof JSFunction) {
            JSFunction function = (JSFunction)elementToChangeTypeOf;
            JSType typeToUse = TypeFromUsageDetector.getReturnTypeInContext((JSType)expressionJSType, null, null, (JSFunction)function);
            if (typeToUse instanceof JSNullType || typeToUse instanceof JSUndefinedType) {
                typeToUse = JSCompositeTypeFactory.createUnionType((JSTypeSource)typeToUse.getSource(), (JSType[])new JSType[]{declaredJSType, typeToUse});
            }
            if (hasTypes) {
                if (JSInheritanceUtil.participatesInMemberHierarchy((JSQualifiedNamedElement)(function.getParent() instanceof JSField ? (JSField)function.getParent() : function))) {
                    fixes.add(JSFixFactory.getInstance().changeSignatureFix(function, Collections.emptyMap(), JSTypeChecker.formatTypeForFix(typeToUse, holder)));
                } else {
                    fixes.add(ValidateTypesUtil.changeTypeFix((JSNamedElement)function, JSTypeChecker.formatTypeForFix(typeToUse, holder), "javascript.fix.set.method.return.type"));
                }
            } else if (function.hasJSDoc()) {
                fixes.add((LocalQuickFix)new ChangeJSDocTypeFix((JSNamedElement)function, typeToUse));
            }
        }
        ArrayList<LocalQuickFix> arrayList = fixes;
        if (arrayList == null) {
            JSTypeChecker.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    public boolean checkExpressionIsAssignableToVariable(JSVariable p, @Nullable JSExpression expr, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String problemKey) {
        if (!p.requiresTypeChecking()) {
            return true;
        }
        JSType variableType = p.getJSType();
        if (p instanceof JSOptionalOwner && ((JSOptionalOwner)p).isOptional()) {
            variableType = JSTypeGuardUtil.wrapWithUndefined((JSType)variableType, null);
        }
        return this.checkExpressionIsAssignableToTypeAndReportError(expr, variableType, problemKey, (PsiElement)p, true);
    }

    public void checkTemplateLiteralTypeSpansAssignability(@NotNull TypeScriptTemplateLiteralType literalType) {
        if (literalType == null) {
            JSTypeChecker.$$$reportNull$$$0(22);
        }
        JSType constraint = TypeScriptTypeRelations.createTemplateLiteralConstraintType((JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)literalType, (boolean)true));
        for (TypeScriptType type : literalType.getTypes()) {
            JSType sourceType = JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)type.getJSType());
            this.checkTypeIsAssignableToTypeAndReportError((PsiElement)type, constraint, sourceType, "typescript.validate.template.literal.types");
        }
    }

    public void checkTypesInReturnStatement(@NotNull JSElement returnStatementOrShorthandArrowFunctionExpression) {
        JSType actualType;
        JSExpression expression;
        JSType iterableComponentType;
        JSFunction fun;
        if (returnStatementOrShorthandArrowFunctionExpression == null) {
            JSTypeChecker.$$$reportNull$$$0(23);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JSFunction.class)) == null) {
            return;
        }
        JSType returnType = JSFunctionImpl.evaluateReturnTypeFromHierarchy((JSFunctionItem)fun);
        if (returnType == null || !fun.hasExplicitlyDeclaredReturnType() && returnType == fun.getReturnType()) {
            return;
        }
        if (fun.isGenerator() && (iterableComponentType = JSTypeUtils.getIterableComponentType((JSType)returnType)) != null) {
            returnType = iterableComponentType;
        }
        if (fun.isAsync()) {
            returnType = JSTypeChecker.getAsyncFunctionReturnTypeForValidation(fun, returnType);
        }
        if (returnStatementOrShorthandArrowFunctionExpression instanceof JSReturnStatement) {
            expression = ((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression).getExpression();
            if (expression == null) {
                this.checkEmptyReturnStatement((JSReturnStatement)returnStatementOrShorthandArrowFunctionExpression, fun, returnType);
                return;
            }
        } else {
            expression = (JSExpression)returnStatementOrShorthandArrowFunctionExpression;
        }
        if (returnType instanceof JSVoidType && (actualType = JSResolveUtil.getExpressionJSType((JSExpression)expression)) != null && !(actualType instanceof JSVoidType)) {
            this.registerProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression, JavaScriptBundle.message((String)"javascript.cannot.return.expression.from.function.with.void.result.type", (Object[])new Object[0]), ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)returnStatementOrShorthandArrowFunctionExpression), ValidateTypesUtil.removeASTNodeFix((PsiElement)expression, "javascript.cannot.return.expression.from.function.with.void.result.type.fix"), ValidateTypesUtil.changeTypeFix((JSNamedElement)fun, actualType.getTypeText(JSType.TypeTextFormat.CODE), "javascript.fix.set.method.return.type"));
            return;
        }
        this.checkExpressionIsAssignableToTypeAndReportError(expression, returnType, "javascript.returned.expression.type.mismatch", (PsiElement)fun, true);
    }

    private void checkEmptyReturnStatement(@NotNull JSReturnStatement node, @NotNull JSFunction function, @NotNull JSType returnType) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(24);
        }
        if (function == null) {
            JSTypeChecker.$$$reportNull$$$0(25);
        }
        if (returnType == null) {
            JSTypeChecker.$$$reportNull$$$0(26);
        }
        if (!ValidateTypesUtil.emptyReturnIsAcceptable(function, returnType)) {
            String message = JavaScriptBundle.message((String)"javascript.validation.message.return.value.of.type.is.required", (Object[])new Object[]{returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
            ProblemHighlightType highlightType = ValidateTypesUtil.getHighlightTypeForTypeOrSignatureProblem((PsiElement)node);
            this.registerProblem((PsiElement)node, message, highlightType, new LocalQuickFix[0]);
        }
    }

    @NotNull
    protected static JSType getAsyncFunctionReturnTypeForValidation(@NotNull JSFunction function, @NotNull JSType declaredType) {
        if (function == null) {
            JSTypeChecker.$$$reportNull$$$0(27);
        }
        if (declaredType == null) {
            JSTypeChecker.$$$reportNull$$$0(28);
        }
        declaredType = JSTypeUtils.getValuableType((JSType)declaredType, (PsiElement)function);
        JSTypeSource typeSource = declaredType.getSource();
        JSType componentType = JSTypeUtils.getPromiseComponentTypeOrNull((JSType)declaredType);
        if (componentType == null) {
            componentType = JSAnyType.get((PsiElement)function);
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType((JSTypeSource)typeSource, (JSType[])new JSType[]{declaredType, componentType});
        if (jSType == null) {
            JSTypeChecker.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    @NotNull
    public static String formatTypeForFix(@NotNull JSType jsType, @NotNull PsiElement context) {
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(30);
        }
        if (context == null) {
            JSTypeChecker.$$$reportNull$$$0(31);
        }
        return JSTypeChecker.formatTypeForFix(jsType, DialectDetector.dialectOfElement((PsiElement)context));
    }

    @NotNull
    private static String formatTypeForFix(@NotNull JSType jsType, @Nullable DialectOptionHolder holder) {
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(32);
        }
        if (holder != null && holder.isECMA4) {
            String string = jsType.getResolvedTypeText();
            if (string == null) {
                JSTypeChecker.$$$reportNull$$$0(33);
            }
            return string;
        }
        String string = jsType.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            JSTypeChecker.$$$reportNull$$$0(34);
        }
        return string;
    }

    public void checkTypesInForIn(@NotNull JSForInStatement node) {
        if (node == null) {
            JSTypeChecker.$$$reportNull$$$0(35);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static AssignableInfoData buildAssignableErrorMessage(@NotNull PsiElement element, @NotNull JSType jsType, @NotNull JSType elementType, @Nullable DialectOptionHolder holder, @NotNull String problemKey, @Nullable ProcessingContext context) {
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(36);
        }
        if (jsType == null) {
            JSTypeChecker.$$$reportNull$$$0(37);
        }
        if (elementType == null) {
            JSTypeChecker.$$$reportNull$$$0(38);
        }
        if (problemKey == null) {
            JSTypeChecker.$$$reportNull$$$0(39);
        }
        Project project = element.getProject();
        String jsTypeText = jsType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        String elementTypeText = elementType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (holder == null || holder.isECMA4 || (holder == DialectOptionHolder.TS || holder == DialectOptionHolder.TSX) && TypeScriptCompilerSettings.getSettings((Project)project).getUseService() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return new AssignableInfoData(JavaScriptBundle.message((String)problemKey, (Object[])new Object[]{jsTypeText, elementTypeText}), null, Collections.emptyList());
        }
        ProcessingContext newContext = context == null ? new ProcessingContext() : JSTypeBaseImpl.copyProcessingContextWithoutComparingCache((ProcessingContext)context);
        newContext.put(JSTypeAssignableErrorMessage.NOT_ASSIGNABLE_CHAIN_KEY, (Object)new JSTypeAssignableErrorChainImpl());
        newContext.put(JSTypeComparingContextService.TYPE_COMPARATOR, (Object)new JSTypeComparingCache());
        if (JSResolveUtil.isAssignableJSType((JSType)jsType, (JSType)elementType, (ProcessingContext)newContext)) {
            Logger.getInstance(JSTypeChecker.class).error("Comparing returned different value without cache in " + element.getContainingFile().getVirtualFile().getPath() + ": " + jsTypeText + ", " + elementTypeText, JSTypeChecker.getBrokenComparingCacheDiagnostics(jsType, elementType, context, project));
            return new AssignableInfoData(JavaScriptBundle.message((String)problemKey, (Object[])new Object[]{jsTypeText, elementTypeText}), null, Collections.emptyList());
        }
        JSTypeAssignableErrorChain errorChain = (JSTypeAssignableErrorChain)newContext.get(JSTypeAssignableErrorMessage.NOT_ASSIGNABLE_CHAIN_KEY);
        List texts = errorChain != null ? errorChain.getMessages() : Collections.emptyList();
        String tautologyMessage = JavaScriptBundle.message((String)"javascript.type.is.not.assignable.to.type", (Object[])new Object[]{jsTypeText, elementTypeText});
        @InspectionMessage AbstractStreamEx distinctMessages = ((StreamEx)((StreamEx)StreamEx.of((Collection)ContainerUtil.reverse((List)texts)).limit(3L)).filter(message -> !message.getText().equals(tautologyMessage))).distinct(JSTypeAssignableErrorMessage::getText);
        HtmlBuilder builder = new HtmlBuilder();
        builder.appendRaw(JavaScriptBundle.message((String)problemKey, (Object[])new Object[]{JSTooltipWithHtmlHighlighter.highlightTypeOrStmt((Project)project, (String)jsTypeText), JSTooltipWithHtmlHighlighter.highlightTypeOrStmt((Project)project, (String)elementTypeText)}));
        if (texts.size() > 4) {
            builder.append((HtmlChunk)HtmlChunk.br()).append("...");
        }
        IntRef spacesCount = new IntRef(1);
        distinctMessages.forEach(message -> {
            builder.append((HtmlChunk)HtmlChunk.br()).append(HtmlChunk.nbsp((int)(spacesCount.get() * 2)));
            Object[] args = ContainerUtil.map2Array((Object[])message.getArgs(), it -> JSTooltipWithHtmlHighlighter.highlightTypeOrStmt((Project)project, (String)it));
            builder.appendRaw(JavaScriptBundle.message((String)message.getPropertyKey(), (Object[])args));
            spacesCount.inc();
        });
        SmartList fixes = new SmartList();
        for (JSTypeAssignableErrorMessage text : texts) {
            Pair keyAndArgs = text.getProblemKeyAndArgs();
            if (keyAndArgs == null) continue;
            JSTypeChecker.addFixesByInfoKey(element, (List<? super LocalQuickFix>)fixes, (String)keyAndArgs.first, (String[])keyAndArgs.second);
        }
        return new AssignableInfoData(builder.wrapWith("html").toString(), texts.size() == 1 ? ((JSTypeAssignableErrorMessage)texts.getFirst()).getCustomErrorRange(element) : null, (List<? extends LocalQuickFix>)fixes);
    }

    private static String @NotNull [] getBrokenComparingCacheDiagnostics(@NotNull JSType lType, @NotNull JSType rType, final @Nullable ProcessingContext context, @NotNull Project project) {
        JSTypeComparingCache comparingCache;
        if (lType == null) {
            JSTypeChecker.$$$reportNull$$$0(40);
        }
        if (rType == null) {
            JSTypeChecker.$$$reportNull$$$0(41);
        }
        if (project == null) {
            JSTypeChecker.$$$reportNull$$$0(42);
        }
        if ((comparingCache = JSTypeComparingContextService.getComparingCache((Project)project, (boolean)false)) == null) {
            Logger.getInstance(JSTypeChecker.class).error("Comparing cache is null");
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                JSTypeChecker.$$$reportNull$$$0(43);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        final ArrayList<CallSite> diagnostics = new ArrayList<CallSite>();
        ProcessingContext newContext = context == null ? new ProcessingContext() : JSTypeBaseImpl.copyProcessingContextWithoutComparingCache((ProcessingContext)context);
        newContext.put(JSTypeComparingContextService.TYPE_COMPARATOR, (Object)new JSTypeComparingCache());
        newContext.put(JSTypeAssignableErrorMessage.NOT_ASSIGNABLE_CHAIN_KEY, (Object)new JSTypeAssignableErrorChainImpl(){

            @Override
            public void updateAssignableChain(@NotNull JSType lType, @Nullable JSType rType, boolean result2) {
                if (lType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rType == null) {
                    return;
                }
                boolean assignableFromCache = JSResolveUtil.isAssignableJSType((JSType)lType, (JSType)rType, (ProcessingContext)context);
                if (result2 != assignableFromCache) {
                    diagnostics.add(String.format("result actual: %b, result from cache: %s, lType: %s, rType: %s", result2, assignableFromCache, lType, rType));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lType", "com/intellij/lang/javascript/validation/JSTypeChecker$1", "updateAssignableChain"));
            }
        });
        diagnostics.add((CallSite)((Object)("getBrokenComparingCacheDiagnostics result: " + JSResolveUtil.isAssignableJSType((JSType)lType, (JSType)rType, (ProcessingContext)newContext))));
        String[] stringArray = (String[])diagnostics.toArray(String[]::new);
        if (stringArray == null) {
            JSTypeChecker.$$$reportNull$$$0(44);
        }
        return stringArray;
    }

    private static void addFixesByInfoKey(@NotNull PsiElement element, @NotNull @NotNull List<? super @NotNull LocalQuickFix> fixes, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String key, String[] second) {
        if (element == null) {
            JSTypeChecker.$$$reportNull$$$0(45);
        }
        if (fixes == null) {
            JSTypeChecker.$$$reportNull$$$0(46);
        }
        switch (key) {
            case "javascript.known.props.only": {
                if (!(element instanceof JSObjectLiteralExpression) || second.length != 1) {
                    return;
                }
                String desc = second[0];
                List names = ContainerUtil.map((Collection)StringUtil.split((String)desc, (String)","), s -> StringUtil.unquoteString((String)s.trim(), (char)'\''));
                fixes.addAll(JSFixFactory.getInstance().createAddTypeMembersByLiteralFixes((JSObjectLiteralExpression)element, names));
            }
        }
    }

    private static LocalQuickFix changeSignatureForSingleParameterFix(JSFunction function, @NotNull String name, @NotNull String type) {
        if (name == null) {
            JSTypeChecker.$$$reportNull$$$0(47);
        }
        if (type == null) {
            JSTypeChecker.$$$reportNull$$$0(48);
        }
        Map<String, String> parameters = Map.of(name, type);
        return JSFixFactory.getInstance().changeSignatureFix(function, parameters, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 20, 21, 29, 33, 34, 43, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 4: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 15: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemKey";
                break;
            }
            case 9: 
            case 12: 
            case 36: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredJSType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionJSType";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatementOrShorthandArrowFunctionExpression";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 30: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeForFix";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenComparingCacheDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkExpressionIsAssignableToTypeAndReportError";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfTypeNotAssignableToType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkTypeIsAssignableToTypeAndReportError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "skipByExpressionType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 29: 
            case 33: 
            case 34: 
            case 43: 
            case 44: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkTemplateLiteralTypeSpansAssignability";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInReturnStatement";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkEmptyReturnStatement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAsyncFunctionReturnTypeForValidation";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeForFix";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkTypesInForIn";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "buildAssignableErrorMessage";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getBrokenComparingCacheDiagnostics";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addFixesByInfoKey";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureForSingleParameterFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 20, 21, 29, 33, 34, 43, 44 -> new IllegalStateException(string);
        };
    }

    private record AssignableInfoData(@NotNull @InspectionMessage String message, @Nullable TextRange range, @NotNull @NotNull List<? extends @NotNull LocalQuickFix> fixes) {
        @NotNull
        private final @InspectionMessage String message;
        @NotNull
        private final @NotNull List<? extends @NotNull LocalQuickFix> fixes;

        private AssignableInfoData(@NotNull @InspectionMessage String message, @Nullable TextRange range, @NotNull @NotNull List<? extends @NotNull LocalQuickFix> fixes) {
            if (message == null) {
                AssignableInfoData.$$$reportNull$$$0(0);
            }
            if (fixes == null) {
                AssignableInfoData.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        @InspectionMessage
        public String message() {
            String string = this.message;
            if (string == null) {
                AssignableInfoData.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public @NotNull List<? extends @NotNull LocalQuickFix> fixes() {
            List<? extends LocalQuickFix> list = this.fixes;
            if (list == null) {
                AssignableInfoData.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixes";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker$AssignableInfoData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker$AssignableInfoData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class JSTypeAssignableErrorChainImpl
    implements JSTypeAssignableErrorChain {
        @NotNull
        private final List<JSTypeAssignableErrorMessage> myMessages = new SmartList();

        private JSTypeAssignableErrorChainImpl() {
        }

        @NotNull
        public List<JSTypeAssignableErrorMessage> getMessages() {
            List<JSTypeAssignableErrorMessage> list = this.myMessages;
            if (list == null) {
                JSTypeAssignableErrorChainImpl.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void updateAssignableChain(@NotNull JSType lType, @Nullable JSType rType, boolean result2) {
            if (lType == null) {
                JSTypeAssignableErrorChainImpl.$$$reportNull$$$0(1);
            }
            if (result2) {
                this.myMessages.clear();
                return;
            }
            this.myMessages.add((JSTypeAssignableErrorMessage)new JSTypesAssignableError(lType, rType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/JSTypeChecker$JSTypeAssignableErrorChainImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/JSTypeChecker$JSTypeAssignableErrorChainImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAssignableChain";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }
}

