/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public final class UnnecessaryReturnJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final UnnecessaryReturnFix fix = new UnnecessaryReturnFix();

    public boolean isEnabledByDefault() {
        return true;
    }

    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = JavaScriptBundle.message((String)"unnecessary.return.error.string", (Object[])new Object[0]);
        if (string == null) {
            UnnecessaryReturnJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryReturnVisitor();
    }

    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryReturnJSInspection", "buildErrorString"));
    }

    private static class UnnecessaryReturnFix
    extends InspectionJSFix {
        private UnnecessaryReturnFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"remove.unnecessary.return.fix", (Object[])new Object[0]);
            if (string == null) {
                UnnecessaryReturnFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement returnKeywordElement = descriptor.getPsiElement();
            PsiElement returnStatement = returnKeywordElement.getParent();
            assert (returnStatement != null);
            UnnecessaryReturnFix.deleteElement((PsiElement)returnStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/UnnecessaryReturnJSInspection$UnnecessaryReturnFix", "getFamilyName"));
        }
    }

    public static class UnnecessaryReturnVisitor
    extends BaseInspectionVisitor {
        public void visitJSReturnStatement(@NotNull JSReturnStatement statement) {
            if (statement == null) {
                UnnecessaryReturnVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSReturnStatement(statement);
            if (DialectDetector.isTypeScript((PsiElement)statement)) {
                return;
            }
            JSExpression returnValue = statement.getExpression();
            if (returnValue != null) {
                return;
            }
            JSFunction function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)statement, JSFunction.class);
            if (function == null) {
                return;
            }
            PsiElement body = function.getLastChild();
            if (body == null) {
                return;
            }
            if (!(body instanceof JSBlockStatement)) {
                return;
            }
            if (ControlFlowUtils.statementCompletesWithStatement((JSStatement)((JSStatement)body), (JSStatement)statement)) {
                this.registerStatementError((JSSourceElement)statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/UnnecessaryReturnJSInspection$UnnecessaryReturnVisitor", "visitJSReturnStatement"));
        }
    }
}

