/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetPtyOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetType;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslPathMapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslNodeInterpreter
extends NodeJsInterpreter {
    @NlsSafe
    private final String myWslDistributionId;
    @NlsSafe
    private final String myWslInterpreterPath;
    private WSLDistribution myDistribution;

    public WslNodeInterpreter(@NotNull @NlsSafe String wslDistributionId, @NotNull @NlsSafe String wslInterpreterPath) {
        if (wslDistributionId == null) {
            WslNodeInterpreter.$$$reportNull$$$0(0);
        }
        if (wslInterpreterPath == null) {
            WslNodeInterpreter.$$$reportNull$$$0(1);
        }
        this.myWslDistributionId = wslDistributionId;
        this.myWslInterpreterPath = FileUtil.toSystemIndependentName((String)wslInterpreterPath);
    }

    @NotNull
    @NlsSafe
    public String getWslDistributionId() {
        String string = this.myWslDistributionId;
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getWslInterpreterPath() {
        String string = this.myWslInterpreterPath;
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public WSLDistribution getDistribution() {
        WSLDistribution distribution = this.myDistribution;
        if (distribution == null) {
            this.myDistribution = distribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.myWslDistributionId);
        }
        WSLDistribution wSLDistribution = distribution;
        if (wSLDistribution == null) {
            WslNodeInterpreter.$$$reportNull$$$0(4);
        }
        return wSLDistribution;
    }

    @Override
    @NotNull
    public NodeJsInterpreterType<? extends NodeJsInterpreter> getType() {
        WslNodeInterpreterType wslNodeInterpreterType = WslNodeInterpreterType.getInstance();
        if (wslNodeInterpreterType == null) {
            WslNodeInterpreter.$$$reportNull$$$0(5);
        }
        return wslNodeInterpreterType;
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = WslNodeInterpreterManager.getReferenceName(this);
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        WSLDistribution dist = this.getDistribution();
        String name = dist.getPresentableName();
        String string = name + " " + this.getWslInterpreterPath();
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return WslNodeInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        if (consumer == null) {
            WslNodeInterpreter.$$$reportNull$$$0(8);
        }
        WslNodeInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return null;
    }

    @Nullable
    public String getPrependNodeDirToPathCommand() {
        String defaultPath = "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games:/usr/local/games";
        String binDir = PathUtil.getParentPath((String)this.myWslInterpreterPath);
        if (StringUtil.split((String)defaultPath, (String)":").contains(binDir)) {
            return null;
        }
        return "export PATH=\"" + CommandLineUtil.posixQuote((String)binDir) + ":$PATH\"";
    }

    @Override
    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRunOptions options) {
        if (project == null) {
            WslNodeInterpreter.$$$reportNull$$$0(9);
        }
        if (options == null) {
            WslNodeInterpreter.$$$reportNull$$$0(10);
        }
        final WslTargetEnvironmentRequest request2 = new WslTargetEnvironmentRequest(new WslTargetEnvironmentConfiguration(this.getDistribution()));
        if (options.getPtyOptions() != null || options.getRunConfiguration() != null) {
            request2.getWslOptions().setExecuteCommandInInteractiveShell(true);
        }
        return new NodeTargetRunSetup((TargetEnvironmentRequest)request2, new WslPathMapper(project, this.getDistribution())){

            @Override
            public void configureCommandLine(@NotNull NodeTargetRun targetRun) {
                LocalPtyOptions localPtyOptions;
                if (targetRun == null) {
                    1.$$$reportNull$$$0(0);
                }
                TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
                if (!targetRun.isExePathDefined()) {
                    commandLineBuilder.setExePath(WslNodeInterpreter.this.myWslInterpreterPath);
                }
                if ((localPtyOptions = targetRun.getOptions().getPtyOptions()) != null) {
                    commandLineBuilder.setPtyOptions((PtyOptions)new LocalTargetPtyOptions(localPtyOptions));
                }
            }

            @Override
            public void configureEnvironment(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull EnvironmentVariablesData envData) {
                if (commandLineBuilder == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (envData == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.configureEnvironment(commandLineBuilder, envData);
                request2.getWslOptions().setPassEnvVarsUsingInterop(false);
            }

            @Override
            public void prependNodeDirToPATH(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull EnvironmentVariablesData envData) {
                String prependNodeDirToPathCommand;
                if (commandLineBuilder == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (envData == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((prependNodeDirToPathCommand = WslNodeInterpreter.this.getPrependNodeDirToPathCommand()) != null) {
                    request2.getWslOptions().addInitCommand(prependNodeDirToPathCommand);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "targetRun";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commandLineBuilder";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "envData";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configureCommandLine";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "configureEnvironment";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "prependNodeDirToPATH";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    @NotNull
    public TargetEnvironmentType<?> getTargetEnvironmentType() throws IllegalStateException {
        TargetEnvironmentType targetEnvironmentType = TargetEnvironmentType.findInstance(WslTargetType.class);
        if (targetEnvironmentType == null) {
            WslNodeInterpreter.$$$reportNull$$$0(11);
        }
        return targetEnvironmentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslNodeInterpreter that = (WslNodeInterpreter)o;
        return Objects.equals(this.myWslDistributionId, that.myWslDistributionId) && Objects.equals(this.myWslInterpreterPath, that.myWslInterpreterPath);
    }

    public int hashCode() {
        return Objects.hash(this.myWslDistributionId, this.myWslInterpreterPath);
    }

    public String toString() {
        return "wsl_id=" + this.myWslDistributionId + ", wsl_path=" + this.myWslInterpreterPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslDistributionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslInterpreterPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslInterpreterPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistribution";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEnvironmentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 11 -> new IllegalStateException(string);
        };
    }
}

