/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.resolve.JavaScriptResolveScopeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FlowJSResolveScopeProvider
extends JavaScriptResolveScopeProvider {
    private static final Key<Set<VirtualFile>> FLOW_PREDEFINED_LIBRARY_SCOPE_KEY = Key.create((String)"js.flow.predefined.library.scope");

    @Override
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(1);
        }
        if (!FlowJSResolveScopeProvider.isApplicable(file)) {
            return null;
        }
        if (!FlowJSResolveScopeProvider.useFlowPredefinedLibrary(file, project)) {
            return super.getResolveScope(file, project);
        }
        Set<VirtualFile> flowPredefinedFiles = (Set<VirtualFile>)project.getUserData(FLOW_PREDEFINED_LIBRARY_SCOPE_KEY);
        if (flowPredefinedFiles == null) {
            flowPredefinedFiles = FlowJSResolveScopeProvider.getPredefinedFlowLibraryFiles();
            Set<VirtualFile> jsRequiredLibraryFiles = JSPredefinedLibraryManager.getPredefinedLibraryManager(project).getRequiredLibraryFilesForResolve(JSLanguageLevel.FLOW);
            flowPredefinedFiles.addAll(jsRequiredLibraryFiles);
            project.putUserData(FLOW_PREDEFINED_LIBRARY_SCOPE_KEY, flowPredefinedFiles);
        }
        Set libraryFilesToExclude = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            SyntheticLibrary library;
            HashSet result2 = new HashSet();
            ScriptingLibraryModel nodeLibrary = JSLibraryManager.getInstance(project).getLibraryByName("Node.js Core");
            if (nodeLibrary instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (library = ((ScriptingLibraryModelBackedBySyntheticLibrary)nodeLibrary).getSyntheticLibrary()) != null) {
                result2.addAll(library.getSourceRoots());
            }
            return new CachedValueProvider.Result(result2, new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
        });
        return this.getProjectAndLibrariesScope(file, project, flowPredefinedFiles, libraryFilesToExclude);
    }

    private static boolean useFlowPredefinedLibrary(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(3);
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return FlowJSResolveScopeProvider.useFlowPredefinedLibrary(psiFile);
    }

    public static boolean useFlowPredefinedLibrary(@Nullable PsiFile file) {
        return file instanceof JSFile && DialectDetector.isFlow((PsiElement)file) && (FlowJSAnnotation.hasFlowAnnotation((PsiFile)file) || FlowJSResolveScopeProvider.getPredefinedFlowLibraryFiles().contains(file.getOriginalFile().getVirtualFile()));
    }

    @NotNull
    private static Set<VirtualFile> getPredefinedFlowLibraryFiles() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            FlowJSResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSResolveScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSResolveScopeProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedFlowLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "useFlowPredefinedLibrary";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

