/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.type.jsclass;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;

public final class JSTypeHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    public JSTypeHierarchyNodeDescriptor(Project project, HierarchyNodeDescriptor parentDescriptor, JSClass jsClass, boolean isBase) {
        super(project, (NodeDescriptor)parentDescriptor, (PsiElement)jsClass, isBase);
    }

    public JSClass getJsClass() {
        return (JSClass)this.getPsiElement();
    }

    public boolean update() {
        String packageName;
        boolean changes = super.update();
        if (this.getJsClass() == null) {
            return this.invalidElement();
        }
        this.installIcon(changes);
        JSClass jsClass = this.getJsClass();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(jsClass.getName(), classNameAttributes);
        String name = jsClass.getQualifiedName();
        if (!(StringUtil.isEmpty((String)name) || StringUtil.isEmpty((String)(packageName = StringUtil.getPackageName((String)name))) && !DialectDetector.isActionScript((PsiElement)jsClass))) {
            this.myHighlightedText.getEnding().addText(" (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

