/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesEnProvider;
import com.intellij.lang.typescript.compiler.languageService.DiagnosticTemplatesMemoryCache;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfo;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageInfoKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoPackageKind;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesTsGoLocalProvider;", "", "<init>", "()V", "myCache", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache;", "getTemplates", "", "", "servicePath", "getCriteria", "Lcom/intellij/lang/typescript/compiler/languageService/DiagnosticTemplatesMemoryCache$GetCriteria;", "intellij.javascript.backend"})
public final class DiagnosticTemplatesTsGoLocalProvider {
    @NotNull
    private final DiagnosticTemplatesMemoryCache myCache = new DiagnosticTemplatesMemoryCache((Function1<? super Path, ? extends Sequence<Pair<Integer, String>>>)((Function1)DiagnosticTemplatesTsGoLocalProvider::myCache$lambda$0));

    @RequiresBackgroundThread
    @NotNull
    public final List<String> getTemplates(@NotNull String servicePath, @NotNull DiagnosticTemplatesMemoryCache.GetCriteria getCriteria) {
        TypeScriptGoPackageInfo tsGoInfo;
        Intrinsics.checkNotNullParameter((Object)servicePath, (String)"servicePath");
        Intrinsics.checkNotNullParameter((Object)getCriteria, (String)"getCriteria");
        TypeScriptGoPackageInfo typeScriptGoPackageInfo = tsGoInfo = TypeScriptGoPackageInfoKt.getTypeScriptGoPackageInfo(servicePath);
        if ((typeScriptGoPackageInfo != null ? typeScriptGoPackageInfo.getKind() : null) != TypeScriptGoPackageKind.LocallyClonedAndBuilt) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = VirtualFileUtil.findFile((VirtualFile)tsGoInfo.getPackageDir(), (String)"_submodules/TypeScript/src/compiler/diagnosticMessages.json");
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile diagnosticMessagesFile = virtualFile;
        Path path2 = diagnosticMessagesFile.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
        return this.myCache.getTemplates(path2, getCriteria);
    }

    private static final Sequence myCache$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DiagnosticTemplatesEnProvider.Companion.getCodeToTemplate(it);
    }
}

