/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/typescript/library/TypeScriptCustomServiceLibrariesRootsProvider;", "Lcom/intellij/openapi/roots/AdditionalLibraryRootsProvider;", "<init>", "()V", "getAdditionalProjectLibraries", "", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "getRootsToWatch", "Lcom/intellij/openapi/vfs/VirtualFile;", "getNonDefaultServiceDirectoryFile", "Ljava/io/File;", "intellij.javascript.backend"})
public final class TypeScriptCustomServiceLibrariesRootsProvider
extends AdditionalLibraryRootsProvider {
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file = this.getNonDefaultServiceDirectoryFile(project);
        if (file == null) {
            return CollectionsKt.emptyList();
        }
        List libFiles = (List)ReadAction.compute(() -> TypeScriptCustomServiceLibrariesRootsProvider.getAdditionalProjectLibraries$lambda$0(file));
        return CollectionsKt.listOf((Object)SyntheticLibrary.newImmutableLibrary((String)"TypeScriptLibraries", (List)libFiles, (List)CollectionsKt.emptyList(), (Set)SetsKt.emptySet(), null));
    }

    @NotNull
    public Collection<VirtualFile> getRootsToWatch(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File ioFile = this.getNonDefaultServiceDirectoryFile(project);
        if (ioFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(ioFile);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile vFile = virtualFile;
        return CollectionsKt.listOf((Object)vFile);
    }

    private final File getNonDefaultServiceDirectoryFile(Project project) {
        TypeScriptServiceDirectoryWatcher typeScriptServiceDirectoryWatcher = TypeScriptServiceDirectoryWatcher.getService(project);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptServiceDirectoryWatcher, (String)"getService(...)");
        TypeScriptServiceDirectoryWatcher watcher2 = typeScriptServiceDirectoryWatcher;
        String directory = watcher2.getCachedCustomServiceDirectory();
        if (directory == null) {
            return null;
        }
        String string = watcher2.getDefaultServicePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultServicePath(...)");
        String defaultServicePath = string;
        if (Intrinsics.areEqual((Object)directory, (Object)defaultServicePath)) {
            return null;
        }
        File file = new File(directory);
        return file.exists() ? file : null;
    }

    private static final List getAdditionalProjectLibraries$lambda$0(File $file) {
        return JSCorePredefinedLibrariesProvider.getLibFilesByIO($file, (Predicate)Conditions.alwaysTrue(), true);
    }
}

