/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ShowSqlParametersPanelAction;
import com.intellij.database.console.DatabaseRunners;
import com.intellij.database.console.GlobalSessionStateListener;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.IntroduceTarget;
import com.intellij.refactoring.introduce.PsiIntroduceTarget;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.treeStructure.ProjectViewUpdateCause;
import com.intellij.util.Consumer;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.JBUI;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JdbcConsoleProvider
extends JdbcConsoleProviderCore {
    public boolean hasRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(0);
        }
        return false;
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor2) {
        PsiFile file;
        if (element == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(1);
        }
        if (DbImplUtil.getAllDataSourcesForExec((PsiFile)(file = element.getContainingFile())).isEmpty()) {
            return false;
        }
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, element, editor2));
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(2);
        }
        List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, @Nullable Editor editor2) {
        if (element == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(4);
        }
        List list = (List)ReadAction.nonBlocking(() -> JdbcConsoleProvider.getRunnersInner(element, editor2)).withDocumentsCommitted(element.getProject()).executeSynchronously();
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static List<PersistenceConsoleProvider.Runner> getRunnersInner(@NotNull PsiElement element, @Nullable Editor editor2) {
        DatabaseSettings.ExecOption execOption;
        Info info2;
        PsiElement elementAt;
        if (element == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(6);
        }
        if (!element.isValid()) {
            return Collections.emptyList();
        }
        PsiFile file = element.getContainingFile();
        if (!JdbcConsoleProvider.isSqlAtPlace(file, elementAt = JdbcConsoleProvider.elementAt(file, element, editor2))) {
            return Collections.emptyList();
        }
        if (elementAt == null) {
            elementAt = element;
        }
        if ((info2 = JdbcConsoleProvider.findScriptModel(file, elementAt, editor2, execOption = (DatabaseSettings.ExecOption)DatabaseSettings.getSettings().execOptions.get(0))) == null || info2.editor == null) {
            return Collections.emptyList();
        }
        VirtualFile virtualFile = info2.editor.getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        Project project = info2.originalFile.getProject();
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, virtualFile);
        if (console != null) {
            return Collections.singletonList(DatabaseRunners.createConsoleRunner(console, () -> JdbcConsoleProvider.doRunQueryInConsole(console, info2)));
        }
        return DatabaseRunners.getAttachDataSourceSchemasRunners(info2);
    }

    @NotNull
    public static JBIterable<JdbcConsole> getRunningConsoles(Project project) {
        JBIterable jBIterable = JBIterable.from(JdbcConsole.getActiveConsoles(project));
        if (jBIterable == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @Nullable
    public static Info findScriptModel(@NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor2, @NotNull DatabaseSettings.ExecOption execOption) {
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(8);
        }
        if (elementAt == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(9);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(10);
        }
        if (!JdbcConsoleProvider.isSqlAtPlace(file, elementAt) && !JdbcConsoleProvider.isJSAtPlace(file, editor2)) {
            return null;
        }
        TextRange selectionRange = ScriptModelUtil.getSelectionForConsole(editor2, execOption);
        Project project = file.getProject();
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt);
        if (documentWindow != null && elementAt.getContainingFile() instanceof SqlFile) {
            return JdbcConsoleProvider.findScriptModelInInjection(project, file, elementAt, editor2, selectionRange, documentWindow, execOption);
        }
        return JdbcConsoleProvider.findScriptModelNoInject(project, file, editor2, selectionRange, execOption);
    }

    @Nullable
    public static Info findScriptModelNoInject(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor2, @NotNull TextRange selectionRange, @NotNull DatabaseSettings.ExecOption execOption) {
        Document document;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(11);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(12);
        }
        if (selectionRange == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(13);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(14);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project).getDocument(file)) == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file.getVirtualFile())) {
            return null;
        }
        JdbcConsole console = JdbcConsoleProvider.getValidConsole(project, virtualFile);
        ScriptModel model = console != null ? console.getScriptModel() : SqlPsiFacade.getInstance((Project)project).createScriptModel(file);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, document, selectionRange, execOption);
        return new Info(file, file, (EditorEx)editor2, m, execOption, null);
    }

    @Nullable
    private static Info findScriptModelInInjection(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement elementAt, @Nullable Editor editor2, @NotNull TextRange selection0, @NotNull DocumentWindow documentWindow, @NotNull DatabaseSettings.ExecOption execOption) {
        SqlFile sqlFile;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(15);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(16);
        }
        if (elementAt == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(17);
        }
        if (selection0 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(18);
        }
        if (documentWindow == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(19);
        }
        if (execOption == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(20);
        }
        if ((sqlFile = (SqlFile)ObjectUtils.tryCast((Object)elementAt.getContainingFile(), SqlFile.class)) == null) {
            return null;
        }
        TextRange selectionInj = editor2 instanceof EditorWindow || editor2 == null ? selection0 : EditorUtil.getSelectionInAnyMode((Editor)InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor2, (PsiFile)sqlFile));
        SyntaxTraverser s = (SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)sqlFile)).withTraversal(TreeTraversal.LEAVES_DFS);
        StringBuilder unescaped = new StringBuilder();
        int count = s.traverse().size();
        int[] injectedOffsets = new int[count + 1];
        int[] copyOffsets = new int[count + 1];
        copyOffsets[0] = 0;
        injectedOffsets[0] = 0;
        int i = 1;
        int unescEnd = -1;
        int unescStart = -1;
        for (PsiElement e : s) {
            String leafText = InjectedLanguageUtilBase.getUnescapedLeafText((PsiElement)e, (boolean)false);
            if (leafText == null) continue;
            TextRange r = e.getTextRange();
            if (r.containsOffset(selectionInj.getStartOffset())) {
                unescStart = unescaped.length() + selectionInj.getStartOffset() - r.getStartOffset();
            }
            if (r.containsOffset(selectionInj.getEndOffset())) {
                unescEnd = unescaped.length() + selectionInj.getEndOffset() - r.getStartOffset();
            }
            unescaped.append(leafText);
            injectedOffsets[i] = r.getEndOffset();
            copyOffsets[i] = unescaped.length();
            ++i;
        }
        if (unescStart < 0 || unescEnd < 0) {
            return null;
        }
        TextRange selectionRange = TextRange.create((int)unescStart, (int)unescEnd);
        SqlFile subFile = (SqlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)sqlFile.getSqlLanguage(), (CharSequence)unescaped.toString(), true, false);
        LightVirtualFile subVirtualFile = Objects.requireNonNull((LightVirtualFile)subFile.getVirtualFile());
        subVirtualFile.setOriginalFile(PsiUtilCore.getVirtualFile((PsiElement)sqlFile));
        if (editor2 instanceof EditorImpl) {
            editor2 = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor2, (PsiFile)sqlFile);
        }
        ScriptModel model = SqlPsiFacade.getInstance((Project)project).createScriptModel((PsiFile)subFile);
        ScriptModel m = ScriptModelUtil.adjustModelForSelection(model, (Document)documentWindow, selectionRange, execOption);
        return new Info(file, (PsiFile)subFile, (EditorEx)editor2, m, execOption, (NotNullFunction<PsiElement, TextRange>)((NotNullFunction)dom -> JdbcConsoleProvider.calcRangeInInjected(dom, copyOffsets, injectedOffsets)));
    }

    @NotNull
    private static TextRange calcRangeInInjected(PsiElement e, int[] copy, int[] injected) {
        TextRange range = e.getTextRange();
        int i1 = Arrays.binarySearch(copy, range.getStartOffset());
        int i2 = Arrays.binarySearch(copy, range.getEndOffset());
        if (i1 < 0 || i2 < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(range) + " not found in " + Arrays.toString(copy));
        }
        TextRange textRange = TextRange.create((int)injected[i1], (int)injected[i2]);
        if (textRange == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(21);
        }
        return textRange;
    }

    public static void chooseStatements(@NotNull Info info2, @NlsContexts.HintText @Nullable String nothingToRunText, boolean allowOutsideOption, @NotNull Consumer<? super ScriptModel<?>> consumer) {
        if (info2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(23);
        }
        JdbcConsoleProvider.chooseStatements(info2, info2.model, nothingToRunText, allowOutsideOption, consumer);
    }

    private static <E> void chooseStatements(final @NotNull Info info2, @NotNull ScriptModel<E> model, @NlsContexts.HintText @Nullable String nothingToRunText, boolean allowOutsideOption, @NotNull Consumer<? super ScriptModel<?>> consumer) {
        boolean noUI;
        if (info2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(24);
        }
        if (model == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(26);
        }
        DatabaseSettings.ExecOption execOption = info2.execOption;
        LinkedHashMap<Object, ScriptModel.ChosenRange> map2 = new LinkedHashMap<Object, ScriptModel.ChosenRange>();
        LinkedHashMap<Object, SyntaxTraverser.Api> apiMap = new LinkedHashMap<Object, SyntaxTraverser.Api>();
        for (ScriptModel.StatementIt it : model.statements()) {
            Object object = it.object();
            if (map2.containsValue(it.range())) continue;
            long offset = it.rangeOffset();
            map2.put(object, new ScriptModel.ChosenRange(offset > 0L ? it.range().shiftRight((int)offset) : it.range()));
            apiMap.put(object, it.api());
        }
        boolean modelAtCaret = model.getTextRange() instanceof ScriptModel.PositionRange;
        EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(model.getLanguage());
        boolean mapEmptyOrBatches = JBIterable.from(map2.keySet()).filter(modelAtCaret ? el -> Conditions.not((Condition)Conditions.or((Condition)helper.isBatchBlock((SyntaxTraverser.Api)apiMap.get(el)), (Condition)helper.isFile((SyntaxTraverser.Api)apiMap.get(el)))).value(el) : Conditions.alwaysTrue()).isEmpty();
        boolean bl = noUI = nothingToRunText == null;
        if (mapEmptyOrBatches) {
            boolean doDefault = true;
            int option = allowOutsideOption ? execOption.execOutside : -1;
            TextRange range = model.getTextRange();
            ScriptModel m = model.subModel(null);
            if (modelAtCaret && !m.statements().isEmpty()) {
                TextRange tailRange;
                ScriptModel m1;
                TextRange r;
                if (option == 1) {
                    doDefault = false;
                } else if (option == 2) {
                    consumer.consume((Object)m);
                    doDefault = false;
                } else if (option == 3 && (r = (TextRange)m.statements().transform(ScriptModelUtilCore.TO_RANGE).last()) != null && range.getStartOffset() < r.getEndOffset() && !(m1 = m.subModel(tailRange = TextRange.create((int)range.getStartOffset(), (int)r.getEndOffset()))).statements().isEmpty()) {
                    consumer.consume((Object)m1);
                    doDefault = false;
                }
            }
            if (!doDefault) {
                return;
            }
            if (noUI) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showErrorHint((Editor)info2.editor, nothingToRunText));
        } else if (!modelAtCaret) {
            consumer.consume(model);
        } else {
            int option = execOption.execInside;
            boolean doDefault = true;
            if (option == 2) {
                element = JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).first();
                consumer.consume((Object)model.subModel((TextRange)map2.get(element)));
                doDefault = false;
            } else if (option == 3 || option == 1 && noUI) {
                element = JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(el -> helper.isStatement((SyntaxTraverser.Api)apiMap.get(el)).value(el)).first();
                consumer.consume((Object)model.subModel((TextRange)map2.get(element)));
                doDefault = false;
            } else if (option == 4) {
                element = JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(el -> helper.isStatement((SyntaxTraverser.Api)apiMap.get(el)).value(el)).last();
                consumer.consume((Object)model.subModel((TextRange)map2.get(element)));
                doDefault = false;
            } else if (option == 5) {
                element = JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(el -> Conditions.or((Condition)helper.isBatchBlock((SyntaxTraverser.Api)apiMap.get(el)), (Condition)helper.isStatement((SyntaxTraverser.Api)apiMap.get(el))).value(el)).last();
                consumer.consume((Object)model.subModel((TextRange)map2.get(element)));
                doDefault = false;
            } else if (option == 6) {
                consumer.consume((Object)model.subModel(null));
                doDefault = false;
            } else if (option == 7) {
                element = JBIterable.from(JdbcConsoleProvider.smallToLarge(map2)).filter(el -> helper.isStatement((SyntaxTraverser.Api)apiMap.get(el)).value(el)).last();
                TextRange range = TextRange.create((int)((TextRange)map2.get(element)).getStartOffset(), (int)info2.file.getTextLength());
                consumer.consume((Object)model.subModel(range));
                doDefault = false;
            } else if (map2.size() == 1) {
                consumer.consume((Object)model.subModel((TextRange)ContainerUtil.getFirstItem(map2.values())));
                doDefault = false;
            }
            if (!doDefault) {
                return;
            }
            if (!info2.editor.getComponent().isShowing()) {
                return;
            }
            List targets = ContainerUtil.mapNotNull(JdbcConsoleProvider.smallToLarge(map2), e -> e instanceof PsiElement ? new PsiIntroduceTarget((PsiElement)e) : new AnyIntroduceTarget<Object>(e, (SyntaxTraverser.Api)apiMap.get(e)));
            targets = ContainerUtil.map((Collection)targets, target -> new MyIntroduceTarget((IntroduceTarget)target, (NotNullFunction<PsiElement, TextRange>)((NotNullFunction)ObjectUtils.notNull(info2.ranger, (Object)ScopeHighlighter.NATURAL_RANGER))));
            java.util.function.Consumer<IntroduceTarget> callback = target -> {
                Object element = JdbcConsoleProvider.getInnerElement(target);
                if (element != null) {
                    consumer.consume((Object)model.subModel((TextRange)map2.get(element)));
                }
            };
            Object selection = JBIterable.from((Iterable)targets).map(target -> JdbcConsoleProvider.getInnerElement(target)).filter(el -> helper.isStatement((SyntaxTraverser.Api)apiMap.get(el)).value(el)).first();
            int sel = selection != null ? JBIterable.from((Iterable)targets).indexOf(target -> selection.equals(JdbcConsoleProvider.getInnerElement(target))) : 0;
            String linkText = DatabaseBundle.message((String)"statement.chooser.settings.link.text", (Object[])new Object[0]);
            ActionLink label = new ActionLink((Action)new AbstractAction(linkText){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String message = DatabaseBundle.message((String)"settings.execute.in.console", (Object[])new Object[0]);
                    ShowSettingsUtilImpl.showSettingsDialog((Project)info2.file.getProject(), (String)"database.query.execution", (String)message);
                }
            });
            label.setBorder((Border)JBUI.Borders.empty((int)1, (int)2));
            IntroduceTargetChooser.showIntroduceTargetChooser((Editor)info2.editor, (List)targets, callback, (String)DatabaseBundle.message((String)"statement.chooser.header", (Object[])new Object[0]), (JComponent)label, (int)sel);
        }
    }

    @Nullable
    private static Object getInnerElement(IntroduceTarget target) {
        if (target instanceof MyIntroduceTarget) {
            target = ((MyIntroduceTarget)target).myDelegate;
        }
        return target instanceof PsiIntroduceTarget ? target.getPlace() : (target instanceof AnyIntroduceTarget ? ((AnyIntroduceTarget)target).myNode : null);
    }

    @NotNull
    private static <E> List<E> smallToLarge(@NotNull Map<E, TextRange> map2) {
        if (map2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(27);
        }
        List list = ContainerUtil.reverse(new ArrayList<E>(map2.keySet()));
        if (list == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(28);
        }
        return list;
    }

    public static boolean isSqlAtPlace(@Nullable PsiFile file, @Nullable Editor editor2) {
        return JdbcConsoleProvider.isSqlAtPlace(file, JdbcConsoleProvider.elementAt(file, null, editor2));
    }

    public static boolean isJSAtPlace(@Nullable PsiFile file, @Nullable Editor editor2) {
        return JdbcConsoleProvider.isJSAtPlace(file, JdbcConsoleProvider.elementAt(file, null, editor2));
    }

    private static boolean isJSAtPlace(@Nullable PsiFile file, @Nullable PsiElement elementAt) {
        return JdbcConsoleProvider.isInjected(elementAt) && ScriptModelUtilCore.isJSFile((PsiFile)((PsiFile)PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{PsiFile.class}))) || ScriptModelUtilCore.isJSFile((PsiFile)file);
    }

    private static boolean isInjected(@Nullable PsiElement elementAt) {
        return elementAt != null && InjectedLanguageUtil.getDocumentWindow((PsiElement)elementAt) != null;
    }

    private static boolean isSqlAtPlace(@Nullable PsiFile file, @Nullable PsiElement elementAt) {
        return JdbcConsoleProvider.isInjected(elementAt) && PsiTreeUtil.getContextOfType((PsiElement)elementAt, (Class[])new Class[]{SqlFile.class}) != null || file instanceof SqlFile || file != null && file.getFileType() == SqlFileType.INSTANCE;
    }

    @Contract(value="null, _, _->null; _, null, null->null")
    public static PsiElement elementAt(@Nullable PsiFile file, @Nullable PsiElement element, @Nullable Editor editor2) {
        int offset;
        int n = offset = file == null ? -1 : JdbcConsoleProvider.getOffset(element, editor2);
        if (offset < 0) {
            return null;
        }
        if (file instanceof SqlFile) {
            PsiElement e = file.findElementAt(offset);
            return e != null || offset == 0 ? e : file.findElementAt(offset - 1);
        }
        PsiElement e = InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)file, (int)offset);
        return e != null || offset == 0 ? e : InjectedLanguageUtilBase.findElementAtNoCommit((PsiFile)file, (int)(offset - 1));
    }

    private static int getOffset(@Nullable PsiElement element, @Nullable Editor editor2) {
        if (editor2 != null) {
            return editor2.getCaretModel().getOffset();
        }
        if (element != null) {
            return element.getTextRange().getStartOffset();
        }
        return -1;
    }

    public static void doRunQueryInConsole(@NotNull JdbcConsole console, @NotNull Info info2) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(29);
        }
        if (info2 == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(30);
        }
        JdbcConsoleProvider.chooseStatements(info2, DatabaseBundle.message((String)"hint.text.nothing.to.run", (Object[])new Object[0]), true, scriptModel -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            if (Objects.requireNonNull(info2.editor).isDisposed()) {
                return;
            }
            if (!console.isValid()) {
                return;
            }
            if (console.beforeExecuteQueries((ScriptModel<?>)scriptModel)) {
                VirtualFile file = info2.editor.getVirtualFile();
                SearchPath before = null;
                try {
                    if (DbImplUtil.isDatabaseVirtualFile((VirtualFile)file)) {
                        SearchPath searchPath = DatabaseEditorHelperCore.dbSrcSearchPath((Project)console.getProject(), (VirtualFile)file, (boolean)false);
                        searchPath = DbImplUtil.getAutoSwitchPath((LocalDataSource)console.getDataSource(), (SearchPath)searchPath);
                        before = JdbcConsoleProvider.ensureSearchPath(console, searchPath);
                    }
                    console.executeQueries((Editor)info2.editor, (ScriptModel<?>)scriptModel, info2.execOption);
                }
                finally {
                    JdbcConsoleProvider.ensureSearchPath(console, before);
                }
            }
        });
    }

    @Nullable
    private static SearchPath ensureSearchPath(@NotNull JdbcConsole console, @Nullable SearchPath searchPath) {
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(31);
        }
        SearchPath currentPath = console.getSearchPath();
        if (searchPath != null && !searchPath.equals((Object)currentPath)) {
            console.switchSchema(searchPath, false);
        }
        return currentPath;
    }

    @Nullable
    public static JdbcConsole reattachConsole(@NotNull Project project, @Nullable DatabaseSession session, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(32);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(33);
        }
        if (session == null) {
            JdbcConsoleProvider.detachConsole(project, file);
            return null;
        }
        return JdbcConsoleProvider.attachConsole(project, session, file);
    }

    public static void detachConsole(@NotNull Project project, @NotNull VirtualFile file) {
        JdbcConsole console;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(34);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(35);
        }
        if ((console = JdbcConsoleProvider.getConsole(project, file)) != null) {
            Disposer.dispose((Disposable)console);
        }
        DatabaseEditorHelper.removeConsoleToolbar(project, file);
        JdbcConsoleProvider.updatePresentation(project, file);
    }

    @Nullable
    public static JdbcConsole attachConsole(@NotNull Project project, @NotNull DatabaseSession session, @NotNull VirtualFile file) {
        DatabaseSession oldSession;
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(36);
        }
        if (session == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(37);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(38);
        }
        if (!JdbcConsoleProvider.isItPossibleToAttachConsoleTo(file) || !file.isValid()) {
            return null;
        }
        JdbcConsole oldConsole = JdbcConsoleProvider.getConsole(project, file);
        DatabaseSession databaseSession = oldSession = oldConsole == null ? null : oldConsole.getSession();
        if (oldConsole != null) {
            Disposer.dispose((Disposable)oldConsole);
        }
        JdbcConsole console = JdbcConsoleProvider.createConsole(project, session, file, oldSession);
        ChooseSchemaAction.scheduleSavedSchemaSwitch(console);
        ShowSqlParametersPanelAction.migrate(oldConsole, console);
        DatabaseEditorHelper.configureConsoleToolbar(project, console, file);
        DataSourcePerFileMappingsImpl.getInstance(project).setMappingAsync(file, session.getConnectionPoint().getDataSource(), () -> JdbcConsoleProvider.updatePresentation(project, file));
        TransactionGuard.submitTransaction((Disposable)console, () -> {
            JdbcConsoleProvider.updateSqlDialectMappingIfNeeded(project, file, console);
            FileContentUtilCore.reparseFiles((VirtualFile[])new VirtualFile[]{file});
        });
        return console;
    }

    private static void updatePresentation(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(39);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(40);
        }
        ProjectView.getInstance((Project)project).refresh(ProjectViewUpdateCause.PLUGIN_DBE);
        FileEditorManager.getInstance((Project)project).updateFilePresentation(file);
    }

    private static void updateSqlDialectMappingIfNeeded(@NotNull Project project, @NotNull VirtualFile file, @NotNull JdbcConsole console) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(41);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(42);
        }
        if (console == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(43);
        }
        if (DbVFSUtils.isAssociatedWithDataSource((VirtualFile)file, (Project)project)) {
            return;
        }
        if (!(file.getFileType() instanceof SqlFileType)) {
            return;
        }
        SqlLanguageDialect dialect = DbSqlUtilCore.getSqlDialect((LocalDataSource)console.getDataSource());
        ScratchRootType scratchRootType = ScratchRootType.getInstance();
        if (scratchRootType.containsFile(file)) {
            ScratchFileService.getInstance().getScratchesMapping().setMapping(file, (Object)dialect);
        } else if (file.isInLocalFileSystem()) {
            SqlPsiFacade.getInstance((Project)project).setDialectMapping(file, dialect);
        }
    }

    @NotNull
    private static JdbcConsole createConsole(@NotNull Project project, @NotNull DatabaseSession session, @NotNull VirtualFile file, @Nullable DatabaseSession oldSession) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(44);
        }
        if (session == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(45);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(46);
        }
        JdbcConsole jdbcConsole = JdbcConsole.newConsole(project).fromDataSource((DatabaseConnectionPoint)session.getTarget()).forFile(file).useSession(session).insteadOf(oldSession).build();
        if (jdbcConsole == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(47);
        }
        return jdbcConsole;
    }

    public static boolean isItPossibleToAttachConsoleTo(@NotNull VirtualFile file) {
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(48);
        }
        return !DatabaseEditorUtil.isTableFile(file) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file);
    }

    @Nullable
    public static JdbcConsole getValidConsole(@Nullable Project project, @Nullable VirtualFile file) {
        return (JdbcConsole)((Object)ObjectUtils.tryCast((Object)JdbcConsoleProviderCore.getValidConsole((Project)project, (VirtualFile)file), JdbcConsole.class));
    }

    @Nullable
    public static JdbcConsole getConsole(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(49);
        }
        if (file == null) {
            JdbcConsoleProvider.$$$reportNull$$$0(50);
        }
        return (JdbcConsole)((Object)ObjectUtils.tryCast((Object)JdbcConsoleProviderCore.getConsole((Project)project, (VirtualFile)file), JdbcConsole.class));
    }

    @Nullable
    public static DatabaseSession findOrCreateSession(@Nullable Project project, @Nullable VirtualFile file) {
        if (project == null || file == null) {
            return null;
        }
        GlobalSessionStateListener.SavedSession sessionInfo = (GlobalSessionStateListener.SavedSession)ReadAction.compute(() -> {
            if (!file.isValid()) {
                return null;
            }
            if (SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)file)) {
                return null;
            }
            return GlobalSessionStateListener.getSessionInfo(project, file);
        });
        if (sessionInfo == null) {
            return null;
        }
        LocalDataSource dataSource = sessionInfo.getDataSource();
        String sessionTitle = sessionInfo.getSessionName();
        if (!sessionInfo.getStrict()) {
            return DatabaseSessionManager.getSession((Project)project, (DatabaseConnectionPoint)dataSource, (String)sessionTitle);
        }
        return DatabaseSessionManager.getExactSession((Project)project, (DatabaseConnectionPoint)dataSource, (String)sessionTitle);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 21, 28, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 28: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 42: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 10: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execOption";
                break;
            }
            case 11: 
            case 15: 
            case 32: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionRange";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection0";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 22: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 29: 
            case 31: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 37: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunningConsoles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRangeInInjected";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "smallToLarge";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 21: 
            case 28: 
            case 47: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRunnersInner";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModel";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModelNoInject";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findScriptModelInInjection";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "chooseStatements";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "smallToLarge";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doRunQueryInConsole";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "ensureSearchPath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "reattachConsole";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "detachConsole";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "attachConsole";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "updateSqlDialectMappingIfNeeded";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isItPossibleToAttachConsoleTo";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 21, 28, 47 -> new IllegalStateException(string);
        };
    }

    public static class Info {
        @NotNull
        public final PsiFile originalFile;
        @NotNull
        public final PsiFile file;
        @Nullable
        public final EditorEx editor;
        @NotNull
        public final ScriptModel<?> model;
        @NotNull
        public final DatabaseSettings.ExecOption execOption;
        @Nullable
        public final NotNullFunction<PsiElement, TextRange> ranger;

        public Info(@NotNull PsiFile originalFile, @NotNull PsiFile file, @Nullable EditorEx editor2, @NotNull ScriptModel<?> model, @NotNull DatabaseSettings.ExecOption execOption, @Nullable NotNullFunction<PsiElement, TextRange> ranger) {
            if (originalFile == null) {
                Info.$$$reportNull$$$0(0);
            }
            if (file == null) {
                Info.$$$reportNull$$$0(1);
            }
            if (model == null) {
                Info.$$$reportNull$$$0(2);
            }
            if (execOption == null) {
                Info.$$$reportNull$$$0(3);
            }
            this.originalFile = originalFile;
            this.file = file;
            this.model = model;
            this.editor = editor2;
            this.execOption = execOption;
            this.ranger = ranger;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "execOption";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/console/JdbcConsoleProvider$Info";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyIntroduceTarget
    implements IntroduceTarget {
        final IntroduceTarget myDelegate;
        final NotNullFunction<PsiElement, TextRange> myRanger;

        MyIntroduceTarget(@NotNull IntroduceTarget delegate, NotNullFunction<PsiElement, TextRange> ranger) {
            if (delegate == null) {
                MyIntroduceTarget.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate;
            this.myRanger = ranger;
        }

        @NotNull
        public TextRange getTextRange() {
            PsiElement place = this.myDelegate.getPlace();
            TextRange textRange = place == null ? this.myDelegate.getTextRange() : (TextRange)this.myRanger.fun((Object)place);
            if (textRange == null) {
                MyIntroduceTarget.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        @Nullable
        public PsiElement getPlace() {
            return this.myDelegate.getPlace();
        }

        @NotNull
        public String render() {
            String string = StringUtil.first((String)this.myDelegate.render().replaceAll("\\s+", " "), (int)50, (boolean)true);
            if (string == null) {
                MyIntroduceTarget.$$$reportNull$$$0(2);
            }
            return string;
        }

        public boolean isValid() {
            return this.myDelegate.isValid();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider$MyIntroduceTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider$MyIntroduceTarget";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "render";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class AnyIntroduceTarget<E>
    implements IntroduceTarget {
        @NotNull
        final E myNode;
        @NotNull
        final SyntaxTraverser.Api<E> myApi;

        AnyIntroduceTarget(@NotNull E node, @NotNull SyntaxTraverser.Api<E> api) {
            if (node == null) {
                AnyIntroduceTarget.$$$reportNull$$$0(0);
            }
            if (api == null) {
                AnyIntroduceTarget.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.myApi = api;
        }

        @NotNull
        public TextRange getTextRange() {
            TextRange textRange = this.myApi.rangeOf(this.myNode);
            if (textRange == null) {
                AnyIntroduceTarget.$$$reportNull$$$0(2);
            }
            return textRange;
        }

        @Nullable
        public PsiElement getPlace() {
            return null;
        }

        @NotNull
        public String render() {
            String string = this.myApi.textOf(this.myNode).toString();
            if (string == null) {
                AnyIntroduceTarget.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isValid() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "api";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/JdbcConsoleProvider$AnyIntroduceTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/JdbcConsoleProvider$AnyIntroduceTarget";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "render";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

