/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.evaluation.JdbcConsoleEvaluationSupport;
import com.intellij.database.console.evaluation.OwnerBasedExpressionEvaluator;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.impl.actions.handlers.CustomEvaluationDialogData;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerCustomEvaluateHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/console/evaluation/JdbcCustomEvaluateHandler;", "Lcom/intellij/xdebugger/impl/actions/handlers/XDebuggerCustomEvaluateHandler;", "<init>", "()V", "createEvaluationDialogData", "Lcom/intellij/xdebugger/impl/actions/handlers/CustomEvaluationDialogData;", "dialogDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/actionSystem/AnActionEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "canEvaluate", "", "intellij.database.impl"})
final class JdbcCustomEvaluateHandler
implements XDebuggerCustomEvaluateHandler {
    @Nullable
    public Object createEvaluationDialogData(@NotNull Disposable dialogDisposable, @NotNull Project project, @NotNull AnActionEvent event, @NotNull Continuation<? super CustomEvaluationDialogData> $completion) {
        Object object;
        EditorEx editor2;
        JdbcConsole jdbcConsole = JdbcConsole.findConsole(event);
        Intrinsics.checkNotNull((Object)((Object)jdbcConsole));
        JdbcConsole console = jdbcConsole;
        Object object2 = event.getData(CommonDataKeys.EDITOR);
        EditorEx editorEx = editor2 = object2 instanceof EditorEx ? (EditorEx)object2 : null;
        if (editor2 == null) {
            return null;
        }
        LocalDataSource localDataSource = console.getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
        LocalDataSource source = localDataSource;
        DbDataSource dbDataSource = DbImplUtilCore.getDbDataSource((Project)project, (DasDataSource)((DasDataSource)source));
        Intrinsics.checkNotNull((Object)dbDataSource);
        DbDataSource dbDataSource2 = dbDataSource;
        SearchPath searchPath = console.getSearchPath();
        boolean useSelection = !EditorUtil.contextMenuInvokedOutsideOfSelection((AnActionEvent)event);
        JdbcConsoleEvaluationSupport.MyEvaluableInfo<?> info2 = JdbcConsoleEvaluationSupport.MyInfoFactory.getInfo(project, event);
        TextRange range = null;
        if (info2 == null) {
            TextRange textRange;
            DatabaseSettings.ExecOption execOption = DatabaseSettings.getDefaultExecOption();
            Intrinsics.checkNotNullExpressionValue((Object)execOption, (String)"getDefaultExecOption(...)");
            DatabaseSettings.ExecOption execOption2 = execOption;
            Caret caret = editor2.getCaretModel().getPrimaryCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
            Caret caret2 = caret;
            if (useSelection) {
                TextRange textRange2 = ScriptModelUtil.getSelectionForConsole((Editor)editor2, execOption2);
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getSelectionForConsole(...)");
            } else {
                TextRange textRange3 = TextRange.create((int)caret2.getOffset(), (int)caret2.getOffset());
                textRange = textRange3;
                Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"create(...)");
            }
            range = textRange;
            TextRange textRange4 = ScriptModelUtil.adjustModelForSelection(console.getScriptModel(), console.getDocument(), range, execOption2).getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange4, (String)"getTextRange(...)");
            range = textRange4;
        } else {
            TextRange textRange = info2.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRange(...)");
            range = textRange;
        }
        if (((object = info2) == null || (object = ((JdbcConsoleEvaluationSupport.MyEvaluableInfo)object).getQuery()) == null) && (object = JdbcConsole.getQueryText(console, range)) == null) {
            object = "";
        }
        Object query = object;
        ScriptModel scriptModel = console.getScriptModel().subModel(range);
        Intrinsics.checkNotNullExpressionValue((Object)scriptModel, (String)"subModel(...)");
        ScriptModel subModel = scriptModel;
        if (!(info2 == null && range.isEmpty() || subModel.statements().isEmpty() || JdbcConsole.beforeExecuteRange(console, range))) {
            return null;
        }
        XExpressionImpl expression = new XExpressionImpl((String)query, console.getLanguage(), null);
        JdbcConsoleEvaluationSupport.MyEditorProvider provider = new JdbcConsoleEvaluationSupport.MyEditorProvider(console, dbDataSource2);
        OwnerBasedExpressionEvaluator.TextExpressionEvaluator evaluator = new OwnerBasedExpressionEvaluator.TextExpressionEvaluator((DataRequest.OwnerEx)console, dbDataSource2, searchPath, project, dialogDisposable);
        JdbcConsoleEvaluationSupport.MyProxy<String> proxy2 = new JdbcConsoleEvaluationSupport.MyProxy<String>(evaluator){

            public String getValue(String expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                return expression;
            }
        };
        return new CustomEvaluationDialogData((XDebuggerEvaluator)proxy2, (XDebuggerEditorsProvider)provider, (XExpression)expression, null, false);
    }

    public boolean canEvaluate(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return JdbcConsoleEvaluationSupport.isEnabled(project, event);
    }
}

