/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.AuthWidgetBuilder;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0016J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0001H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006H\u0016JI\u0010\b\u001a\u0004\u0018\u00010\u00012\u0013\u0010\u0005\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\t0\u00062\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0010H\u0016JA\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0013\u0010\u0005\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\t0\u00062\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0010H\u0016JI\u0010\u0011\u001a\u0004\u0018\u00010\u00012\u0013\u0010\u0005\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\t0\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0010H\u0016JV\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0013\u0010\u0005\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\t0\u00062\u0013\u0010\u0015\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\t0\u00062\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0010H\u0016JA\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0013\u0010\u0005\u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\t0\u00062\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\u0010H\u0016J8\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u000b2\u0010\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0010H\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dataSource/ui/AuthWidgetBuilderBase;", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder;", "<init>", "()V", "addUserField", "label", "Ljava/util/function/Supplier;", "", "addPasswordField", "Lcom/intellij/openapi/util/NlsContexts$Label;", "serialiser", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$Serialiser;", "Lcom/intellij/credentialStore/OneTimeString;", "withStorage", "", "urlHandler", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$UrlHandler;", "addTextField", "completion", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$CompletionProvider;", "addFileField", "description", "addCheckBox", "addHandler", "value", "UserNameSerializer", "PasswordSerializer", "intellij.database.impl"})
public abstract class AuthWidgetBuilderBase
implements AuthWidgetBuilder {
    @Nullable
    public AuthWidgetBuilder addUserField() {
        Supplier supplier = DatabaseBundle.messagePointer((String)"database.auth.user.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        return this.addUserField(supplier);
    }

    @Nullable
    public AuthWidgetBuilder addUserField(@NotNull Supplier<String> label) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        return this.addTextField(label, (AuthWidgetBuilder.Serialiser<String>)((AuthWidgetBuilder.Serialiser)UserNameSerializer.INSTANCE), (AuthWidgetBuilder.UrlHandler<String>)AuthWidgetBuilder.removeParameterHandler((String)"user"));
    }

    @Nullable
    public AuthWidgetBuilder addPasswordField() {
        Supplier supplier = DatabaseBundle.messagePointer((String)"database.auth.password.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        return this.addPasswordField(supplier);
    }

    @Nullable
    public AuthWidgetBuilder addPasswordField(@NotNull Supplier<String> label) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        return this.addPasswordField(label, (AuthWidgetBuilder.Serialiser<OneTimeString>)((AuthWidgetBuilder.Serialiser)PasswordSerializer.INSTANCE), true, (AuthWidgetBuilder.UrlHandler<OneTimeString>)AuthWidgetBuilder.adapt((AuthWidgetBuilder.UrlHandler)AuthWidgetBuilder.removeParameterHandler((String)"password"), null));
    }

    @Nullable
    public AuthWidgetBuilder addPasswordField(@NotNull Supplier<String> label, @NotNull AuthWidgetBuilder.Serialiser<OneTimeString> serialiser, boolean withStorage, @Nullable AuthWidgetBuilder.UrlHandler<OneTimeString> urlHandler) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        Intrinsics.checkNotNullParameter(serialiser, (String)"serialiser");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public AuthWidgetBuilder addTextField(@NotNull Supplier<String> label, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        Intrinsics.checkNotNullParameter(serialiser, (String)"serialiser");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public AuthWidgetBuilder addTextField(@NotNull Supplier<String> label, @NotNull AuthWidgetBuilder.CompletionProvider completion, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)completion, (String)"completion");
        Intrinsics.checkNotNullParameter(serialiser, (String)"serialiser");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public AuthWidgetBuilder addFileField(@NotNull Supplier<String> label, @NotNull Supplier<String> description, @NotNull AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        Intrinsics.checkNotNullParameter(description, (String)"description");
        Intrinsics.checkNotNullParameter(serialiser, (String)"serialiser");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public AuthWidgetBuilder addCheckBox(@NotNull Supplier<String> label, @NotNull AuthWidgetBuilder.Serialiser<Boolean> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<Boolean> urlHandler) {
        Intrinsics.checkNotNullParameter(label, (String)"label");
        Intrinsics.checkNotNullParameter(serialiser, (String)"serialiser");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public AuthWidgetBuilder addHandler(@Nullable String value, @Nullable AuthWidgetBuilder.Serialiser<String> serialiser, @Nullable AuthWidgetBuilder.UrlHandler<String> urlHandler) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dataSource/ui/AuthWidgetBuilderBase$PasswordSerializer;", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$Serialiser;", "Lcom/intellij/credentialStore/OneTimeString;", "<init>", "()V", "save", "", "v", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "load", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "intellij.database.impl"})
    private static final class PasswordSerializer
    implements AuthWidgetBuilder.Serialiser<OneTimeString> {
        @NotNull
        public static final PasswordSerializer INSTANCE = new PasswordSerializer();

        private PasswordSerializer() {
        }

        public void save(@Nullable OneTimeString v, @NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                DatabaseCredentials databaseCredentials = credentials;
                if (databaseCredentials == null) break block0;
                databaseCredentials.storePassword(config, v);
            }
        }

        @Nullable
        public OneTimeString load(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            DatabaseCredentials databaseCredentials = credentials;
            return databaseCredentials != null ? DatabaseCredentials.loadPassword$default((DatabaseCredentials)databaseCredentials, (DatabaseConnectionPoint)point, null, (int)2, null) : null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/dataSource/ui/AuthWidgetBuilderBase$UserNameSerializer;", "Lcom/intellij/database/dataSource/ui/AuthWidgetBuilder$Serialiser;", "", "<init>", "()V", "save", "", "v", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "load", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "intellij.database.impl"})
    private static final class UserNameSerializer
    implements AuthWidgetBuilder.Serialiser<String> {
        @NotNull
        public static final UserNameSerializer INSTANCE = new UserNameSerializer();

        private UserNameSerializer() {
        }

        public void save(@Nullable String v, @NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            LocalDataSource.setUsername((DatabaseConnectionConfig)config, (String)v);
        }

        @NotNull
        public String load(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            String string = LocalDataSource.getUsername((DatabaseConnectionPoint)point);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUsername(...)");
            return string;
        }
    }
}

