/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.debugger;

import com.intellij.database.debugger.SqlProgramSource;
import com.intellij.database.debugger.SqlProgramSourceKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016J\u0015\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0001H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0001H\u00c6\u0001J\u0014\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\bH\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020 H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"Lcom/intellij/database/debugger/SqlProgramPosition;", "Lcom/intellij/xdebugger/XSourcePosition;", "source", "Lcom/intellij/database/debugger/SqlProgramSource;", "xPosition", "<init>", "(Lcom/intellij/database/debugger/SqlProgramSource;Lcom/intellij/xdebugger/XSourcePosition;)V", "fileLine", "", "(Lcom/intellij/database/debugger/SqlProgramSource;I)V", "getSource", "()Lcom/intellij/database/debugger/SqlProgramSource;", "getXPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLine", "getOffset", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "Lorg/jetbrains/annotations/NotNull;", "project", "Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.database.impl"})
public final class SqlProgramPosition
implements XSourcePosition {
    @NotNull
    private final SqlProgramSource source;
    @NotNull
    private final XSourcePosition xPosition;

    public SqlProgramPosition(@NotNull SqlProgramSource source, @NotNull XSourcePosition xPosition) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)xPosition, (String)"xPosition");
        this.source = source;
        this.xPosition = xPosition;
    }

    @NotNull
    public final SqlProgramSource getSource() {
        return this.source;
    }

    @NotNull
    public final XSourcePosition getXPosition() {
        return this.xPosition;
    }

    public SqlProgramPosition(@NotNull SqlProgramSource source, int fileLine) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source, SqlProgramSourceKt.createVirtualFilePosition(source.getVirtualFile(), fileLine));
    }

    @NotNull
    public VirtualFile getFile() {
        return this.source.getVirtualFile();
    }

    public int getLine() {
        return this.xPosition.getLine();
    }

    public int getOffset() {
        return this.xPosition.getOffset();
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Navigatable navigatable = this.xPosition.createNavigatable(project);
        Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
        return navigatable;
    }

    @NotNull
    public final SqlProgramSource component1() {
        return this.source;
    }

    @NotNull
    public final XSourcePosition component2() {
        return this.xPosition;
    }

    @NotNull
    public final SqlProgramPosition copy(@NotNull SqlProgramSource source, @NotNull XSourcePosition xPosition) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)xPosition, (String)"xPosition");
        return new SqlProgramPosition(source, xPosition);
    }

    public static /* synthetic */ SqlProgramPosition copy$default(SqlProgramPosition sqlProgramPosition, SqlProgramSource sqlProgramSource, XSourcePosition xSourcePosition, int n, Object object) {
        if ((n & 1) != 0) {
            sqlProgramSource = sqlProgramPosition.source;
        }
        if ((n & 2) != 0) {
            xSourcePosition = sqlProgramPosition.xPosition;
        }
        return sqlProgramPosition.copy(sqlProgramSource, xSourcePosition);
    }

    @NotNull
    public String toString() {
        return "SqlProgramPosition(source=" + this.source + ", xPosition=" + this.xPosition + ")";
    }

    public int hashCode() {
        int result2 = this.source.hashCode();
        result2 = result2 * 31 + this.xPosition.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SqlProgramPosition)) {
            return false;
        }
        SqlProgramPosition sqlProgramPosition = (SqlProgramPosition)other;
        if (!Intrinsics.areEqual((Object)this.source, (Object)sqlProgramPosition.source)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.xPosition, (Object)sqlProgramPosition.xPosition);
    }
}

