/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.actions.ddl.DbModifyObjectDialogPanel;
import com.intellij.database.editor.DialogBootstrapperKt;
import com.intellij.database.editor.StructureRecoveryState;
import com.intellij.database.editor.TableStructureFileEditorState;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicObjectNode;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementMatcher;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0014J\u001c\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J&\u0010\u001d\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/database/editor/TableStructureEditorBootstrapper;", "Lcom/intellij/database/actions/ddl/DbModifyObjectDialogPanel$ObjectEditorBootstrapper;", "project", "Lcom/intellij/openapi/project/Project;", "basicModel", "Lcom/intellij/database/model/basic/BasicModel;", "basicElement", "Lcom/intellij/database/model/basic/BasicElement;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/basic/BasicModel;Lcom/intellij/database/model/basic/BasicElement;)V", "getBasicElement", "()Lcom/intellij/database/model/basic/BasicElement;", "recoveryState", "Lcom/intellij/database/editor/TableStructureFileEditorState;", "getRecoveryState", "()Lcom/intellij/database/editor/TableStructureFileEditorState;", "setRecoveryState", "(Lcom/intellij/database/editor/TableStructureFileEditorState;)V", "onTargetModelReady", "", "targetModel", "Lcom/intellij/database/model/basic/BasicModModel;", "targetOwner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "targetElementIdentity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "createTargetId", "matcher", "Lcom/intellij/database/schemaEditor/ElementMatcher;", "createEditorModelImpl", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "controller", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "targetId", "intellij.database.impl"})
public final class TableStructureEditorBootstrapper
extends DbModifyObjectDialogPanel.ObjectEditorBootstrapper {
    @NotNull
    private final BasicElement basicElement;
    @NotNull
    private TableStructureFileEditorState recoveryState;

    public TableStructureEditorBootstrapper(@NotNull Project project, @NotNull BasicModel basicModel, @NotNull BasicElement basicElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)basicModel, (String)"basicModel");
        Intrinsics.checkNotNullParameter((Object)basicElement, (String)"basicElement");
        super(project, basicModel, null);
        this.basicElement = basicElement;
        this.recoveryState = TableStructureFileEditorState.Companion.getEMPTY();
    }

    @NotNull
    public final BasicElement getBasicElement() {
        return this.basicElement;
    }

    @NotNull
    public final TableStructureFileEditorState getRecoveryState() {
        return this.recoveryState;
    }

    public final void setRecoveryState(@NotNull TableStructureFileEditorState tableStructureFileEditorState) {
        Intrinsics.checkNotNullParameter((Object)tableStructureFileEditorState, (String)"<set-?>");
        this.recoveryState = tableStructureFileEditorState;
    }

    @Override
    protected void onTargetModelReady(@NotNull BasicModModel targetModel, @NotNull ElementOwner targetOwner, @NotNull ElementIdentity<?> targetElementIdentity) {
        block0: {
            TableStructureFileEditorState tableStructureFileEditorState;
            Intrinsics.checkNotNullParameter((Object)targetModel, (String)"targetModel");
            Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
            Intrinsics.checkNotNullParameter(targetElementIdentity, (String)"targetElementIdentity");
            BasicElement basicElement = targetOwner.find(targetElementIdentity);
            if (basicElement == null) break block0;
            BasicElement targetElement = basicElement;
            boolean bl = false;
            TableStructureFileEditorState it = tableStructureFileEditorState = new TableStructureFileEditorState();
            boolean bl2 = false;
            it.getRecoveryStates().addAll((Collection<StructureRecoveryState>)this.recoveryState.getRecoveryStates());
            TableStructureFileEditorState stateCopy = tableStructureFileEditorState;
            DialogBootstrapperKt.applyRecoveryState(targetElement, stateCopy, this.getTargetElementOwner(), (Function1<? super ObjectPath, ? extends BasicElement>)((Function1)arg_0 -> TableStructureEditorBootstrapper.onTargetModelReady$lambda$0$1(targetModel, arg_0)));
        }
    }

    @Override
    @NotNull
    public ElementIdentity<?> createTargetId(@NotNull ElementMatcher matcher, @NotNull ElementOwner targetOwner) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)targetOwner, (String)"targetOwner");
        ElementOwner elementOwner = matcher.getOriginalOwner();
        if (elementOwner == null) {
            throw new AssertionError((Object)"Should have original owner");
        }
        ElementOwner originalOwner = elementOwner;
        BasicElement basicElement = targetOwner.find(DialogBootstrapperKt.doPull(originalOwner, (BasicObjectNode)this.basicElement));
        if (basicElement == null) {
            throw new AssertionError((Object)"Should have found basic element");
        }
        BasicElement targetElement = basicElement;
        return DialogBootstrapperKt.doPull(targetOwner, (BasicObjectNode)targetElement);
    }

    @Override
    @Nullable
    protected DbEditorModel<?, ?> createEditorModelImpl(@NotNull DbEditorModelController controller, @NotNull ElementIdentity<?> targetId) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(targetId, (String)"targetId");
        return controller.getBuilder().createAppropriateObjectEditorModel(controller, targetId);
    }

    private static final BasicElement onTargetModelReady$lambda$0$1(BasicModModel $targetModel, ObjectPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        JBIterable jBIterable = QNameUtil.findByPath((DasModel)((DasModel)$targetModel), (ObjectPath)path);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"findByPath(...)");
        Object object = CollectionsKt.firstOrNull((Iterable)((Iterable)jBIterable));
        return object instanceof BasicElement ? (BasicElement)object : null;
    }
}

