/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.Dbms;
import com.intellij.database.explorer.structure.DvExtraNode;
import com.intellij.database.explorer.structure.DvTreeImplantingLayer;
import com.intellij.database.explorer.structure.DvTreeLayer;
import com.intellij.database.explorer.structure.DvTreeStructureService;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModLikeColumn;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.migration.DbMigrationRequest;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.util.sequences.EmptyMatSequence;
import com.intellij.database.util.sequences.MatSequence;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\bH\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00000\u001fJ\u001a\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0#J&\u0010$\u001a\u0004\u0018\u00010\n2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010\u0007\u001a\u00020\u001bH\u0002J,\u0010%\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0&2\b\u0010'\u001a\u0004\u0018\u00010\u00002\u0006\u0010(\u001a\u00020\u0019J\b\u0010)\u001a\u00020!H\u0002J\"\u0010*\u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\n2\b\u0010'\u001a\u0004\u0018\u00010\u0000H\u0002J,\u0010+\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0&2\u0006\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0019H\u0002J\n\u0010,\u001a\u00020-H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lcom/intellij/database/model/migration/DbMigrationElement;", "", "request", "Lcom/intellij/database/model/migration/DbMigrationRequest;", "side", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "parent", "base", "Lcom/intellij/database/model/basic/BasicNode;", "altElement", "Lcom/intellij/database/model/basic/BasicModElement;", "<init>", "(Lcom/intellij/database/model/migration/DbMigrationRequest;Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;Lcom/intellij/database/model/migration/DbMigrationElement;Lcom/intellij/database/model/basic/BasicNode;Lcom/intellij/database/model/basic/BasicModElement;)V", "getParent", "()Lcom/intellij/database/model/migration/DbMigrationElement;", "getBase", "()Lcom/intellij/database/model/basic/BasicNode;", "getAltElement", "()Lcom/intellij/database/model/basic/BasicModElement;", "createAltElement", "basicNode", "getAltParentOfKind", "kind", "Lcom/intellij/database/model/ObjectKind;", "isAlwaysLeaf", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "createChild", "node", "getChildren", "", "pullDeps", "", "index", "", "instantiate", "prepare", "", "other", "withSources", "hackPgDefaultValue", "fillAltElement", "fillAltElementUpward", "toString", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationElement\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 SequenceFun.kt\ncom/intellij/database/util/sequences/SequenceFun\n*L\n1#1,703:1\n1661#2,3:704\n30#3,2:707\n55#4:709\n*S KotlinDebug\n*F\n+ 1 DbMigrationTreeModel.kt\ncom/intellij/database/model/migration/DbMigrationElement\n*L\n91#1:704,3\n95#1:707,2\n96#1:709\n*E\n"})
public final class DbMigrationElement {
    @NotNull
    private final DbMigrationRequest request;
    @NotNull
    private final DbMigrationTreeModel.Side side;
    @Nullable
    private final DbMigrationElement parent;
    @NotNull
    private final BasicNode base;
    @Nullable
    private final BasicModElement altElement;

    public DbMigrationElement(@NotNull DbMigrationRequest request, @NotNull DbMigrationTreeModel.Side side, @Nullable DbMigrationElement parent2, @NotNull BasicNode base, @Nullable BasicModElement altElement) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this.request = request;
        this.side = side;
        this.parent = parent2;
        this.base = base;
        this.altElement = altElement;
    }

    @Nullable
    public final DbMigrationElement getParent() {
        return this.parent;
    }

    @NotNull
    public final BasicNode getBase() {
        return this.base;
    }

    @Nullable
    public final BasicModElement getAltElement() {
        return this.altElement;
    }

    private final BasicModElement createAltElement(BasicNode basicNode) {
        ModFamily altFamily;
        BasicModElement parentAltElement;
        DbMigrationElement realParent;
        if (this.side == DbMigrationTreeModel.Side.TARGET) {
            return null;
        }
        if (!(basicNode instanceof BasicElement)) {
            return null;
        }
        BasicElement basicElement = ((BasicElement)basicNode).getParent();
        DbMigrationElement dbMigrationElement = realParent = this.getAltParentOfKind((ObjectKind)(basicElement != null ? basicElement.getKind() : null));
        BasicModElement basicModElement = parentAltElement = dbMigrationElement != null ? dbMigrationElement.altElement : null;
        ModFamily modFamily = altFamily = basicModElement != null ? (ModFamily)basicModElement.familyOf(((BasicElement)basicNode).getKind()) : null;
        return modFamily != null ? modFamily.createNewOne() : null;
    }

    private final DbMigrationElement getAltParentOfKind(ObjectKind kind) {
        if (kind == null) {
            return null;
        }
        DbMigrationElement current = this;
        while (current != null) {
            BasicNode e = current.base;
            if (e instanceof BasicElement && Intrinsics.areEqual((Object)((BasicElement)e).getKind(), (Object)kind)) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }

    private final boolean isAlwaysLeaf(BasicElement e) {
        return !e.hasChildren() || e instanceof BasicSourceAware && !(e instanceof BasicView);
    }

    private final DbMigrationElement createChild(BasicNode node) {
        return new DbMigrationElement(this.request, this.side, this, node, this.createAltElement(node));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DbMigrationElement> getChildren() {
        if (this.base instanceof BasicElement) {
            if (this.isAlwaysLeaf((BasicElement)this.base)) {
                return CollectionsKt.emptyList();
            }
            List<BasicElement> list = this.request.getRoot(this.side).getRoot().getRootElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRootElements(...)");
            List<BasicElement> requestedElements = list;
            if (this.parent == null && Intrinsics.areEqual((Object)((BasicElement)CollectionsKt.first(requestedElements)).getParent(), (Object)this.base)) {
                void $this$mapTo$iv;
                Iterable iterable = requestedElements;
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void p0;
                    BasicNode basicNode = (BasicNode)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(this.createChild((BasicNode)p0));
                }
                return (List)destination$iv;
            }
        }
        ComponentManager $this$service$iv = (ComponentManager)this.request.getProject();
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeLayer treeLayer = ((DvTreeStructureService)object).getLayoutLayer();
        DvTreeLayer dvTreeLayer = treeLayer;
        if (dvTreeLayer == null || (dvTreeLayer = dvTreeLayer.childrenOf(this.base)) == null) {
            boolean $i$f$emptyMatSequence = false;
            dvTreeLayer = (Sequence)((MatSequence)EmptyMatSequence.INSTANCE);
        }
        DvTreeLayer baseChildren = dvTreeLayer;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)baseChildren, arg_0 -> DbMigrationElement.getChildren$lambda$0(treeLayer, arg_0)), DbMigrationElement::getChildren$lambda$1), arg_0 -> DbMigrationElement.getChildren$lambda$2(this, arg_0)), (Function1)((Function1)new Function1<BasicNode, DbMigrationElement>((Object)this){

            public final DbMigrationElement invoke(BasicNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DbMigrationElement.access$createChild((DbMigrationElement)this.receiver, p0);
            }
        })));
    }

    public final void pullDeps(@NotNull Map<BasicElement, ? extends BasicModElement> index) {
        Intrinsics.checkNotNullParameter(index, (String)"index");
        if (!(this.base instanceof BasicElement)) {
            return;
        }
        if (this.altElement == null) {
            return;
        }
        BasicMetaObject basicMetaObject = BasicMetaUtils.getMetaObject((BasicElement)((BasicElement)this.base));
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"getMetaObject(...)");
        BasicMetaObject baseMeta = basicMetaObject;
        BasicMetaObject basicMetaObject2 = BasicMetaUtils.getMetaObject((BasicElement)((BasicElement)this.altElement));
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject2, (String)"getMetaObject(...)");
        BasicMetaObject altMeta = basicMetaObject2;
        Intrinsics.checkNotNullExpressionValue((Object)baseMeta.references, (String)"references");
        for (BasicMetaProperty r : baseMeta.references) {
            BasicMetaReference altMetaRef;
            BasicMetaReference baseMetaRef;
            if (r.isInternal() || BasicMetaReference.asRef((BasicMetaProperty)r) == null || altMeta.getReference(baseMetaRef.getId()) == null) continue;
            BasicElement baseTarget = BasicMetaUtils.resolve((BasicElement)((BasicElement)this.base), (BasicMetaReferenceDesc)baseMetaRef.getReferenceDesc(), (BasicReference)((BasicReference)baseMetaRef.get((BasicElement)this.base)));
            BasicElement altTarget = BasicMetaUtils.resolve((BasicElement)((BasicElement)this.altElement), (BasicMetaReferenceDesc)altMetaRef.getReferenceDesc(), (BasicReference)((BasicReference)altMetaRef.get((BasicElement)this.altElement)));
            if (baseTarget == null || altTarget != null) continue;
            this.instantiate(index, baseTarget);
        }
    }

    private final BasicModElement instantiate(Map<BasicElement, ? extends BasicModElement> index, BasicElement base) {
        BasicElement basicElement = base.getParent();
        if (basicElement == null) {
            return null;
        }
        BasicElement baseParent = basicElement;
        BasicModElement basicModElement = index.get(baseParent);
        if (basicModElement == null && (basicModElement = this.instantiate(index, baseParent)) == null) {
            return null;
        }
        BasicModElement altParent = basicModElement;
        ModFamily modFamily = (ModFamily)altParent.familyOf(base.getKind());
        if (modFamily == null) {
            return null;
        }
        ModFamily targetFamily = modFamily;
        BasicModElement basicModElement2 = targetFamily.createNewOne();
        Intrinsics.checkNotNullExpressionValue((Object)basicModElement2, (String)"createNewOne(...)");
        BasicModElement alt = basicModElement2;
        DbDiffElement.copyChildren(base, alt, true);
        this.fillAltElement(base, alt, null);
        return alt;
    }

    public final void prepare(@NotNull Map<BasicElement, BasicModElement> index, @Nullable DbMigrationElement other, boolean withSources) {
        Intrinsics.checkNotNullParameter(index, (String)"index");
        if (!(this.base instanceof BasicElement)) {
            return;
        }
        if (this.altElement == null) {
            return;
        }
        index.put((BasicElement)this.base, this.altElement);
        this.fillAltElement((BasicElement)this.base, this.altElement, other);
        if (!DbDiffElement.isContainer((BasicElement)this.base)) {
            DbDiffElement.copyChildren((BasicElement)this.base, this.altElement, withSources, DbMigrationElement::prepare$lambda$0);
        }
        if (withSources) {
            BasicMetaUtils.copySourceText((BasicElement)((BasicElement)this.base), (BasicModElement)this.altElement, (boolean)true, (boolean)true);
        }
        if (other != null && this.parent == null) {
            this.fillAltElementUpward(index, other, withSources);
        }
        this.hackPgDefaultValue();
    }

    private final void hackPgDefaultValue() {
        if (!(this.altElement instanceof BasicModLikeColumn)) {
            return;
        }
        boolean pgLike = ((BasicModModel)((BasicModLikeColumn)this.altElement).getModel()).getDbms().in(Dbms.POSTGRES_LIKE);
        if (!pgLike) {
            return;
        }
        String string = ((BasicModLikeColumn)this.altElement).getDefaultExpression();
        if (string == null) {
            return;
        }
        String def = string;
        BasicNode basicNode = this.base;
        Object object = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
        if (object == null || (object = object.getSchema()) == null || (object = object.getName()) == null) {
            return;
        }
        Object originSchemaName = object;
        String qualification = (String)originSchemaName + ".";
        int idx = StringsKt.indexOf$default((CharSequence)def, (String)qualification, (int)0, (boolean)false, (int)6, null);
        if (idx == -1) {
            return;
        }
        String string2 = def.substring(0, idx);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String string3 = def.substring(idx + qualification.length());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String hackedDefault = string2 + string3;
        ((BasicModLikeColumn)this.altElement).setDefaultExpression(hackedDefault);
    }

    private final void fillAltElement(BasicElement base, BasicModElement altElement, DbMigrationElement other) {
        if (other != null && other.base instanceof BasicElement) {
            DbDiffElement.assignElement((BasicElement)other.base, altElement, false);
        }
        if (Intrinsics.areEqual((Object)base.getMetaObject(), (Object)altElement.getMetaObject())) {
            ModelLightCopier.copyProperties((BasicElement)base, (BasicModElement)altElement, (boolean)false, (boolean)true);
        } else {
            BasicMetaUtils.copyMatchedProperties((BasicElement)base, (BasicModElement)altElement, (other == null ? 1 : 0) != 0, (boolean)false, (boolean)true);
        }
    }

    private final void fillAltElementUpward(Map<BasicElement, BasicModElement> index, DbMigrationElement other, boolean withSources) {
        if (!(other.base instanceof BasicElement)) {
            return;
        }
        BasicNode basicNode = this.base;
        BasicElement b = basicNode instanceof BasicElement ? (BasicElement)basicNode : null;
        BasicModElement alt = this.altElement;
        for (BasicElement o = (BasicElement)other.base; alt != null && o != null; alt = (BasicModElement)alt.getParent(), o = o.getParent()) {
            if (b != null) {
                index.put(b, alt);
            }
            DbDiffElement.assignElement(o, alt, withSources);
            BasicElement basicElement = b;
            b = basicElement != null ? basicElement.getParent() : null;
        }
    }

    @NotNull
    public String toString() {
        return "DbMigrationElement(base=" + this.base + ")";
    }

    private static final Sequence getChildren$lambda$0(DvTreeLayer $treeLayer, BasicNode it) {
        DvTreeLayer dvTreeLayer;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof DvExtraNode) {
            dvTreeLayer = $treeLayer;
            if (dvTreeLayer == null || (dvTreeLayer = dvTreeLayer.childrenOf(it)) == null) {
                dvTreeLayer = SequencesKt.emptySequence();
            }
        } else {
            dvTreeLayer = SequencesKt.sequenceOf((Object)it);
        }
        return dvTreeLayer;
    }

    private static final boolean getChildren$lambda$1(BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof DvTreeImplantingLayer.ImplantedNode);
    }

    private static final boolean getChildren$lambda$2(DbMigrationElement this$0, BasicNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(this$0.base instanceof BasicView) || it instanceof Family && ((Family)it).isNotEmpty() && Intrinsics.areEqual((Object)((DasNamed)((Family)it).first()).getKind(), (Object)ObjectKind.TRIGGER);
    }

    private static final boolean prepare$lambda$0(ObjectKind kind) {
        return !Intrinsics.areEqual((Object)kind, (Object)ObjectKind.TRIGGER);
    }

    public static final /* synthetic */ DbMigrationElement access$createChild(DbMigrationElement $this, BasicNode node) {
        return $this.createChild(node);
    }
}

