/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.DetailRow;
import com.intellij.database.plan.ui.PlanRenderers;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.database.plan.ui.PlanView;
import com.intellij.database.plan.ui.QueryPlanDetailsTableModelKt;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.psi.documentation.DbTableDocumentationTarget;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.icons.AllIcons;
import com.intellij.lang.documentation.ide.impl.DocumentationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.TableView;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 T2\u00020\u0001:\bNOPQRSTUB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0002J\u0012\u0010%\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020\u000bJ\u0006\u0010,\u001a\u00020\u000bJ\b\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020.2\b\u00100\u001a\u0004\u0018\u00010\tJ+\u00101\u001a\u00020\u00072\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u000304032\u0006\u00100\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u00020.2\u0006\u00100\u001a\u00020\tH\u0002J+\u00107\u001a\u00020.2\u0006\u0010\u0006\u001a\u00020\u00072\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030403H\u0002\u00a2\u0006\u0002\u00108J+\u00109\u001a\u00020.2\u0006\u00100\u001a\u00020\t2\u0014\u00102\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030403H\u0002\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020.H\u0002J\u0010\u0010<\u001a\u00020.2\u0006\u0010=\u001a\u00020>H\u0002J2\u0010?\u001a\u00020.2\u0010\u0010@\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b2\u0006\u0010A\u001a\u00020B2\u0010\u0010C\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010DJ\u001a\u0010E\u001a\u00020.2\u0012\u0010@\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001bJ\u001a\u0010F\u001a\u00020#2\u0012\u0010@\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001bJ\u0012\u0010G\u001a\u00020H2\b\u0010I\u001a\u0004\u0018\u00010BH\u0002J\u001c\u0010J\u001a\u00020.*\u00020K2\u0006\u0010L\u001a\u00020*2\u0006\u0010I\u001a\u00020\u000bH\u0002J\u0012\u0010M\u001a\u00020.2\b\u0010I\u001a\u0004\u0018\u00010BH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0019\u001a\u0018\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\u0012\u0004\u0012\u00020\u001d0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/database/plan/ui/PlanView;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "table", "Lcom/intellij/ui/dualView/TreeTableView;", "currentModel", "Lcom/intellij/database/plan/PlanModel;", "panel", "Ljavax/swing/JComponent;", "detailsTableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/database/plan/ui/DetailRow;", "detailsTable", "Lcom/intellij/ui/table/TableView;", "detailsTableScrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "splitter", "Lcom/intellij/ui/JBSplitter;", "scrollPane", "Ljavax/swing/JScrollPane;", "tabs", "Lcom/intellij/ui/JBTabsPaneImpl;", "charts", "", "Lcom/intellij/database/plan/ui/PlanView$MyColumnInfo;", "", "Lcom/intellij/database/plan/ui/PlanView$ChartData;", "toolbar", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "treeRenderer", "Lcom/intellij/database/plan/ui/PlanRenderers$ActionRenderer;", "isNewUi", "", "createDetailsTable", "isTableRow", "detailRow", "getDocumentationTarget", "Lcom/intellij/database/psi/documentation/DbTableDocumentationTarget;", "tableName", "", "getComponent", "getPreferredFocusedComponent", "updateTabVisibility", "", "setModel", "model", "createTreeTableView", "columns", "", "Lcom/intellij/util/ui/ColumnInfo;", "([Lcom/intellij/util/ui/ColumnInfo;Lcom/intellij/database/plan/PlanModel;)Lcom/intellij/ui/dualView/TreeTableView;", "updateDetailsTable", "configureTable", "(Lcom/intellij/ui/dualView/TreeTableView;[Lcom/intellij/util/ui/ColumnInfo;)V", "updateCharts", "(Lcom/intellij/database/plan/PlanModel;[Lcom/intellij/util/ui/ColumnInfo;)V", "clearView", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "registerChart", "column", "comp", "Ljava/awt/Component;", "updater", "Lcom/intellij/util/Consumer;", "removeChart", "hasChart", "findTabIdx", "", "component", "registerWithShortcutSet", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionId", "removeTab", "ChartData", "ShowFullAction", "NlsColumnInfo", "NlsTreeColumnInfo", "MyColumnInfo", "NumericCellRenderer", "Companion", "PlanTreeTableView", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nPlanView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanView.kt\ncom/intellij/database/plan/ui/PlanView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,756:1\n1#2:757\n14125#3,3:758\n1915#4,2:761\n296#4,2:763\n*S KotlinDebug\n*F\n+ 1 PlanView.kt\ncom/intellij/database/plan/ui/PlanView\n*L\n375#1:758,3\n426#1:761,2\n466#1:763,2\n*E\n"})
public final class PlanView
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private TreeTableView table;
    @Nullable
    private PlanModel currentModel;
    @NotNull
    private final JComponent panel;
    @NotNull
    private final ListTableModel<DetailRow> detailsTableModel;
    @NotNull
    private final TableView<DetailRow> detailsTable;
    @NotNull
    private final JBScrollPane detailsTableScrollPane;
    @NotNull
    private final JBSplitter splitter;
    @NotNull
    private final JScrollPane scrollPane;
    @NotNull
    private final JBTabsPaneImpl tabs;
    @NotNull
    private final Map<MyColumnInfo<? extends Number>, ChartData> charts;
    @NotNull
    private final ActionToolbarImpl toolbar;
    @NotNull
    private final PlanRenderers.ActionRenderer treeRenderer;
    private final boolean isNewUi;
    @NotNull
    private static final ColumnInfo<?, ?> OPERATION_COLUMN;
    @NotNull
    private static final MyColumnInfo<String> PARAMS_COLUMN;
    @NotNull
    private static final MyColumnInfo<BigDecimal> NUM_ROWS_COLUMN;
    @NotNull
    private static final MyColumnInfo<BigDecimal> ACTUAL_NUM_ROWS_COLUMN;
    @JvmField
    @NotNull
    public static final MyColumnInfo<Double> TOTAL_COST_COLUMN;
    @JvmField
    @NotNull
    public static final MyColumnInfo<Double> ACTUAL_TOTAL_TIME_COLUMN;
    @JvmField
    @NotNull
    public static final MyColumnInfo<Double> STARTUP_COST_COLUMN;
    @JvmField
    @NotNull
    public static final MyColumnInfo<Double> ACTUAL_STARTUP_TIME_COLUMN;
    @NotNull
    private static final ColumnInfo<?, ?> RAW_DESC_COLUMN;

    /*
     * WARNING - void declaration
     */
    private PlanView(Project project) {
        BorderLayoutPanel borderLayoutPanel;
        void $this$_init__u24lambda_u240;
        ActionToolbarImpl $this$tabs_u24lambda_u240;
        void $this$scrollPane_u24lambda_u240;
        JScrollPane $this$splitter_u24lambda_u240;
        JBScrollPane $this$detailsTableScrollPane_u24lambda_u240;
        JBScrollPane jBScrollPane;
        this.project = project;
        this.detailsTableModel = QueryPlanDetailsTableModelKt.createDetailsTableModel();
        this.detailsTable = this.createDetailsTable();
        JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)this.detailsTable);
        PlanView planView = this;
        boolean bl = false;
        $this$detailsTableScrollPane_u24lambda_u240.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)8));
        planView.detailsTableScrollPane = jBScrollPane;
        $this$detailsTableScrollPane_u24lambda_u240 = jBScrollPane = new JBSplitter(false, 0.7f, 0.15f, 0.85f);
        planView = this;
        boolean $i$a$-apply-PlanView$splitter$22 = false;
        $this$splitter_u24lambda_u240.setShowDividerControls(false);
        $this$splitter_u24lambda_u240.setDividerWidth(1);
        planView.splitter = jBScrollPane;
        JScrollPane $i$a$-apply-PlanView$splitter$22 = $this$splitter_u24lambda_u240 = ScrollPaneFactory.createScrollPane();
        planView = this;
        boolean bl2 = false;
        $this$scrollPane_u24lambda_u240.setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)12));
        JScrollPane jScrollPane = $this$splitter_u24lambda_u240;
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"apply(...)");
        planView.scrollPane = jScrollPane;
        jBScrollPane = new JBTabsPaneImpl(this.project, 3, (Disposable)this);
        $this$splitter_u24lambda_u240 = jBScrollPane;
        planView = this;
        boolean $i$a$-apply-PlanView$tabs$22 = false;
        $this$tabs_u24lambda_u240.getComponent().setBorder((Border)JBUI.Borders.empty());
        $this$tabs_u24lambda_u240.getTabs().getPresentation().setShowBorder(false);
        planView.tabs = jBScrollPane;
        this.charts = new LinkedHashMap();
        this.treeRenderer = new PlanRenderers.ActionRenderer(this.project);
        this.isNewUi = Registry.Companion.is("database.explain.plan.new.ui", false);
        AnAction anAction = ActionManagerEx.Companion.getInstanceEx().getAction("PlanViewGroup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        ActionToolbarImpl $i$a$-apply-PlanView$tabs$22 = $this$tabs_u24lambda_u240 = new ActionToolbarImpl("toolbar", actionGroup, false, false, false, 24, null);
        planView = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u240.setTargetComponent(this.tabs.getComponent());
        $this$_init__u24lambda_u240.setBorder(this.isNewUi ? (Border)JBUI.Borders.empty((int)3, (int)5, (int)0, (int)7) : JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)0, (int)1));
        planView.toolbar = $this$tabs_u24lambda_u240;
        BorderLayoutPanel $this$_init__u24lambda_u241 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl4 = false;
        $this$_init__u24lambda_u241.addToCenter((Component)this.tabs.getComponent());
        $this$_init__u24lambda_u241.addToLeft((Component)this.toolbar);
        BorderLayoutPanel layoutPanel = borderLayoutPanel;
        if (this.isNewUi) {
            BorderLayoutPanel $this$_init__u24lambda_u242 = borderLayoutPanel = this.splitter;
            boolean bl5 = false;
            $this$_init__u24lambda_u242.setFirstComponent((JComponent)this.scrollPane);
            $this$_init__u24lambda_u242.setSecondComponent((JComponent)this.detailsTableScrollPane);
            this.tabs.insertTab(DatabaseBundle.message((String)"PlanView.tab.title.operations.tree", (Object[])new Object[0]), null, (Component)this.splitter, null, 0);
        } else {
            this.tabs.insertTab(DatabaseBundle.message((String)"PlanView.tab.title.operations.tree", (Object[])new Object[0]), null, (Component)this.scrollPane, null, 0);
        }
        this.updateTabVisibility();
        this.panel = UiDataProvider.Companion.wrapComponent((JComponent)layoutPanel, new UiDataProvider(){

            public final void uiDataSnapshot(DataSink p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                this.uiDataSnapshot(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, (Object)this, PlanView.class, "uiDataSnapshot", "uiDataSnapshot(Lcom/intellij/openapi/actionSystem/DataSink;)V", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof UiDataProvider ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    private final TableView<DetailRow> createDetailsTable() {
        TableView tableView;
        TableView $this$createDetailsTable_u24lambda_u240 = tableView = new TableView(this.detailsTableModel);
        boolean bl = false;
        $this$createDetailsTable_u24lambda_u240.setShowGrid(false);
        $this$createDetailsTable_u24lambda_u240.setShowHorizontalLines(false);
        $this$createDetailsTable_u24lambda_u240.setShowVerticalLines(false);
        $this$createDetailsTable_u24lambda_u240.setBorder((Border)JBUI.Borders.empty());
        $this$createDetailsTable_u24lambda_u240.setExpandableItemsEnabled(false);
        $this$createDetailsTable_u24lambda_u240.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(this){
            private final NumericCellRenderer numericRenderer;
            final /* synthetic */ PlanView this$0;
            {
                this.this$0 = $receiver;
                this.numericRenderer = new NumericCellRenderer();
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object formattedValue;
                Component c2;
                Object object;
                block10: {
                    block8: {
                        block9: {
                            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                            if (column != 1 || !(value instanceof String)) break block8;
                            object = StringsKt.toBigDecimalOrNull((String)((String)value));
                            if (object == null) break block9;
                            Object bd = object;
                            boolean bl = false;
                            String string = this.numericRenderer.formatValue(bd);
                            object = string;
                            if (string != null) break block10;
                        }
                        Double d = StringsKt.toDoubleOrNull((String)((String)value));
                        if (d != null) {
                            double d2 = ((Number)d).doubleValue();
                            boolean bl = false;
                            object = this.numericRenderer.formatValue(d2);
                        } else {
                            object = (String)value;
                        }
                        break block10;
                    }
                    object = value;
                }
                if ((c2 = super.getTableCellRendererComponent(table, formattedValue = object, isSelected, hasFocus, row, column)) instanceof JComponent) {
                    ((JComponent)c2).setBorder(column == 0 ? (Border)JBUI.Borders.empty((int)3, (int)12, (int)4, (int)6) : (Border)JBUI.Borders.empty((int)3, (int)6, (int)4, (int)6));
                    TableView tableView = table instanceof TableView ? (TableView)table : null;
                    Object object2 = tableView != null ? tableView.getRow(row) : null;
                    DetailRow detailRow = object2 instanceof DetailRow ? (DetailRow)object2 : null;
                    boolean isTableRow = PlanView.access$isTableRow(this.this$0, detailRow);
                    if (!isTableRow) {
                        Object object3 = value;
                        if (object3 == null || (object3 = object3.toString()) == null) {
                            object3 = "";
                        }
                        Object valueStr = object3;
                        FontMetrics metrics = ((JComponent)c2).getFontMetrics(((JComponent)c2).getFont());
                        int cellWidth = table.getColumnModel().getColumn(column).getWidth();
                        int textWidth = metrics.stringWidth((String)valueStr);
                        ((JComponent)c2).setToolTipText(textWidth > cellWidth - 12 ? "<html><body style='width: 300px'>" + (String)valueStr + "</body></html>" : null);
                    } else {
                        ((JComponent)c2).setToolTipText(null);
                    }
                }
                Intrinsics.checkNotNull((Object)c2);
                return c2;
            }
        });
        $this$createDetailsTable_u24lambda_u240.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter((TableView<DetailRow>)$this$createDetailsTable_u24lambda_u240, this){
            final /* synthetic */ TableView<DetailRow> $this_apply;
            final /* synthetic */ PlanView this$0;
            {
                this.$this_apply = $this_apply;
                this.this$0 = $receiver;
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.$this_apply.rowAtPoint(e.getPoint());
                int col = this.$this_apply.columnAtPoint(e.getPoint());
                if (row >= 0 && col >= 0 && col == 1 && row < this.$this_apply.getRowCount()) {
                    DetailRow detailRow = (DetailRow)this.$this_apply.getRow(row);
                    if (detailRow == null) {
                        return;
                    }
                    DetailRow detailRow2 = detailRow;
                    if (PlanView.access$isTableRow(this.this$0, detailRow2)) {
                        DbTableDocumentationTarget dbTableDocumentationTarget = this.this$0.getDocumentationTarget(detailRow2.getValue());
                        if (dbTableDocumentationTarget == null) {
                            return;
                        }
                        DbTableDocumentationTarget target = dbTableDocumentationTarget;
                        Rectangle cellRect = this.$this_apply.getCellRect(row, col, true);
                        WriteIntentReadAction.run(() -> createDetailsTable.1.2.mouseMoved$lambda$0(this.this$0, target, cellRect));
                    }
                }
            }

            private static final void mouseMoved$lambda$0(PlanView this$0, DbTableDocumentationTarget $target, Rectangle $cellRect) {
                DocumentationManager documentationManager = DocumentationManager.Companion.getInstance(PlanView.access$getProject$p(this$0));
                List list = CollectionsKt.listOf((Object)$target);
                Project project = PlanView.access$getProject$p(this$0);
                Component component = (Component)PlanView.access$getDetailsTable$p(this$0);
                Intrinsics.checkNotNull((Object)$cellRect);
                documentationManager.showDocumentationOnHoverAround(list, project, component, $cellRect, 200, 500, null);
            }
        });
        return tableView;
    }

    private final boolean isTableRow(DetailRow detailRow) {
        String string;
        Object object = detailRow;
        if (object != null && (object = ((DetailRow)object).getName()) != null) {
            String string2 = ((String)object).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        return Intrinsics.areEqual(string, (Object)"table");
    }

    @Nullable
    public final DbTableDocumentationTarget getDocumentationTarget(@NotNull String tableName) {
        Object v3;
        PlanModel model;
        block9: {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            PlanModel planModel = this.currentModel;
            if (planModel == null) {
                return null;
            }
            model = planModel;
            String string = model.getDataSourceId();
            if (string == null) {
                return null;
            }
            String dataSourceId = string;
            List list = DbPsiFacade.getInstance((Project)this.project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource it = (DbDataSource)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)dataSourceId)) continue;
                v3 = t;
                break block9;
            }
            v3 = null;
        }
        DbDataSource dbDataSource = v3;
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource = dbDataSource;
        SearchPath searchPath = model.getSearchPath();
        if (searchPath == null) {
            return null;
        }
        SearchPath searchPath2 = searchPath;
        DasObject dasObject = (DasObject)QNameUtil.findByPath((DasModel)dataSource.getModel(), (ObjectPath)searchPath2.getCurrent()).first();
        if (dasObject == null) {
            return null;
        }
        DasObject currentNamespace = dasObject;
        SqlReferenceExpression sqlReferenceExpression = SqlPsiElementFactory.createReferenceFromText((String)tableName, (SqlLanguageDialect)DbSqlUtil.getSqlDialect((DbDataSource)dataSource), (SqlReferenceElementType)SqlCompositeElementTypes.SQL_TABLE_REFERENCE, (Project)this.project, (PsiElement)((PsiElement)DbImplUtilCore.findElement((DbDataSource)dataSource, (DasObject)currentNamespace)));
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression ref = sqlReferenceExpression;
        PsiElement psiElement = ref.getReference().resolve();
        if (psiElement == null) {
            return null;
        }
        PsiElement resolvedElement = psiElement;
        DbTableImpl dbTableImpl = resolvedElement instanceof DbTableImpl ? (DbTableImpl)resolvedElement : null;
        if (dbTableImpl == null) {
            return null;
        }
        DbTableImpl dbTable = dbTableImpl;
        return new DbTableDocumentationTarget(dbTable);
    }

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return this.panel;
    }

    private final void updateTabVisibility() {
        if (!this.isNewUi) {
            return;
        }
        this.tabs.getTabs().getPresentation().setHideTabs(this.tabs.getTabCount() <= 1);
    }

    public final void setModel(@Nullable PlanModel model) {
        this.currentModel = model;
        PlanModel planModel = model;
        if (planModel != null) {
            TreeTableView newTable;
            PlanModel it = planModel;
            boolean bl = false;
            ColumnInfo<?, ?>[] columns = Companion.columnsFor(it, this.isNewUi);
            this.table = newTable = this.createTreeTableView(columns, it);
            this.configureTable(newTable, columns);
            this.updateCharts(it, columns);
        } else {
            this.clearView();
        }
    }

    private final TreeTableView createTreeTableView(ColumnInfo<?, ?>[] columns, PlanModel model) {
        PlanTreeTableView planTreeTableView;
        PlanTreeNode planTreeNode = PlanTreeNode.create(model.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)planTreeNode, (String)"create(...)");
        PlanTreeTableView $this$createTreeTableView_u24lambda_u240 = planTreeTableView = new PlanTreeTableView(planTreeNode, columns);
        boolean bl = false;
        $this$createTreeTableView_u24lambda_u240.putClientProperty(PlanView.class, this);
        $this$createTreeTableView_u24lambda_u240.getTree().getTreeTable().putClientProperty((Object)RenderingUtil.ALWAYS_PAINT_SELECTION_AS_FOCUSED, (Object)true);
        $this$createTreeTableView_u24lambda_u240.addMouseListener(new MouseAdapter($this$createTreeTableView_u24lambda_u240){
            final /* synthetic */ PlanTreeTableView $this_apply;
            {
                this.$this_apply = $this_apply;
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = this.$this_apply.rowAtPoint(e.getPoint());
                int col = this.$this_apply.columnAtPoint(e.getPoint());
                if (e.getButton() == 3 && row >= 0 && col >= 0) {
                    this.$this_apply.changeSelection(row, col, false, false);
                }
            }
        });
        if (this.isNewUi) {
            $this$createTreeTableView_u24lambda_u240.getSelectionModel().addListSelectionListener(arg_0 -> PlanView.createTreeTableView$lambda$0$0($this$createTreeTableView_u24lambda_u240, this, model, arg_0));
            $this$createTreeTableView_u24lambda_u240.setRowSelectionAllowed(true);
            $this$createTreeTableView_u24lambda_u240.setColumnSelectionAllowed(false);
            DefaultTableCellRenderer noFocusRenderer2 = new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                    Component c2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (c2 instanceof JComponent) {
                        ((JComponent)c2).setBorder(DefaultTableCellRenderer.noFocusBorder);
                    }
                    Intrinsics.checkNotNull((Object)c2);
                    return c2;
                }
            };
            $this$createTreeTableView_u24lambda_u240.setDefaultRenderer(Object.class, noFocusRenderer2);
            $this$createTreeTableView_u24lambda_u240.getSelectionModel().setSelectionInterval(0, 0);
        }
        $this$createTreeTableView_u24lambda_u240.setTreeCellRenderer(this.treeRenderer);
        $this$createTreeTableView_u24lambda_u240.setRootVisible(false);
        return planTreeTableView;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateDetailsTable(PlanModel model) {
        Sequence kvs;
        PlanModel.GenericNode genericNode = PlanView.Companion.getSelectedNode(this.table);
        if (genericNode == null) {
            PlanView $this$updateDetailsTable_u24lambda_u240 = this;
            boolean bl = false;
            $this$updateDetailsTable_u24lambda_u240.detailsTable.getListTableModel().setItems(CollectionsKt.emptyList());
            return;
        }
        PlanModel.GenericNode node = genericNode;
        List rows = new ArrayList();
        NumericCellRenderer numericFormatter = new NumericCellRenderer();
        PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.operation", node.getTitle());
        String string = node.getExtraInfo();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtraInfo(...)");
        if (((CharSequence)string).length() > 0) {
            String string2 = node.getExtraInfo();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtraInfo(...)");
            if (StringsKt.contains$default((CharSequence)string2, (CharSequence)";", (boolean)false, (int)2, null)) {
                String string3 = node.getExtraInfo();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getExtraInfo(...)");
                String[] bl = new String[]{";"};
                List params = StringsKt.split$default((CharSequence)string3, (String[])bl, (boolean)false, (int)0, (int)6, null);
                for (String param : params) {
                    if (StringsKt.contains$default((CharSequence)param, (CharSequence)":", (boolean)false, (int)2, null)) {
                        String string4;
                        String[] stringArray = new String[]{":"};
                        List list = StringsKt.split$default((CharSequence)param, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
                        String key = (String)list.get(0);
                        String value = (String)list.get(1);
                        String string5 = ((Object)StringsKt.trim((CharSequence)key)).toString();
                        if (((CharSequence)string5).length() > 0) {
                            String string6;
                            void it;
                            char c2 = string5.charAt(0);
                            StringBuilder stringBuilder = new StringBuilder();
                            boolean bl2 = false;
                            if (Character.isLowerCase((char)it)) {
                                Locale locale = Locale.getDefault();
                                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                                string6 = CharsKt.titlecase((char)it, (Locale)locale);
                            } else {
                                string6 = String.valueOf((char)it);
                            }
                            StringBuilder stringBuilder2 = stringBuilder.append((Object)string6);
                            String string7 = string5;
                            int n = 1;
                            String string8 = string7.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"substring(...)");
                            string4 = stringBuilder2.append(string8).toString();
                        } else {
                            string4 = string5;
                        }
                        String capitalizedKey = string4;
                        PlanView.updateDetailsTable$addRow(numericFormatter, rows, capitalizedKey, ((Object)StringsKt.trim((CharSequence)value)).toString());
                        continue;
                    }
                    PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.params", param);
                }
            } else {
                PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.params", node.getExtraInfo());
            }
        }
        if (!model.getUnsupported().contains(PlanModel.Feature.NUM_ROWS)) {
            PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.rows", node.getPlanNumRows());
            if (model.isActual()) {
                PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.actual.rows", node.getActualNumRows());
            }
        }
        if (!model.getUnsupported().contains(PlanModel.Feature.TOTAL_COST)) {
            PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.total.cost", node.getTotalCost());
            if (model.isActual()) {
                PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.actual.total.time", node.getActualTotalTime());
            }
        }
        if (!model.getUnsupported().contains(PlanModel.Feature.STARTUP_COST)) {
            PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.startup.cost", node.getStartupCost());
            if (model.isActual()) {
                PlanView.updateDetailsTable$addRow(numericFormatter, rows, "PlanView.column.name.actual.startup.time", node.getActualStartupTime());
            }
        }
        PlanView.updateDetailsTable$addRow(numericFormatter, rows, "Very long cell", "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        String string9 = node.getRawDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getRawDescription(...)");
        String raw = string9;
        if (((CharSequence)raw).length() > 0 && SequenceFun.isNotEmpty((Sequence)(kvs = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)((Object)StringsKt.trim((CharSequence)raw)).toString()), PlanView::updateDetailsTable$lambda$2), PlanView::updateDetailsTable$lambda$3)))) {
            CollectionsKt.addAll((Collection)rows, (Sequence)SequencesKt.map((Sequence)kvs, PlanView::updateDetailsTable$lambda$4));
        }
        this.detailsTable.getListTableModel().setItems(rows);
        if (!((Collection)rows).isEmpty()) {
            this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(0, 0, true));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureTable(TreeTableView table, ColumnInfo<?, ?>[] columns) {
        this.scrollPane.setViewportView((Component)table);
        this.toolbar.setTargetComponent(this.tabs.getComponent());
        TreeUtil.expandAll((JTree)((JTree)table.getTree()));
        FontMetrics metrics = table.getFontMetrics(table.getFont());
        int minWidth = metrics.stringWidth("XXXX");
        int spacing = metrics.stringWidth("X");
        ColumnInfo<?, ?>[] $this$forEachIndexed$iv = columns;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ColumnInfo<?, ?> item$iv : $this$forEachIndexed$iv) {
            void var28_27;
            Number number;
            void column;
            int n = index$iv++;
            ColumnInfo<?, ?> columnInfo = item$iv;
            int i = n;
            boolean bl = false;
            TableColumn columnModel = table.getColumnModel().getColumn(i);
            if (Intrinsics.areEqual((Object)column, RAW_DESC_COLUMN)) {
                number = metrics.stringWidth("XXXXXXXXXXXX");
            } else {
                Double d;
                Iterator iterator = ((Iterable)RangesKt.until((int)0, (int)table.getRowCount())).iterator();
                if (!iterator.hasNext()) {
                    d = null;
                } else {
                    int row = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    double d2 = PlanView.Companion.getRendererWidth((JTable)table, false, row, i);
                    while (iterator.hasNext()) {
                        int row2 = ((IntIterator)iterator).nextInt();
                        $i$a$-maxOfOrNull-PlanView$configureTable$1$size$maxSize$1 = false;
                        double d3 = PlanView.Companion.getRendererWidth((JTable)table, false, row2, i);
                        d2 = Math.max(d2, d3);
                    }
                    d = d2;
                }
                double maxSize = d != null ? d : (double)columnModel.getMinWidth();
                number = Math.max(maxSize, PlanView.Companion.getRendererWidth((JTable)table, true, -1, i) + (double)spacing);
            }
            Integer size = number;
            columnModel.setPreferredWidth(((Number)size).intValue());
            columnModel.setMinWidth(minWidth);
            if (!this.isNewUi || !Intrinsics.areEqual((Object)(var28_27 = column), NUM_ROWS_COLUMN) && !Intrinsics.areEqual((Object)var28_27, ACTUAL_NUM_ROWS_COLUMN) && !Intrinsics.areEqual((Object)var28_27, TOTAL_COST_COLUMN) && !Intrinsics.areEqual((Object)var28_27, ACTUAL_TOTAL_TIME_COLUMN) && !Intrinsics.areEqual((Object)var28_27, STARTUP_COST_COLUMN) && !Intrinsics.areEqual((Object)var28_27, ACTUAL_STARTUP_TIME_COLUMN)) continue;
            columnModel.setCellRenderer(new NumericCellRenderer());
        }
        if (!this.isNewUi) {
            AnAction[] showFullAction;
            AnAction[] anActionArray;
            AnAction[] $this$configureTable_u24lambda_u241 = anActionArray = (showFullAction = new ShowFullAction());
            boolean bl = false;
            this.registerWithShortcutSet((AnAction)$this$configureTable_u24lambda_u241, "ViewSource", (JComponent)table);
            anActionArray = new AnAction[]{showFullAction};
            PopupHandler.installPopupMenu((JComponent)((JComponent)table), (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (String)"QueryPlanTablePopup");
        }
        table.revalidate();
    }

    private final void updateCharts(PlanModel model, ColumnInfo<?, ?>[] columns) {
        this.charts.entrySet().removeIf(arg_0 -> PlanView.updateCharts$lambda$1(arg_0 -> PlanView.updateCharts$lambda$0(columns, model, this, arg_0), arg_0));
    }

    private final void clearView() {
        this.scrollPane.setViewportView(null);
        this.toolbar.setTargetComponent(null);
        Iterable $this$forEach$iv = (Iterable)RangesKt.downTo((int)this.tabs.getTabCount(), (int)1);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            this.tabs.removeTabAt(it);
        }
        this.charts.clear();
        this.updateTabVisibility();
    }

    private final void uiDataSnapshot(DataSink sink) {
        DataKey dataKey = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
        sink.set(dataKey, (Object)this.project);
        DataKey dataKey2 = PlatformCoreDataKeys.SELECTED_ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"SELECTED_ITEM");
        sink.set(dataKey2, (Object)PlanView.Companion.getSelectedNode(this.table));
        DataKey dataKey3 = CommonDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey3, (String)"VIRTUAL_FILE");
        sink.set(dataKey3, null);
    }

    public final void registerChart(@NotNull MyColumnInfo<? extends Number> column, @NotNull Component comp, @Nullable Consumer<PlanModel> updater) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        Object[] objectArray = new Object[]{column.getName()};
        this.tabs.insertTab(DatabaseBundle.message((String)"PlanView.tab.title.flame.chart", (Object[])objectArray), null, comp, null, -1);
        this.charts.put(column, new ChartData(comp, updater));
        if (this.isNewUi) {
            Integer n = this.findTabIdx(comp);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it != -1 ? n : null;
            if (n2 != null) {
                int tabIndex = ((Number)n2).intValue();
                boolean bl2 = false;
                TabInfo tabInfo = this.tabs.getTabs().getTabAt(tabIndex);
                Intrinsics.checkNotNullExpressionValue((Object)tabInfo, (String)"getTabAt(...)");
                TabInfo tabInfo2 = tabInfo;
                AnAction[] anActionArray = AllIcons.Actions.Close;
                DumbAwareAction closeAction2 = new DumbAwareAction(this, column, (Icon)anActionArray){
                    final /* synthetic */ PlanView this$0;
                    final /* synthetic */ MyColumnInfo<? extends Number> $column;
                    {
                        this.this$0 = $receiver;
                        this.$column = $column;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        this.this$0.removeChart(this.$column);
                    }

                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.EDT;
                    }
                };
                anActionArray = new AnAction[]{closeAction2};
                tabInfo2.setTabLabelActions((ActionGroup)new DefaultActionGroup(anActionArray), "unknown");
                this.tabs.setSelectedIndex(tabIndex);
            }
        }
        this.updateTabVisibility();
    }

    public final void removeChart(@Nullable MyColumnInfo<? extends Number> column) {
        ChartData chartData = (ChartData)TypeIntrinsics.asMutableMap(this.charts).remove(column);
        if (chartData != null) {
            ChartData it = chartData;
            boolean bl = false;
            this.removeTab(it.getComponent());
        }
        this.updateTabVisibility();
    }

    public final boolean hasChart(@Nullable MyColumnInfo<? extends Number> column) {
        return this.charts.containsKey(column);
    }

    private final int findTabIdx(Component component) {
        Object v0;
        block2: {
            if (component == null) {
                return -1;
            }
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)this.tabs.getTabCount());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!(this.tabs.getComponentAt(it) == component)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n : -1;
    }

    private final void registerWithShortcutSet(AnAction $this$registerWithShortcutSet, String actionId, JComponent component) {
        $this$registerWithShortcutSet.registerCustomShortcutSet(ActionManager.getInstance().getAction(actionId).getShortcutSet(), component);
    }

    private final void removeTab(Component component) {
        block0: {
            Integer n = this.findTabIdx(component);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it != -1 ? n : null;
            if (n2 == null) break block0;
            it = ((Number)n2).intValue();
            boolean bl2 = false;
            this.tabs.removeTabAt(it);
        }
    }

    private static final void createTreeTableView$lambda$0$0(PlanTreeTableView $this_apply, PlanView this$0, PlanModel $model, ListSelectionEvent e) {
        block1: {
            if (e.getValueIsAdjusting()) break block1;
            int[] nArray = $this_apply.getSelectionModel().getSelectedIndices();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
            Integer n = ArraysKt.firstOrNull((int[])nArray);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                this$0.updateDetailsTable($model);
            }
        }
    }

    private static final void updateDetailsTable$addRow(NumericCellRenderer numericFormatter, List<DetailRow> rows, String labelKey, Object value) {
        Object object = value;
        String s = object == null ? null : (object instanceof BigDecimal || object instanceof Double || object instanceof Number ? numericFormatter.formatValue(value) : value.toString());
        object = s;
        if (!(object == null || object.length() == 0)) {
            String string = DatabaseBundle.messageOr((String)labelKey, (String)labelKey, (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageOr(...)");
            String key = string;
            rows.add(new DetailRow(key, s));
        }
    }

    private static final List updateDetailsTable$lambda$2(String line) {
        List list;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String cleanLine = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)line, (String)";", (String)"", (boolean)false, (int)4, null))).toString();
        if (StringsKt.contains$default((CharSequence)cleanLine, (char)'=', (boolean)false, (int)2, null)) {
            Object[] objectArray = new char[]{'='};
            List parts = StringsKt.split$default((CharSequence)cleanLine, (char[])objectArray, (boolean)false, (int)2, (int)2, null);
            objectArray = new String[2];
            objectArray[0] = (char)((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
            objectArray[1] = (char)((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            Object[] objectArray = new String[]{cleanLine, ""};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return list;
    }

    private static final boolean updateDetailsTable$lambda$3(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.size() == 2 && !StringsKt.isBlank((CharSequence)((CharSequence)it.get(0)));
    }

    private static final DetailRow updateDetailsTable$lambda$4(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DetailRow((String)it.get(0), (String)it.get(1));
    }

    private static final boolean updateCharts$lambda$0(ColumnInfo[] $columns, PlanModel $model, PlanView this$0, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        MyColumnInfo key = (MyColumnInfo)((Object)entry.getKey());
        ChartData chartData = (ChartData)entry.getValue();
        if (ArrayUtil.contains((Object)((Object)key), (Object[])Arrays.copyOf($columns, $columns.length))) {
            Consumer<PlanModel> consumer = chartData.getUpdater();
            if (consumer != null) {
                consumer.consume((Object)$model);
            }
            bl = false;
        } else {
            this$0.removeTab(chartData.getComponent());
            bl = true;
        }
        return bl;
    }

    private static final boolean updateCharts$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String PARAMS_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getExtraInfo() : null;
    }

    private static final BigDecimal NUM_ROWS_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getPlanNumRows() : null;
    }

    private static final BigDecimal ACTUAL_NUM_ROWS_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getActualNumRows() : null;
    }

    private static final Double TOTAL_COST_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getTotalCost() : null;
    }

    private static final Double ACTUAL_TOTAL_TIME_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getActualTotalTime() : null;
    }

    private static final Double STARTUP_COST_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getStartupCost() : null;
    }

    private static final Double ACTUAL_STARTUP_TIME_COLUMN$lambda$0(PlanModel.GenericNode it) {
        PlanModel.GenericNode genericNode = it;
        return genericNode != null ? genericNode.getActualStartupTime() : null;
    }

    @JvmStatic
    @NotNull
    public static final ColumnInfo<?, ?>[] columnsFor(@NotNull PlanModel model, boolean showDetailsPanel) {
        return Companion.columnsFor(model, showDetailsPanel);
    }

    @JvmStatic
    @NotNull
    public static final PlanView createView(@NotNull Project project) {
        return Companion.createView(project);
    }

    @JvmStatic
    @Nullable
    public static final PlanView getPlanView(@NotNull DataContext context) {
        return Companion.getPlanView(context);
    }

    @JvmStatic
    @Nullable
    public static final PlanModel.GenericNode contextPlanNode(@NotNull DataContext context) {
        return Companion.contextPlanNode(context);
    }

    public static final /* synthetic */ boolean access$isTableRow(PlanView $this, DetailRow detailRow) {
        return $this.isTableRow(detailRow);
    }

    public static final /* synthetic */ Project access$getProject$p(PlanView $this) {
        return $this.project;
    }

    public static final /* synthetic */ TableView access$getDetailsTable$p(PlanView $this) {
        return $this.detailsTable;
    }

    public /* synthetic */ PlanView(Project project, DefaultConstructorMarker $constructor_marker) {
        this(project);
    }

    static {
        Supplier supplier = DatabaseBundle.messagePointer((String)"PlanView.column.name.operation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"messagePointer(...)");
        OPERATION_COLUMN = (ColumnInfo)new NlsTreeColumnInfo(supplier);
        Supplier supplier2 = DatabaseBundle.messagePointer((String)"PlanView.column.name.params", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"messagePointer(...)");
        PARAMS_COLUMN = PlanView.Companion.col(supplier2, PlanView::PARAMS_COLUMN$lambda$0);
        Supplier supplier3 = DatabaseBundle.messagePointer((String)"PlanView.column.name.rows", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"messagePointer(...)");
        NUM_ROWS_COLUMN = PlanView.Companion.col(supplier3, PlanView::NUM_ROWS_COLUMN$lambda$0);
        Supplier supplier4 = DatabaseBundle.messagePointer((String)"PlanView.column.name.actual.rows", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier4, (String)"messagePointer(...)");
        ACTUAL_NUM_ROWS_COLUMN = PlanView.Companion.col(supplier4, PlanView::ACTUAL_NUM_ROWS_COLUMN$lambda$0);
        Supplier supplier5 = DatabaseBundle.messagePointer((String)"PlanView.column.name.total.cost", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier5, (String)"messagePointer(...)");
        TOTAL_COST_COLUMN = PlanView.Companion.col(supplier5, PlanView::TOTAL_COST_COLUMN$lambda$0);
        Supplier supplier6 = DatabaseBundle.messagePointer((String)"PlanView.column.name.actual.total.time", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier6, (String)"messagePointer(...)");
        ACTUAL_TOTAL_TIME_COLUMN = PlanView.Companion.col(supplier6, PlanView::ACTUAL_TOTAL_TIME_COLUMN$lambda$0);
        Supplier supplier7 = DatabaseBundle.messagePointer((String)"PlanView.column.name.startup.cost", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier7, (String)"messagePointer(...)");
        STARTUP_COST_COLUMN = PlanView.Companion.col(supplier7, PlanView::STARTUP_COST_COLUMN$lambda$0);
        Supplier supplier8 = DatabaseBundle.messagePointer((String)"PlanView.column.name.actual.startup.time", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)supplier8, (String)"messagePointer(...)");
        ACTUAL_STARTUP_TIME_COLUMN = PlanView.Companion.col(supplier8, PlanView::ACTUAL_STARTUP_TIME_COLUMN$lambda$0);
        Supplier supplier9 = DatabaseBundle.messagePointer((String)"PlanView.column.name.raw.desc", (Object[])new Object[0]);
        RAW_DESC_COLUMN = new NlsColumnInfo<PlanTreeNode, String>((Supplier<String>)supplier9){
            {
                Intrinsics.checkNotNull($super_call_param$1);
                super($super_call_param$1);
            }

            public String valueOf(PlanTreeNode node) {
                PlanTreeNode planTreeNode = node;
                return planTreeNode != null && (planTreeNode = planTreeNode.getNode()) != null ? planTreeNode.getRawDescription() : null;
            }

            public boolean isCellEditable(PlanTreeNode node) {
                return false;
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0012\b\u0002\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/plan/ui/PlanView$ChartData;", "", "component", "Ljava/awt/Component;", "updater", "Lcom/intellij/util/Consumer;", "Lcom/intellij/database/plan/PlanModel;", "<init>", "(Ljava/awt/Component;Lcom/intellij/util/Consumer;)V", "getComponent", "()Ljava/awt/Component;", "getUpdater", "()Lcom/intellij/util/Consumer;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class ChartData {
        @NotNull
        private final Component component;
        @Nullable
        private final Consumer<PlanModel> updater;

        public ChartData(@NotNull Component component, @Nullable Consumer<PlanModel> updater) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            this.component = component;
            this.updater = updater;
        }

        @NotNull
        public final Component getComponent() {
            return this.component;
        }

        @Nullable
        public final Consumer<PlanModel> getUpdater() {
            return this.updater;
        }

        @NotNull
        public final Component component1() {
            return this.component;
        }

        @Nullable
        public final Consumer<PlanModel> component2() {
            return this.updater;
        }

        @NotNull
        public final ChartData copy(@NotNull Component component, @Nullable Consumer<PlanModel> updater) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return new ChartData(component, updater);
        }

        public static /* synthetic */ ChartData copy$default(ChartData chartData, Component component, Consumer consumer, int n, Object object) {
            if ((n & 1) != 0) {
                component = chartData.component;
            }
            if ((n & 2) != 0) {
                consumer = chartData.updater;
            }
            return chartData.copy(component, consumer);
        }

        @NotNull
        public String toString() {
            return "ChartData(component=" + this.component + ", updater=" + this.updater + ")";
        }

        public int hashCode() {
            int result2 = this.component.hashCode();
            result2 = result2 * 31 + (this.updater == null ? 0 : this.updater.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChartData)) {
                return false;
            }
            ChartData chartData = (ChartData)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)chartData.component)) {
                return false;
            }
            return Intrinsics.areEqual(this.updater, chartData.updater);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001a0\t\"\u0004\b\u0000\u0010\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u0001H\u001a0\u001eH\u0002J+\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00050!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007\u00a2\u0006\u0002\u0010&J(\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0007J\u0012\u00108\u001a\u0004\u0018\u0001052\u0006\u00109\u001a\u00020:H\u0007J\u0012\u0010;\u001a\u0004\u0018\u00010\u001f2\u0006\u00109\u001a\u00020:H\u0007J\u0014\u0010<\u001a\u0004\u0018\u00010\u001f2\b\u0010=\u001a\u0004\u0018\u00010>H\u0002J\u0012\u0010?\u001a\u0004\u0018\u00010>2\u0006\u00109\u001a\u00020:H\u0002R\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0019\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u0018\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006@"}, d2={"Lcom/intellij/database/plan/ui/PlanView$Companion;", "", "<init>", "()V", "OPERATION_COLUMN", "Lcom/intellij/util/ui/ColumnInfo;", "getOPERATION_COLUMN", "()Lcom/intellij/util/ui/ColumnInfo;", "PARAMS_COLUMN", "Lcom/intellij/database/plan/ui/PlanView$MyColumnInfo;", "", "getPARAMS_COLUMN", "()Lcom/intellij/database/plan/ui/PlanView$MyColumnInfo;", "NUM_ROWS_COLUMN", "Ljava/math/BigDecimal;", "getNUM_ROWS_COLUMN", "ACTUAL_NUM_ROWS_COLUMN", "getACTUAL_NUM_ROWS_COLUMN", "TOTAL_COST_COLUMN", "", "ACTUAL_TOTAL_TIME_COLUMN", "STARTUP_COST_COLUMN", "ACTUAL_STARTUP_TIME_COLUMN", "RAW_DESC_COLUMN", "getRAW_DESC_COLUMN", "col", "T", "title", "Ljava/util/function/Supplier;", "value", "Lkotlin/Function1;", "Lcom/intellij/database/plan/PlanModel$GenericNode;", "columnsFor", "", "model", "Lcom/intellij/database/plan/PlanModel;", "showDetailsPanel", "", "(Lcom/intellij/database/plan/PlanModel;Z)[Lcom/intellij/util/ui/ColumnInfo;", "getRendererWidth", "table", "Ljavax/swing/JTable;", "header", "i", "", "j", "dispatchMouseEventByTreeCell", "", "e", "Ljava/awt/event/MouseEvent;", "tree", "Lcom/intellij/ui/treeStructure/treetable/TreeTableTree;", "createView", "Lcom/intellij/database/plan/ui/PlanView;", "project", "Lcom/intellij/openapi/project/Project;", "getPlanView", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "contextPlanNode", "getSelectedNode", "c", "Lcom/intellij/ui/dualView/TreeTableView;", "getTreeTable", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nPlanView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlanView.kt\ncom/intellij/database/plan/ui/PlanView$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n37#2,2:757\n1#3:759\n*S KotlinDebug\n*F\n+ 1 PlanView.kt\ncom/intellij/database/plan/ui/PlanView$Companion\n*L\n619#1:757,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ColumnInfo<?, ?> getOPERATION_COLUMN() {
            return OPERATION_COLUMN;
        }

        @NotNull
        public final MyColumnInfo<String> getPARAMS_COLUMN() {
            return PARAMS_COLUMN;
        }

        @NotNull
        public final MyColumnInfo<BigDecimal> getNUM_ROWS_COLUMN() {
            return NUM_ROWS_COLUMN;
        }

        @NotNull
        public final MyColumnInfo<BigDecimal> getACTUAL_NUM_ROWS_COLUMN() {
            return ACTUAL_NUM_ROWS_COLUMN;
        }

        @NotNull
        public final ColumnInfo<?, ?> getRAW_DESC_COLUMN() {
            return RAW_DESC_COLUMN;
        }

        private final <T> MyColumnInfo<T> col(Supplier<String> title, Function1<? super PlanModel.GenericNode, ? extends T> value) {
            return new MyColumnInfo<T>(title, value);
        }

        @JvmStatic
        @NotNull
        public final ColumnInfo<?, ?>[] columnsFor(@NotNull PlanModel model, boolean showDetailsPanel) {
            List list;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            List $this$columnsFor_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$columnsFor_u24lambda_u240.add(Companion.getOPERATION_COLUMN());
            $this$columnsFor_u24lambda_u240.add(Companion.getPARAMS_COLUMN());
            if (!model.getUnsupported().contains(PlanModel.Feature.NUM_ROWS)) {
                $this$columnsFor_u24lambda_u240.add(Companion.getNUM_ROWS_COLUMN());
                if (model.isActual()) {
                    $this$columnsFor_u24lambda_u240.add(Companion.getACTUAL_NUM_ROWS_COLUMN());
                }
            }
            if (!model.getUnsupported().contains(PlanModel.Feature.TOTAL_COST)) {
                $this$columnsFor_u24lambda_u240.add(TOTAL_COST_COLUMN);
                if (model.isActual()) {
                    $this$columnsFor_u24lambda_u240.add(ACTUAL_TOTAL_TIME_COLUMN);
                }
            }
            if (!model.getUnsupported().contains(PlanModel.Feature.STARTUP_COST)) {
                $this$columnsFor_u24lambda_u240.add(STARTUP_COST_COLUMN);
                if (model.isActual()) {
                    $this$columnsFor_u24lambda_u240.add(ACTUAL_STARTUP_TIME_COLUMN);
                }
            }
            if (!showDetailsPanel) {
                $this$columnsFor_u24lambda_u240.add(Companion.getRAW_DESC_COLUMN());
            }
            Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new ColumnInfo[0]);
        }

        private final double getRendererWidth(JTable table, boolean header, int i, int j) {
            TableCellRenderer tableCellRenderer;
            if (header) {
                tableCellRenderer = table.getColumnModel().getColumn(j).getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = table.getTableHeader().getDefaultRenderer();
                }
            } else {
                tableCellRenderer = table.getCellRenderer(i, j);
            }
            if (tableCellRenderer == null) {
                return 0.0;
            }
            TableCellRenderer renderer2 = tableCellRenderer;
            Object value = header ? table.getColumnModel().getColumn(j).getHeaderValue() : table.getModel().getValueAt(i, j);
            return renderer2.getTableCellRendererComponent((JTable)table, (Object)value, (boolean)false, (boolean)false, (int)i, (int)j).getPreferredSize().width;
        }

        private final void dispatchMouseEventByTreeCell(MouseEvent e, TreeTableTree tree) {
            int y;
            int x = e.getX();
            int row = tree.getRowForLocation(x, y = e.getY());
            if (row < 0) {
                return;
            }
            TreeCellRenderer treeCellRenderer = tree.getCellRenderer();
            if (treeCellRenderer == null) {
                return;
            }
            TreeCellRenderer renderer2 = treeCellRenderer;
            TreePath path = tree.getPathForRow(row);
            Object node = path.getLastPathComponent();
            Component component = renderer2.getTreeCellRendererComponent((JTree)tree, node, tree.isRowSelected(row), tree.isExpanded(row), tree.getModel().isLeaf(node), row, true);
            Rectangle rectangle = tree.getPathBounds(path);
            if (rectangle == null) {
                return;
            }
            Rectangle bounds = rectangle;
            component.setBounds(bounds);
            component.doLayout();
            Component component2 = SwingUtilities.getDeepestComponentAt(component, x - bounds.x, y - bounds.y);
            if (component2 == null) {
                return;
            }
            Component deepestComponent = component2;
            Component lastParent = (Component)UIUtil.uiParents((Component)deepestComponent, (boolean)false).last();
            Point convertedPoint = SwingUtilities.convertPoint(lastParent, x - bounds.x, y - bounds.y, deepestComponent);
            deepestComponent.dispatchEvent(new MouseEvent(deepestComponent, e.getID(), e.getWhen(), e.getModifiersEx(), convertedPoint.x, convertedPoint.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }

        @JvmStatic
        @NotNull
        public final PlanView createView(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return new PlanView(project, null);
        }

        @JvmStatic
        @Nullable
        public final PlanView getPlanView(@NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            TreeTableView table = this.getTreeTable(context);
            return (PlanView)UIUtil.getClientProperty((Component)((Component)table), PlanView.class);
        }

        @JvmStatic
        @Nullable
        public final PlanModel.GenericNode contextPlanNode(@NotNull DataContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = PlatformCoreDataKeys.SELECTED_ITEM.getData(context);
            return object instanceof PlanModel.GenericNode ? (PlanModel.GenericNode)object : null;
        }

        private final PlanModel.GenericNode getSelectedNode(TreeTableView c2) {
            Object item;
            if (c2 == null) {
                return null;
            }
            List list = c2.getSelection();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelection(...)");
            Object object = CollectionsKt.firstOrNull((List)list);
            if (object == null) {
                Companion $this$getSelectedNode_u24lambda_u240 = this;
                boolean bl = false;
                TreeTableTree tree = c2.getTree();
                object = tree.getRowCount() > 0 ? tree.getPathForRow(0).getLastPathComponent() : null;
            }
            PlanTreeNode planTreeNode = (item = object) instanceof PlanTreeNode ? (PlanTreeNode)item : null;
            return planTreeNode != null ? planTreeNode.getNode() : null;
        }

        private final TreeTableView getTreeTable(DataContext context) {
            JBTabs pane;
            TreeTableView treeTableView;
            Component data = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context);
            TreeTableView treeTableView2 = treeTableView = data instanceof TreeTableView ? (TreeTableView)data : null;
            if (treeTableView != null) {
                TreeTableView it = treeTableView;
                boolean bl = false;
                return it;
            }
            JBTabs jBTabs = pane = data instanceof JBTabs ? (JBTabs)data : null;
            if (pane == null || pane.getTabCount() == 0) {
                return null;
            }
            return (TreeTableView)UIUtil.findComponentOfType((JComponent)pane.getTabAt(0).getComponent(), TreeTableView.class);
        }

        public static final /* synthetic */ void access$dispatchMouseEventByTreeCell(Companion $this, MouseEvent e, TreeTableTree tree) {
            $this.dispatchMouseEventByTreeCell(e, tree);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002B/\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00018\u00000\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00018\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0011R\u001e\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00018\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/plan/ui/PlanView$MyColumnInfo;", "T", "Lcom/intellij/database/plan/ui/PlanView$NlsColumnInfo;", "Lcom/intellij/database/plan/ui/PlanTreeNode;", "title", "Ljava/util/function/Supplier;", "", "valueExtractor", "Lkotlin/Function1;", "Lcom/intellij/database/plan/PlanModel$GenericNode;", "<init>", "(Ljava/util/function/Supplier;Lkotlin/jvm/functions/Function1;)V", "doubleValueOf", "", "node", "(Lcom/intellij/database/plan/PlanModel$GenericNode;)Ljava/lang/Double;", "valueOf", "(Lcom/intellij/database/plan/ui/PlanTreeNode;)Ljava/lang/Object;", "intellij.database.impl"})
    public static final class MyColumnInfo<T>
    extends NlsColumnInfo<PlanTreeNode, T> {
        @NotNull
        private final Function1<PlanModel.GenericNode, T> valueExtractor;

        public MyColumnInfo(@NotNull Supplier<String> title, @NotNull Function1<? super PlanModel.GenericNode, ? extends T> valueExtractor) {
            Intrinsics.checkNotNullParameter(title, (String)"title");
            Intrinsics.checkNotNullParameter(valueExtractor, (String)"valueExtractor");
            super(title);
            this.valueExtractor = valueExtractor;
        }

        @Nullable
        public final Double doubleValueOf(@Nullable PlanModel.GenericNode node) {
            Object object = this.valueExtractor.invoke((Object)node);
            Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
            return number != null ? Double.valueOf(number.doubleValue()) : null;
        }

        @Nullable
        public T valueOf(@Nullable PlanTreeNode node) {
            PlanTreeNode planTreeNode = node;
            return (T)this.valueExtractor.invoke(planTreeNode != null ? planTreeNode.getNode() : null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u0012\u0012\u0006\u0012\u0004\u0018\u0001H\u0001\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0003B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/plan/ui/PlanView$NlsColumnInfo;", "Item", "Aspect", "Lcom/intellij/util/ui/ColumnInfo;", "nameSupplier", "Ljava/util/function/Supplier;", "", "<init>", "(Ljava/util/function/Supplier;)V", "getName", "intellij.database.impl"})
    public static abstract class NlsColumnInfo<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        @NotNull
        private final Supplier<String> nameSupplier;

        public NlsColumnInfo(@NotNull Supplier<String> nameSupplier) {
            Intrinsics.checkNotNullParameter(nameSupplier, (String)"nameSupplier");
            super(nameSupplier.get());
            this.nameSupplier = nameSupplier;
        }

        @Nullable
        public String getName() {
            return this.nameSupplier.get();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/plan/ui/PlanView$NlsTreeColumnInfo;", "Lcom/intellij/ui/treeStructure/treetable/TreeColumnInfo;", "nameSupplier", "Ljava/util/function/Supplier;", "", "<init>", "(Ljava/util/function/Supplier;)V", "getName", "intellij.database.impl"})
    public static final class NlsTreeColumnInfo
    extends TreeColumnInfo {
        @NotNull
        private final Supplier<String> nameSupplier;

        public NlsTreeColumnInfo(@NotNull Supplier<String> nameSupplier) {
            Intrinsics.checkNotNullParameter(nameSupplier, (String)"nameSupplier");
            super(nameSupplier.get());
            this.nameSupplier = nameSupplier;
        }

        @Nullable
        public String getName() {
            return this.nameSupplier.get();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/plan/ui/PlanView$NumericCellRenderer;", "Ljavax/swing/table/DefaultTableCellRenderer;", "<init>", "()V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "setValue", "", "formatValue", "", "intellij.database.impl"})
    public static final class NumericCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Component component = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getTableCellRendererComponent(...)");
            return component;
        }

        @Override
        protected void setValue(@Nullable Object value) {
            this.setText(this.formatValue(value));
        }

        @NotNull
        public final String formatValue(@Nullable Object value) {
            String string;
            Object object = value;
            if (object == null) {
                string = "";
            } else if (object instanceof BigDecimal) {
                String string2 = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toPlainString(...)");
            } else if (object instanceof Double) {
                if (Double.isNaN(((Number)value).doubleValue()) || Double.isInfinite(((Number)value).doubleValue())) {
                    string = String.valueOf(((Number)value).doubleValue());
                } else {
                    String string3 = BigDecimal.valueOf(((Number)value).doubleValue()).stripTrailingZeros().toPlainString();
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toPlainString(...)");
                }
            } else if (object instanceof Float) {
                if (Float.isNaN(((Number)value).floatValue()) || Float.isInfinite(((Number)value).floatValue())) {
                    string = String.valueOf(((Number)value).floatValue());
                } else {
                    String string4 = BigDecimal.valueOf(((Number)value).floatValue()).stripTrailingZeros().toPlainString();
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toPlainString(...)");
                }
            } else {
                string = object instanceof Number ? ((Number)value).toString() : value.toString();
            }
            return string;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/plan/ui/PlanView$PlanTreeTableView;", "Lcom/intellij/ui/dualView/TreeTableView;", "root", "Lcom/intellij/database/plan/ui/PlanTreeNode;", "columns", "", "Lcom/intellij/util/ui/ColumnInfo;", "<init>", "(Lcom/intellij/database/plan/ui/PlanTreeNode;[Lcom/intellij/util/ui/ColumnInfo;)V", "setTableModel", "", "treeTableModel", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "dispatchByTree", "e", "Ljava/awt/event/MouseEvent;", "intellij.database.impl"})
    public static final class PlanTreeTableView
    extends TreeTableView {
        public PlanTreeTableView(@NotNull PlanTreeNode root, @NotNull ColumnInfo<?, ?>[] columns) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            super(new ListTreeTableModelOnColumns((TreeNode)root, columns));
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.dispatchByTree(e);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.dispatchByTree(e);
                }
            });
        }

        public void setTableModel(@Nullable TreeTableModel treeTableModel) {
            TreeTableTree treeTableTree;
            super.setTableModel(treeTableModel);
            TreeTableTree $this$setTableModel_u24lambda_u240 = treeTableTree = this.getTree();
            boolean bl = false;
            $this$setTableModel_u24lambda_u240.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(this, $this$setTableModel_u24lambda_u240){
                final /* synthetic */ PlanTreeTableView this$0;
                final /* synthetic */ TreeTableTree $this_apply;
                {
                    this.this$0 = $receiver;
                    this.$this_apply = $this_apply;
                }

                public void mouseMoved(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int row = this.this$0.rowAtPoint(e.getPoint());
                    int col = this.this$0.columnAtPoint(e.getPoint());
                    if (row != -1 && col != -1) {
                        this.$this_apply.repaint(this.this$0.getCellRect(row, col, false));
                    }
                }
            });
            $this$setTableModel_u24lambda_u240.addMouseListener((MouseListener)new MouseAdapter($this$setTableModel_u24lambda_u240){
                final /* synthetic */ TreeTableTree $this_apply;
                {
                    this.$this_apply = $this_apply;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TreeTableTree treeTableTree = this.$this_apply;
                    Intrinsics.checkNotNull((Object)treeTableTree);
                    com.intellij.database.plan.ui.PlanView$Companion.access$dispatchMouseEventByTreeCell(PlanView.Companion, e, treeTableTree);
                }
            });
        }

        public final void dispatchByTree(@NotNull MouseEvent e) {
            int n;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int row = this.rowAtPoint(e.getPoint());
            int column = this.columnAtPoint(e.getPoint());
            if (this.rowHeight != this.getTree().getRowHeight()) {
                Rectangle tableCellRect = this.getCellRect(row, column, true);
                n = Math.min(e.getY() - tableCellRect.y, this.getTree().getRowHeight() - 1) + row * this.getTree().getRowHeight();
            } else {
                n = e.getY();
            }
            int adjustedY = n;
            int adjustedX = e.getX() - this.getCellRect((int)0, (int)column, (boolean)true).x;
            this.getTree().dispatchEvent((AWTEvent)new MouseEvent((Component)this.getTree(), e.getID(), e.getWhen(), e.getModifiersEx(), adjustedX, adjustedY, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/plan/ui/PlanView$ShowFullAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class ShowFullAction
    extends DumbAwareAction {
        public ShowFullAction() {
            super(DatabaseBundle.message((String)"action.PlanView.show.full.text", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JTextArea jTextArea;
            int row;
            int col;
            TreeTableView component;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DataContext dataContext = e.getDataContext();
                    Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                    TreeTableView treeTableView = Companion.getTreeTable(dataContext);
                    if (treeTableView == null) {
                        return;
                    }
                    component = treeTableView;
                    col = component.getSelectedColumn();
                    row = component.getSelectedRow();
                    boolean bl = 0 <= col ? col < component.getColumnCount() : false;
                    if (!bl) break block5;
                    if (0 <= row ? row < component.getRowCount() : false) break block6;
                }
                return;
            }
            String cellValue = component.getModel().getValueAt(row, col).toString();
            if (((CharSequence)cellValue).length() == 0) {
                return;
            }
            String title = component.getColumnModel().getColumn(col).getHeaderValue().toString();
            JTextArea $this$actionPerformed_u24lambda_u240 = jTextArea = new JTextArea(cellValue);
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setLineWrap(true);
            $this$actionPerformed_u24lambda_u240.setEditable(false);
            $this$actionPerformed_u24lambda_u240.setSize(new Dimension(200, 200));
            JTextArea text = jTextArea;
            JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)text, (boolean)true), (JComponent)text).setShowBorder(true).setResizable(true).setMovable(true).setTitle(title).setRequestFocus(true).setDimensionServiceKey(e.getProject(), "PlanView.ShowFull", false).createPopup().showInBestPositionFor(e.getDataContext());
        }
    }
}

