/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.agents.features.opentelemetry.span;

import ai.koog.agents.features.opentelemetry.event.GenAIAgentEvent;
import ai.koog.agents.features.opentelemetry.extension.SpanExtKt;
import ai.koog.agents.features.opentelemetry.span.CreateAgentSpan;
import ai.koog.agents.features.opentelemetry.span.GenAIAgentSpan;
import ai.koog.agents.features.opentelemetry.span.InvokeAgentSpan;
import ai.koog.agents.features.opentelemetry.span.SpanEndStatus;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000b2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001a\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ$\u0010\u001f\u001a\u0004\u0018\u0001H \"\n\b\u0000\u0010 \u0018\u0001*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010!J\"\u0010\"\u001a\u0002H \"\n\b\u0000\u0010 \u0018\u0001*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010!J\u001c\u0010#\u001a\u00020\u00132\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00050%J\u0016\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\nJ\u0010\u0010)\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006+"}, d2={"Lai/koog/agents/features/opentelemetry/span/SpanProcessor;", "", "tracer", "Lio/opentelemetry/api/trace/Tracer;", "verbose", "", "<init>", "(Lio/opentelemetry/api/trace/Tracer;Z)V", "_spans", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lai/koog/agents/features/opentelemetry/span/GenAIAgentSpan;", "spansLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "spansCount", "", "getSpansCount", "()I", "addEventsToSpan", "", "spanId", "events", "", "Lai/koog/agents/features/opentelemetry/event/GenAIAgentEvent;", "startSpan", "span", "instant", "Ljava/time/Instant;", "endSpan", "spanEndStatus", "Lai/koog/agents/features/opentelemetry/span/SpanEndStatus;", "getSpan", "T", "(Ljava/lang/String;)Lai/koog/agents/features/opentelemetry/span/GenAIAgentSpan;", "getSpanOrThrow", "endUnfinishedSpans", "filter", "Lkotlin/Function1;", "endUnfinishedInvokeAgentSpans", "agentId", "runId", "addSpan", "Companion", "agents-features-opentelemetry"})
@SourceDebugExtension(value={"SMAP\nSpanProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpanProcessor.kt\nai/koog/agents/features/opentelemetry/span/SpanProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n774#2:144\n865#2,2:145\n1869#2,2:147\n1#3:149\n*S KotlinDebug\n*F\n+ 1 SpanProcessor.kt\nai/koog/agents/features/opentelemetry/span/SpanProcessor\n*L\n108#1:144\n108#1:145,2\n112#1:147,2\n*E\n"})
public final class SpanProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Tracer tracer;
    private final boolean verbose;
    @NotNull
    private final ConcurrentHashMap<String, GenAIAgentSpan> _spans;
    @NotNull
    private final ReentrantReadWriteLock spansLock;
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(SpanProcessor::logger$lambda$13);

    public SpanProcessor(@NotNull Tracer tracer, boolean verbose) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        this.tracer = tracer;
        this.verbose = verbose;
        this._spans = new ConcurrentHashMap();
        this.spansLock = new ReentrantReadWriteLock();
    }

    public /* synthetic */ SpanProcessor(Tracer tracer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(tracer, bl);
    }

    public final int getSpansCount() {
        return ((Map)this._spans).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addEventsToSpan(@NotNull String spanId, @NotNull List<? extends GenAIAgentEvent> events) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ReentrantReadWriteLock.ReadLock readLock = this.spansLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            GenAIAgentSpan genAIAgentSpan = this._spans.get(spanId);
            if (genAIAgentSpan == null) {
                throw new IllegalStateException(("Span with id '" + spanId + "' not found").toString());
            }
            GenAIAgentSpan span = genAIAgentSpan;
            span.addEvents(events);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            readLock.unlock();
        }
    }

    public final void startSpan(@NotNull GenAIAgentSpan span, @Nullable Instant instant) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        logger.debug(() -> SpanProcessor.startSpan$lambda$1(span));
        if (this._spans.containsKey(span.getSpanId())) {
            logger.warn(() -> SpanProcessor.startSpan$lambda$2(span));
            return;
        }
        SpanKind spanKind = span.getKind();
        GenAIAgentSpan genAIAgentSpan = span.getParent();
        if (genAIAgentSpan == null || (genAIAgentSpan = genAIAgentSpan.getContext()) == null) {
            genAIAgentSpan = Context.current();
        }
        GenAIAgentSpan parentContext = genAIAgentSpan;
        SpanBuilder spanBuilder = this.tracer.spanBuilder(span.getName());
        Instant instant2 = instant;
        if (instant2 == null) {
            instant2 = Instant.now();
        }
        SpanBuilder spanBuilder2 = spanBuilder.setStartTimestamp(instant2).setSpanKind(spanKind).setParent((Context)parentContext);
        Intrinsics.checkNotNull((Object)spanBuilder2);
        SpanExtKt.setAttributes(spanBuilder2, span.getAttributes(), this.verbose);
        Span startedSpan = spanBuilder2.startSpan();
        this.addSpan(span);
        Intrinsics.checkNotNull((Object)startedSpan);
        span.setSpan(startedSpan);
        Context context = startedSpan.storeInContext((Context)parentContext);
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"storeInContext(...)");
        span.setContext(context);
        logger.debug(() -> SpanProcessor.startSpan$lambda$3(span));
    }

    public static /* synthetic */ void startSpan$default(SpanProcessor spanProcessor, GenAIAgentSpan genAIAgentSpan, Instant instant, int n, Object object) {
        if ((n & 2) != 0) {
            instant = null;
        }
        spanProcessor.startSpan(genAIAgentSpan, instant);
    }

    public final void endSpan(@NotNull GenAIAgentSpan span, @Nullable SpanEndStatus spanEndStatus) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        logger.debug(() -> SpanProcessor.endSpan$lambda$4(span));
        Span spanToFinish = span.getSpan();
        SpanExtKt.setAttributes(spanToFinish, span.getAttributes(), this.verbose);
        SpanExtKt.setEvents(spanToFinish, span.getEvents(), this.verbose);
        SpanExtKt.setSpanStatus(spanToFinish, spanEndStatus);
        spanToFinish.end();
        GenAIAgentSpan removedSpan = this._spans.remove(span.getSpanId());
        if (removedSpan == null) {
            logger.warn(() -> SpanProcessor.endSpan$lambda$5(span));
        }
    }

    public static /* synthetic */ void endSpan$default(SpanProcessor spanProcessor, GenAIAgentSpan genAIAgentSpan, SpanEndStatus spanEndStatus, int n, Object object) {
        if ((n & 2) != 0) {
            spanEndStatus = null;
        }
        spanProcessor.endSpan(genAIAgentSpan, spanEndStatus);
    }

    public final /* synthetic */ <T extends GenAIAgentSpan> T getSpan(String spanId) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        boolean $i$f$getSpan = false;
        Object v = this._spans.get(spanId);
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)((GenAIAgentSpan)v);
    }

    public final /* synthetic */ <T extends GenAIAgentSpan> T getSpanOrThrow(String spanId) {
        Intrinsics.checkNotNullParameter((Object)spanId, (String)"spanId");
        boolean $i$f$getSpanOrThrow = false;
        GenAIAgentSpan genAIAgentSpan = (GenAIAgentSpan)this._spans.get(spanId);
        if (genAIAgentSpan == null) {
            throw new IllegalStateException(("Span with id: " + spanId + " not found").toString());
        }
        GenAIAgentSpan span = genAIAgentSpan;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        GenAIAgentSpan genAIAgentSpan2 = span;
        if (genAIAgentSpan2 == null) {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            throw new IllegalStateException(("Span with id <" + spanId + "> is not of expected type. Expected: <" + Reflection.getOrCreateKotlinClass(GenAIAgentSpan.class).getSimpleName() + ">, actual: <" + Reflection.getOrCreateKotlinClass(span.getClass()).getSimpleName() + ">").toString());
        }
        return (T)genAIAgentSpan2;
    }

    /*
     * WARNING - void declaration
     */
    public final void endUnfinishedSpans(@NotNull Function1<? super GenAIAgentSpan, Boolean> filter2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        Collection<GenAIAgentSpan> collection = this._spans.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GenAIAgentSpan span = (GenAIAgentSpan)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)span);
            boolean isRequireFinish = (Boolean)filter2.invoke((Object)span);
            if (!isRequireFinish) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GenAIAgentSpan span = (GenAIAgentSpan)element$iv;
            boolean bl = false;
            logger.warn(() -> SpanProcessor.endUnfinishedSpans$lambda$9$lambda$8(span));
            Intrinsics.checkNotNull((Object)span);
            this.endSpan(span, new SpanEndStatus(StatusCode.UNSET, null, 2, null));
        }
    }

    public static /* synthetic */ void endUnfinishedSpans$default(SpanProcessor spanProcessor, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = SpanProcessor::endUnfinishedSpans$lambda$6;
        }
        spanProcessor.endUnfinishedSpans((Function1<? super GenAIAgentSpan, Boolean>)function1);
    }

    public final void endUnfinishedInvokeAgentSpans(@NotNull String agentId, @NotNull String runId) {
        Intrinsics.checkNotNullParameter((Object)agentId, (String)"agentId");
        Intrinsics.checkNotNullParameter((Object)runId, (String)"runId");
        String agentRunSpanId = InvokeAgentSpan.Companion.createId(agentId, runId);
        String agentSpanId = CreateAgentSpan.Companion.createId(agentId);
        this.endUnfinishedSpans((Function1<? super GenAIAgentSpan, Boolean>)((Function1)arg_0 -> SpanProcessor.endUnfinishedInvokeAgentSpans$lambda$10(agentSpanId, agentRunSpanId, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addSpan(GenAIAgentSpan span) {
        ReentrantReadWriteLock reentrantReadWriteLock = this.spansLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            String spanId = span.getSpanId();
            GenAIAgentSpan existingSpan = this._spans.get(spanId);
            if (!(existingSpan == null)) {
                boolean bl2 = false;
                String string = "Span with id '" + spanId + "' already added";
                throw new IllegalStateException(string.toString());
            }
            ((Map)this._spans).put(span.getSpanId(), span);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    private static final Object startSpan$lambda$1(GenAIAgentSpan $span) {
        return "Starting span (name: " + $span.getName() + ", id: " + $span.getSpanId() + ")";
    }

    private static final Object startSpan$lambda$2(GenAIAgentSpan $span) {
        return "Span with id '" + $span.getSpanId() + "' already started";
    }

    private static final Object startSpan$lambda$3(GenAIAgentSpan $span) {
        return "Span has been started (name: " + $span.getName() + ", id: " + $span.getSpanId() + ")";
    }

    private static final Object endSpan$lambda$4(GenAIAgentSpan $span) {
        return "Finishing the span (id: " + $span.getSpanId() + ")";
    }

    private static final Object endSpan$lambda$5(GenAIAgentSpan $span) {
        return "Span with id '" + $span.getSpanId() + "' not found. Make sure you do not delete span with same id several times";
    }

    private static final boolean endUnfinishedSpans$lambda$6(GenAIAgentSpan it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Object endUnfinishedSpans$lambda$9$lambda$8(GenAIAgentSpan $span) {
        return "Force close span with id: " + $span.getSpanId();
    }

    private static final boolean endUnfinishedInvokeAgentSpans$lambda$10(String $agentSpanId, String $agentRunSpanId, GenAIAgentSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        return !Intrinsics.areEqual((Object)span.getSpanId(), (Object)$agentSpanId) && !Intrinsics.areEqual((Object)span.getSpanId(), (Object)$agentRunSpanId);
    }

    private static final Unit logger$lambda$13() {
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lai/koog/agents/features/opentelemetry/span/SpanProcessor$Companion;", "", "<init>", "()V", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "agents-features-opentelemetry"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

