/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.common;

import ai.grazie.llm.services.LLMService;
import ai.grazie.model.cloud.exceptions.ExtensionsKt;
import ai.grazie.model.llm.chat.metadata.LlmRequestContext;
import ai.grazie.model.llm.chat.v5.LLMChat;
import ai.grazie.model.llm.data.stream.LLMStreamData;
import ai.grazie.model.llm.definitions.ChatDefinition;
import ai.grazie.model.llm.definitions.CompletionDefinition;
import ai.grazie.model.llm.definitions.EmbeddingDefinition;
import ai.grazie.model.llm.embedding.LLMEmbeddingData;
import ai.grazie.model.llm.profile.LLMFeature;
import ai.grazie.model.llm.prompt.LLMPromptID;
import ai.grazie.utils.annotations.ExperimentalAPI;
import ai.grazie.utils.attributes.Attributes;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0086@\u00a2\u0006\u0002\u0010\u000eJ6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0018J6\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0087@\u00a2\u0006\u0002\u0010\u0013J.\u0010\u001a\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0094@\u00a2\u0006\u0002\u0010\u0018J8\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0094@\u00a2\u0006\u0002\u0010\u000eJ:\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0094@\u00a2\u0006\u0002\u0010\u0013J:\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0094@\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lai/grazie/llm/provider/common/BaseLLMService;", "Lai/grazie/llm/services/LLMService;", "<init>", "()V", "complete", "Lkotlinx/coroutines/flow/Flow;", "Lai/grazie/model/llm/data/stream/LLMStreamData;", "prompt", "Lai/grazie/model/llm/prompt/LLMPromptID;", "prefix", "", "postfix", "parameters", "Lai/grazie/utils/attributes/Attributes;", "(Lai/grazie/model/llm/prompt/LLMPromptID;Ljava/lang/String;Ljava/lang/String;Lai/grazie/utils/attributes/Attributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chat", "Lai/grazie/model/llm/chat/v5/LLMChat;", "requestContext", "Lai/grazie/model/llm/chat/metadata/LlmRequestContext;", "(Lai/grazie/model/llm/prompt/LLMPromptID;Lai/grazie/model/llm/chat/v5/LLMChat;Lai/grazie/utils/attributes/Attributes;Lai/grazie/model/llm/chat/metadata/LlmRequestContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "embedWithMetadata", "Lai/grazie/model/llm/embedding/LLMEmbeddingData;", "text", "", "(Ljava/util/List;Lai/grazie/utils/attributes/Attributes;Lai/grazie/model/llm/chat/metadata/LlmRequestContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chatResponses", "executeEmbed", "executeComplete", "executeChat", "executeResponses", "llm-provider-common"})
public abstract class BaseLLMService
implements LLMService {
    @Override
    @Nullable
    public final Object complete(@Nullable LLMPromptID prompt, @NotNull String prefix, @NotNull String postfix, @NotNull Attributes parameters, @NotNull Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        ExtensionsKt.requireOrBadRequest((boolean)this.getProfile().getFeatures().contains(LLMFeature.Completion), () -> BaseLLMService.complete$lambda$0(this));
        CompletionDefinition completionDefinition = this.getProfile().getFeatureDefinitions().getCompletionDefinition();
        completionDefinition.validateParameters(this.getName(), parameters, this.getProfile());
        return this.executeComplete(prompt, prefix, postfix, parameters, $completion);
    }

    @Override
    @Nullable
    public final Object chat(@Nullable LLMPromptID prompt, @NotNull LLMChat chat, @NotNull Attributes parameters, @NotNull LlmRequestContext requestContext, @NotNull Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        ExtensionsKt.requireOrBadRequest((boolean)this.getProfile().getFeatures().contains(LLMFeature.Chat), () -> BaseLLMService.chat$lambda$1(this));
        ChatDefinition chatDefinition = this.getProfile().getFeatureDefinitions().getChatDefinition();
        chatDefinition.validateParameters(this.getName(), parameters, this.getProfile());
        chatDefinition.validateChat(this.getName(), chat, this.getProfile());
        return this.executeChat(prompt, chat, parameters, requestContext, $completion);
    }

    @Override
    @Nullable
    public final Object embedWithMetadata(@NotNull List<String> text, @NotNull Attributes parameters, @NotNull LlmRequestContext requestContext, @NotNull Continuation<? super LLMEmbeddingData> $completion) {
        ExtensionsKt.requireOrBadRequest((boolean)this.getProfile().getFeatures().contains(LLMFeature.Embedding), () -> BaseLLMService.embedWithMetadata$lambda$2(this));
        EmbeddingDefinition embeddingDefinition = this.getProfile().getFeatureDefinitions().getEmbeddingDefinition();
        embeddingDefinition.validateParameters(this.getName(), parameters, this.getProfile());
        return this.executeEmbed(text, parameters, requestContext, $completion);
    }

    @Override
    @ExperimentalAPI
    @Nullable
    public final Object chatResponses(@Nullable LLMPromptID prompt, @NotNull LLMChat chat, @NotNull Attributes parameters, @NotNull LlmRequestContext requestContext, @NotNull Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        ExtensionsKt.requireOrBadRequest((boolean)this.getProfile().getFeatures().contains(LLMFeature.Responses), () -> BaseLLMService.chatResponses$lambda$3(this));
        ChatDefinition chatDefinition = this.getProfile().getFeatureDefinitions().getChatDefinition();
        chatDefinition.validateParameters(this.getName(), parameters, this.getProfile());
        chatDefinition.validateChat(this.getName(), chat, this.getProfile());
        return this.executeResponses(prompt, chat, parameters, requestContext, $completion);
    }

    @Nullable
    protected Object executeEmbed(@NotNull List<String> text, @NotNull Attributes parameters, @NotNull LlmRequestContext requestContext, @NotNull Continuation<? super LLMEmbeddingData> $completion) {
        return BaseLLMService.executeEmbed$suspendImpl(this, text, parameters, requestContext, $completion);
    }

    static /* synthetic */ Object executeEmbed$suspendImpl(BaseLLMService $this, List<String> text, Attributes parameters, LlmRequestContext requestContext, Continuation<? super LLMEmbeddingData> $completion) {
        ExtensionsKt.badRequest((String)("Embeddings is not supported by the " + $this.getName() + " provider"));
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Object executeEmbed$default(BaseLLMService baseLLMService, List list, Attributes attributes, LlmRequestContext llmRequestContext, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeEmbed");
        }
        if ((n & 4) != 0) {
            llmRequestContext = LlmRequestContext.Companion.getEMPTY();
        }
        return baseLLMService.executeEmbed(list, attributes, llmRequestContext, (Continuation<? super LLMEmbeddingData>)continuation);
    }

    @Nullable
    protected Object executeComplete(@Nullable LLMPromptID prompt, @NotNull String prefix, @NotNull String postfix, @NotNull Attributes parameters, @NotNull Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        return BaseLLMService.executeComplete$suspendImpl(this, prompt, prefix, postfix, parameters, $completion);
    }

    static /* synthetic */ Object executeComplete$suspendImpl(BaseLLMService $this, LLMPromptID prompt, String prefix, String postfix, Attributes parameters, Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        ExtensionsKt.badRequest((String)("Completion is not supported by the " + $this.getName() + " provider"));
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Object executeComplete$default(BaseLLMService baseLLMService, LLMPromptID lLMPromptID, String string, String string2, Attributes attributes, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeComplete");
        }
        if ((n & 8) != 0) {
            attributes = Attributes.Companion.getEmpty();
        }
        return baseLLMService.executeComplete(lLMPromptID, string, string2, attributes, (Continuation<? super Flow<? extends LLMStreamData>>)continuation);
    }

    @Nullable
    protected Object executeChat(@Nullable LLMPromptID prompt, @NotNull LLMChat chat, @NotNull Attributes parameters, @NotNull LlmRequestContext requestContext, @NotNull Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        return BaseLLMService.executeChat$suspendImpl(this, prompt, chat, parameters, requestContext, $completion);
    }

    static /* synthetic */ Object executeChat$suspendImpl(BaseLLMService $this, LLMPromptID prompt, LLMChat chat, Attributes parameters, LlmRequestContext requestContext, Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        ExtensionsKt.badRequest((String)("Chat is not supported by the " + $this.getName() + " provider"));
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Object executeChat$default(BaseLLMService baseLLMService, LLMPromptID lLMPromptID, LLMChat lLMChat, Attributes attributes, LlmRequestContext llmRequestContext, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeChat");
        }
        if ((n & 4) != 0) {
            attributes = Attributes.Companion.getEmpty();
        }
        if ((n & 8) != 0) {
            llmRequestContext = LlmRequestContext.Companion.getEMPTY();
        }
        return baseLLMService.executeChat(lLMPromptID, lLMChat, attributes, llmRequestContext, (Continuation<? super Flow<? extends LLMStreamData>>)continuation);
    }

    @Nullable
    protected Object executeResponses(@Nullable LLMPromptID prompt, @NotNull LLMChat chat, @NotNull Attributes parameters, @NotNull LlmRequestContext requestContext, @NotNull Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        return BaseLLMService.executeResponses$suspendImpl(this, prompt, chat, parameters, requestContext, $completion);
    }

    static /* synthetic */ Object executeResponses$suspendImpl(BaseLLMService $this, LLMPromptID prompt, LLMChat chat, Attributes parameters, LlmRequestContext requestContext, Continuation<? super Flow<? extends LLMStreamData>> $completion) {
        ExtensionsKt.badRequest((String)("Responses is not supported by the " + $this.getName() + " provider"));
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ Object executeResponses$default(BaseLLMService baseLLMService, LLMPromptID lLMPromptID, LLMChat lLMChat, Attributes attributes, LlmRequestContext llmRequestContext, Continuation continuation, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeResponses");
        }
        if ((n & 4) != 0) {
            attributes = Attributes.Companion.getEmpty();
        }
        if ((n & 8) != 0) {
            llmRequestContext = LlmRequestContext.Companion.getEMPTY();
        }
        return baseLLMService.executeResponses(lLMPromptID, lLMChat, attributes, llmRequestContext, (Continuation<? super Flow<? extends LLMStreamData>>)continuation);
    }

    private static final String complete$lambda$0(BaseLLMService this$0) {
        return "Profile " + this$0.getProfile().getId() + " does not support completion";
    }

    private static final String chat$lambda$1(BaseLLMService this$0) {
        return "Profile " + this$0.getProfile().getId() + " does not support chat";
    }

    private static final String embedWithMetadata$lambda$2(BaseLLMService this$0) {
        return "Profile " + this$0.getProfile().getId() + " does not support embedding";
    }

    private static final String chatResponses$lambda$3(BaseLLMService this$0) {
        return "Profile " + this$0.getProfile().getId() + " does not support responses";
    }
}

