/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.llm.provider.common.profile;

import ai.grazie.llm.profile.ConfigurablePricing;
import ai.grazie.llm.profile.LLMAccessLevel;
import ai.grazie.llm.provider.common.profile.ConfigurationProviderWrapper;
import ai.grazie.llm.provider.common.profile.ModelConfigProviderKt;
import ai.grazie.model.llm.profile.LLMProfileID;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0002,-B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u0002H\t\"\b\b\u0000\u0010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u0002H\t\u00a2\u0006\u0002\u0010\u000fJ1\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u0002H\t\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0014J\u0016\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0014J\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0014J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001eJ.\u0010 \u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010%\u001a\u00020&2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020&J\u001f\u0010'\u001a\u0004\u0018\u00010&2\u0006\u0010\u0015\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010*\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010!\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006."}, d2={"Lai/grazie/llm/provider/common/profile/ModelConfigProvider;", "", "configProvider", "Lai/grazie/llm/provider/common/profile/ConfigurationProviderWrapper;", "<init>", "(Lai/grazie/llm/provider/common/profile/ConfigurationProviderWrapper;)V", "getConfigProvider", "()Lai/grazie/llm/provider/common/profile/ConfigurationProviderWrapper;", "getModelProperty", "T", "model", "Lai/grazie/model/llm/profile/LLMProfileID;", "property", "", "defaultValue", "(Lai/grazie/model/llm/profile/LLMProfileID;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "type", "Ljava/lang/reflect/Type;", "(Lai/grazie/model/llm/profile/LLMProfileID;Ljava/lang/String;Ljava/lang/reflect/Type;Ljava/lang/Object;)Ljava/lang/Object;", "getEnabled", "", "profile", "getAccessLevel", "Lai/grazie/llm/profile/LLMAccessLevel;", "getDisplayName", "getRegion", "getPreview", "getReasoning", "getDeprecated", "getThrottling", "", "period", "getPricing", "range", "Lai/grazie/llm/profile/ConfigurablePricing$PricingRange;", "Lai/grazie/llm/profile/ConfigurablePricing$PriceType;", "extended", "getMaxTokens", "", "getMaxOutputTokens", "(Lai/grazie/model/llm/profile/LLMProfileID;Ljava/lang/Integer;)Ljava/lang/Integer;", "getModelId", "getRangePrefix", "getTypePrefix", "PropertyNames", "PricingConstants", "llm-provider-common"})
public final class ModelConfigProvider {
    @NotNull
    private final ConfigurationProviderWrapper configProvider;

    public ModelConfigProvider(@NotNull ConfigurationProviderWrapper configProvider) {
        Intrinsics.checkNotNullParameter((Object)configProvider, (String)"configProvider");
        this.configProvider = configProvider;
    }

    @NotNull
    public final ConfigurationProviderWrapper getConfigProvider() {
        return this.configProvider;
    }

    @NotNull
    public final <T> T getModelProperty(@NotNull LLMProfileID model, @NotNull String property, @NotNull T defaultValue) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
        return this.getModelProperty(model, property, defaultValue.getClass(), defaultValue);
    }

    public final <T> T getModelProperty(@NotNull LLMProfileID model, @NotNull String property, @NotNull Type type, T defaultValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String fullProperty = "llm_model_" + model.getId() + "_" + property;
        Object configValue = this.configProvider.fetch(fullProperty, type);
        ModelConfigProviderKt.access$getLogger$p().debug(() -> ModelConfigProvider.getModelProperty$lambda$0(fullProperty, configValue));
        Object n = configValue;
        if (n != null) {
            Object n2;
            Object value = n2 = n;
            boolean bl = false;
            ModelConfigProviderKt.access$getLogger$p().info(() -> ModelConfigProvider.getModelProperty$lambda$2$lambda$1(fullProperty, value, defaultValue));
            object = n2;
        } else {
            object = defaultValue;
        }
        return object;
    }

    public final boolean getEnabled(@NotNull LLMProfileID profile, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getModelProperty(profile, PropertyNames.ENABLED.getValue(), defaultValue);
    }

    @NotNull
    public final LLMAccessLevel getAccessLevel(@NotNull LLMProfileID profile, @NotNull LLMAccessLevel defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)((Object)defaultValue), (String)"defaultValue");
        return this.getModelProperty(profile, PropertyNames.ACCESS_LEVEL.getValue(), defaultValue);
    }

    @NotNull
    public final String getDisplayName(@NotNull LLMProfileID profile, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.getModelProperty(profile, PropertyNames.DISPLAY_NAME.getValue(), defaultValue);
    }

    @NotNull
    public final String getRegion(@NotNull LLMProfileID profile, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.getModelProperty(profile, PropertyNames.REGION.getValue(), defaultValue);
    }

    public final boolean getPreview(@NotNull LLMProfileID profile, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getModelProperty(profile, PropertyNames.PREVIEW.getValue(), defaultValue);
    }

    public final boolean getReasoning(@NotNull LLMProfileID profile, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getModelProperty(profile, PropertyNames.REASONING.getValue(), defaultValue);
    }

    public final boolean getDeprecated(@NotNull LLMProfileID profile, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getModelProperty(profile, PropertyNames.DEPRECATED.getValue(), defaultValue);
    }

    public final long getThrottling(@NotNull LLMProfileID profile, @NotNull String period, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        return ((Number)this.getModelProperty(profile, PropertyNames.THROTTLING_PREFIX.getValue() + period, defaultValue)).longValue();
    }

    @NotNull
    public final String getPricing(@NotNull LLMProfileID profile, @NotNull ConfigurablePricing.PricingRange range, @NotNull ConfigurablePricing.PriceType type, boolean extended, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)((Object)range), (String)"range");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        String property = PropertyNames.PRICING.getValue() + "." + this.getRangePrefix(range) + "." + this.getTypePrefix(type) + (extended ? "_extended" : "");
        return this.getModelProperty(profile, property, defaultValue);
    }

    public final int getMaxTokens(@NotNull LLMProfileID profile, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return ((Number)this.getModelProperty(profile, PropertyNames.MAX_TOKENS.getValue(), defaultValue)).intValue();
    }

    @Nullable
    public final Integer getMaxOutputTokens(@NotNull LLMProfileID profile, @Nullable Integer defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return this.getModelProperty(profile, PropertyNames.MAX_OUTPUT_TOKENS.getValue(), (Type)((Object)Integer.class), defaultValue);
    }

    @NotNull
    public final String getModelId(@NotNull LLMProfileID profile, @NotNull String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        return this.getModelProperty(profile, PropertyNames.ID.getValue(), defaultValue);
    }

    private final String getRangePrefix(ConfigurablePricing.PricingRange range) {
        return switch (WhenMappings.$EnumSwitchMapping$0[range.ordinal()]) {
            case 1 -> "per_million";
            case 2 -> "per_thousand";
            case 3 -> "per_token";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final String getTypePrefix(ConfigurablePricing.PriceType range) {
        return switch (WhenMappings.$EnumSwitchMapping$1[range.ordinal()]) {
            case 1 -> "generation";
            case 2 -> "context";
            case 3 -> "cached_context";
            case 4 -> "cache_read";
            case 5 -> "cache_write";
            case 6 -> "cache_write_5_min";
            case 7 -> "cache_write_1_hour";
            case 8 -> "thinking";
            case 9 -> "web_search";
            case 10 -> "web_fetch";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String getModelProperty$lambda$0(String $fullProperty, Object $configValue) {
        return "Fetched " + $fullProperty + ": " + $configValue;
    }

    private static final String getModelProperty$lambda$2$lambda$1(String $fullProperty, Object $value, Object $defaultValue) {
        return "Using " + $fullProperty + " value: " + $value + " instead of default " + $defaultValue;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lai/grazie/llm/provider/common/profile/ModelConfigProvider$PricingConstants;", "", "<init>", "()V", "PER_MILLION_PREFIX", "", "PER_THOUSAND_PREFIX", "PER_TOKEN_PREFIX", "GENERATION_SUFFIX", "CONTEXT_SUFFIX", "CACHED_CONTEXT", "CACHE_READ", "CACHE_WRITE", "CACHE_WRITE_5_MIN", "CACHE_WRITE_1_HOUR", "THINKING", "WEB_SEARCH", "WEB_FETCH", "llm-provider-common"})
    private static final class PricingConstants {
        @NotNull
        public static final PricingConstants INSTANCE = new PricingConstants();
        @NotNull
        public static final String PER_MILLION_PREFIX = "per_million";
        @NotNull
        public static final String PER_THOUSAND_PREFIX = "per_thousand";
        @NotNull
        public static final String PER_TOKEN_PREFIX = "per_token";
        @NotNull
        public static final String GENERATION_SUFFIX = "generation";
        @NotNull
        public static final String CONTEXT_SUFFIX = "context";
        @NotNull
        public static final String CACHED_CONTEXT = "cached_context";
        @NotNull
        public static final String CACHE_READ = "cache_read";
        @NotNull
        public static final String CACHE_WRITE = "cache_write";
        @NotNull
        public static final String CACHE_WRITE_5_MIN = "cache_write_5_min";
        @NotNull
        public static final String CACHE_WRITE_1_HOUR = "cache_write_1_hour";
        @NotNull
        public static final String THINKING = "thinking";
        @NotNull
        public static final String WEB_SEARCH = "web_search";
        @NotNull
        public static final String WEB_FETCH = "web_fetch";

        private PricingConstants() {
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lai/grazie/llm/provider/common/profile/ModelConfigProvider$PropertyNames;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "ENABLED", "ACCESS_LEVEL", "PREVIEW", "DISPLAY_NAME", "REASONING", "DEPRECATED", "MAX_TOKENS", "MAX_OUTPUT_TOKENS", "ID", "REGION", "PRICING", "THROTTLING_PREFIX", "llm-provider-common"})
    public static final class PropertyNames
    extends Enum<PropertyNames> {
        @NotNull
        private final String value;
        public static final /* enum */ PropertyNames ENABLED = new PropertyNames("enabled");
        public static final /* enum */ PropertyNames ACCESS_LEVEL = new PropertyNames("accessLevel");
        public static final /* enum */ PropertyNames PREVIEW = new PropertyNames("preview");
        public static final /* enum */ PropertyNames DISPLAY_NAME = new PropertyNames("displayName");
        public static final /* enum */ PropertyNames REASONING = new PropertyNames("reasoning");
        public static final /* enum */ PropertyNames DEPRECATED = new PropertyNames("deprecated");
        public static final /* enum */ PropertyNames MAX_TOKENS = new PropertyNames("maxTokens");
        public static final /* enum */ PropertyNames MAX_OUTPUT_TOKENS = new PropertyNames("maxOutputTokens");
        public static final /* enum */ PropertyNames ID = new PropertyNames("id");
        public static final /* enum */ PropertyNames REGION = new PropertyNames("region");
        public static final /* enum */ PropertyNames PRICING = new PropertyNames("pricing");
        public static final /* enum */ PropertyNames THROTTLING_PREFIX = new PropertyNames("throttling.");
        private static final /* synthetic */ PropertyNames[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private PropertyNames(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public static PropertyNames[] values() {
            return (PropertyNames[])$VALUES.clone();
        }

        public static PropertyNames valueOf(String value) {
            return Enum.valueOf(PropertyNames.class, value);
        }

        @NotNull
        public static EnumEntries<PropertyNames> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = propertyNamesArray = new PropertyNames[]{PropertyNames.ENABLED, PropertyNames.ACCESS_LEVEL, PropertyNames.PREVIEW, PropertyNames.DISPLAY_NAME, PropertyNames.REASONING, PropertyNames.DEPRECATED, PropertyNames.MAX_TOKENS, PropertyNames.MAX_OUTPUT_TOKENS, PropertyNames.ID, PropertyNames.REGION, PropertyNames.PRICING, PropertyNames.THROTTLING_PREFIX};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ConfigurablePricing.PricingRange.values().length];
            try {
                nArray[ConfigurablePricing.PricingRange.PER_MILLION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PricingRange.PER_THOUSAND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PricingRange.PER_TOKEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ConfigurablePricing.PriceType.values().length];
            try {
                nArray[ConfigurablePricing.PriceType.OUTPUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.INPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.CACHED_CONTEXT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.CACHE_READ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.CACHE_WRITE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.CACHE_WRITE_5_MIN_TTL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.CACHE_WRITE_1_HOUR_TTL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.THINKING.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.SERVER_TOOL_WEB_SEARCH.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigurablePricing.PriceType.SERVER_TOOL_WEB_FETCH.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

