/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.text.exclusions;

import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import ai.grazie.text.exclusions.Exclusion;
import ai.grazie.text.exclusions.ExclusionUtilsKt;
import ai.grazie.text.exclusions.IExclusion;
import ai.grazie.utils.multiplatform.SafeJsExport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SafeJsExport
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\bg\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0016J \u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0000H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lai/grazie/text/exclusions/TextWithExclusions;", "", "text", "", "getText", "()Ljava/lang/String;", "exclusions", "", "Lai/grazie/text/exclusions/Exclusion;", "getExclusions", "()Ljava/util/List;", "stubExclusions", "replaceExclusions", "forMarkup", "", "forUnknown", "stubbedToOriginal", "Lai/grazie/text/TextRange;", "range", "subSequence", "start", "", "endExclusive", "trim", "replace", "replacement", "Companion", "model-text"})
@SourceDebugExtension(value={"SMAP\nTextWithExclusions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextWithExclusions.kt\nai/grazie/text/exclusions/TextWithExclusions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1053#2:102\n1611#2,9:103\n1863#2:112\n1864#2:114\n1620#2:115\n1557#2:116\n1628#2,3:117\n1#3:113\n*S KotlinDebug\n*F\n+ 1 TextWithExclusions.kt\nai/grazie/text/exclusions/TextWithExclusions\n*L\n26#1:102\n47#1:103,9\n47#1:112\n47#1:114\n47#1:115\n36#1:116\n36#1:117,3\n47#1:113\n*E\n"})
public interface TextWithExclusions {
    @NotNull
    public static final Companion Companion = ai.grazie.text.exclusions.TextWithExclusions$Companion.$$INSTANCE;

    @NotNull
    public String getText();

    @NotNull
    public List<Exclusion> getExclusions();

    @Nullable
    default public String stubExclusions() {
        return this.getExclusions().isEmpty() ? null : this.replaceExclusions('\"', 'X');
    }

    @NotNull
    default public String replaceExclusions(char forMarkup, char forUnknown) {
        StringBuilder stubbed = new StringBuilder(this.getText());
        int delta = 0;
        Iterable $this$sortedBy$iv = this.getExclusions();
        boolean $i$f$sortedBy = false;
        for (Exclusion ex : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Exclusion it = (Exclusion)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getOffset());
                it = (Exclusion)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getOffset()));
            }
        })) {
            stubbed.insert(ex.getOffset() + delta, ex.getKind() == Exclusion.Kind.Markup ? forMarkup : forUnknown);
            ++delta;
        }
        String string = stubbed.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    default public TextRange stubbedToOriginal(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        return new TextRange(TextWithExclusions.stubbedToOriginal$toOriginal(this, range.getStart()), TextWithExclusions.stubbedToOriginal$toOriginal(this, range.getEndExclusive()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public TextWithExclusions subSequence(int start, int endExclusive) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        if (start == 0 && endExclusive == this.getText().length()) {
            return this;
        }
        String string = this.getText().substring(start, endExclusive);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        Iterable iterable = this.getExclusions();
        String string2 = string;
        Companion companion = Companion;
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Exclusion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Exclusion it = (Exclusion)element$iv$iv;
            boolean bl2 = false;
            if (it.restrictToRange(start, endExclusive) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return companion.of(string2, list);
    }

    @NotNull
    default public TextWithExclusions trim() {
        String trimmedText = ((Object)StringsKt.trim((CharSequence)this.getText())).toString();
        int start = StringsKt.indexOf$default((CharSequence)this.getText(), (String)trimmedText, (int)0, (boolean)false, (int)6, null);
        int end = start + trimmedText.length();
        if (!this.getExclusions().isEmpty()) {
            start = Math.min(start, ((Exclusion)CollectionsKt.first(this.getExclusions())).getOffset());
            end = Math.max(end, ((Exclusion)CollectionsKt.last(this.getExclusions())).getOffset());
        }
        return this.subSequence(start, end);
    }

    @NotNull
    default public TextWithExclusions replace(int start, int endExclusive, @NotNull TextWithExclusions replacement) {
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        TextWithExclusions[] textWithExclusionsArray = new TextWithExclusions[]{this.subSequence(0, start), replacement, this.subSequence(endExclusive, this.getText().length())};
        return Companion.concat(textWithExclusionsArray);
    }

    /*
     * WARNING - void declaration
     */
    private static int stubbedToOriginal$toOriginal(TextWithExclusions this$0, int offsetInStubbed) {
        int offset;
        void $this$mapTo$iv$iv;
        int result = offsetInStubbed;
        Iterable $this$map$iv = this$0.getExclusions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Exclusion exclusion = (Exclusion)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOffset());
        }
        Iterator iterator = CollectionsKt.sorted((Iterable)((List)destination$iv$iv)).iterator();
        while (iterator.hasNext() && (offset = ((Number)iterator.next()).intValue()) < result) {
            --result;
        }
        return result;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static TextWithExclusions of(@NotNull String text, @NotNull List<Exclusion> exclusions) {
        return Companion.of(text, exclusions);
    }

    @JvmStatic
    @NotNull
    public static TextWithExclusions of(@NotNull Text text) {
        return Companion.of(text);
    }

    @JvmStatic
    @NotNull
    public static TextWithExclusions concat(TextWithExclusions ... texts) {
        return Companion.concat(texts);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static TextWithExclusions of(@NotNull String text) {
        return Companion.of(text);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J!\u0010\f\u001a\u00020\u00052\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000e\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lai/grazie/text/exclusions/TextWithExclusions$Companion;", "", "<init>", "()V", "of", "Lai/grazie/text/exclusions/TextWithExclusions;", "text", "", "exclusions", "", "Lai/grazie/text/exclusions/Exclusion;", "Lai/grazie/text/Text;", "concat", "texts", "", "([Lai/grazie/text/exclusions/TextWithExclusions;)Lai/grazie/text/exclusions/TextWithExclusions;", "model-text"})
    @SourceDebugExtension(value={"SMAP\nTextWithExclusions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextWithExclusions.kt\nai/grazie/text/exclusions/TextWithExclusions$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1557#2:102\n1628#2,3:103\n*S KotlinDebug\n*F\n+ 1 TextWithExclusions.kt\nai/grazie/text/exclusions/TextWithExclusions$Companion\n*L\n81#1:102\n81#1:103,3\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TextWithExclusions of(@NotNull String text, @NotNull List<Exclusion> exclusions) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(exclusions, (String)"exclusions");
            return new TextWithExclusions(text, exclusions){
                private final String text;
                private final List<Exclusion> exclusions;
                final /* synthetic */ String $text;
                final /* synthetic */ List<Exclusion> $exclusions;
                {
                    this.$text = $text;
                    this.$exclusions = $exclusions;
                    this.text = $text;
                    this.exclusions = $exclusions;
                }

                public String getText() {
                    return this.text;
                }

                public List<Exclusion> getExclusions() {
                    return this.exclusions;
                }

                public boolean equals(Object other) {
                    return other instanceof TextWithExclusions && Intrinsics.areEqual((Object)this.$text, (Object)((TextWithExclusions)other).getText()) && Intrinsics.areEqual(this.$exclusions, ((TextWithExclusions)other).getExclusions());
                }

                public int hashCode() {
                    return this.$text.hashCode() * 31 + ((Object)this.$exclusions).hashCode();
                }

                public String toString() {
                    return this.$text;
                }
            };
        }

        public static /* synthetic */ TextWithExclusions of$default(Companion companion, String string, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.of(string, list);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final TextWithExclusions of(@NotNull Text text) {
            Collection<Exclusion> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Iterable iterable = ExclusionUtilsKt.getExclusions(text);
            String string = text.getValue();
            Companion companion = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void e;
                IExclusion iExclusion = (IExclusion)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Exclusion(e.getOffset(), e.isUnknown() ? Exclusion.Kind.Unknown : Exclusion.Kind.Markup));
            }
            collection = (List)destination$iv$iv;
            return companion.of(string, (List<Exclusion>)collection);
        }

        @JvmStatic
        @NotNull
        public final TextWithExclusions concat(TextWithExclusions ... texts) {
            Intrinsics.checkNotNullParameter((Object)texts, (String)"texts");
            StringBuilder sb = new StringBuilder();
            ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
            for (TextWithExclusions text : texts) {
                for (Exclusion e : text.getExclusions()) {
                    Exclusion shifted = e.withOffset(e.getOffset() + sb.length());
                    if (Intrinsics.areEqual((Object)shifted, (Object)CollectionsKt.lastOrNull((List)exclusions))) continue;
                    exclusions.add(shifted);
                }
                sb.append(text.getText());
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return this.of(string, (List<Exclusion>)exclusions);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final TextWithExclusions of(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return ai.grazie.text.exclusions.TextWithExclusions$Companion.of$default(this, text, null, 2, null);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

