/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.library;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.konan.library.KlibNativeManifestTransformer;
import org.jetbrains.kotlin.konan.library.KonanLibraryKt;
import org.jetbrains.kotlin.konan.library.SearchPathResolverWithTarget;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryProperResolverWithAttributes;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.library.loader.KlibLoader;
import org.jetbrains.kotlin.library.loader.KlibLoaderSpec;
import org.jetbrains.kotlin.library.loader.KlibPlatformChecker;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003BA\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u000bH\u0016J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/konan/library/KonanLibraryProperResolver;", "Lorg/jetbrains/kotlin/library/KotlinLibraryProperResolverWithAttributes;", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/konan/library/SearchPathResolverWithTarget;", "directLibs", "", "", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "distributionKlib", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "zipFileSystemAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "(Ljava/util/List;Lorg/jetbrains/kotlin/konan/target/KonanTarget;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;)V", "distPlatformHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getDistPlatformHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getZipFileSystemAccessor", "()Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "candidate", "unresolved", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "kotlin-native-utils"})
public final class KonanLibraryProperResolver
extends KotlinLibraryProperResolverWithAttributes<KotlinLibrary>
implements SearchPathResolverWithTarget<KotlinLibrary> {
    @NotNull
    private final KonanTarget target;
    @NotNull
    private final Logger logger;
    @Nullable
    private final ZipFileSystemAccessor zipFileSystemAccessor;

    public KonanLibraryProperResolver(@NotNull List<String> directLibs, @NotNull KonanTarget target, @Nullable String distributionKlib, boolean skipCurrentDir, @NotNull Logger logger, @Nullable ZipFileSystemAccessor zipFileSystemAccessor) {
        Intrinsics.checkNotNullParameter(directLibs, (String)"directLibs");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(directLibs, distributionKlib, skipCurrentDir, logger, CollectionsKt.listOf((Object)"kotlin.native.cinterop"));
        this.target = target;
        this.logger = logger;
        this.zipFileSystemAccessor = zipFileSystemAccessor;
    }

    public /* synthetic */ KonanLibraryProperResolver(List list, KonanTarget konanTarget, String string, boolean bl, Logger logger, ZipFileSystemAccessor zipFileSystemAccessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            zipFileSystemAccessor = null;
        }
        this(list, konanTarget, string, bl, logger, zipFileSystemAccessor);
    }

    @Override
    @NotNull
    public KonanTarget getTarget() {
        return this.target;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ZipFileSystemAccessor getZipFileSystemAccessor() {
        return this.zipFileSystemAccessor;
    }

    @Override
    @NotNull
    public List<KotlinLibrary> libraryComponentBuilder(@NotNull File file, boolean isDefault) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new KlibLoader((Function1<? super KlibLoaderSpec, Unit>)((Function1)new Function1<KlibLoaderSpec, Unit>(file, this){
            final /* synthetic */ File $file;
            final /* synthetic */ KonanLibraryProperResolver this$0;
            {
                this.$file = $file;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(KlibLoaderSpec $this$$receiver) {
                Intrinsics.checkNotNullParameter((Object)$this$$receiver, (String)"$this$$receiver");
                Path[] pathArray = new Path[1];
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(this.$file.getAbsolutePath(), new String[0]).normalize(), (String)"get(file.absolutePath).normalize()");
                $this$$receiver.libraryPaths(pathArray);
                ZipFileSystemAccessor zipFileSystemAccessor = this.this$0.getZipFileSystemAccessor();
                if (zipFileSystemAccessor != null) {
                    ZipFileSystemAccessor p0 = zipFileSystemAccessor;
                    boolean bl = false;
                    $this$$receiver.zipFileSystemAccessor(p0);
                }
                $this$$receiver.platformChecker(new KlibPlatformChecker.NativeMetadata(this.this$0.getTarget().getName()));
                $this$$receiver.manifestTransformer(new KlibNativeManifestTransformer(this.this$0.getTarget()));
            }
        })).load().getLibrariesStdlibFirst();
    }

    @Override
    @Nullable
    public File getDistPlatformHead() {
        Object object = this.getDistributionKlib();
        return object != null && (object = FileKt.File((String)object)) != null && (object = ((File)object).child("platform")) != null ? ((File)object).child(this.getTarget().getVisibleName()) : null;
    }

    @Override
    public boolean libraryMatch(@NotNull KotlinLibrary candidate2, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        KonanTarget resolverTarget = this.getTarget();
        String candidatePath = candidate2.getLibraryFile().getAbsolutePath();
        List<String> supportedTargets = KonanLibraryKt.getSupportedTargetList(candidate2);
        if (!((Collection)supportedTargets).isEmpty() && !supportedTargets.contains(resolverTarget.getVisibleName())) {
            this.getLogger().strongWarning("KLIB resolver: Skipping '" + candidatePath + "'. The target doesn't match. Expected '" + resolverTarget + "', found " + supportedTargets + '.');
            return false;
        }
        return super.libraryMatch(candidate2, unresolved);
    }
}

