/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.HighlightInfoB;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdater;
import com.intellij.codeInsight.daemon.impl.HighlightInfoUpdaterImpl;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.actions.DisableHighlightingIntentionAction;
import com.intellij.codeInsight.daemon.impl.actions.IntentionActionWithFixAllOption;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.ExternalSourceProblemGroup;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ReportingClassSubstitutor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.CancellablePromise;

@ApiStatus.NonExtendable
public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance(HighlightInfo.class);
    @ApiStatus.Internal
    static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    private static final byte FROM_INJECTION_MASK = 1;
    private static final byte AFTER_END_OF_LINE_MASK = 2;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 4;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    public final int startOffset;
    public final int endOffset;
    @Deprecated
    public @Unmodifiable List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    @Deprecated
    public @Unmodifiable List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final @NlsContexts.DetailedDescription String description;
    private final @NlsContexts.Tooltip String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    volatile Object toolId;
    private int group;
    private final long fixRange;
    private volatile byte myFlags;
    @ApiStatus.Internal
    public final int navigationShift;
    @Nullable
    private Object fileLevelComponentsStorage;
    @NotNull
    private volatile OffsetStore offsetStore;
    private static final VarHandle OFFSET_STORE_HANDLE;
    private static final OffsetStore INITIAL_STORE;
    private static final OffsetStore TOMB;

    @Deprecated
    @ApiStatus.Internal
    protected HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @NlsContexts.DetailedDescription @Nullable String escapedDescription, @NlsContexts.Tooltip @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, boolean isFileLevelAnnotation, int navigationShift, @Nullable ProblemGroup problemGroup, @Nullable Object toolId, @Nullable GutterMark gutterIconRenderer, int group, @NotNull @NotNull @Unmodifiable List<? extends @NotNull Consumer<? super QuickFixActionRegistrar>> lazyFixes) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(0);
        }
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(1);
        }
        if (lazyFixes == null) {
            HighlightInfo.$$$reportNull$$$0(2);
        }
        if (startOffset < 0 || startOffset > endOffset) {
            throw new IllegalArgumentException("Incorrect highlightInfo bounds: startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + String.valueOf(type) + "; description=" + escapedDescription + ". Maybe you forgot to call .range()?");
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixRange = TextRangeScalarUtil.toScalarRange((int)startOffset, (int)endOffset);
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.myFlags = (byte)((afterEndOfLine ? 2 : 0) | (isFileLevelAnnotation ? 4 : 0));
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
        this.toolId = toolId;
        this.group = group;
        List myLazyQuickFixes = ContainerUtil.map(lazyFixes, c -> new LazyFixDescription((Consumer<? super QuickFixActionRegistrar>)c, 0L, null));
        this.offsetStore = INITIAL_STORE.withLazyQuickFixes(myLazyQuickFixes);
    }

    @ApiStatus.Internal
    public final void setToolId(Object toolId) {
        this.toolId = toolId;
    }

    @ApiStatus.Internal
    public final Object getToolId() {
        return this.toolId;
    }

    @NotNull
    private static @Unmodifiable List<IntentionActionDescriptor> getIntentionActionDescriptors(@NotNull OffsetStore store) {
        if (store == null) {
            HighlightInfo.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.concat(store.intentionActionDescriptors(), (List)ContainerUtil.flatMap(store.lazyQuickFixes(), desc -> {
            Future<@NotNull List<IntentionActionDescriptor>> future = desc.future();
            if (future != null && future.isDone()) {
                try {
                    List<IntentionActionDescriptor> coll = future.get();
                    assert (coll != null) : String.valueOf(future) + "; " + String.valueOf(future.getClass()) + "; desc=" + String.valueOf(desc);
                    return List.copyOf(coll);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.warn((Throwable)e);
                    return List.of();
                }
            }
            return List.of();
        }));
        if (list == null) {
            HighlightInfo.$$$reportNull$$$0(4);
        }
        return list;
    }

    public final <T> T findRegisteredQuickFix(@NotNull @NotNull BiFunction<? super @NotNull IntentionActionDescriptor, ? super @NotNull TextRange, ? extends @Nullable T> predicate) {
        if (predicate == null) {
            HighlightInfo.$$$reportNull$$$0(5);
        }
        OffsetStore store = this.offsetStore;
        List<IntentionActionDescriptor> descriptors = HighlightInfo.getIntentionActionDescriptors(store);
        HashSet<IntentionActionDescriptor> processed = new HashSet<IntentionActionDescriptor>();
        for (IntentionActionDescriptor descriptor : descriptors) {
            T result;
            if (!processed.add(descriptor)) continue;
            TextRange fixRange = descriptor.getFixRange();
            if (fixRange == null) {
                fixRange = TextRangeScalarUtil.create((long)this.getFixTextRangeScalar(store));
            }
            if ((result = predicate.apply(descriptor, (TextRange)fixRange)) == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static HighlightInfo fromRangeHighlighter(@NotNull RangeHighlighter highlighter) {
        HighlightInfo info;
        Object errorStripeTooltip;
        if (highlighter == null) {
            HighlightInfo.$$$reportNull$$$0(6);
        }
        return (errorStripeTooltip = highlighter.getErrorStripeTooltip()) instanceof HighlightInfo ? (info = (HighlightInfo)errorStripeTooltip) : null;
    }

    @NotNull
    private Segment getFixTextRange() {
        OffsetStore store = this.offsetStore;
        RangeMarker myFixMarker = store.fixMarker();
        if (myFixMarker == null) {
            RangeHighlighterEx myHighlighter = store.highlighter();
            if (myHighlighter != null && myHighlighter.isValid()) {
                RangeHighlighterEx rangeHighlighterEx = myHighlighter;
                if (rangeHighlighterEx == null) {
                    HighlightInfo.$$$reportNull$$$0(7);
                }
                return rangeHighlighterEx;
            }
        } else if (myFixMarker.isValid()) {
            RangeMarker rangeMarker = myFixMarker;
            if (rangeMarker == null) {
                HighlightInfo.$$$reportNull$$$0(8);
            }
            return rangeMarker;
        }
        TextRange textRange = TextRangeScalarUtil.create((long)this.fixRange);
        if (textRange == null) {
            HighlightInfo.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private long getFixTextRangeScalar(@NotNull OffsetStore store) {
        if (store == null) {
            HighlightInfo.$$$reportNull$$$0(10);
        }
        RangeMarker myFixMarker = store.fixMarker();
        RangeHighlighterEx myHighlighter = store.highlighter();
        if (myFixMarker == null) {
            if (myHighlighter != null && myHighlighter.isValid()) {
                return TextRangeScalarUtil.toScalarRange((Segment)myHighlighter);
            }
        } else if (myFixMarker.isValid()) {
            return TextRangeScalarUtil.toScalarRange((Segment)myFixMarker);
        }
        return this.fixRange;
    }

    @ApiStatus.Internal
    public final void markFromInjection() {
        this.setFlag((byte)1);
    }

    @ApiStatus.Internal
    public final void addFileLevelComponent(@NotNull FileEditor fileEditor, @NotNull JComponent component) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(11);
        }
        if (component == null) {
            HighlightInfo.$$$reportNull$$$0(12);
        }
        Object object = this.fileLevelComponentsStorage;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pair.class, Map.class}, (Object)object, n)) {
            case -1: {
                this.fileLevelComponentsStorage = new Pair((Object)fileEditor, (Object)component);
                break;
            }
            case 0: {
                Pair p;
                Pair pair = p = (Pair)object;
                HashMap<FileEditor, JComponent> map = new HashMap<FileEditor, JComponent>();
                map.put((FileEditor)pair.first, (JComponent)pair.second);
                map.put(fileEditor, component);
                this.fileLevelComponentsStorage = map;
                break;
            }
            case 1: {
                Map map = (Map)object;
                map.put(fileEditor, component);
                break;
            }
            default: {
                LOG.error((Throwable)new IllegalStateException("fileLevelComponents=" + String.valueOf(this.fileLevelComponentsStorage)));
            }
        }
    }

    @ApiStatus.Internal
    public final void removeFileLeverComponent(@NotNull FileEditor fileEditor) {
        Object object;
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(13);
        }
        if ((object = this.fileLevelComponentsStorage) instanceof Pair) {
            Pair p;
            Pair pair = p = (Pair)object;
            if (pair.first == fileEditor) {
                this.fileLevelComponentsStorage = null;
            }
        } else {
            object = this.fileLevelComponentsStorage;
            if (object instanceof Map) {
                Map map = (Map)object;
                map.remove(fileEditor);
            }
        }
    }

    @ApiStatus.Internal
    @Nullable
    public final JComponent getFileLevelComponent(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            HighlightInfo.$$$reportNull$$$0(14);
        }
        Object object = this.fileLevelComponentsStorage;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Pair.class, Map.class}, (Object)object, n)) {
            case -1: {
                return null;
            }
            case 0: {
                Pair pair = (Pair)object;
                return pair.first == fileEditor ? (JComponent)pair.second : null;
            }
            case 1: {
                Map map = (Map)object;
                return (JComponent)map.get(fileEditor);
            }
        }
        LOG.error((Throwable)new IllegalStateException("fileLevelComponents=" + String.valueOf(this.fileLevelComponentsStorage)));
        return null;
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null) {
            return null;
        }
        String wrapped = XmlStringUtil.wrapInHtml((CharSequence)toolTip);
        if (description == null || !wrapped.contains(DESCRIPTION_PLACEHOLDER)) {
            return wrapped;
        }
        return StringUtil.replace((String)wrapped, (String)DESCRIPTION_PLACEHOLDER, (String)XmlStringUtil.escapeString((String)description));
    }

    @NlsContexts.Tooltip
    @Nullable
    private static String encodeTooltip(@NlsContexts.Tooltip @Nullable String tooltip, @NlsContexts.DetailedDescription @Nullable String description) {
        if (tooltip == null) {
            return null;
        }
        String stripped = XmlStringUtil.stripHtml((String)tooltip);
        if (description == null || description.isEmpty()) {
            return stripped;
        }
        String encoded = StringUtil.replace((String)stripped, (String)XmlStringUtil.escapeString((String)description), (String)DESCRIPTION_PLACEHOLDER);
        if (Strings.areSameInstance((String)encoded, (String)stripped)) {
            return stripped;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return encoded;
    }

    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.description;
    }

    @Nullable
    @NonNls
    public final String getInspectionToolId() {
        String inspectionToolShortName;
        Object object = this.toolId;
        return object instanceof String ? (inspectionToolShortName = (String)object) : null;
    }

    @ApiStatus.Internal
    @Nullable
    @NonNls
    public final String getExternalSourceId() {
        String string;
        ProblemGroup problemGroup = this.myProblemGroup;
        if (problemGroup instanceof ExternalSourceProblemGroup) {
            ExternalSourceProblemGroup externalSourceId = (ExternalSourceProblemGroup)problemGroup;
            string = externalSourceId.getExternalCheckName();
        } else {
            string = null;
        }
        return string;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myFlags, (byte)mask);
    }

    private void setFlag(@FlagConstant byte mask) {
        this.myFlags = BitUtil.set((byte)this.myFlags, (byte)mask, (boolean)true);
    }

    @ApiStatus.Internal
    public final boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)4);
    }

    @NotNull
    public final HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = this.severity;
        if (highlightSeverity == null) {
            HighlightInfo.$$$reportNull$$$0(15);
        }
        return highlightSeverity;
    }

    public final RangeHighlighterEx getHighlighter() {
        return this.offsetStore.highlighter();
    }

    public final void setHighlighter(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            HighlightInfo.$$$reportNull$$$0(16);
        }
        OffsetStore savedStore = this.updateOffsetStore(oldStore -> {
            if (oldStore.highlighter() != null) {
                throw new IllegalStateException("Cannot set highlighter to " + String.valueOf(highlighter) + " because it already set: " + String.valueOf(oldStore.highlighter()) + ". Maybe this HighlightInfo was (incorrectly) stored and reused?");
            }
            OffsetStore newStore = oldStore.withHighlighter(highlighter);
            return this.updateFields(newStore, highlighter.getDocument());
        });
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(HighlightInfo.getIntentionActionDescriptors(savedStore));
    }

    public final boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)2);
    }

    @Nullable
    public final TextAttributes getTextAttributes(@Nullable PsiElement element, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        SeverityRegistrar severityRegistrar;
        TextAttributes textAttributes;
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(17);
        }
        if (colorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(18);
        }
        if ((textAttributes = (severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element != null ? element.getProject() : null)).getTextAttributesBySeverity(type.getSeverity(element))) != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    final Color getErrorStripeMarkColor(@NotNull PsiElement element, @Nullable(value="when null, the global scheme will be used") @Nullable(value="when null, the global scheme will be used") EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (element == null) {
            HighlightInfo.$$$reportNull$$$0(19);
        }
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element, this.type, (TextAttributesScheme)scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        EditorColorsScheme editorColorsScheme = customScheme != null ? customScheme : EditorColorsManager.getInstance().getGlobalScheme();
        if (editorColorsScheme == null) {
            HighlightInfo.$$$reportNull$$$0(20);
        }
        return editorColorsScheme;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return this.equalsByActualOffset(info);
    }

    @ApiStatus.Internal
    public boolean equalsByActualOffset(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(21);
        }
        if (info == this) {
            return true;
        }
        return info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && this.attributesEqual(info);
    }

    @ApiStatus.Internal
    public final boolean attributesEqual(@NotNull HighlightInfo info) {
        if (info == null) {
            HighlightInfo.$$$reportNull$$$0(22);
        }
        return info.getSeverity() == this.getSeverity() && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    @ApiStatus.Internal
    @NonNls
    public final String toStringCompact(boolean showFullQualifiedClassNames) {
        OffsetStore store;
        RangeHighlighterEx highlighter;
        String s = "HighlightInfo(" + this.getStartOffset() + "," + this.getEndOffset() + ")";
        if (this.isFileLevelAnnotation()) {
            s = s + " (file level)";
        }
        if (this.getStartOffset() != this.startOffset || this.getEndOffset() != this.endOffset) {
            s = s + "; created as: (" + this.startOffset + "," + this.endOffset + ")";
        }
        if ((highlighter = (store = this.offsetStore).highlighter()) != null) {
            s = s + "; text='" + StringUtil.first((String)this.getText(), (int)40, (boolean)true) + "'; highlighter: (" + highlighter.getStartOffset() + "," + highlighter.getEndOffset() + ")";
            if (!highlighter.isValid()) {
                s = s + " (invalid)";
            }
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + "; severity=" + String.valueOf(this.getSeverity());
        List<IntentionActionDescriptor> descriptors = HighlightInfo.getIntentionActionDescriptors(store);
        if (!descriptors.isEmpty()) {
            s = s + "; quickFixes: " + StringUtil.join(descriptors, (String)", ");
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + String.valueOf(this.gutterIconRenderer);
        }
        if (this.toolId != null) {
            String string;
            if (showFullQualifiedClassNames) {
                string = "; toolId: " + String.valueOf(this.toolId) + (String)(this.toolId instanceof Class ? "" : " (" + String.valueOf(this.toolId.getClass()) + ")");
            } else {
                String string2;
                Object object = this.toolId;
                if (object instanceof Class) {
                    Class c = (Class)object;
                    string2 = c.getSimpleName();
                } else {
                    string2 = "not specified";
                }
                string = "; toolId: " + string2;
            }
            s = s + string;
        }
        if (this.group != -6) {
            s = s + "; group: " + this.group;
        }
        if (this.forcedTextAttributesKey != null) {
            s = s + "; forcedTextAttributesKey: " + String.valueOf(this.forcedTextAttributesKey);
        }
        if (this.forcedTextAttributes != null) {
            s = s + "; forcedTextAttributes: " + String.valueOf(this.forcedTextAttributes);
        }
        return s;
    }

    @NonNls
    public String toString() {
        return this.toStringCompact(true);
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        if (type == null) {
            HighlightInfo.$$$reportNull$$$0(23);
        }
        return new HighlightInfoB(type, false);
    }

    @ApiStatus.Internal
    public final void setGroup(int group) {
        this.group = group;
    }

    public final GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public final ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation, @NotNull Document document) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(24);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(25);
        }
        return HighlightInfo.fromAnnotation(ExternalAnnotator.class, annotation, false, document);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(26);
        }
        return HighlightInfo.fromAnnotation(ExternalAnnotator.class, annotation, false, (Document)new DocumentImpl(""));
    }

    @ApiStatus.Internal
    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull ExternalAnnotator<?, ?> externalAnnotator, @NotNull Annotation annotation, @NotNull Document document) {
        if (externalAnnotator == null) {
            HighlightInfo.$$$reportNull$$$0(27);
        }
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(28);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(29);
        }
        return HighlightInfo.fromAnnotation(externalAnnotator.getClass(), annotation, false, document);
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Class<?> annotatorClass, @NotNull Annotation annotation, boolean batchMode, @NotNull Document document) {
        List fixes;
        if (annotatorClass == null) {
            HighlightInfo.$$$reportNull$$$0(30);
        }
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(31);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(32);
        }
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null && key != HighlighterColors.NO_HIGHLIGHTING ? key : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), annotation.getStartOffset(), annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), annotatorClass, (GutterMark)annotation.getGutterIconRenderer(), -6, annotation.getLazyQuickFixes());
        List list = fixes = batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes();
        if (fixes != null) {
            List descriptors = ContainerUtil.map((Collection)fixes, af -> {
                TextRange range = af.textRange;
                HighlightDisplayKey k = af.key != null ? af.key : HighlightDisplayKey.find((String)ANNOTATOR_INSPECTION_SHORT_NAME);
                return new IntentionActionDescriptor(af.quickFix, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)k), null, k, annotation.getProblemGroup(), info.getSeverity(), (Segment)range);
            });
            info.registerFixes(descriptors, document);
        }
        HighlightInfo highlightInfo = info;
        if (highlightInfo == null) {
            HighlightInfo.$$$reportNull$$$0(33);
        }
        return highlightInfo;
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        if (annotation == null) {
            HighlightInfo.$$$reportNull$$$0(34);
        }
        ProblemHighlightType type = annotation.getHighlightType();
        HighlightSeverity severity = annotation.getSeverity();
        return HighlightInfo.toHighlightInfoType(type, severity);
    }

    @NotNull
    private static HighlightInfoType toHighlightInfoType(ProblemHighlightType problemHighlightType, @NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(35);
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.UNUSED_SYMBOL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(36);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.WRONG_REF;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(37);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            HighlightInfoType highlightInfoType = HighlightInfoType.DEPRECATED;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(38);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL) {
            HighlightInfoType highlightInfoType = HighlightInfoType.MARKED_FOR_REMOVAL;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(39);
            }
            return highlightInfoType;
        }
        if (problemHighlightType == ProblemHighlightType.POSSIBLE_PROBLEM) {
            HighlightInfoType highlightInfoType = HighlightInfoType.POSSIBLE_PROBLEM;
            if (highlightInfoType == null) {
                HighlightInfo.$$$reportNull$$$0(40);
            }
            return highlightInfoType;
        }
        return HighlightInfo.convertSeverity(severity);
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(41);
        }
        HighlightInfoType highlightInfoType = severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(42);
        }
        return highlightInfoType;
    }

    @NotNull
    public static ProblemHighlightType convertType(@NotNull HighlightInfoType infoType) {
        if (infoType == null) {
            HighlightInfo.$$$reportNull$$$0(43);
        }
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.ERROR;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(44);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.WARNING) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.WARNING;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(45);
            }
            return problemHighlightType;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                HighlightInfo.$$$reportNull$$$0(46);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(47);
        }
        return problemHighlightType;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            HighlightInfo.$$$reportNull$$$0(48);
        }
        ProblemHighlightType problemHighlightType = severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
        if (problemHighlightType == null) {
            HighlightInfo.$$$reportNull$$$0(49);
        }
        return problemHighlightType;
    }

    public final boolean hasHint() {
        return ContainerUtil.exists(HighlightInfo.getIntentionActionDescriptors(this.offsetStore), descriptor -> descriptor.myAction instanceof HintAction);
    }

    public final int getActualStartOffset() {
        RangeHighlighterEx h = this.offsetStore.highlighter();
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public final int getActualEndOffset() {
        RangeHighlighterEx h = this.offsetStore.highlighter();
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    public final int getStartOffset() {
        return this.getActualStartOffset();
    }

    public final int getEndOffset() {
        return this.getActualEndOffset();
    }

    @ApiStatus.Internal
    public final int getGroup() {
        return this.group;
    }

    @ApiStatus.Internal
    public final boolean isFromInjection() {
        return this.isFlagSet((byte)1);
    }

    @NotNull
    public final String getText() {
        if (this.isFileLevelAnnotation()) {
            return "";
        }
        RangeHighlighterEx highlighter = this.offsetStore.highlighter();
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        TextRange range = highlighter.getTextRange();
        if (!highlighter.isValid()) {
            return "";
        }
        String text = highlighter.getDocument().getText();
        String string = text.substring(Math.min(range.getStartOffset(), text.length()), Math.min(range.getEndOffset(), text.length()));
        if (string == null) {
            HighlightInfo.$$$reportNull$$$0(50);
        }
        return string;
    }

    @Deprecated
    public final void registerFix(@NotNull IntentionAction action, @Nullable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action == null) {
            HighlightInfo.$$$reportNull$$$0(51);
        }
        this.registerFixes(List.of(new IntentionActionDescriptor(action, options, displayName, null, key, this.myProblemGroup, this.getSeverity(), (Segment)fixRange)), null);
    }

    @ApiStatus.Internal
    final void registerFixes(@NotNull @NotNull List<@NotNull IntentionActionDescriptor> fixes, @Nullable Document document) {
        if (fixes == null) {
            HighlightInfo.$$$reportNull$$$0(52);
        }
        if (fixes.isEmpty()) {
            return;
        }
        this.updateOffsetStore(oldStore -> {
            List<IntentionActionDescriptor> newDescriptors = List.copyOf(ContainerUtil.concat(oldStore.intentionActionDescriptors(), (List)fixes));
            OffsetStore newStore = oldStore.withIntentionDescriptorsAndFixMarker(newDescriptors, oldStore.fixMarker());
            return this.updateFields(newStore, document);
        });
    }

    @ApiStatus.Internal
    public final void updateLazyFixesPsiTimeStamp(long psiTimeStamp) {
        this.updateOffsetStore(store -> store.withLazyQuickFixes(ContainerUtil.map(store.lazyQuickFixes(), d -> d.psiModificationStamp() == 0L ? new LazyFixDescription(d.fixesComputer(), psiTimeStamp, d.future()) : d)));
    }

    @Contract(pure=true)
    @NotNull
    private OffsetStore updateFields(@NotNull OffsetStore oldStore, @Nullable Document document) {
        RangeMarker newFixMarker;
        List<IntentionActionDescriptor> newDescriptors;
        if (oldStore == null) {
            HighlightInfo.$$$reportNull$$$0(53);
        }
        long newFixRange = this.getFixTextRangeScalar(oldStore);
        for (IntentionActionDescriptor descriptor : oldStore.intentionActionDescriptors()) {
            Segment segment;
            TextRange descriptorFixRange = descriptor.getFixRange();
            if (document == null && (segment = descriptor.myFixRange) instanceof RangeMarker) {
                RangeMarker marker = (RangeMarker)segment;
                document = marker.getDocument();
            }
            if (descriptorFixRange == null) continue;
            newFixRange = TextRangeScalarUtil.union((long)newFixRange, (long)TextRangeScalarUtil.toScalarRange((Segment)descriptorFixRange));
        }
        RangeHighlighterEx highlighter = oldStore.highlighter();
        if (document == null) {
            RangeMarker fixMarker = oldStore.fixMarker();
            Object object = fixMarker != null ? fixMarker.getDocument() : (document = highlighter != null ? highlighter.getDocument() : null);
        }
        if (document == null) {
            newDescriptors = oldStore.intentionActionDescriptors();
            newFixMarker = null;
        } else {
            newFixRange = TextRangeScalarUtil.coerceRange((long)newFixRange, (int)0, (int)document.getTextLength());
            Long2ObjectMap<RangeMarker> cache = HighlightInfo.getRangeMarkerCache(oldStore);
            newDescriptors = HighlightInfo.toRangeMarkerFixRanges(oldStore.intentionActionDescriptors(), document, cache, newFixRange);
            long highlighterRange = highlighter != null && highlighter.isValid() ? TextRangeScalarUtil.toScalarRange((Segment)highlighter) : newFixRange;
            newFixMarker = HighlightInfo.updateFixMarker(document, cache, newFixRange, highlighterRange);
        }
        OffsetStore offsetStore = oldStore.withIntentionDescriptorsAndFixMarker(newDescriptors, newFixMarker);
        if (offsetStore == null) {
            HighlightInfo.$$$reportNull$$$0(54);
        }
        return offsetStore;
    }

    @Contract(pure=true)
    @NotNull
    private static Long2ObjectMap<RangeMarker> getRangeMarkerCache(@NotNull OffsetStore store) {
        RangeHighlighterEx highlighter;
        if (store == null) {
            HighlightInfo.$$$reportNull$$$0(55);
        }
        Long2ObjectOpenHashMap cache = new Long2ObjectOpenHashMap();
        for (IntentionActionDescriptor pair : HighlightInfo.getIntentionActionDescriptors(store)) {
            RangeMarker marker;
            Segment fixRange = pair.myFixRange;
            if (!(fixRange instanceof RangeMarker) || !(marker = (RangeMarker)fixRange).isValid()) continue;
            cache.put(TextRangeScalarUtil.toScalarRange((Segment)marker), (Object)marker);
            break;
        }
        if ((highlighter = store.highlighter()) != null && highlighter.isValid()) {
            cache.putIfAbsent(TextRangeScalarUtil.toScalarRange((Segment)highlighter), (Object)highlighter);
        }
        Long2ObjectOpenHashMap long2ObjectOpenHashMap = cache;
        if (long2ObjectOpenHashMap == null) {
            HighlightInfo.$$$reportNull$$$0(56);
        }
        return long2ObjectOpenHashMap;
    }

    public final void unregisterQuickFix(@NotNull Condition<? super IntentionAction> condition) {
        if (condition == null) {
            HighlightInfo.$$$reportNull$$$0(57);
        }
        this.updateOffsetStore(oldStore -> oldStore.withIntentionDescriptorsAndFixMarker(List.copyOf(ContainerUtil.filter(oldStore.intentionActionDescriptors(), descriptor -> !condition.value((Object)descriptor.getAction()))), oldStore.fixMarker()));
    }

    public final IntentionAction getSameFamilyFix(@NotNull IntentionActionWithFixAllOption action) {
        if (action == null) {
            HighlightInfo.$$$reportNull$$$0(58);
        }
        for (IntentionActionDescriptor descriptor : HighlightInfo.getIntentionActionDescriptors(this.offsetStore)) {
            IntentionActionWithFixAllOption option;
            IntentionAction other = IntentionActionDelegate.unwrap((IntentionAction)descriptor.getAction());
            if (!(other instanceof IntentionActionWithFixAllOption) || !action.belongsToMyFamily(option = (IntentionActionWithFixAllOption)other)) continue;
            return other;
        }
        return null;
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public final boolean containsOffset(int offset, boolean includeFixRange) {
        OffsetStore store = this.offsetStore;
        RangeHighlighterEx highlighter = store.highlighter();
        if (highlighter == null || !highlighter.isValid()) {
            return false;
        }
        int startOffset = highlighter.getStartOffset();
        int endOffset = highlighter.getEndOffset();
        if (startOffset <= offset && offset <= endOffset) {
            return true;
        }
        if (!includeFixRange) {
            return false;
        }
        long fixRange = this.getFixTextRangeScalar(store);
        return TextRangeScalarUtil.containsOffset((long)fixRange, (int)offset);
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long textRange) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(59);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(60);
        }
        RangeMarker rangeMarker = (RangeMarker)range2markerCache.computeIfAbsent(textRange, __ -> document.createRangeMarker(TextRangeScalarUtil.startOffset((long)textRange), TextRangeScalarUtil.endOffset((long)textRange)));
        if (rangeMarker == null) {
            HighlightInfo.$$$reportNull$$$0(61);
        }
        return rangeMarker;
    }

    final void updateQuickFixFields(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long finalHighlighterRange) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(62);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(63);
        }
        this.updateOffsetStore(oldStore -> {
            long fixTextRange = TextRangeScalarUtil.coerceRange((long)this.getFixTextRangeScalar((OffsetStore)oldStore), (int)0, (int)document.getTextLength());
            RangeMarker newFixMarker = HighlightInfo.updateFixMarker(document, range2markerCache, fixTextRange, finalHighlighterRange);
            List<IntentionActionDescriptor> newDescriptors = HighlightInfo.toRangeMarkerFixRanges(HighlightInfo.getIntentionActionDescriptors(oldStore), document, range2markerCache, fixTextRange);
            return oldStore.withIntentionDescriptorsAndFixMarker(newDescriptors, newFixMarker);
        });
    }

    @Contract(pure=true)
    @NotNull
    private static @Unmodifiable List<IntentionActionDescriptor> toRangeMarkerFixRanges(@NotNull List<IntentionActionDescriptor> descriptors, @NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long fixTextRange) {
        if (descriptors == null) {
            HighlightInfo.$$$reportNull$$$0(64);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(65);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(66);
        }
        List list = ContainerUtil.map(descriptors, descriptor -> descriptor.withRangeMarkerFixRange(document, range2markerCache, fixTextRange));
        if (list == null) {
            HighlightInfo.$$$reportNull$$$0(67);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    private static RangeMarker updateFixMarker(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long newFixRange, long l) {
        void finalHighlighterRange;
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(68);
        }
        if (range2markerCache == null) {
            HighlightInfo.$$$reportNull$$$0(69);
        }
        if (newFixRange == finalHighlighterRange) {
            return null;
        }
        return HighlightInfo.getOrCreate(document, range2markerCache, newFixRange);
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public final boolean hasLazyQuickFixes() {
        return !this.offsetStore.lazyQuickFixes().isEmpty();
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public boolean hasQuickFixes() {
        return this.hasLazyQuickFixes() || !this.offsetStore.intentionActionDescriptors.isEmpty();
    }

    @ApiStatus.Internal
    @Contract(pure=true)
    public final boolean isFromAnnotator() {
        return HighlightInfoUpdaterImpl.isAnnotatorToolId(this.toolId);
    }

    @ApiStatus.Internal
    public final boolean isFromInspection() {
        return HighlightInfoUpdaterImpl.isInspectionToolId(this.toolId);
    }

    @ApiStatus.Internal
    public final boolean isFromHighlightVisitor() {
        return HighlightInfoUpdaterImpl.isHighlightVisitorToolId(this.toolId);
    }

    @ApiStatus.Internal
    final boolean isInjectionRelated() {
        return HighlightInfoUpdaterImpl.isInjectionRelated(this.toolId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @ApiStatus.Internal
    @Contract(pure=true)
    @NotNull
    public static HighlightInfo createComposite(@NotNull List<? extends HighlightInfo> infos, @NotNull Project project) {
        if (infos == null) {
            HighlightInfo.$$$reportNull$$$0(70);
        }
        if (project == null) {
            HighlightInfo.$$$reportNull$$$0(71);
        }
        HighlightInfoUpdater highlightInfoUpdater = HighlightInfoUpdater.getInstance(project);
        // MONITORENTER : highlightInfoUpdater
        HighlightInfo anchorInfo = (HighlightInfo)ContainerUtil.find(infos, info -> info.getToolTip() != null && info.getHighlighter() != null);
        if (anchorInfo == null) {
            anchorInfo = infos.get(0);
        }
        Builder builder = anchorInfo.copy(false);
        String compositeDescription = HighlightInfo.createCompositeDescription(infos);
        String compositeTooltip = HighlightInfo.createCompositeTooltip(infos);
        if (compositeDescription != null) {
            builder.description(compositeDescription);
        }
        if (compositeTooltip != null) {
            builder.escapedToolTip(compositeTooltip);
        }
        HighlightInfo newInfo = builder.createUnconditionally();
        OffsetStore oldStore = newInfo.offsetStore;
        List newDescriptors = ContainerUtil.concat((List)ContainerUtil.map(infos, i -> i.offsetStore.intentionActionDescriptors()));
        OffsetStore newStore = oldStore.withIntentionDescriptorsAndFixMarker(newDescriptors, oldStore.fixMarker());
        if (anchorInfo.getHighlighter() != null) {
            newStore = newStore.withHighlighter(anchorInfo.getHighlighter());
        }
        newInfo.offsetStore = newStore;
        HighlightInfo highlightInfo = newInfo;
        // MONITOREXIT : highlightInfoUpdater
        if (highlightInfo != null) return highlightInfo;
        HighlightInfo.$$$reportNull$$$0(72);
        return highlightInfo;
    }

    @Nullable
    @NlsSafe
    private static String createCompositeDescription(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfo.$$$reportNull$$$0(73);
        }
        StringBuilder description = new StringBuilder();
        boolean isNull = true;
        for (HighlightInfo highlightInfo : infos) {
            String itemDescription = highlightInfo.getDescription();
            if (itemDescription == null) continue;
            itemDescription = itemDescription.trim();
            description.append(itemDescription);
            if (!itemDescription.endsWith(".")) {
                description.append('.');
            }
            description.append(' ');
            isNull = false;
        }
        return isNull ? null : description.toString();
    }

    @Nullable
    @NlsSafe
    private static String createCompositeTooltip(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            HighlightInfo.$$$reportNull$$$0(74);
        }
        StringBuilder result = new StringBuilder();
        for (HighlightInfo highlightInfo : infos) {
            String toolTip = highlightInfo.getToolTip();
            if (toolTip == null) continue;
            if (!result.isEmpty()) {
                result.append("<hr size=1 noshade>");
            }
            toolTip = XmlStringUtil.stripHtml((String)toolTip);
            result.append(toolTip);
        }
        if (result.isEmpty()) {
            return null;
        }
        return XmlStringUtil.wrapInHtml((CharSequence)result);
    }

    @NotNull
    private OffsetStore updateOffsetStore(@NotNull @NotNull Function<? super @NotNull OffsetStore, @NotNull OffsetStore> computation) {
        OffsetStore newStore;
        OffsetStore oldStore;
        if (computation == null) {
            HighlightInfo.$$$reportNull$$$0(75);
        }
        do {
            if ((oldStore = this.offsetStore) == (newStore = computation.apply(oldStore)) || oldStore.fixMarker() == newStore.fixMarker() && oldStore.highlighter() == newStore.highlighter() && oldStore.intentionActionDescriptors() == newStore.intentionActionDescriptors() && oldStore.lazyQuickFixes() == newStore.lazyQuickFixes()) {
                OffsetStore offsetStore = oldStore;
                if (offsetStore == null) {
                    HighlightInfo.$$$reportNull$$$0(76);
                }
                return offsetStore;
            }
            assert (oldStore != TOMB && (oldStore.highlighter() == null || oldStore.highlighter() == newStore.highlighter())) : "Trying overwrite '" + String.valueOf(oldStore) + "' with '" + String.valueOf(newStore) + "'";
        } while (!OFFSET_STORE_HANDLE.compareAndSet(this, oldStore, newStore));
        OffsetStore offsetStore = newStore;
        if (offsetStore == null) {
            HighlightInfo.$$$reportNull$$$0(77);
        }
        return offsetStore;
    }

    final void computeQuickFixesSynchronously(@NotNull PsiFile psiFile, @NotNull Document document) throws ExecutionException, InterruptedException {
        if (psiFile == null) {
            HighlightInfo.$$$reportNull$$$0(78);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(79);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        IdentityHashMap<K, @NotNull V> computerToResult = new IdentityHashMap();
        this.updateOffsetStore(oldStore -> {
            List newLazies = ContainerUtil.map(oldStore.lazyQuickFixes(), desc -> {
                Future<List<IntentionActionDescriptor>> future = desc.future();
                if (future != null && future.isDone()) {
                    return desc;
                }
                Consumer<? super QuickFixActionRegistrar> computer = desc.fixesComputer();
                List result = computerToResult.computeIfAbsent(computer, __ -> this.doComputeLazyQuickFixes(document, psiFile.getProject(), desc.psiModificationStamp(), computer));
                assert (result != null);
                future = CompletableFuture.completedFuture(result);
                return new LazyFixDescription(desc.fixesComputer(), desc.psiModificationStamp(), future);
            });
            return oldStore.withLazyQuickFixes(newLazies);
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private List<IntentionActionDescriptor> doComputeLazyQuickFixes(final @NotNull Document document, @NotNull Project project, long oldPsiModificationStamp, @NotNull Consumer<? super QuickFixActionRegistrar> consumer) {
        void computation;
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(80);
        }
        if (project == null) {
            HighlightInfo.$$$reportNull$$$0(81);
        }
        if (consumer == null) {
            HighlightInfo.$$$reportNull$$$0(82);
        }
        if (project.isDisposed() || PsiDocumentManager.getInstance((Project)project).isUncommited(document) || PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount() != oldPsiModificationStamp) {
            List<IntentionActionDescriptor> list = List.of();
            if (list == null) {
                HighlightInfo.$$$reportNull$$$0(83);
            }
            return list;
        }
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(HighlightInfo.getIntentionActionDescriptors(this.offsetStore));
        final List<IntentionActionDescriptor> lazyDescriptors = Collections.synchronizedList(new ArrayList());
        final Long2ObjectMap<RangeMarker> cache = HighlightInfo.getRangeMarkerCache(this.offsetStore);
        QuickFixActionRegistrar registrarDelegate = new QuickFixActionRegistrar(){

            public void register(@NotNull IntentionAction action) {
                if (action == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.doRegister(HighlightInfo.this.getFixTextRange(), action, null);
            }

            public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action, @Nullable HighlightDisplayKey key) {
                if (fixRange == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (action == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.doRegister((Segment)fixRange, action, key);
            }

            private void doRegister(@NotNull Segment fixRange, @NotNull IntentionAction action, @Nullable HighlightDisplayKey key) {
                if (fixRange == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (action == null) {
                    1.$$$reportNull$$$0(4);
                }
                IntentionActionDescriptor descriptor = new IntentionActionDescriptor(action, null, null, null, key, HighlightInfo.this.myProblemGroup, HighlightInfo.this.severity, fixRange);
                IntentionActionDescriptor newDescriptor = descriptor.withRangeMarkerFixRange(document, (Long2ObjectMap<RangeMarker>)cache, HighlightInfo.this.fixRange);
                lazyDescriptors.add(newDescriptor);
                HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(List.of(newDescriptor));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fixRange";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "register";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "doRegister";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        computation.accept(registrarDelegate);
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(HighlightInfo.getIntentionActionDescriptors(this.offsetStore));
        List<IntentionActionDescriptor> list = lazyDescriptors;
        if (list == null) {
            HighlightInfo.$$$reportNull$$$0(84);
        }
        return list;
    }

    private static void assertIntentionActionDescriptorsAreRangeMarkerBased(@NotNull List<IntentionActionDescriptor> descriptors) {
        if (descriptors == null) {
            HighlightInfo.$$$reportNull$$$0(85);
        }
        for (IntentionActionDescriptor descriptor : descriptors) {
            assert (descriptor.myFixRange == null || descriptor.myFixRange instanceof RangeMarker) : String.valueOf(descriptor) + "; descriptors:" + String.valueOf(descriptors);
        }
    }

    final void startComputeQuickFixes(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(86);
        }
        if (project == null) {
            HighlightInfo.$$$reportNull$$$0(87);
        }
        HighlightInfo.assertIntentionActionDescriptorsAreRangeMarkerBased(HighlightInfo.getIntentionActionDescriptors(this.offsetStore));
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        AtomicReference<DaemonProgressIndicator> progressIndicator = new AtomicReference<DaemonProgressIndicator>(new DaemonProgressIndicator());
        this.updateOffsetStore(oldStore -> {
            ((ProgressIndicator)progressIndicator.get()).cancel();
            progressIndicator.set(new DaemonProgressIndicator());
            if (oldStore == TOMB) {
                return oldStore;
            }
            List newLazyFixes = ContainerUtil.map(oldStore.lazyQuickFixes(), description -> {
                CancellablePromise future = description.future();
                if (future == null) {
                    Consumer<? super QuickFixActionRegistrar> computer = description.fixesComputer();
                    future = ReadAction.nonBlocking(() -> this.doComputeLazyQuickFixes(document, project, description.psiModificationStamp(), computer)).wrapProgress((ProgressIndicator)progressIndicator.get()).submit((Executor)ForkJoinPool.commonPool());
                    return new LazyFixDescription(computer, PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount(), (Future<List<IntentionActionDescriptor>>)future);
                }
                return description;
            });
            return oldStore.withLazyQuickFixes(newLazyFixes);
        });
    }

    final void copyComputedLazyFixesTo(@NotNull HighlightInfo newInfo, @NotNull Document document) {
        if (newInfo == null) {
            HighlightInfo.$$$reportNull$$$0(88);
        }
        if (document == null) {
            HighlightInfo.$$$reportNull$$$0(89);
        }
        newInfo.updateOffsetStore(store -> {
            List<LazyFixDescription> oldFixes = this.offsetStore.lazyQuickFixes();
            List<LazyFixDescription> newFixes = store.lazyQuickFixes();
            if (newFixes.size() == oldFixes.size() && HighlightInfo.psiModificationStampIsTheSame(newFixes, oldFixes)) {
                OffsetStore newO = store.withLazyQuickFixes(oldFixes);
                return this.updateFields(newO, document);
            }
            return store;
        });
    }

    private static boolean psiModificationStampIsTheSame(@NotNull @Unmodifiable List<LazyFixDescription> list1, @NotNull @Unmodifiable List<LazyFixDescription> list2) {
        if (list1 == null) {
            HighlightInfo.$$$reportNull$$$0(90);
        }
        if (list2 == null) {
            HighlightInfo.$$$reportNull$$$0(91);
        }
        for (int i = 0; i < list1.size(); ++i) {
            LazyFixDescription fix1 = list1.get(i);
            LazyFixDescription fix2 = list2.get(i);
            if (fix1.psiModificationStamp() == fix2.psiModificationStamp()) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    @NotNull
    public final Builder copy(final boolean copyFlagsAndFixes) {
        GutterMark gutterMark;
        HighlightInfoB builder = new HighlightInfoB(this.type, true){

            @Override
            @NotNull
            public HighlightInfo createUnconditionally() {
                HighlightInfo newInfo = super.createUnconditionally();
                newInfo.updateOffsetStore(oldStore -> {
                    OffsetStore myStore = HighlightInfo.this.offsetStore;
                    return (copyFlagsAndFixes ? oldStore.withIntentionDescriptorsAndFixMarker(myStore.intentionActionDescriptors(), myStore.fixMarker()) : oldStore).withLazyQuickFixes(myStore.lazyQuickFixes());
                });
                if (copyFlagsAndFixes) {
                    newInfo.myFlags = HighlightInfo.this.myFlags;
                }
                newInfo.toolId = HighlightInfo.this.toolId;
                HighlightInfo highlightInfo = newInfo;
                if (highlightInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                return highlightInfo;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/HighlightInfo$2", "createUnconditionally"));
            }
        };
        builder.range(this.startOffset, this.endOffset);
        if (this.forcedTextAttributes != null) {
            builder.textAttributes(this.forcedTextAttributes);
        }
        if (this.forcedTextAttributesKey != null) {
            builder.textAttributes(this.forcedTextAttributesKey);
        }
        if (this.description != null) {
            builder.description(this.description);
        }
        if (this.toolTip != null) {
            builder.escapedToolTip(this.toolTip);
        }
        if (this.isFileLevelAnnotation()) {
            builder.fileLevelAnnotation();
        }
        if (copyFlagsAndFixes && this.isAfterEndOfLine()) {
            builder.endOfLine();
        }
        builder.severity(this.severity);
        if (this.navigationShift != 0) {
            builder.navigationShift(this.navigationShift);
        }
        if (this.getProblemGroup() != null) {
            builder.problemGroup(this.getProblemGroup());
        }
        if ((gutterMark = this.gutterIconRenderer) instanceof GutterIconRenderer) {
            GutterIconRenderer g = (GutterIconRenderer)gutterMark;
            builder.gutterIconRenderer(g);
        }
        if (this.group != 0) {
            builder.group(this.group);
        }
        HighlightInfoB highlightInfoB = builder;
        if (highlightInfoB == null) {
            HighlightInfo.$$$reportNull$$$0(92);
        }
        return highlightInfoB;
    }

    void invalidate() {
        this.offsetStore = TOMB;
    }

    @TestOnly
    @NotNull
    public HighlightInfoType getType() {
        HighlightInfoType highlightInfoType = this.type;
        if (highlightInfoType == null) {
            HighlightInfo.$$$reportNull$$$0(93);
        }
        return highlightInfoType;
    }

    static {
        try {
            OFFSET_STORE_HANDLE = MethodHandles.privateLookupIn(HighlightInfo.class, MethodHandles.lookup()).findVarHandle(HighlightInfo.class, "offsetStore", OffsetStore.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        INITIAL_STORE = new OffsetStore(null, null, List.of(), List.of());
        TOMB = new OffsetStore(null, null, List.of(), List.of());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8, 9, 15, 20, 33, 36, 37, 38, 39, 40, 42, 44, 45, 46, 47, 49, 50, 54, 56, 61, 67, 72, 76, 77, 83, 84, 92, 93 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 35: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lazyFixes";
                break;
            }
            case 3: 
            case 10: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "store";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 20: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 61: 
            case 67: 
            case 72: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 92: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsScheme";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 25: 
            case 29: 
            case 32: 
            case 59: 
            case 62: 
            case 65: 
            case 68: 
            case 79: 
            case 80: 
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalAnnotator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotatorClass";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoType";
                break;
            }
            case 51: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldStore";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 60: 
            case 63: 
            case 66: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range2markerCache";
                break;
            }
            case 64: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 70: 
            case 73: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 71: 
            case 81: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 75: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntentionActionDescriptors";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixTextRange";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "toHighlightInfoType";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverity";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "convertType";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "convertSeverityToProblemHighlight";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "updateFields";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeMarkerCache";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "toRangeMarkerFixRanges";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createComposite";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "updateOffsetStore";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeLazyQuickFixes";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIntentionActionDescriptors";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 20: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 61: 
            case 67: 
            case 72: 
            case 76: 
            case 77: 
            case 83: 
            case 84: 
            case 92: 
            case 93: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findRegisteredQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromRangeHighlighter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFixTextRangeScalar";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFileLevelComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeFileLeverComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileLevelComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setHighlighter";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStripeMarkColor";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "equalsByActualOffset";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "attributesEqual";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "newHighlightInfo";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 34: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "convertType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "toHighlightInfoType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverity";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "convertSeverityToProblemHighlight";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "registerFix";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "updateFields";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRangeMarkerCache";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unregisterQuickFix";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getSameFamilyFix";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "updateQuickFixFields";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "toRangeMarkerFixRanges";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "updateFixMarker";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeDescription";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeTooltip";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "updateOffsetStore";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "computeQuickFixesSynchronously";
                break;
            }
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "doComputeLazyQuickFixes";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "assertIntentionActionDescriptorsAreRangeMarkerBased";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "startComputeQuickFixes";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "copyComputedLazyFixesTo";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "psiModificationStampIsTheSame";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8, 9, 15, 20, 33, 36, 37, 38, 39, 40, 42, 44, 45, 46, 47, 49, 50, 54, 56, 61, 67, 72, 76, 77, 83, 84, 92, 93 -> new IllegalStateException(string);
        };
    }

    private record OffsetStore(@Nullable RangeHighlighterEx highlighter, @Nullable(value="null means its fix range is the same as the range of #highlighter") @Nullable(value="null means its fix range is the same as the range of #highlighter") RangeMarker fixMarker, @NotNull @Unmodifiable List<IntentionActionDescriptor> intentionActionDescriptors, @NotNull @Unmodifiable List<LazyFixDescription> lazyQuickFixes) {
        @NotNull
        private final @Unmodifiable List<IntentionActionDescriptor> intentionActionDescriptors;
        @NotNull
        private final @Unmodifiable List<LazyFixDescription> lazyQuickFixes;

        private OffsetStore(@Nullable RangeHighlighterEx highlighter, @Nullable(value="null means its fix range is the same as the range of #highlighter") @Nullable(value="null means its fix range is the same as the range of #highlighter") RangeMarker fixMarker, @NotNull @Unmodifiable List<IntentionActionDescriptor> intentionActionDescriptors, @NotNull @Unmodifiable List<LazyFixDescription> lazyQuickFixes) {
            if (intentionActionDescriptors == null) {
                OffsetStore.$$$reportNull$$$0(0);
            }
            if (lazyQuickFixes == null) {
                OffsetStore.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        OffsetStore withLazyQuickFixes(@NotNull @Unmodifiable List<LazyFixDescription> newLazyQuickFixes) {
            if (newLazyQuickFixes == null) {
                OffsetStore.$$$reportNull$$$0(2);
            }
            return newLazyQuickFixes.equals(this.lazyQuickFixes()) ? this : new OffsetStore(this.highlighter(), this.fixMarker(), this.intentionActionDescriptors(), newLazyQuickFixes);
        }

        @NotNull
        OffsetStore withIntentionDescriptorsAndFixMarker(@NotNull @Unmodifiable List<IntentionActionDescriptor> newIntentionDescriptors, @Nullable RangeMarker fixMarker) {
            if (newIntentionDescriptors == null) {
                OffsetStore.$$$reportNull$$$0(3);
            }
            return new OffsetStore(this.highlighter(), fixMarker, newIntentionDescriptors, this.lazyQuickFixes());
        }

        @NotNull
        OffsetStore withHighlighter(@NotNull RangeHighlighterEx highlighter) {
            if (highlighter == null) {
                OffsetStore.$$$reportNull$$$0(4);
            }
            return highlighter.equals((Object)this.highlighter()) ? this : new OffsetStore(highlighter, this.fixMarker(), this.intentionActionDescriptors(), this.lazyQuickFixes());
        }

        @Override
        @NotNull
        public String toString() {
            Object object = this == TOMB ? "TOMB" : (this == INITIAL_STORE ? "INITIAL" : "highlighter: " + String.valueOf(this.highlighter) + (String)(this.fixMarker == null ? "" : "; fixMarker:" + String.valueOf(this.fixMarker.getTextRange())) + (String)(this.intentionActionDescriptors.isEmpty() ? "" : "; intentionActionDescriptors:" + String.valueOf(this.intentionActionDescriptors)) + (String)(this.lazyQuickFixes.isEmpty() ? "" : "; lazyQuickFixes:" + String.valueOf(this.lazyQuickFixes)));
            if (object == null) {
                OffsetStore.$$$reportNull$$$0(5);
            }
            return object;
        }

        @NotNull
        public @Unmodifiable List<IntentionActionDescriptor> intentionActionDescriptors() {
            List<IntentionActionDescriptor> list = this.intentionActionDescriptors;
            if (list == null) {
                OffsetStore.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        public @Unmodifiable List<LazyFixDescription> lazyQuickFixes() {
            List<LazyFixDescription> list = this.lazyQuickFixes;
            if (list == null) {
                OffsetStore.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "intentionActionDescriptors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lazyQuickFixes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLazyQuickFixes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newIntentionDescriptors";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlighter";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$OffsetStore";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$OffsetStore";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intentionActionDescriptors";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "lazyQuickFixes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withLazyQuickFixes";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withIntentionDescriptorsAndFixMarker";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withHighlighter";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile @Unmodifiable List<? extends IntentionAction> myOptions;
        @Nullable
        private final HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        @Nls
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;
        private final Segment myFixRange;

        @Deprecated
        public IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable @Unmodifiable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            if (action == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(0);
            }
            this(action, options, displayName, icon, key, problemGroup, severity, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action, @Nullable @Unmodifiable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable Icon icon, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity, @Nullable Segment fixRange) {
            if (action == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(1);
            }
            this.myAction = action;
            this.myOptions = options;
            this.myDisplayName = displayName;
            this.myIcon = icon;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
            this.myFixRange = fixRange;
        }

        @Nullable
        @ApiStatus.Internal
        public IntentionActionDescriptor withEmptyAction() {
            if (this.myKey == null || this.myKey.getID().equals(HighlightInfo.ANNOTATOR_INSPECTION_SHORT_NAME)) {
                return null;
            }
            String displayName = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)this.myKey);
            if (displayName == null) {
                return null;
            }
            return new IntentionActionDescriptor((IntentionAction)new EmptyIntentionAction(displayName), this.myOptions, this.myDisplayName, this.myIcon, this.myKey, this.myProblemGroup, this.mySeverity, this.myFixRange);
        }

        @NotNull
        IntentionActionDescriptor withProblemGroupAndSeverity(@Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            return new IntentionActionDescriptor(this.myAction, this.myOptions, this.myDisplayName, this.myIcon, this.myKey, problemGroup, severity, this.myFixRange);
        }

        @NotNull
        @ApiStatus.Internal
        IntentionActionDescriptor withFixRange(@NotNull Segment fixRange) {
            if (fixRange == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(2);
            }
            return new IntentionActionDescriptor(this.myAction, this.myOptions, this.myDisplayName, this.myIcon, this.myKey, this.myProblemGroup, this.mySeverity, fixRange);
        }

        @NotNull
        @ApiStatus.Internal
        IntentionActionDescriptor withRangeMarkerFixRange(@NotNull Document document, @NotNull Long2ObjectMap<RangeMarker> range2markerCache, long fallBackFixTextRange) {
            IntentionActionDescriptor intentionActionDescriptor;
            if (document == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(3);
            }
            if (range2markerCache == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(4);
            }
            if (this.myFixRange instanceof RangeMarker) {
                intentionActionDescriptor = this;
            } else {
                long l;
                Segment segment = this.myFixRange;
                if (segment instanceof TextRange) {
                    TextRange tr = (TextRange)segment;
                    l = TextRangeScalarUtil.toScalarRange((Segment)tr);
                } else {
                    l = fallBackFixTextRange;
                }
                intentionActionDescriptor = this.withFixRange((Segment)HighlightInfo.getOrCreate(document, range2markerCache, l));
            }
            if (intentionActionDescriptor == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(5);
            }
            return intentionActionDescriptor;
        }

        @NotNull
        public IntentionAction getAction() {
            IntentionAction intentionAction = this.myAction;
            if (intentionAction == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(6);
            }
            return intentionAction;
        }

        @ApiStatus.Internal
        public boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        @ApiStatus.Internal
        public boolean isInformation() {
            return HighlightSeverity.INFORMATION.equals((Object)this.mySeverity);
        }

        @ApiStatus.Internal
        public boolean canCleanup(@NotNull PsiElement element) {
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(7);
            }
            if (this.myCanCleanup == null) {
                InspectionToolWrapper toolWrapper;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
                this.myCanCleanup = this.myKey == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile.getInspectionTool(this.myKey.getShortName(), element)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        @NotNull
        public @NotNull Iterable<? extends @NotNull IntentionAction> getOptions(@NotNull PsiElement element, @Nullable Editor editor) {
            ProblemGroup wrappedTool;
            IntentionAction action;
            if (element == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(8);
            }
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                List list = Collections.emptyList();
                if (list == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(9);
                }
                return list;
            }
            List options = this.myOptions;
            if (options != null) {
                List list = options;
                if (list == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(10);
                }
                return list;
            }
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById((String)problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if ((action = IntentionActionDelegate.unwrap((IntentionAction)this.myAction)) instanceof IntentionActionWithOptions) {
                IntentionActionWithOptions wo = (IntentionActionWithOptions)action;
                if (!(key != null && wo.getCombiningPolicy() != IntentionActionWithOptions.CombiningPolicy.IntentionOptionsOnly || (options = wo.getOptions()).isEmpty())) {
                    return this.updateOptions(options);
                }
            }
            if (key == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    IntentionActionDescriptor.$$$reportNull$$$0(11);
                }
                return list;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            ArrayList<DisableHighlightingIntentionAction> newOptions = new ArrayList<DisableHighlightingIntentionAction>(intentionManager.getStandardIntentionOptions(key, element));
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
            InspectionToolWrapper toolWrapper = profile.getInspectionTool(key.getShortName(), element);
            if (toolWrapper != null) {
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                    v4 = local.getTool();
                } else {
                    v4 = wrappedTool = ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                }
                if (HighlightInfo.ANNOTATOR_INSPECTION_SHORT_NAME.equals(wrappedTool.getShortName())) {
                    List<Object> actions = Collections.emptyList();
                    ProblemGroup problemGroup = this.myProblemGroup;
                    if (problemGroup instanceof SuppressableProblemGroup) {
                        SuppressableProblemGroup suppressible = (SuppressableProblemGroup)problemGroup;
                        actions = Arrays.asList(suppressible.getSuppressActions(element));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            List<IntentionAction> list = Collections.singletonList(fixAllIntention);
                            if (list == null) {
                                IntentionActionDescriptor.$$$reportNull$$$0(12);
                            }
                            return list;
                        }
                        actions = new ArrayList(actions);
                        actions.add(fixAllIntention);
                    }
                    List list = actions;
                    if (list == null) {
                        IntentionActionDescriptor.$$$reportNull$$$0(13);
                    }
                    return list;
                }
                if (!(action instanceof EmptyIntentionAction)) {
                    newOptions.add(new DisableHighlightingIntentionAction(toolWrapper.getShortName()));
                }
                ContainerUtil.addIfNotNull(newOptions, (Object)fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    CustomSuppressableInspectionTool custom = (CustomSuppressableInspectionTool)wrappedTool;
                    Object[] suppressActions = custom.getSuppressActions(element);
                    if (suppressActions != null) {
                        ContainerUtil.addAll(newOptions, (Object[])suppressActions);
                    }
                } else {
                    Object[] suppressFixes = wrappedTool.getBatchSuppressActions(element);
                    if (suppressFixes.length > 0) {
                        newOptions.addAll(ContainerUtil.map((Object[])suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if ((wrappedTool = this.myProblemGroup) instanceof SuppressableProblemGroup) {
                SuppressableProblemGroup suppressible = (SuppressableProblemGroup)wrappedTool;
                Object[] suppressActions = suppressible.getSuppressActions(element);
                ContainerUtil.addAll(newOptions, (Object[])suppressActions);
            }
            return this.updateOptions(newOptions);
        }

        @NotNull
        private synchronized List<? extends IntentionAction> updateOptions(@NotNull List<? extends IntentionAction> newOptions) {
            List<? extends IntentionAction> options;
            if (newOptions == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(14);
            }
            if ((options = this.myOptions) == null) {
                this.myOptions = options = newOptions;
            }
            List<? extends IntentionAction> list = options;
            if (list == null) {
                IntentionActionDescriptor.$$$reportNull$$$0(15);
            }
            return list;
        }

        @Nullable
        @Nls
        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            String name = this.getAction().getFamilyName();
            return "IntentionActionDescriptor: '" + name + "' (" + String.valueOf(ReportingClassSubstitutor.getClassToReport((Object)this.getAction())) + ")" + (String)(this.myFixRange == null || this.myFixRange.getStartOffset() == this.myFixRange.getEndOffset() ? "" : "; fixRange: (" + this.myFixRange.getStartOffset() + ", " + this.myFixRange.getEndOffset() + ": " + String.valueOf(this.myFixRange.getClass()) + ")");
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof IntentionActionDescriptor)) return false;
            IntentionActionDescriptor descriptor = (IntentionActionDescriptor)obj;
            if (!this.myAction.equals((Object)descriptor.myAction)) return false;
            return true;
        }

        @Nullable
        public String getToolId() {
            return this.myKey != null ? this.myKey.getID() : null;
        }

        @ApiStatus.Internal
        public TextRange getFixRange() {
            TextRange textRange;
            Segment range = this.myFixRange;
            if (range instanceof TextRange) {
                TextRange tr;
                textRange = tr = (TextRange)range;
            } else if (range instanceof RangeMarker) {
                RangeMarker marker = (RangeMarker)range;
                textRange = marker.getTextRange();
            } else {
                textRange = null;
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 9, 10, 11, 12, 13, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixRange";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range2markerCache";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$IntentionActionDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRangeMarkerFixRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAction";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "withFixRange";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "withRangeMarkerFixRange";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "canCleanup";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getOptions";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "updateOptions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 9, 10, 11, 12, 13, 15 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, @NotNull TextRange var2);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @Deprecated(forRemoval=true)
        @NotNull
        public Builder inspectionToolId(@NotNull String var1);

        @NotNull
        public Builder description(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @Deprecated(forRemoval=true)
        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @NotNull
        public Builder group(int var1);

        @NotNull
        public Builder registerFix(@NotNull IntentionAction var1, @Nullable List<? extends IntentionAction> var2, @Nullable @Nls String var3, @Nullable TextRange var4, @Nullable HighlightDisplayKey var5);

        @NotNull
        @ApiStatus.Experimental
        public Builder registerLazyFixes(@NotNull Consumer<? super QuickFixActionRegistrar> var1);

        @ApiStatus.Experimental
        @NotNull
        default public Builder registerFix(@NotNull ModCommandAction action, @Nullable List<? extends IntentionAction> options, @Nullable @Nls String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
            if (action == null) {
                Builder.$$$reportNull$$$0(0);
            }
            Builder builder = this.registerFix(action.asIntention(), options, displayName, fixRange, key);
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @Nullable(value="null means filtered out")
        public @Nullable(value="null means filtered out") HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerFix";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record LazyFixDescription(@NotNull Consumer<? super QuickFixActionRegistrar> fixesComputer, long psiModificationStamp, @Nullable Future<@NotNull List<IntentionActionDescriptor>> future) {
        @NotNull
        private final Consumer<? super QuickFixActionRegistrar> fixesComputer;

        /*
         * WARNING - void declaration
         */
        private LazyFixDescription(@NotNull Consumer<? super QuickFixActionRegistrar> fixesComputer, long psiModificationStamp, @Nullable Future<@NotNull List<IntentionActionDescriptor>> future) {
            void future2;
            if (fixesComputer == null) {
                LazyFixDescription.$$$reportNull$$$0(0);
            }
            this.fixesComputer = fixesComputer;
            this.psiModificationStamp = psiModificationStamp;
            this.future = future2;
        }

        @NotNull
        public Consumer<? super QuickFixActionRegistrar> fixesComputer() {
            Consumer<? super QuickFixActionRegistrar> consumer = this.fixesComputer;
            if (consumer == null) {
                LazyFixDescription.$$$reportNull$$$0(1);
            }
            return consumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixesComputer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$LazyFixDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HighlightInfo$LazyFixDescription";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixesComputer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static @interface FlagConstant {
    }
}

