/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeInsightFrontbackUtil {
    @Nullable
    public static PsiExpression findExpressionInRange(PsiFile file, int startOffset, int endOffset) {
        int newEndOffset;
        PsiElement element;
        PsiJavaToken token;
        IElementType tokenType;
        PsiElement element2;
        if (!file.getViewProvider().getLanguages().contains(JavaLanguage.INSTANCE)) {
            return null;
        }
        PsiExpression expression = CodeInsightFrontbackUtil.findElementInRange(file, startOffset, endOffset, PsiExpression.class);
        if (expression == null && CodeInsightFrontbackUtil.findStatementsInRange(file, startOffset, endOffset).length == 0 && (element2 = file.getViewProvider().findElementAt(endOffset - 1, (Language)JavaLanguage.INSTANCE)) instanceof PsiJavaToken && ((tokenType = (token = (PsiJavaToken)element2).getTokenType()).equals(JavaTokenType.SEMICOLON) || element2.getParent() instanceof PsiErrorElement)) {
            expression = CodeInsightFrontbackUtil.findElementInRange(file, startOffset, element2.getTextRange().getStartOffset(), PsiExpression.class);
        }
        if (expression == null && CodeInsightFrontbackUtil.findStatementsInRange(file, startOffset, endOffset).length == 0 && (element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)file.findElementAt(endOffset))) != null && (element = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element.getLastChild())) != null && (newEndOffset = element.getTextRange().getEndOffset()) < endOffset) {
            expression = CodeInsightFrontbackUtil.findExpressionInRange(file, startOffset, newEndOffset);
        }
        if (expression instanceof PsiReferenceExpression && expression.getParent() instanceof PsiMethodCallExpression) {
            return null;
        }
        return expression;
    }

    public static <T extends PsiElement> T findElementInRange(PsiFile file, int startOffset, int endOffset, Class<T> klass) {
        return (T)CodeInsightUtilCore.findElementInRange((PsiFile)file, (int)startOffset, (int)endOffset, klass, (Language)JavaLanguage.INSTANCE);
    }

    public static PsiElement @NotNull [] findStatementsInRange(@NotNull PsiFile file, int startOffset, int endOffset) {
        Language language2;
        if (file == null) {
            CodeInsightFrontbackUtil.$$$reportNull$$$0(0);
        }
        if ((language2 = CodeInsightFrontbackUtil.findJavaOrLikeLanguage(file)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightFrontbackUtil.$$$reportNull$$$0(1);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        FileViewProvider viewProvider = file.getViewProvider();
        PsiElement element1 = viewProvider.findElementAt(startOffset, language2);
        PsiElement element2 = viewProvider.findElementAt(endOffset - 1, language2);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightFrontbackUtil.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightFrontbackUtil.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (true) {
            if (parent instanceof PsiStatement) {
                if (element1 instanceof PsiComment) break;
                parent = parent.getParent();
                break;
            }
            if (parent instanceof PsiCodeBlock || FileTypeUtils.isInServerPageFile(parent) && parent instanceof PsiFile || parent instanceof PsiCodeFragment) break;
            if (parent == null || parent instanceof PsiFile) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CodeInsightFrontbackUtil.$$$reportNull$$$0(4);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            parent = parent.getParent();
        }
        if (!parent.equals((Object)element1)) {
            while (!parent.equals((Object)element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightFrontbackUtil.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals((Object)element2)) {
            while (!parent.equals((Object)element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset() && !CodeInsightFrontbackUtil.isAtTrailingComment(element1, element2, endOffset)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightFrontbackUtil.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent instanceof PsiCodeBlock && element1 == ((PsiCodeBlock)parent).getLBrace() && element2 == ((PsiCodeBlock)parent).getRBrace()) {
            if (parent.getParent() instanceof PsiBlockStatement) {
                PsiElement[] psiElementArray = new PsiElement[]{parent.getParent()};
                if (psiElementArray == null) {
                    CodeInsightFrontbackUtil.$$$reportNull$$$0(7);
                }
                return psiElementArray;
            }
            PsiElement[] children = parent.getChildren();
            return CodeInsightFrontbackUtil.getStatementsInRange(children, ((PsiCodeBlock)parent).getFirstBodyElement(), ((PsiCodeBlock)parent).getLastBodyElement());
        }
        PsiElement[] children = parent.getChildren();
        return CodeInsightFrontbackUtil.getStatementsInRange(children, element1, element2);
    }

    private static boolean isAtTrailingComment(PsiElement element1, PsiElement element2, int offset) {
        if (element1 == element2 && element1 instanceof PsiExpressionStatement) {
            for (PsiElement child = element1.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (!PsiUtil.isJavaToken(child, JavaTokenType.SEMICOLON) || child.getTextRange().getEndOffset() != offset) continue;
                return false;
            }
        }
        PsiElement trailing = element2;
        while (trailing.getTextRange().contains(offset) && trailing.getLastChild() != null) {
            trailing = trailing.getLastChild();
        }
        while (trailing instanceof PsiComment || trailing instanceof PsiWhiteSpace) {
            PsiElement previous = trailing.getPrevSibling();
            if (trailing.getTextRange().contains(offset)) {
                return true;
            }
            trailing = previous;
        }
        return false;
    }

    @Nullable
    private static Language findJavaOrLikeLanguage(@NotNull PsiFile file) {
        Set languages;
        if (file == null) {
            CodeInsightFrontbackUtil.$$$reportNull$$$0(8);
        }
        if ((languages = file.getViewProvider().getLanguages()).contains(JavaLanguage.INSTANCE)) {
            return JavaLanguage.INSTANCE;
        }
        for (Language language2 : languages) {
            if (!language2.isKindOf((Language)JavaLanguage.INSTANCE)) continue;
            return language2;
        }
        return null;
    }

    private static PsiElement @NotNull [] getStatementsInRange(PsiElement[] children, PsiElement element1, PsiElement element2) {
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child.equals((Object)element1)) {
                flag = true;
            }
            if (flag && !(child instanceof PsiWhiteSpace)) {
                array.add(child);
            }
            if (child.equals((Object)element2)) break;
        }
        for (PsiElement element : array) {
            if (element instanceof PsiStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CodeInsightFrontbackUtil.$$$reportNull$$$0(9);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            CodeInsightFrontbackUtil.$$$reportNull$$$0(10);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightFrontbackUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightFrontbackUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatementsInRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findStatementsInRange";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findJavaOrLikeLanguage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10 -> new IllegalStateException(string);
        };
    }
}

