/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionUtil {
    public static boolean isEffectivelyUnqualified(PsiReferenceExpression refExpression) {
        PsiExpression qualifier = PsiUtil.deparenthesizeExpression(refExpression.getQualifierExpression());
        if (qualifier == null) {
            return true;
        }
        if (qualifier instanceof PsiQualifiedExpression) {
            PsiJavaCodeReferenceElement thisQualifier = ((PsiQualifiedExpression)qualifier).getQualifier();
            if (thisQualifier == null) {
                return true;
            }
            PsiClass innerMostClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiClass.class);
            return innerMostClass == thisQualifier.resolve();
        }
        return false;
    }

    public static boolean isEnhancedSwitch(@NotNull PsiSwitchBlock statement) {
        if (statement == null) {
            ExpressionUtil.$$$reportNull$$$0(0);
        }
        if (statement instanceof PsiSwitchExpression) {
            return true;
        }
        PsiExpression selector = statement.getExpression();
        if (selector == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return false;
        }
        if (ExpressionUtil.isEnhancedSelectorType(selectorType)) {
            return true;
        }
        PsiCodeBlock body2 = statement.getBody();
        if (body2 == null) {
            return false;
        }
        for (PsiStatement psiStatement : body2.getStatements()) {
            PsiCaseLabelElement[] elements;
            PsiSwitchLabelStatementBase labelStatementBase;
            PsiCaseLabelElementList elementList;
            if (!(psiStatement instanceof PsiSwitchLabelStatementBase) || (elementList = (labelStatementBase = (PsiSwitchLabelStatementBase)psiStatement).getCaseLabelElementList()) == null) continue;
            for (PsiCaseLabelElement caseLabelElement : elements = elementList.getElements()) {
                if (caseLabelElement == null || !(caseLabelElement instanceof PsiPattern) && !ExpressionUtil.isNullLiteral(caseLabelElement)) continue;
                return true;
            }
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isNullLiteral(@Nullable PsiElement element) {
        if (!(element instanceof PsiExpression)) {
            return false;
        }
        PsiExpression deparenthesized = PsiUtil.deparenthesizeExpression((PsiExpression)element);
        return deparenthesized instanceof PsiLiteralExpression && ((PsiLiteralExpression)deparenthesized).getValue() == null;
    }

    private static boolean isEnhancedSelectorType(@NotNull PsiType type) {
        PsiPrimitiveType unboxedType;
        if (type == null) {
            ExpressionUtil.$$$reportNull$$$0(1);
        }
        if ((unboxedType = PsiPrimitiveType.getOptionallyUnboxedType(type)) != null && (unboxedType.equals(PsiTypes.booleanType()) || unboxedType.equals(PsiTypes.floatType()) || unboxedType.equals(PsiTypes.doubleType()) || unboxedType.equals(PsiTypes.longType()))) {
            return true;
        }
        if (TypeConversionUtil.getTypeRank(type) <= 4) {
            return false;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull(type)) {
            return false;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                return false;
            }
            String fqn = psiClass.getQualifiedName();
            if (Comparing.strEqual((String)fqn, (String)"java.lang.String")) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/ExpressionUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnhancedSwitch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnhancedSelectorType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

