/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class IfConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        PsiElement prevLeaf;
        if (psiElement == null) {
            IfConditionFixer.$$$reportNull$$$0(0);
        }
        if (psiElement instanceof PsiIfStatement) {
            PsiIfStatement ifStatement = (PsiIfStatement)psiElement;
            Document doc = editor.getDocument();
            PsiJavaToken rParen = ifStatement.getRParenth();
            PsiJavaToken lParen = ifStatement.getLParenth();
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                if (lParen == null || rParen == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(ifStatement.getTextRange().getStartOffset()));
                    PsiStatement then = ifStatement.getThenBranch();
                    if (then != null) {
                        stopOffset = Math.min(stopOffset, then.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, ifStatement.getTextRange().getEndOffset());
                    PsiElement lastChild = ifStatement.getLastChild();
                    String innerComment = "";
                    String lastComment = "";
                    if (lParen != null && PsiUtilCore.getElementType((PsiElement)lastChild) == JavaTokenType.C_STYLE_COMMENT) {
                        innerComment = lastChild.getText();
                    } else if (lastChild instanceof PsiComment) {
                        lastComment = lastChild.getText();
                    }
                    String prefix = "if (" + innerComment;
                    doc.replaceString(ifStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)(prefix + ")" + lastComment));
                    processor.registerUnresolvedError(ifStatement.getTextRange().getStartOffset() + prefix.length());
                } else {
                    processor.registerUnresolvedError(lParen.getTextRange().getEndOffset());
                }
            } else if (rParen == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        } else if (psiElement instanceof PsiExpression && psiElement.getParent() instanceof PsiExpressionStatement && (prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)psiElement)) != null && prevLeaf.textMatches((CharSequence)"if")) {
            Document doc = editor.getDocument();
            doc.insertString(psiElement.getTextRange().getEndOffset(), (CharSequence)")");
            doc.insertString(psiElement.getTextRange().getStartOffset(), (CharSequence)"(");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/editorActions/smartEnter/IfConditionFixer", "apply"));
    }
}

