/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.java.debugger.impl.shared.actions.ViewTextActionBase;
import com.intellij.java.debugger.impl.shared.engine.JavaValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeSplitActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0015\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/actions/ViewTextAction;", "Lcom/intellij/java/debugger/impl/shared/actions/ViewTextActionBase;", "<init>", "()V", "getStringNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.java.debugger.impl.shared"})
public final class ViewTextAction
extends ViewTextActionBase {
    @Override
    @ApiStatus.Internal
    @Nullable
    protected XValueNodeImpl getStringNode(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)CollectionsKt.singleOrNull((List)XDebuggerTreeSplitActionBase.Companion.getSelectedNodes(dataContext));
        if (xValueNodeImpl == null) {
            return null;
        }
        XValueNodeImpl node = xValueNodeImpl;
        XValueContainer xValueContainer = node.getValueContainer();
        Intrinsics.checkNotNullExpressionValue((Object)xValueContainer, (String)"getValueContainer(...)");
        XValue xValue = (XValue)xValueContainer;
        CompletableFuture completableFuture = xValue.getXValueDescriptorAsync();
        XDescriptor xDescriptor = completableFuture != null ? (XDescriptor)completableFuture.getNow(null) : null;
        JavaValueDescriptor javaValueDescriptor = xDescriptor instanceof JavaValueDescriptor ? (JavaValueDescriptor)xDescriptor : null;
        if (javaValueDescriptor == null) {
            return null;
        }
        JavaValueDescriptor descriptor = javaValueDescriptor;
        if (xValue.getModifier() != null && descriptor.isString()) {
            return node;
        }
        return null;
    }
}

