/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.java.syntax.JavaSyntaxBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.util.lang.JavaVersion;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 D2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001DB$\b\u0012\u0012\u0011\u0010\u0002\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0012\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\b\u00105\u001a\u0004\u0018\u00010\u0000J\u0006\u00106\u001a\u00020\u0000J\u000e\u0010:\u001a\u0002022\u0006\u0010;\u001a\u00020\u0000J\u000e\u0010<\u001a\u0002022\u0006\u0010;\u001a\u00020\u0000J\u0006\u0010=\u001a\u000200J\u0006\u0010>\u001a\u00020\u0007J\b\u0010?\u001a\u0004\u0018\u00010\u0000J\b\u0010@\u001a\u0004\u0018\u00010\u0000R\u0019\u0010.\u001a\r\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00103R\u0011\u00104\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00103R\u0016\u00107\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0016\u0010A\u001a\u00070\u0004\u00a2\u0006\u0002\bB8F\u00a2\u0006\u0006\u001a\u0004\bC\u00109j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-\u00a8\u0006E"}, d2={"Lcom/intellij/pom/java/LanguageLevel;", "", "presentableTextSupplier", "Lkotlin/Function0;", "", "Lorg/jetbrains/annotations/Nls;", "major", "", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function0;I)V", "(Ljava/lang/String;II)V", "JDK_1_3", "JDK_1_4", "JDK_1_5", "JDK_1_6", "JDK_1_7", "JDK_1_8", "JDK_1_9", "JDK_10", "JDK_11", "JDK_12", "JDK_13", "JDK_14", "JDK_15", "JDK_16", "JDK_17", "JDK_17_PREVIEW", "JDK_18", "JDK_18_PREVIEW", "JDK_19", "JDK_19_PREVIEW", "JDK_20", "JDK_20_PREVIEW", "JDK_21", "JDK_21_PREVIEW", "JDK_22", "JDK_22_PREVIEW", "JDK_23", "JDK_23_PREVIEW", "JDK_24", "JDK_24_PREVIEW", "JDK_25", "JDK_25_PREVIEW", "JDK_26", "JDK_26_PREVIEW", "JDK_X", "myPresentableText", "myVersion", "Lcom/intellij/util/lang/JavaVersion;", "isPreview", "", "()Z", "isUnsupported", "getPreviewLevel", "getNonPreviewLevel", "presentableText", "getPresentableText", "()Ljava/lang/String;", "isAtLeast", "level", "isLessThan", "toJavaVersion", "feature", "next", "previous", "shortText", "Lcom/intellij/openapi/util/NlsSafe;", "getShortText", "Companion", "intellij.java.syntax"})
@SourceDebugExtension(value={"SMAP\nLanguageLevel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageLevel.kt\ncom/intellij/pom/java/LanguageLevel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,229:1\n1#2:230\n688#3:231\n719#3,4:232\n*S KotlinDebug\n*F\n+ 1 LanguageLevel.kt\ncom/intellij/pom/java/LanguageLevel\n*L\n206#1:231\n206#1:232,4\n*E\n"})
public final class LanguageLevel
extends Enum<LanguageLevel> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Function0<String> myPresentableText;
    @NotNull
    private final JavaVersion myVersion;
    private final boolean isPreview;
    private final boolean isUnsupported;
    @JvmField
    @NotNull
    public static final LanguageLevel HIGHEST;
    @NotNull
    private static final Map<Integer, LanguageLevel> ourStandardVersions;
    @NotNull
    private static final String PREVIEW_SUFFIX = "_PREVIEW";
    public static final /* enum */ LanguageLevel JDK_1_3;
    public static final /* enum */ LanguageLevel JDK_1_4;
    public static final /* enum */ LanguageLevel JDK_1_5;
    public static final /* enum */ LanguageLevel JDK_1_6;
    public static final /* enum */ LanguageLevel JDK_1_7;
    public static final /* enum */ LanguageLevel JDK_1_8;
    public static final /* enum */ LanguageLevel JDK_1_9;
    public static final /* enum */ LanguageLevel JDK_10;
    public static final /* enum */ LanguageLevel JDK_11;
    public static final /* enum */ LanguageLevel JDK_12;
    public static final /* enum */ LanguageLevel JDK_13;
    public static final /* enum */ LanguageLevel JDK_14;
    public static final /* enum */ LanguageLevel JDK_15;
    public static final /* enum */ LanguageLevel JDK_16;
    public static final /* enum */ LanguageLevel JDK_17;
    @ApiStatus.Obsolete
    public static final /* enum */ LanguageLevel JDK_17_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_18;
    @ApiStatus.Obsolete
    public static final /* enum */ LanguageLevel JDK_18_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_19;
    @ApiStatus.Obsolete
    public static final /* enum */ LanguageLevel JDK_19_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_20;
    @ApiStatus.Obsolete
    public static final /* enum */ LanguageLevel JDK_20_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_21;
    public static final /* enum */ LanguageLevel JDK_21_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_22;
    public static final /* enum */ LanguageLevel JDK_22_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_23;
    public static final /* enum */ LanguageLevel JDK_23_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_24;
    public static final /* enum */ LanguageLevel JDK_24_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_25;
    public static final /* enum */ LanguageLevel JDK_25_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_26;
    public static final /* enum */ LanguageLevel JDK_26_PREVIEW;
    public static final /* enum */ LanguageLevel JDK_X;
    private static final /* synthetic */ LanguageLevel[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    public final boolean isPreview() {
        return this.isPreview;
    }

    public final boolean isUnsupported() {
        return this.isUnsupported;
    }

    private LanguageLevel(Function0<String> presentableTextSupplier, int major) {
        this.myPresentableText = presentableTextSupplier;
        this.myVersion = JavaVersion.Companion.compose$default((JavaVersion.Companion)JavaVersion.Companion, (int)major, (int)0, (int)0, (int)0, (boolean)false, (int)30, null);
        this.isUnsupported = false;
        this.isPreview = StringsKt.endsWith$default((String)this.name(), (String)PREVIEW_SUFFIX, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.name(), (String)"_X", (boolean)false, (int)2, null);
    }

    private LanguageLevel(int major) {
        Object[] objectArray = new Object[]{major};
        this.myPresentableText = JavaSyntaxBundle.messagePointer("jdk.unsupported.preview.language.level.description", objectArray);
        this.myVersion = JavaVersion.Companion.compose$default((JavaVersion.Companion)JavaVersion.Companion, (int)major, (int)0, (int)0, (int)0, (boolean)false, (int)30, null);
        this.isUnsupported = true;
        this.isPreview = true;
        if (!StringsKt.endsWith$default((String)this.name(), (String)PREVIEW_SUFFIX, (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string = "Only preview versions could be unsupported: " + this.name();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final LanguageLevel getPreviewLevel() {
        LanguageLevel languageLevel;
        if (this.isPreview) {
            return this;
        }
        try {
            languageLevel = LanguageLevel.valueOf(this.name() + PREVIEW_SUFFIX);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            languageLevel = null;
        }
        return languageLevel;
    }

    @NotNull
    public final LanguageLevel getNonPreviewLevel() {
        if (!this.isPreview) {
            return this;
        }
        LanguageLevel languageLevel = ourStandardVersions.get(this.myVersion.feature);
        if (languageLevel == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return languageLevel;
    }

    @NotNull
    public final String getPresentableText() {
        return (String)this.myPresentableText.invoke();
    }

    public final boolean isAtLeast(@NotNull LanguageLevel level) {
        return this.compareTo((Enum)level) >= 0;
    }

    public final boolean isLessThan(@NotNull LanguageLevel level) {
        return this.compareTo((Enum)level) < 0;
    }

    @NotNull
    public final JavaVersion toJavaVersion() {
        return this.myVersion;
    }

    public final int feature() {
        return this.myVersion.feature;
    }

    @Nullable
    public final LanguageLevel next() {
        return Companion.forFeature(this.feature() + 1);
    }

    @Nullable
    public final LanguageLevel previous() {
        return Companion.forFeature(this.feature() - 1);
    }

    @NotNull
    public final String getShortText() {
        if (this == JDK_X) {
            return "X";
        }
        int feature = this.feature();
        if (feature < 5) {
            return "1." + feature;
        }
        return feature + (this.isPreview ? "-preview" : "");
    }

    public static LanguageLevel[] values() {
        return (LanguageLevel[])$VALUES.clone();
    }

    public static LanguageLevel valueOf(String value) {
        return Enum.valueOf(LanguageLevel.class, value);
    }

    @NotNull
    public static EnumEntries<LanguageLevel> getEntries() {
        return $ENTRIES;
    }

    private static final boolean ourStandardVersions$lambda$0(LanguageLevel ver) {
        return ver.isPreview;
    }

    @JvmStatic
    @Nullable
    public static final LanguageLevel parse(@Nullable String compilerComplianceOption) {
        return Companion.parse(compilerComplianceOption);
    }

    @JvmStatic
    @Nullable
    public static final LanguageLevel forFeature(int feature) {
        return Companion.forFeature(feature);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$associateByTo$iv$iv;
        JDK_1_3 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.3.language.level.description", new Object[0]), 3);
        JDK_1_4 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.4.language.level.description", new Object[0]), 4);
        JDK_1_5 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.5.language.level.description", new Object[0]), 5);
        JDK_1_6 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.6.language.level.description", new Object[0]), 6);
        JDK_1_7 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.7.language.level.description", new Object[0]), 7);
        JDK_1_8 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.8.language.level.description", new Object[0]), 8);
        JDK_1_9 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.1.9.language.level.description", new Object[0]), 9);
        JDK_10 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.10.language.level.description", new Object[0]), 10);
        JDK_11 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.11.language.level.description", new Object[0]), 11);
        JDK_12 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.12.language.level.description", new Object[0]), 12);
        JDK_13 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.13.language.level.description", new Object[0]), 13);
        JDK_14 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.14.language.level.description", new Object[0]), 14);
        JDK_15 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.15.language.level.description", new Object[0]), 15);
        JDK_16 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.16.language.level.description", new Object[0]), 16);
        JDK_17 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.17.language.level.description", new Object[0]), 17);
        JDK_17_PREVIEW = new LanguageLevel(17);
        JDK_18 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.18.language.level.description", new Object[0]), 18);
        JDK_18_PREVIEW = new LanguageLevel(18);
        JDK_19 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.19.language.level.description", new Object[0]), 19);
        JDK_19_PREVIEW = new LanguageLevel(19);
        JDK_20 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.20.language.level.description", new Object[0]), 20);
        JDK_20_PREVIEW = new LanguageLevel(20);
        JDK_21 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.21.language.level.description", new Object[0]), 21);
        JDK_21_PREVIEW = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.21.preview.language.level.description", new Object[0]), 21);
        JDK_22 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.22.language.level.description", new Object[0]), 22);
        JDK_22_PREVIEW = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.22.preview.language.level.description", new Object[0]), 22);
        JDK_23 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.23.language.level.description", new Object[0]), 23);
        JDK_23_PREVIEW = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.23.preview.language.level.description", new Object[0]), 23);
        JDK_24 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.24.language.level.description", new Object[0]), 24);
        JDK_24_PREVIEW = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.24.preview.language.level.description", new Object[0]), 24);
        JDK_25 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.25.language.level.description", new Object[0]), 25);
        JDK_25_PREVIEW = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.25.preview.language.level.description", new Object[0]), 25);
        JDK_26 = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.26.language.level.description", new Object[0]), 26);
        JDK_26_PREVIEW = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.26.preview.language.level.description", new Object[0]), 26);
        JDK_X = new LanguageLevel(JavaSyntaxBundle.messagePointer("jdk.X.language.level.description", new Object[0]), 27);
        $VALUES = languageLevelArray = new LanguageLevel[]{LanguageLevel.JDK_1_3, LanguageLevel.JDK_1_4, LanguageLevel.JDK_1_5, LanguageLevel.JDK_1_6, LanguageLevel.JDK_1_7, LanguageLevel.JDK_1_8, LanguageLevel.JDK_1_9, LanguageLevel.JDK_10, LanguageLevel.JDK_11, LanguageLevel.JDK_12, LanguageLevel.JDK_13, LanguageLevel.JDK_14, LanguageLevel.JDK_15, LanguageLevel.JDK_16, LanguageLevel.JDK_17, LanguageLevel.JDK_17_PREVIEW, LanguageLevel.JDK_18, LanguageLevel.JDK_18_PREVIEW, LanguageLevel.JDK_19, LanguageLevel.JDK_19_PREVIEW, LanguageLevel.JDK_20, LanguageLevel.JDK_20_PREVIEW, LanguageLevel.JDK_21, LanguageLevel.JDK_21_PREVIEW, LanguageLevel.JDK_22, LanguageLevel.JDK_22_PREVIEW, LanguageLevel.JDK_23, LanguageLevel.JDK_23_PREVIEW, LanguageLevel.JDK_24, LanguageLevel.JDK_24_PREVIEW, LanguageLevel.JDK_25, LanguageLevel.JDK_25_PREVIEW, LanguageLevel.JDK_26, LanguageLevel.JDK_26_PREVIEW, LanguageLevel.JDK_X};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        HIGHEST = JDK_26;
        Sequence $this$associateBy$iv = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)LanguageLevel.getEntries())), LanguageLevel::ourStandardVersions$lambda$0);
        boolean $i$f$associateBy = false;
        Sequence sequence = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void ver;
            LanguageLevel languageLevel = (LanguageLevel)((Object)element$iv$iv);
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(ver.myVersion.feature, element$iv$iv);
        }
        ourStandardVersions = var3_3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\bH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/pom/java/LanguageLevel$Companion;", "", "<init>", "()V", "HIGHEST", "Lcom/intellij/pom/java/LanguageLevel;", "ourStandardVersions", "", "", "parse", "compilerComplianceOption", "", "forFeature", "feature", "PREVIEW_SUFFIX", "intellij.java.syntax"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final LanguageLevel parse(@Nullable String compilerComplianceOption) {
            if (compilerComplianceOption == null) {
                return null;
            }
            JavaSdkVersion javaSdkVersion = JavaSdkVersion.Companion.fromVersionString(compilerComplianceOption);
            if (javaSdkVersion == null) {
                return null;
            }
            JavaSdkVersion sdkVersion = javaSdkVersion;
            return sdkVersion.getMaxLanguageLevel();
        }

        @JvmStatic
        @Nullable
        public final LanguageLevel forFeature(int feature) {
            return (LanguageLevel)((Object)ourStandardVersions.get(feature));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

