/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.lang.jvm.types.JvmArrayType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.JavaTypeNullabilityUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiArrayType
extends PsiType.Stub
implements JvmArrayType {
    private final PsiType myComponentType;
    TypeNullability myNullability;
    @Nullable
    final PsiModifierListOwner myContainerNullabilityContext;

    public PsiArrayType(@NotNull PsiType componentType) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(0);
        }
        this(componentType, TypeAnnotationProvider.EMPTY);
    }

    public PsiArrayType(@NotNull PsiType componentType, PsiAnnotation @NotNull [] annotations) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(1);
        }
        if (annotations == null) {
            PsiArrayType.$$$reportNull$$$0(2);
        }
        this(componentType, TypeAnnotationProvider.Static.create(annotations));
    }

    public PsiArrayType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider provider) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            PsiArrayType.$$$reportNull$$$0(4);
        }
        this(componentType, provider, null, null);
    }

    PsiArrayType(@NotNull PsiType componentType, @NotNull TypeAnnotationProvider provider, @Nullable TypeNullability nullability, @Nullable PsiModifierListOwner containerNullabilityContext) {
        if (componentType == null) {
            PsiArrayType.$$$reportNull$$$0(5);
        }
        if (provider == null) {
            PsiArrayType.$$$reportNull$$$0(6);
        }
        super(provider);
        this.myComponentType = componentType;
        this.myNullability = nullability;
        this.myContainerNullabilityContext = containerNullabilityContext;
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getText(this.getDeepComponentType().getPresentableText(annotated), "[]", false, annotated);
        if (string == null) {
            PsiArrayType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getText(this.getDeepComponentType().getCanonicalText(annotated), "[]", true, annotated);
        if (string == null) {
            PsiArrayType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getText(this.getDeepComponentType().getInternalCanonicalText(), "[]", true, true);
        if (string == null) {
            PsiArrayType.$$$reportNull$$$0(9);
        }
        return string;
    }

    protected String getText(@NotNull String prefix, @NotNull String suffix, boolean qualified, boolean annotated) {
        if (prefix == null) {
            PsiArrayType.$$$reportNull$$$0(10);
        }
        if (suffix == null) {
            PsiArrayType.$$$reportNull$$$0(11);
        }
        int dimensions = this.getArrayDimensions();
        StringBuilder sb = new StringBuilder(prefix.length() + (dimensions - 1) * 2 + suffix.length());
        sb.append(prefix);
        PsiType current = this;
        for (int i = 0; i < dimensions; ++i) {
            PsiAnnotation[] annotations;
            if (annotated && (annotations = current.getAnnotations()).length != 0) {
                sb.append(' ');
                PsiNameHelper.appendAnnotations(sb, annotations, qualified);
            }
            if (i == dimensions - 1) {
                sb.append(suffix);
                continue;
            }
            sb.append("[]");
            current = current.getComponentType();
        }
        return sb.toString();
    }

    @Override
    public boolean isValid() {
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (annotation.isValid()) continue;
            return false;
        }
        return this.myComponentType.isValid();
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiArrayType.$$$reportNull$$$0(12);
        }
        return text.endsWith("[]") && this.myComponentType.equalsToText(text.substring(0, text.length() - 2));
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiArrayType.$$$reportNull$$$0(13);
        }
        return visitor2.visitArrayType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myComponentType.getResolveScope();
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] superTypes = this.myComponentType.getSuperTypes();
        PsiType[] result = PsiArrayType.createArray(superTypes.length);
        for (int i = 0; i < superTypes.length; ++i) {
            result[i] = superTypes[i].createArrayType();
        }
        if (result == null) {
            PsiArrayType.$$$reportNull$$$0(14);
        }
        return result;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public PsiType getComponentType() {
        PsiType psiType = this.myComponentType;
        if (psiType == null) {
            PsiArrayType.$$$reportNull$$$0(15);
        }
        return psiType;
    }

    @ApiStatus.Experimental
    @NotNull
    public PsiType withContainerNullability(@Nullable PsiModifierListOwner containerNullabilityContext) {
        if (containerNullabilityContext == this.myContainerNullabilityContext) {
            PsiArrayType psiArrayType = this;
            if (psiArrayType == null) {
                PsiArrayType.$$$reportNull$$$0(16);
            }
            return psiArrayType;
        }
        return new PsiArrayType(this.myComponentType, this.getAnnotationProvider(), this.myNullability, containerNullabilityContext);
    }

    @ApiStatus.Experimental
    @Nullable
    static TypeNullability getContainerNullability(@NotNull PsiElement psiContext) {
        Project project;
        if (psiContext == null) {
            PsiArrayType.$$$reportNull$$$0(17);
        }
        if ((project = psiContext.getProject()).isDefault()) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(project);
        if (manager == null) {
            return null;
        }
        NullabilityAnnotationInfo defaultNullability = manager.findDefaultTypeUseNullability(psiContext);
        TypeNullability nullability = defaultNullability == null ? null : defaultNullability.toTypeNullability();
        return nullability;
    }

    @ApiStatus.Experimental
    @NotNull
    public PsiType withContainerNullability(@Nullable PsiArrayType arrayType) {
        if (arrayType == null && this.myContainerNullabilityContext == null) {
            PsiArrayType psiArrayType = this;
            if (psiArrayType == null) {
                PsiArrayType.$$$reportNull$$$0(18);
            }
            return psiArrayType;
        }
        if (arrayType != null && arrayType.myContainerNullabilityContext == this.myContainerNullabilityContext) {
            PsiArrayType psiArrayType = this;
            if (psiArrayType == null) {
                PsiArrayType.$$$reportNull$$$0(19);
            }
            return psiArrayType;
        }
        return new PsiArrayType(this.myComponentType, this.getAnnotationProvider(), this.myNullability, arrayType != null ? arrayType.myContainerNullabilityContext : null);
    }

    @Override
    @NotNull
    public TypeNullability getNullability() {
        if (this.myNullability == null) {
            TypeNullability containerNullability;
            TypeNullability nullability = JavaTypeNullabilityUtil.getNullabilityFromAnnotations(this.getAnnotations());
            if (nullability == TypeNullability.UNKNOWN && this.myContainerNullabilityContext != null && (containerNullability = PsiArrayType.getContainerNullability(this.myContainerNullabilityContext)) != null) {
                nullability = containerNullability;
            }
            this.myNullability = nullability;
        }
        TypeNullability typeNullability = this.myNullability;
        if (typeNullability == null) {
            PsiArrayType.$$$reportNull$$$0(20);
        }
        return typeNullability;
    }

    @Override
    @NotNull
    public PsiArrayType withNullability(@NotNull TypeNullability nullability) {
        if (nullability == null) {
            PsiArrayType.$$$reportNull$$$0(21);
        }
        return new PsiArrayType(this.getComponentType(), this.getAnnotationProvider(), nullability, this.myContainerNullabilityContext);
    }

    @Override
    @NotNull
    public PsiArrayType annotate(@NotNull TypeAnnotationProvider provider) {
        PsiArrayType annotated;
        if (provider == null) {
            PsiArrayType.$$$reportNull$$$0(22);
        }
        if ((annotated = (PsiArrayType)super.annotate(provider)) != this) {
            annotated.myNullability = null;
        }
        PsiArrayType psiArrayType = annotated;
        if (psiArrayType == null) {
            PsiArrayType.$$$reportNull$$$0(23);
        }
        return psiArrayType;
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiArrayType && this instanceof PsiEllipsisType == obj instanceof PsiEllipsisType && this.myComponentType.equals(((PsiArrayType)obj).getComponentType());
    }

    public int hashCode() {
        return this.myComponentType.hashCode() * 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 4: 
            case 6: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiArrayType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiContext";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiArrayType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentType";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "withContainerNullability";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContainerNullability";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withNullability";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

