/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.TypeAnnotationContainer;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsAnnotationParameterListImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiAnnotationStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExplicitTypeAnnotationContainer
implements TypeAnnotationContainer {
    private final List<TypeAnnotationEntry> myList;

    private ExplicitTypeAnnotationContainer(List<TypeAnnotationEntry> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("Empty container: use TypeAnnotationContainer.EMPTY instead");
        }
        this.myList = entries;
    }

    @Override
    @NotNull
    public TypeAnnotationContainer forArrayElement() {
        List list = ContainerUtil.mapNotNull(this.myList, entry -> ((TypeAnnotationEntry)entry).forPathElement(0));
        return list.isEmpty() ? EMPTY : new ExplicitTypeAnnotationContainer(list);
    }

    @Override
    @NotNull
    public TypeAnnotationContainer forEnclosingClass() {
        List list = ContainerUtil.mapNotNull(this.myList, entry -> ((TypeAnnotationEntry)entry).forPathElement(1));
        return list.isEmpty() ? EMPTY : new ExplicitTypeAnnotationContainer(list);
    }

    @Override
    @NotNull
    public TypeAnnotationContainer forBound() {
        List list = ContainerUtil.mapNotNull(this.myList, entry -> ((TypeAnnotationEntry)entry).forPathElement(2));
        return list.isEmpty() ? EMPTY : new ExplicitTypeAnnotationContainer(list);
    }

    @Override
    @NotNull
    public TypeAnnotationContainer forTypeArgument(int index) {
        List list = ContainerUtil.mapNotNull(this.myList, e -> e.forTypeArgument(index));
        return list.isEmpty() ? EMPTY : new ExplicitTypeAnnotationContainer(list);
    }

    @Override
    @NotNull
    public TypeAnnotationProvider getProvider(PsiElement parent) {
        return new TypeAnnotationContainerProvider(parent, (PsiAnnotationOwner)ObjectUtils.tryCast((Object)parent, PsiAnnotationOwner.class));
    }

    public void createAnnotationStubs(StubElement<?> parent) {
        for (TypeAnnotationEntry entry : this.myList) {
            if (entry.myPath.length != 0) continue;
            new PsiAnnotationStubImpl(parent, entry.myText);
        }
    }

    @Override
    public void appendImmediateText(@NotNull StringBuilder sb) {
        if (sb == null) {
            ExplicitTypeAnnotationContainer.$$$reportNull$$$0(0);
        }
        for (TypeAnnotationEntry entry : this.myList) {
            if (entry.myPath.length != 0) continue;
            sb.append(entry.myText).append(' ');
        }
    }

    public static void writeTypeAnnotations(@NotNull StubOutputStream dataStream, @NotNull ExplicitTypeAnnotationContainer container) throws IOException {
        if (dataStream == null) {
            ExplicitTypeAnnotationContainer.$$$reportNull$$$0(1);
        }
        if (container == null) {
            ExplicitTypeAnnotationContainer.$$$reportNull$$$0(2);
        }
        dataStream.writeShort(container.myList.size());
        for (TypeAnnotationEntry entry : container.myList) {
            dataStream.writeShort(entry.myPath.length);
            dataStream.write(entry.myPath);
            dataStream.writeUTFFast(entry.myText);
        }
    }

    @NotNull
    public static TypeAnnotationContainer readTypeAnnotations(@NotNull StubInputStream dataStream) throws IOException {
        int count;
        if (dataStream == null) {
            ExplicitTypeAnnotationContainer.$$$reportNull$$$0(3);
        }
        if ((count = dataStream.readShort()) == 0) {
            TypeAnnotationContainer typeAnnotationContainer = EMPTY;
            if (typeAnnotationContainer == null) {
                ExplicitTypeAnnotationContainer.$$$reportNull$$$0(4);
            }
            return typeAnnotationContainer;
        }
        TypeAnnotationEntry[] entries = new TypeAnnotationEntry[count];
        for (int i = 0; i < count; ++i) {
            short pathLength = dataStream.readShort();
            byte[] path = new byte[pathLength];
            dataStream.readFully(path);
            String text = dataStream.readUTFFast();
            entries[i] = new TypeAnnotationEntry(path, text);
        }
        return new ExplicitTypeAnnotationContainer(Arrays.asList(entries));
    }

    public String toString() {
        return StringUtil.join(this.myList, (String)"\n");
    }

    @NotNull
    private static String encodePath(byte @NotNull [] path) {
        if (path == null) {
            ExplicitTypeAnnotationContainer.$$$reportNull$$$0(5);
        }
        StringBuilder result = new StringBuilder();
        block6: for (int pos = 0; pos < path.length; ++pos) {
            switch (path[pos]) {
                case 0: {
                    result.append("/[]");
                    continue block6;
                }
                case 1: {
                    result.append("/.");
                    continue block6;
                }
                case 2: {
                    result.append("/*");
                    continue block6;
                }
                case 3: {
                    result.append('/').append(path[++pos] + 1);
                }
            }
        }
        String string = result.toString();
        if (string == null) {
            ExplicitTypeAnnotationContainer.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readTypeAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "encodePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendImmediateText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeTypeAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readTypeAnnotations";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "encodePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TypeAnnotationContainerProvider
    implements TypeAnnotationProvider {
        private final PsiElement myParent;
        @Nullable
        private final PsiAnnotationOwner myOwner;
        private final NotNullLazyValue<PsiAnnotation[]> myAnnotations = NotNullLazyValue.createValue(this::computeAnnotations);

        private TypeAnnotationContainerProvider(@Nullable PsiElement parent, PsiAnnotationOwner owner) {
            this.myParent = parent;
            this.myOwner = owner;
        }

        @Override
        @NotNull
        public TypeAnnotationProvider withOwner(@NotNull PsiAnnotationOwner owner) {
            if (owner == null) {
                TypeAnnotationContainerProvider.$$$reportNull$$$0(0);
            }
            return new TypeAnnotationContainerProvider(this.myParent, owner);
        }

        @NotNull
        private @NotNull PsiAnnotation @NotNull [] computeAnnotations() {
            ArrayList<ClsTypeAnnotationImpl> result = new ArrayList<ClsTypeAnnotationImpl>();
            for (TypeAnnotationEntry entry : ExplicitTypeAnnotationContainer.this.myList) {
                if (entry.myPath.length != 0) continue;
                PsiAnnotation anno = this.myParent instanceof PsiCompiledElement ? new ClsTypeAnnotationImpl(this.myParent, this.myOwner, entry.myText) : JavaPsiFacade.getElementFactory(this.myParent.getProject()).createAnnotationFromText(entry.myText, this.myParent);
                result.add((ClsTypeAnnotationImpl)anno);
            }
            PsiAnnotation[] psiAnnotationArray = result.toArray(PsiAnnotation.EMPTY_ARRAY);
            if (psiAnnotationArray == null) {
                TypeAnnotationContainerProvider.$$$reportNull$$$0(1);
            }
            return psiAnnotationArray;
        }

        @Override
        @NotNull
        public @NotNull PsiAnnotation @NotNull [] getAnnotations() {
            PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])this.myAnnotations.getValue();
            if (psiAnnotationArray == null) {
                TypeAnnotationContainerProvider.$$$reportNull$$$0(2);
            }
            return psiAnnotationArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer$TypeAnnotationContainerProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer$TypeAnnotationContainerProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAnnotations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "withOwner";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TypeAnnotationEntry {
        final byte @NotNull [] myPath;
        @NotNull
        final String myText;

        private TypeAnnotationEntry(byte @NotNull [] path, @NotNull String text) {
            if (text == null) {
                TypeAnnotationEntry.$$$reportNull$$$0(0);
            }
            if (path == null) {
                TypeAnnotationEntry.$$$reportNull$$$0(1);
            }
            this.myPath = path.length == 0 ? ArrayUtil.EMPTY_BYTE_ARRAY : path;
            this.myText = text;
        }

        private TypeAnnotationEntry forPathElement(int wanted) {
            if (this.myPath.length > 0 && this.myPath[0] == wanted) {
                return new TypeAnnotationEntry(Arrays.copyOfRange(this.myPath, 1, this.myPath.length), this.myText);
            }
            return null;
        }

        public TypeAnnotationEntry forTypeArgument(int index) {
            if (this.myPath.length > 1 && this.myPath[0] == 3 && this.myPath[1] == index) {
                return new TypeAnnotationEntry(Arrays.copyOfRange(this.myPath, 2, this.myPath.length), this.myText);
            }
            return null;
        }

        public String toString() {
            return ExplicitTypeAnnotationContainer.encodePath(this.myPath) + "->" + this.myText;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer$TypeAnnotationEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Collector {
        public static final byte ARRAY_ELEMENT = 0;
        public static final byte ENCLOSING_CLASS = 1;
        public static final byte WILDCARD_BOUND = 2;
        public static final byte TYPE_ARGUMENT = 3;
        @NotNull
        private final ArrayList<TypeAnnotationEntry> myList;
        @NotNull
        protected final TypeInfo myTypeInfo;

        public Collector(@NotNull TypeInfo info) {
            if (info == null) {
                Collector.$$$reportNull$$$0(0);
            }
            this.myList = new ArrayList();
            this.myTypeInfo = info;
        }

        public void add(byte @NotNull [] path, @NotNull String text) {
            if (text == null) {
                Collector.$$$reportNull$$$0(1);
            }
            if (path == null) {
                Collector.$$$reportNull$$$0(2);
            }
            this.myList.add(new TypeAnnotationEntry(path, text));
        }

        public void install() {
            if (this.myList.isEmpty()) {
                this.myTypeInfo.setTypeAnnotations(TypeAnnotationContainer.EMPTY);
            } else {
                this.myList.trimToSize();
                this.myTypeInfo.setTypeAnnotations(new ExplicitTypeAnnotationContainer(this.myList));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer$Collector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ClsTypeAnnotationImpl
    extends ClsElementImpl
    implements PsiAnnotation {
        private final NotNullLazyValue<ClsJavaCodeReferenceElementImpl> myReferenceElement;
        private final NotNullLazyValue<ClsAnnotationParameterListImpl> myParameterList;
        private final PsiElement myParent;
        @Nullable
        private final PsiAnnotationOwner myOwner;
        private final String myText;

        ClsTypeAnnotationImpl(PsiElement parent, @Nullable PsiAnnotationOwner owner, String text) {
            this.myParent = parent;
            this.myOwner = owner;
            this.myText = text;
            this.myReferenceElement = NotNullLazyValue.atomicLazy(() -> {
                int index = this.myText.indexOf(40);
                String refText = index > 0 ? this.myText.substring(1, index) : this.myText.substring(1);
                return new ClsJavaCodeReferenceElementImpl(this, refText);
            });
            this.myParameterList = NotNullLazyValue.atomicLazy(() -> {
                PsiNameValuePair[] attrs = this.myText.indexOf(40) > 0 ? JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText(this.myText, this.myParent).getParameterList().getAttributes() : PsiNameValuePair.EMPTY_ARRAY;
                return new ClsAnnotationParameterListImpl(this, attrs);
            });
        }

        @Override
        @NotNull
        public PsiAnnotationParameterList getParameterList() {
            PsiAnnotationParameterList psiAnnotationParameterList = (PsiAnnotationParameterList)this.myParameterList.getValue();
            if (psiAnnotationParameterList == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(0);
            }
            return psiAnnotationParameterList;
        }

        @Override
        @Nullable
        public String getQualifiedName() {
            return this.getNameReferenceElement().getCanonicalText();
        }

        @Override
        @NotNull
        public PsiJavaCodeReferenceElement getNameReferenceElement() {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)this.myReferenceElement.getValue();
            if (psiJavaCodeReferenceElement == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(1);
            }
            return psiJavaCodeReferenceElement;
        }

        @Override
        @Nullable
        public PsiAnnotationMemberValue findAttributeValue(@Nullable String attributeName) {
            return PsiImplUtil.findAttributeValue(this, attributeName);
        }

        @Override
        @Nullable
        public PsiAnnotationMemberValue findDeclaredAttributeValue(@Nullable String attributeName) {
            return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
        }

        @Override
        public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@Nullable String attributeName, @Nullable T value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public PsiAnnotationOwner getOwner() {
            return this.myOwner;
        }

        @Override
        public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
            if (buffer == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(2);
            }
            buffer.append(this.myText);
        }

        @Override
        public String getText() {
            return this.myText;
        }

        @Override
        protected void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
            if (element == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(3);
            }
            this.setMirrorCheckingType(element, null);
            PsiAnnotation mirror = (PsiAnnotation)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)element);
            ClsTypeAnnotationImpl.setMirror(this.getNameReferenceElement(), mirror.getNameReferenceElement());
            ClsTypeAnnotationImpl.setMirror(this.getParameterList(), mirror.getParameterList());
        }

        public PsiElement @NotNull [] getChildren() {
            PsiElement[] psiElementArray = new PsiElement[]{(PsiElement)this.myReferenceElement.getValue(), this.getParameterList()};
            if (psiElementArray == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(4);
            }
            return psiElementArray;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                ClsTypeAnnotationImpl.$$$reportNull$$$0(5);
            }
            if (visitor2 instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor2).visitAnnotation(this);
            } else {
                visitor2.visitElement((PsiElement)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer$ClsTypeAnnotationImpl";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParameterList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameReferenceElement";
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/cache/ExplicitTypeAnnotationContainer$ClsTypeAnnotationImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "appendMirrorText";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setMirror";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

