/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Handle;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;

class FirstPassData
implements SignatureParsing.TypeInfoProvider {
    private static final Logger LOG = Logger.getInstance(FirstPassData.class);
    private static final FirstPassData NO_DATA = new FirstPassData(Collections.emptyMap(), "", null, Collections.emptySet(), true, false);
    @NotNull
    private final Map<String, ClassEntry> myMap;
    @NotNull
    private final Set<ObjectMethod> mySyntheticMethods;
    @NotNull
    private final String myTopLevelName;
    @Nullable
    private final String myVarArgRecordComponent;
    private final boolean myTrustInnerClasses;
    private final boolean mySealed;

    private FirstPassData(@NotNull Map<String, ClassEntry> map2, @NotNull String topLevelName, @Nullable String component, @NotNull Set<ObjectMethod> syntheticMethods, boolean trustInnerClasses, boolean sealed) {
        if (map2 == null) {
            FirstPassData.$$$reportNull$$$0(0);
        }
        if (topLevelName == null) {
            FirstPassData.$$$reportNull$$$0(1);
        }
        if (syntheticMethods == null) {
            FirstPassData.$$$reportNull$$$0(2);
        }
        this.myMap = map2;
        this.myTopLevelName = topLevelName;
        this.myVarArgRecordComponent = component;
        this.mySyntheticMethods = syntheticMethods;
        this.myTrustInnerClasses = trustInnerClasses;
        this.mySealed = sealed;
    }

    boolean isVarArgComponent(@NotNull String componentName) {
        if (componentName == null) {
            FirstPassData.$$$reportNull$$$0(3);
        }
        return componentName.equals(this.myVarArgRecordComponent);
    }

    boolean isSealed() {
        return this.mySealed;
    }

    boolean isSyntheticRecordMethod(@NotNull String methodName, @NotNull String methodDesc) {
        if (methodName == null) {
            FirstPassData.$$$reportNull$$$0(4);
        }
        if (methodDesc == null) {
            FirstPassData.$$$reportNull$$$0(5);
        }
        return !this.mySyntheticMethods.isEmpty() && this.mySyntheticMethods.contains((Object)ObjectMethod.from(methodName, methodDesc));
    }

    @Contract(value="null -> null; !null -> !null")
    @Unmodifiable List<TypeInfo> createTypes(String @Nullable [] jvmNames) {
        return jvmNames == null ? null : ContainerUtil.map((Object[])jvmNames, jvmName -> this.toTypeInfo((String)jvmName, false));
    }

    @Override
    public boolean isKnownStatic(@NotNull String jvmClassName) {
        ClassEntry entry;
        if (jvmClassName == null) {
            FirstPassData.$$$reportNull$$$0(6);
        }
        return (entry = this.myMap.get(jvmClassName)) instanceof StringInnerClassEntry && ((StringInnerClassEntry)entry).myStatic || entry instanceof TypeInfoInnerClassEntry && ((TypeInfoInnerClassEntry)entry).myStatic;
    }

    @Override
    @NotNull
    public TypeInfo.RefTypeInfo toTypeInfo(@NotNull String jvmName) {
        if (jvmName == null) {
            FirstPassData.$$$reportNull$$$0(7);
        }
        TypeInfo.RefTypeInfo refTypeInfo = this.toTypeInfo(jvmName, true);
        if (refTypeInfo == null) {
            FirstPassData.$$$reportNull$$$0(8);
        }
        return refTypeInfo;
    }

    @NotNull
    TypeInfo.RefTypeInfo toTypeInfo(@NotNull String jvmName, boolean useGuesser) {
        ClassEntry p;
        if (jvmName == null) {
            FirstPassData.$$$reportNull$$$0(9);
        }
        if ((p = this.myMap.get(jvmName)) != null) {
            if (p instanceof RegularClassEntry) {
                return new TypeInfo.RefTypeInfo(((RegularClassEntry)p).myName);
            }
            if (p instanceof StringInnerClassEntry) {
                StringInnerClassEntry entry = (StringInnerClassEntry)p;
                TypeInfo.RefTypeInfo outer = this.toTypeInfo(entry.myOuterName, false);
                p = new TypeInfoInnerClassEntry(outer, entry.myInnerName, entry.myStatic);
                this.myMap.put(jvmName, p);
            }
            assert (p instanceof TypeInfoInnerClassEntry);
            return new TypeInfo.RefTypeInfo(((TypeInfoInnerClassEntry)p).myInnerName, ((TypeInfoInnerClassEntry)p).myOuterType);
        }
        if (!(jvmName.indexOf(36) < 0 || jvmName.equals(this.myTopLevelName) || !useGuesser && this.myTrustInnerClasses)) {
            TypeInfo.RefTypeInfo refTypeInfo = StubBuildingVisitor.GUESSING_PROVIDER.toTypeInfo(jvmName);
            if (refTypeInfo == null) {
                FirstPassData.$$$reportNull$$$0(10);
            }
            return refTypeInfo;
        }
        String name = jvmName.replace('/', '.');
        this.myMap.put(jvmName, new RegularClassEntry(name));
        return new TypeInfo.RefTypeInfo(name);
    }

    @NotNull
    static FirstPassData create(Object classSource) {
        ClassReader reader = null;
        if (classSource instanceof ClsFileImpl.FileContentPair) {
            reader = ((ClsFileImpl.FileContentPair)((Object)classSource)).getContent();
        } else if (classSource instanceof VirtualFile) {
            try {
                reader = new ClassReader(((VirtualFile)classSource).contentsToByteArray(false));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (reader != null) {
            return FirstPassData.fromReader(reader);
        }
        FirstPassData firstPassData = NO_DATA;
        if (firstPassData == null) {
            FirstPassData.$$$reportNull$$$0(11);
        }
        return firstPassData;
    }

    @NotNull
    private static FirstPassData fromReader(@NotNull ClassReader reader) {
        if (reader == null) {
            FirstPassData.$$$reportNull$$$0(12);
        }
        class FirstPassVisitor
        extends ClassVisitor {
            final Map<String, ClassEntry> mapping = new HashMap<String, ClassEntry>();
            Set<String> varArgConstructors;
            Set<ObjectMethod> syntheticSignatures;
            StringBuilder canonicalSignature;
            String lastComponent;
            String name;
            boolean trustInnerClasses = true;
            boolean sealed = false;

            FirstPassVisitor() {
                super(589824);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (BitUtil.isSet((int)access, (int)65536)) {
                    this.varArgConstructors = new HashSet<String>();
                    this.canonicalSignature = new StringBuilder("(");
                    this.syntheticSignatures = EnumSet.noneOf(ObjectMethod.class);
                }
                this.name = name;
            }

            public void visitSource(String source, String debug) {
                String suffix = ".groovy";
                if (source != null && source.length() > suffix.length() && source.regionMatches(true, source.length() - suffix.length(), suffix, 0, suffix.length())) {
                    this.trustInnerClasses = false;
                }
                super.visitSource(source, debug);
            }

            public void visitPermittedSubclass(String permittedSubclass) {
                this.sealed = true;
            }

            public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
                if (this.isRecord()) {
                    this.canonicalSignature.append(descriptor);
                    this.lastComponent = name;
                }
                return null;
            }

            private boolean isRecord() {
                return this.varArgConstructors != null;
            }

            public MethodVisitor visitMethod(int access, final String name, String descriptor, String signature, String[] exceptions) {
                if (this.isRecord()) {
                    ObjectMethod method;
                    if (name.equals("<init>") && BitUtil.isSet((int)access, (int)128)) {
                        this.varArgConstructors.add(descriptor);
                    }
                    if ((method = ObjectMethod.from(name, descriptor)) != null) {
                        return new MethodVisitor(589824){

                            public void visitInvokeDynamicInsn(String indyName, String indyDescriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                                if (indyName.equals(name) && bootstrapMethodHandle.getName().equals("bootstrap") && bootstrapMethodHandle.getOwner().equals("java/lang/runtime/ObjectMethods")) {
                                    syntheticSignatures.add(method);
                                }
                            }
                        };
                    }
                }
                return null;
            }

            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                if (outerName != null && innerName != null) {
                    this.mapping.put(name, new StringInnerClassEntry(outerName, innerName, BitUtil.isSet((int)access, (int)8)));
                }
            }
        }
        FirstPassVisitor visitor2 = new FirstPassVisitor();
        try {
            reader.accept((ClassVisitor)visitor2, ClsFileImpl.EMPTY_ATTRIBUTES, 4);
        }
        catch (Exception ex) {
            LOG.debug((Throwable)ex);
        }
        String varArgComponent = null;
        if (visitor2.isRecord()) {
            visitor2.canonicalSignature.append(")V");
            if (visitor2.varArgConstructors.contains(visitor2.canonicalSignature.toString())) {
                varArgComponent = visitor2.lastComponent;
            }
        }
        Set<ObjectMethod> syntheticMethods = visitor2.syntheticSignatures == null ? Collections.emptySet() : visitor2.syntheticSignatures;
        return new FirstPassData(visitor2.mapping, visitor2.name, varArgComponent, syntheticMethods, visitor2.trustInnerClasses, visitor2.sealed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntheticMethods";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodDesc";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmClassName";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmName";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/compiled/FirstPassData";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/compiled/FirstPassData";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toTypeInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVarArgComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSyntheticRecordMethod";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isKnownStatic";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toTypeInfo";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromReader";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ObjectMethod {
        EQUALS("equals", "(Ljava/lang/Object;)Z"),
        HASH_CODE("hashCode", "()I"),
        TO_STRING("toString", "()Ljava/lang/String;");

        @NotNull
        private final String myName;
        @NotNull
        private final String myDesc;

        private ObjectMethod(String name, String desc) {
            if (name == null) {
                ObjectMethod.$$$reportNull$$$0(0);
            }
            if (desc == null) {
                ObjectMethod.$$$reportNull$$$0(1);
            }
            this.myName = name;
            this.myDesc = desc;
        }

        @Nullable
        static ObjectMethod from(@NotNull String name, @NotNull String desc) {
            if (name == null) {
                ObjectMethod.$$$reportNull$$$0(2);
            }
            if (desc == null) {
                ObjectMethod.$$$reportNull$$$0(3);
            }
            for (ObjectMethod method : ObjectMethod.values()) {
                if (!method.myName.equals(name) || !method.myDesc.equals(desc)) continue;
                return method;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/compiled/FirstPassData$ObjectMethod";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "from";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ClassEntry {
        private ClassEntry() {
        }
    }

    private static final class StringInnerClassEntry
    extends ClassEntry {
        @NotNull
        final String myOuterName;
        @NotNull
        final String myInnerName;
        final boolean myStatic;

        private StringInnerClassEntry(@NotNull String outerName, @NotNull String innerName, boolean aStatic) {
            if (outerName == null) {
                StringInnerClassEntry.$$$reportNull$$$0(0);
            }
            if (innerName == null) {
                StringInnerClassEntry.$$$reportNull$$$0(1);
            }
            this.myOuterName = outerName;
            this.myInnerName = innerName;
            this.myStatic = aStatic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "innerName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/FirstPassData$StringInnerClassEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TypeInfoInnerClassEntry
    extends ClassEntry {
        private final TypeInfo.RefTypeInfo myOuterType;
        private final String myInnerName;
        private final boolean myStatic;

        private TypeInfoInnerClassEntry(@NotNull TypeInfo.RefTypeInfo outerType, @NotNull String innerName, boolean aStatic) {
            if (outerType == null) {
                TypeInfoInnerClassEntry.$$$reportNull$$$0(0);
            }
            if (innerName == null) {
                TypeInfoInnerClassEntry.$$$reportNull$$$0(1);
            }
            this.myOuterType = outerType;
            this.myInnerName = innerName;
            this.myStatic = aStatic;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "innerName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/compiled/FirstPassData$TypeInfoInnerClassEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RegularClassEntry
    extends ClassEntry {
        @NotNull
        final String myName;

        private RegularClassEntry(@NotNull String name) {
            if (name == null) {
                RegularClassEntry.$$$reportNull$$$0(0);
            }
            this.myName = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/compiled/FirstPassData$RegularClassEntry", "<init>"));
        }
    }
}

