/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiImportListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiImportModuleStatementImpl;
import com.intellij.psi.impl.source.PsiImportStatementImpl;
import com.intellij.psi.impl.source.PsiImportStaticStatementImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiImportListImpl
extends JavaStubPsiElement<PsiImportListStub>
implements PsiImportList {
    private volatile Map<String, PsiImportStatement> myClassNameToImportMap;
    private volatile Map<String, PsiImportStatement> myPackageNameToImportMap;
    private volatile Map<String, PsiImportModuleStatement> myModuleNameToImportMap;
    private volatile Map<String, PsiImportStatementBase> myNameToSingleImportMap;
    private static final TokenSet IMPORT_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_STATEMENT});
    private static final TokenSet IMPORT_STATIC_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_STATIC_STATEMENT});
    private static final TokenSet IMPORT_MODULE_STATEMENT_BIT_SET = TokenSet.create((IElementType[])new IElementType[]{JavaElementType.IMPORT_MODULE_STATEMENT});

    public PsiImportListImpl(PsiImportListStub stub) {
        super(stub, JavaStubElementTypes.IMPORT_LIST);
    }

    public PsiImportListImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiImportListImpl clone = (PsiImportListImpl)super.clone();
        clone.myClassNameToImportMap = null;
        clone.myPackageNameToImportMap = null;
        clone.myNameToSingleImportMap = null;
        clone.myModuleNameToImportMap = null;
        return clone;
    }

    public void subtreeChanged() {
        this.myClassNameToImportMap = null;
        this.myPackageNameToImportMap = null;
        this.myNameToSingleImportMap = null;
        this.myModuleNameToImportMap = null;
        super.subtreeChanged();
    }

    @Override
    public PsiImportStatement @NotNull [] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = (PsiImportStatement[])this.getStubOrPsiChildren(IMPORT_STATEMENT_BIT_SET, PsiImportStatementImpl.ARRAY_FACTORY);
        if (psiImportStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(0);
        }
        return psiImportStatementArray;
    }

    @Override
    public PsiImportStaticStatement @NotNull [] getImportStaticStatements() {
        PsiImportStaticStatement[] psiImportStaticStatementArray = (PsiImportStaticStatement[])this.getStubOrPsiChildren(IMPORT_STATIC_STATEMENT_BIT_SET, PsiImportStaticStatementImpl.ARRAY_FACTORY);
        if (psiImportStaticStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(1);
        }
        return psiImportStaticStatementArray;
    }

    @Override
    public PsiImportModuleStatement @NotNull [] getImportModuleStatements() {
        PsiImportModuleStatement[] psiImportModuleStatementArray = (PsiImportModuleStatement[])this.getStubOrPsiChildren(IMPORT_MODULE_STATEMENT_BIT_SET, PsiImportModuleStatementImpl.ARRAY_FACTORY);
        if (psiImportModuleStatementArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(2);
        }
        return psiImportModuleStatementArray;
    }

    @Override
    public PsiImportStatementBase @NotNull [] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])this.getStubOrPsiChildren(ElementType.IMPORT_STATEMENT_BASE_BIT_SET, PsiImportStatementBase.ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            PsiImportListImpl.$$$reportNull$$$0(3);
        }
        return psiImportStatementBaseArray;
    }

    @Override
    public PsiImportStatement findSingleClassImportStatement(String name) {
        Map<String, PsiImportStatement> map2;
        while ((map2 = this.myClassNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    @Override
    public PsiImportStatement findOnDemandImportStatement(String name) {
        Map<String, PsiImportStatement> map2;
        while ((map2 = this.myPackageNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    @Override
    @Nullable
    public PsiImportModuleStatement findImportModuleStatement(String name) {
        Map<String, PsiImportModuleStatement> map2;
        while ((map2 = this.myModuleNameToImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    @Override
    @Nullable
    public PsiImportStatementBase findSingleImportStatement(String name) {
        Map<String, PsiImportStatementBase> map2;
        while ((map2 = this.myNameToSingleImportMap) == null) {
            this.initializeMaps();
        }
        return map2.get(name);
    }

    @Override
    public boolean isReplaceEquivalent(PsiImportList otherList) {
        PsiImportStatementBase[] importStatements2;
        PsiImportStatementBase[] importStatements1 = this.getAllImportStatements();
        if (importStatements1.length != (importStatements2 = otherList.getAllImportStatements()).length) {
            return false;
        }
        for (int i = 0; i < importStatements1.length; ++i) {
            if (importStatements1[i].isReplaceEquivalent(importStatements2[i])) continue;
            return false;
        }
        return true;
    }

    private void initializeMaps() {
        PsiImportModuleStatement[] importModules;
        PsiImportStaticStatement[] importStatics;
        PsiImportStatement[] imports;
        HashMap<String, PsiImportStatement> classNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatement> packageNameToImportMap = new HashMap<String, PsiImportStatement>();
        HashMap<String, PsiImportStatementBase> nameToSingleImportMap = new HashMap<String, PsiImportStatementBase>();
        HashMap<String, PsiImportModuleStatement> moduleNameToImportMap = new HashMap<String, PsiImportModuleStatement>();
        for (PsiImportStatement anImport : imports = this.getImportStatements()) {
            String qName = anImport.getQualifiedName();
            if (qName == null) continue;
            if (anImport.isOnDemand()) {
                packageNameToImportMap.put(qName, anImport);
                continue;
            }
            classNameToImportMap.put(qName, anImport);
            PsiJavaCodeReferenceElement importReference = anImport.getImportReference();
            if (importReference == null) continue;
            nameToSingleImportMap.put(importReference.getReferenceName(), anImport);
        }
        for (PsiImportStaticStatement importStatic : importStatics = this.getImportStaticStatements()) {
            String referenceName;
            if (importStatic.isOnDemand() || (referenceName = importStatic.getReferenceName()) == null) continue;
            nameToSingleImportMap.put(referenceName, importStatic);
        }
        for (PsiImportModuleStatement importModule : importModules = this.getImportModuleStatements()) {
            String referenceName = importModule.getReferenceName();
            if (referenceName == null) continue;
            moduleNameToImportMap.put(referenceName, importModule);
        }
        this.myClassNameToImportMap = classNameToImportMap;
        this.myPackageNameToImportMap = packageNameToImportMap;
        this.myNameToSingleImportMap = nameToSingleImportMap;
        this.myModuleNameToImportMap = moduleNameToImportMap;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiImportListImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitImportList(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiImportList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiImportListImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportModuleStatements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportStatements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiImportListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

