/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.cache.ModifierFlags;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiModifierListStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiModifierListImpl
extends JavaStubPsiElement<PsiModifierListStub>
implements PsiModifierList {
    private static final Map<String, IElementType> NAME_TO_KEYWORD_TYPE_MAP = new HashMap<String, IElementType>();
    private static final Map<IElementType, String> KEYWORD_TYPE_TO_NAME_MAP;
    private volatile ModifierCache myModifierCache;

    public PsiModifierListImpl(PsiModifierListStub stub) {
        super(stub, JavaStubElementTypes.MODIFIER_LIST);
    }

    public PsiModifierListImpl(ASTNode node) {
        super(node);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        ModifierCache modifierCache;
        if (name == null) {
            PsiModifierListImpl.$$$reportNull$$$0(0);
        }
        if ((modifierCache = this.myModifierCache) == null || !modifierCache.isUpToDate()) {
            this.myModifierCache = modifierCache = this.calcModifiers();
        }
        return modifierCache.modifiers.contains(name);
    }

    private ModifierCache calcModifiers() {
        Set<String> modifiers = this.calcExplicitModifiers();
        modifiers.addAll(this.calcImplicitModifiers(modifiers));
        if (!(modifiers.contains("public") || modifiers.contains("protected") || modifiers.contains("private"))) {
            modifiers.add("packageLocal");
        }
        PsiFile file = this.getContainingFile();
        return new ModifierCache(file, PsiAugmentProvider.transformModifierProperties(this, file.getProject(), modifiers));
    }

    private Set<String> calcExplicitModifiers() {
        HashSet<String> explicitModifiers = new HashSet<String>();
        PsiModifierListStub stub = (PsiModifierListStub)this.getGreenStub();
        if (stub != null) {
            int mask = stub.getModifiersMask();
            for (int i = 0; i < 31; ++i) {
                int flag = 1 << i;
                if (!BitUtil.isSet((int)mask, (int)flag)) continue;
                ContainerUtil.addIfNotNull(explicitModifiers, (Object)((String)ModifierFlags.MODIFIER_FLAG_TO_NAME_MAP.get(flag)));
            }
        } else {
            for (ASTNode child : this.getNode().getChildren(null)) {
                ContainerUtil.addIfNotNull(explicitModifiers, (Object)KEYWORD_TYPE_TO_NAME_MAP.get(child.getElementType()));
            }
        }
        return explicitModifiers;
    }

    private Set<String> calcImplicitModifiers(Set<String> explicitModifiers) {
        HashSet<String> implicitModifiers = new HashSet<String>();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            PsiElement grandParent = parent.getContext();
            if (grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface()) {
                Collections.addAll(implicitModifiers, "public", "static");
            }
            if (aClass.isInterface()) {
                implicitModifiers.add("abstract");
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
            } else if (explicitModifiers.contains("value") && !explicitModifiers.contains("abstract")) {
                implicitModifiers.add("final");
            }
            if (aClass.isRecord()) {
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
                implicitModifiers.add("final");
            }
            if (aClass.isEnum()) {
                boolean hasSubClass;
                if (!(grandParent instanceof PsiFile)) {
                    implicitModifiers.add("static");
                }
                List<PsiField> fields = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnFields() : Arrays.asList(aClass.getFields());
                Condition condition = field -> field instanceof PsiEnumConstant && ((PsiEnumConstant)field).getInitializingClass() != null;
                boolean bl = hasSubClass = ContainerUtil.find(fields, (Condition)condition) != null;
                if (hasSubClass) {
                    implicitModifiers.add("sealed");
                } else {
                    implicitModifiers.add("final");
                }
                List<PsiMethod> methods = parent instanceof PsiExtensibleClass ? ((PsiExtensibleClass)parent).getOwnMethods() : Arrays.asList(aClass.getMethods());
                for (PsiMethod method : methods) {
                    if (!method.hasModifierProperty("abstract")) continue;
                    implicitModifiers.add("abstract");
                    break;
                }
            }
        } else if (parent instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)parent).getContainingClass();
            if (aClass != null && aClass.isInterface()) {
                if (!explicitModifiers.contains("private")) {
                    implicitModifiers.add("public");
                    if (!explicitModifiers.contains("default") && !explicitModifiers.contains("static")) {
                        implicitModifiers.add("abstract");
                    }
                }
            } else if (aClass != null && aClass.isEnum() && ((PsiMethod)parent).isConstructor()) {
                implicitModifiers.add("private");
            }
        } else if (parent instanceof PsiRecordComponent) {
            implicitModifiers.add("final");
        } else if (parent instanceof PsiField) {
            if (parent instanceof PsiEnumConstant) {
                Collections.addAll(implicitModifiers, "public", "static", "final");
            } else {
                PsiClass aClass = ((PsiField)parent).getContainingClass();
                if (aClass != null) {
                    if (aClass.isInterface()) {
                        Collections.addAll(implicitModifiers, "public", "static", "final");
                    } else if (aClass.isValueClass()) {
                        implicitModifiers.add("final");
                    }
                }
            }
        } else if (parent instanceof PsiParameter && parent.getParent() instanceof PsiCatchSection && ((PsiParameter)parent).getType() instanceof PsiDisjunctionType) {
            Collections.addAll(implicitModifiers, "final");
        } else if (parent instanceof PsiResourceVariable) {
            Collections.addAll(implicitModifiers, "final");
        }
        return implicitModifiers;
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        PsiModifierListStub stub;
        if (name == null) {
            PsiModifierListImpl.$$$reportNull$$$0(1);
        }
        if ((stub = (PsiModifierListStub)this.getGreenStub()) != null) {
            return BitUtil.isSet((int)stub.getModifiersMask(), (int)ModifierFlags.NAME_TO_MODIFIER_FLAG_MAP.getInt((Object)name));
        }
        CompositeElement tree = (CompositeElement)this.getNode();
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        return type != null && tree.findChildByType(type) != null;
    }

    @Override
    public void setModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        PsiMethod method;
        ASTNode node;
        if (name == null) {
            PsiModifierListImpl.$$$reportNull$$$0(2);
        }
        this.checkSetModifierProperty(name, value);
        PsiElement parent = this.getParent();
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        IElementType type = NAME_TO_KEYWORD_TYPE_MAP.get(name);
        CompositeElement treeElement = (CompositeElement)this.getNode();
        if (parent instanceof PsiMethod && (node = (method = (PsiMethod)parent).getParameterList().getNode()) != null) {
            CodeEditUtil.markToReformat((ASTNode)node, (boolean)true);
        }
        if (value) {
            if (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.PRIVATE_KEYWORD || type == JavaTokenType.PROTECTED_KEYWORD || type == null) {
                if (type != JavaTokenType.PUBLIC_KEYWORD) {
                    this.setModifierProperty("public", false);
                }
                if (type != JavaTokenType.PRIVATE_KEYWORD) {
                    this.setModifierProperty("private", false);
                }
                if (type != JavaTokenType.PROTECTED_KEYWORD) {
                    this.setModifierProperty("protected", false);
                }
                if (type == null) {
                    return;
                }
            }
            if (type == JavaTokenType.SEALED_KEYWORD || type == JavaTokenType.FINAL_KEYWORD || type == JavaTokenType.NON_SEALED_KEYWORD) {
                if (type != JavaTokenType.SEALED_KEYWORD) {
                    this.setModifierProperty("sealed", false);
                }
                if (type != JavaTokenType.NON_SEALED_KEYWORD) {
                    this.setModifierProperty("non-sealed", false);
                }
                if (type != JavaTokenType.FINAL_KEYWORD) {
                    this.setModifierProperty("final", false);
                }
            }
            if (parent instanceof PsiField && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.STATIC_KEYWORD || type == JavaTokenType.FINAL_KEYWORD : (parent instanceof PsiMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD : (parent instanceof PsiClass && grandParent instanceof PsiClass && ((PsiClass)grandParent).isInterface() ? type == JavaTokenType.PUBLIC_KEYWORD : parent instanceof PsiAnnotationMethod && grandParent instanceof PsiClass && ((PsiClass)grandParent).isAnnotationType() && (type == JavaTokenType.PUBLIC_KEYWORD || type == JavaTokenType.ABSTRACT_KEYWORD)))) {
                return;
            }
            if (treeElement.findChildByType(type) == null) {
                LeafElement keyword = Factory.createSingleLeafElement((IElementType)type, (CharSequence)name, null, (PsiManager)this.getManager());
                treeElement.addInternal((TreeElement)keyword, (ASTNode)keyword, null, null);
            }
        } else {
            if (type == null) {
                throw new IncorrectOperationException("Cannot reset package-private modifier.");
            }
            ASTNode child = treeElement.findChildByType(type);
            if (child != null) {
                SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)child).delete();
            }
        }
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            PsiModifierListImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable((PsiElement)this);
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        Object[] own = (PsiAnnotation[])this.getStubOrPsiChildren(JavaStubElementTypes.ANNOTATION, PsiAnnotation.ARRAY_FACTORY);
        List<PsiAnnotation> ext = PsiAugmentProvider.collectAugments(this, PsiAnnotation.class, null);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])ArrayUtil.mergeArrayAndCollection((Object[])own, ext, PsiAnnotation.ARRAY_FACTORY);
        if (psiAnnotationArray == null) {
            PsiModifierListImpl.$$$reportNull$$$0(4);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean hasAnnotations() {
        return this.getStubOrPsiChild(JavaStubElementTypes.ANNOTATION) != null || !PsiAugmentProvider.collectAugments(this, PsiAnnotation.class, null).isEmpty();
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation.TargetType[] targets = AnnotationTargetUtil.getTargetsForLocation(this);
        List filtered = ContainerUtil.findAll((Object[])this.getAnnotations(), annotation -> {
            PsiAnnotation.TargetType target = AnnotationTargetUtil.findAnnotationTarget(annotation, targets);
            return target != null && target != PsiAnnotation.TargetType.UNKNOWN;
        });
        PsiAnnotation[] psiAnnotationArray = filtered.toArray(PsiAnnotation.EMPTY_ARRAY);
        if (psiAnnotationArray == null) {
            PsiModifierListImpl.$$$reportNull$$$0(5);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiModifierListImpl.$$$reportNull$$$0(6);
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            PsiModifierListImpl.$$$reportNull$$$0(7);
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)this.addAfter(JavaPsiFacade.getElementFactory(this.getProject()).createAnnotationFromText("@" + qualifiedName, this), null);
        if (psiAnnotation == null) {
            PsiModifierListImpl.$$$reportNull$$$0(8);
        }
        return psiAnnotation;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiModifierListImpl.$$$reportNull$$$0(9);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiModifierList:" + this.getText();
    }

    static {
        NAME_TO_KEYWORD_TYPE_MAP.put("public", JavaTokenType.PUBLIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("protected", JavaTokenType.PROTECTED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("private", JavaTokenType.PRIVATE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("static", JavaTokenType.STATIC_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("abstract", JavaTokenType.ABSTRACT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("final", JavaTokenType.FINAL_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("native", JavaTokenType.NATIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("synchronized", JavaTokenType.SYNCHRONIZED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("strictfp", JavaTokenType.STRICTFP_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transient", JavaTokenType.TRANSIENT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("volatile", JavaTokenType.VOLATILE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("default", JavaTokenType.DEFAULT_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("open", JavaTokenType.OPEN_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("transitive", JavaTokenType.TRANSITIVE_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("sealed", JavaTokenType.SEALED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("non-sealed", JavaTokenType.NON_SEALED_KEYWORD);
        NAME_TO_KEYWORD_TYPE_MAP.put("value", JavaTokenType.VALUE_KEYWORD);
        KEYWORD_TYPE_TO_NAME_MAP = new HashMap<IElementType, String>();
        for (String name : NAME_TO_KEYWORD_TYPE_MAP.keySet()) {
            KEYWORD_TYPE_TO_NAME_MAP.put(NAME_TO_KEYWORD_TYPE_MAP.get(name), name);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiModifierListImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiModifierListImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModifierCache {
        private static final Interner<List<String>> ourInterner = Interner.createWeakInterner();
        private final PsiFile file;
        private final List<String> modifiers;
        private final int modCount;

        ModifierCache(@NotNull PsiFile file, @NotNull Set<String> modifiers) {
            if (file == null) {
                ModifierCache.$$$reportNull$$$0(0);
            }
            if (modifiers == null) {
                ModifierCache.$$$reportNull$$$0(1);
            }
            this.file = file;
            List modifierList = ContainerUtil.sorted(modifiers);
            this.modifiers = (List)ourInterner.intern((Object)modifierList);
            this.modCount = this.getModCount();
        }

        private int getModCount() {
            return (int)(this.file.getManager().getModificationTracker().getModificationCount() + this.file.getModificationStamp());
        }

        boolean isUpToDate() {
            return this.getModCount() == this.modCount;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modifiers";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/impl/source/PsiModifierListImpl$ModifierCache";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

