/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiAssertStatementImpl
extends CompositePsiElement
implements PsiAssertStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiAssertStatementImpl.class);

    public PsiAssertStatementImpl() {
        super(ASSERT_STATEMENT);
    }

    @Override
    public PsiExpression getAssertCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiExpression getAssertDescription() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(117);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 116: {
                return this.findChildByType(ASSERT_KEYWORD);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
            case 117: {
                ASTNode child;
                ASTNode colon = this.findChildByRole(87);
                if (colon == null) {
                    return null;
                }
                for (child = colon.getTreeNext(); child != null && !EXPRESSION_BIT_SET.contains(child.getElementType()); child = child.getTreeNext()) {
                }
                return child;
            }
            case 22: {
                return this.findChildByType(SEMICOLON);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiAssertStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == ASSERT_KEYWORD) {
            return 116;
        }
        if (i == COLON) {
            return 87;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            int role = this.getChildRole(child, 32);
            if (role != 0) {
                return role;
            }
            return 117;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAssertStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAssertStatement(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiAssertStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiAssertStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

