/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.impl.PsiLiteralStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.util.text.LiteralFormatUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralExpressionImpl
extends JavaStubPsiElement<PsiLiteralStub>
implements PsiLiteralExpression,
PsiLanguageInjectionHost,
ContributedReferenceHost {
    private static final TokenSet NUMERIC_LITERALS = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.INTEGER_LITERALS, ElementType.REAL_LITERALS});

    public PsiLiteralExpressionImpl(@NotNull PsiLiteralStub stub) {
        if (stub == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, JavaStubElementTypes.LITERAL_EXPRESSION);
    }

    public PsiLiteralExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(node);
    }

    @Override
    public PsiElement @NotNull [] getChildren() {
        PsiElement[] psiElementArray = ((CompositeElement)this.getNode()).getChildrenAsPsiElements((TokenSet)null, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @Override
    public PsiType getType() {
        IElementType type = this.getLiteralElementType();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            return PsiTypes.intType();
        }
        if (type == JavaTokenType.LONG_LITERAL) {
            return PsiTypes.longType();
        }
        if (type == JavaTokenType.FLOAT_LITERAL) {
            return PsiTypes.floatType();
        }
        if (type == JavaTokenType.DOUBLE_LITERAL) {
            return PsiTypes.doubleType();
        }
        if (type == JavaTokenType.CHARACTER_LITERAL) {
            return PsiTypes.charType();
        }
        if (ElementType.STRING_LITERALS.contains(type)) {
            PsiFile file = this.getContainingFile();
            return PsiType.getJavaLangString(file.getManager(), ResolveScopeManager.getElementResolveScope((PsiElement)file)).withNullability(TypeNullability.NOT_NULL_MANDATED);
        }
        if (type == JavaTokenType.TRUE_KEYWORD || type == JavaTokenType.FALSE_KEYWORD) {
            return PsiTypes.booleanType();
        }
        if (type == JavaTokenType.NULL_KEYWORD) {
            return PsiTypes.nullType();
        }
        return null;
    }

    @Override
    public boolean isTextBlock() {
        return this.getLiteralElementType() == JavaTokenType.TEXT_BLOCK_LITERAL;
    }

    public IElementType getLiteralElementType() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralType();
        }
        return this.getNode().getFirstChildNode().getElementType();
    }

    public String getCanonicalText() {
        IElementType type = this.getLiteralElementType();
        return NUMERIC_LITERALS.contains(type) ? LiteralFormatUtil.removeUnderscores(this.getText()) : this.getText();
    }

    public String getText() {
        PsiLiteralStub stub = (PsiLiteralStub)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralText();
        }
        return super.getText();
    }

    public Object getValue() {
        IElementType type = this.getLiteralElementType();
        if (type == JavaTokenType.TRUE_KEYWORD) {
            return Boolean.TRUE;
        }
        if (type == JavaTokenType.FALSE_KEYWORD) {
            return Boolean.FALSE;
        }
        if (type == JavaTokenType.STRING_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(PsiLiteralUtil.getStringLiteralContent(this));
        }
        if (type == JavaTokenType.TEXT_BLOCK_LITERAL) {
            return PsiLiteralExpressionImpl.internedParseStringCharacters(PsiLiteralUtil.getTextBlockText(this));
        }
        String text = NUMERIC_LITERALS.contains(type) ? StringUtil.toLowerCase((String)this.getCanonicalText()) : this.getCanonicalText();
        int textLength = text.length();
        if (type == JavaTokenType.INTEGER_LITERAL) {
            return PsiLiteralUtil.parseInteger(text);
        }
        if (type == JavaTokenType.LONG_LITERAL) {
            return PsiLiteralUtil.parseLong(text);
        }
        if (type == JavaTokenType.FLOAT_LITERAL) {
            return PsiLiteralUtil.parseFloat(text);
        }
        if (type == JavaTokenType.DOUBLE_LITERAL) {
            return PsiLiteralUtil.parseDouble(text);
        }
        if (type == JavaTokenType.CHARACTER_LITERAL) {
            if (textLength == 1 || !StringUtil.endsWithChar((CharSequence)text, (char)'\'')) {
                return null;
            }
            CharSequence chars = CodeInsightUtilCore.parseStringCharacters((String)(text = text.substring(1, textLength - 1)), null);
            if (chars == null) {
                return null;
            }
            if (chars.length() != 1) {
                return null;
            }
            return Character.valueOf(chars.charAt(0));
        }
        return null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public String getInnerText() {
        return PsiLiteralUtil.getStringLiteralContent(this);
    }

    @Nullable
    private static String internedParseStringCharacters(String chars) {
        if (chars == null) {
            return null;
        }
        CharSequence outChars = CodeInsightUtilCore.parseStringCharacters((String)chars, null);
        return outChars == null ? null : outChars.toString();
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, int @Nullable [] sourceOffsets) {
        if (chars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (outChars == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return CodeInsightUtilCore.parseStringCharacters((String)chars, (StringBuilder)outChars, (int[])sourceOffsets);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitLiteralExpression(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiLiteralExpression:" + this.getText();
    }

    public boolean isValidHost() {
        return ElementType.TEXT_LITERALS.contains(this.getLiteralElementType());
    }

    public PsiReference @NotNull [] getReferences() {
        IElementType type = this.getLiteralElementType();
        PsiReference[] psiReferenceArray = ElementType.STRING_LITERALS.contains(type) || type == JavaTokenType.INTEGER_LITERAL ? PsiReferenceService.getService().getContributedReferences((PsiElement)this) : PsiReference.EMPTY_ARRAY;
        if (psiReferenceArray == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiReferenceArray;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            PsiLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<PsiLiteralExpressionImpl> createLiteralTextEscaper() {
        return new StringLiteralEscaper<PsiLiteralExpressionImpl>(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

