/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.PsiSwitchLabelStatementBaseImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSwitchLabelStatementImpl
extends PsiSwitchLabelStatementBaseImpl
implements PsiSwitchLabelStatement {
    private static final Logger LOG = Logger.getInstance(PsiSwitchLabelStatementImpl.class);

    public PsiSwitchLabelStatementImpl() {
        super(JavaElementType.SWITCH_LABEL_STATEMENT);
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 84: {
                return this.findChildByType(JavaTokenType.CASE_KEYWORD);
            }
            case 85: {
                return this.findChildByType(JavaTokenType.DEFAULT_KEYWORD);
            }
            case 86: {
                return this.findChildByType(ElementType.EXPRESSION_BIT_SET);
            }
            case 87: {
                return this.findChildByType(JavaTokenType.COLON);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.CASE_KEYWORD) {
            return 84;
        }
        if (i == JavaTokenType.DEFAULT_KEYWORD) {
            return 85;
        }
        if (i == JavaTokenType.COLON) {
            return 87;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 86;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSwitchLabelStatement(this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiSwitchLabelStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(4);
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        return !this.shouldAnalyzePatternVariablesInCaseLabel(place) || this.processPatternVariables(processor, state, place);
    }

    private boolean shouldAnalyzePatternVariablesInCaseLabel(@NotNull PsiElement place) {
        if (place == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(5);
        }
        if (place instanceof PsiCodeBlock) {
            return true;
        }
        boolean patternInSwitch = PsiUtil.isAvailable(JavaFeature.PATTERNS_IN_SWITCH, place);
        AtomicBoolean thisSwitchLabelIsImmediate = new AtomicBoolean();
        PsiTreeUtil.treeWalkUp((PsiElement)place, (PsiElement)this.getParent(), (currentScope, __) -> {
            PsiSwitchLabelStatementBase immediateSwitchLabel = currentScope instanceof PsiSwitchLabelStatementBase ? (PsiSwitchLabelStatementBase)currentScope : (PsiSwitchLabelStatementBase)PsiTreeUtil.getPrevSiblingOfType((PsiElement)currentScope, PsiSwitchLabelStatementBase.class);
            while (immediateSwitchLabel != null && !patternInSwitch && PsiTreeUtil.getPrevSiblingOfType((PsiElement)immediateSwitchLabel, PsiStatement.class) instanceof PsiSwitchLabelStatementBase && PsiSwitchLabelStatementImpl.isCaseNull(immediateSwitchLabel)) {
                immediateSwitchLabel = (PsiSwitchLabelStatementBase)PsiTreeUtil.getPrevSiblingOfType((PsiElement)immediateSwitchLabel, PsiSwitchLabelStatementBase.class);
            }
            if (immediateSwitchLabel == this) {
                thisSwitchLabelIsImmediate.set(true);
                return false;
            }
            return true;
        });
        return thisSwitchLabelIsImmediate.get();
    }

    private static boolean isCaseNull(@NotNull PsiSwitchLabelStatementBase switchCaseLabel) {
        if (switchCaseLabel == null) {
            PsiSwitchLabelStatementImpl.$$$reportNull$$$0(6);
        }
        if (switchCaseLabel.getCaseLabelElementList() == null) {
            return false;
        }
        PsiCaseLabelElement[] elements = switchCaseLabel.getCaseLabelElementList().getElements();
        if (elements.length != 1) {
            return false;
        }
        return elements[0].getNode().getFirstChildNode().getElementType() == JavaTokenType.NULL_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchCaseLabel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiSwitchLabelStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldAnalyzePatternVariablesInCaseLabel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCaseNull";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

