/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483618)
@ApiStatus.Internal
public final class ModuleDependencyDataService
extends AbstractDependencyDataService<ModuleDependencyData, ModuleOrderEntry> {
    private static final Logger LOG = Logger.getInstance(ModuleDependencyDataService.class);

    @NotNull
    public Key<ModuleDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE_DEPENDENCY;
        if (key == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    @NotNull
    public Class<ModuleOrderEntry> getOrderEntryType() {
        return ModuleOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleOrderEntry orderEntry) {
        if (modelsProvider == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(1);
        }
        if (orderEntry == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(2);
        }
        String moduleName = orderEntry.getModuleName();
        Module orderEntryModule = orderEntry.getModule();
        if (orderEntryModule != null) {
            moduleName = modelsProvider.getModifiableModuleModel().getActualName(orderEntryModule);
        }
        return moduleName;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<? extends DataNode<ModuleDependencyData>> toImport, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(5);
        }
        HashMap<Pair, ModuleOrderEntry> toRemove = new HashMap<Pair, ModuleOrderEntry>();
        LinkedHashMap<OrderEntry, OrderAware> orderEntryDataMap = new LinkedHashMap<OrderEntry, OrderAware>();
        ArrayList<ModuleOrderEntry> duplicatesToRemove = new ArrayList<ModuleOrderEntry>();
        for (OrderEntry orderEntry : modelsProvider.getOrderEntries(module)) {
            if (!(orderEntry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry e = (ModuleOrderEntry)orderEntry;
            Pair key = Pair.create((Object)e.getModuleName(), (Object)e.getScope());
            if (toRemove.containsKey(key)) {
                duplicatesToRemove.add(e);
                continue;
            }
            toRemove.put(key, e);
        }
        HashSet<ModuleDependencyData> processed = new HashSet<ModuleDependencyData>();
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (DataNode<ModuleDependencyData> dataNode : toImport) {
            ModuleOrderEntry orderEntry;
            ModuleDependencyData dependencyData = (ModuleDependencyData)dataNode.getData();
            if (processed.contains(dependencyData)) continue;
            processed.add(dependencyData);
            ModuleData moduleData = (ModuleData)dependencyData.getTarget();
            Module ideDependencyModule = modelsProvider.findIdeModule(moduleData);
            if (ideDependencyModule != null) {
                String targetModuleName = ideDependencyModule.getName();
                toRemove.remove(Pair.create((Object)targetModuleName, (Object)dependencyData.getScope()));
                dependencyData.setInternalName(targetModuleName);
            }
            if (module.equals((Object)ideDependencyModule)) continue;
            if (ideDependencyModule == null) {
                LOG.warn(String.format("Can't import module dependency for '%s' module. Reason: target module (%s) is not found at the ide", module.getName(), dependencyData));
            }
            if ((orderEntry = modelsProvider.findIdeModuleDependency(dependencyData, module)) == null) {
                orderEntry = (ModuleOrderEntry)ReadAction.compute(() -> ideDependencyModule == null ? modifiableRootModel.addInvalidModuleEntry(moduleData.getInternalName()) : modifiableRootModel.addModuleOrderEntry(ideDependencyModule));
            }
            orderEntry.setScope(dependencyData.getScope());
            orderEntry.setExported(dependencyData.isExported());
            orderEntry.setProductionOnTestDependency(dependencyData.isProductionOnTestDependency());
            orderEntryDataMap.put((OrderEntry)orderEntry, (OrderAware)dependencyData);
        }
        if (!toRemove.isEmpty() || !duplicatesToRemove.isEmpty()) {
            Collection orderEntries = ContainerUtil.toCollection((Iterable)ContainerUtil.concat(duplicatesToRemove, toRemove.values()));
            this.removeData(orderEntries, module, modelsProvider);
        }
        return orderEntryDataMap;
    }

    @Override
    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toRemove == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(6);
        }
        if (module == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(7);
        }
        if (modelsProvider == null) {
            ModuleDependencyDataService.$$$reportNull$$$0(8);
        }
        List filteredList = ContainerUtil.filter(toRemove, o -> {
            if (o instanceof ModuleOrderEntry) {
                String moduleName = ((ModuleOrderEntry)o).getModuleName();
                return ModuleManager.getInstance((Project)module.getProject()).getUnloadedModuleDescription(moduleName) == null;
            }
            return true;
        });
        super.removeData(filteredList, module, modelsProvider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntryName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

