/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.jetbrains.rd.ide.editor.markup.ExtendedBackendProperties;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.HighlighterElement;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.FrontendHighlighterExtensionHandler;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00100\u001c2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010#\u001a\u00020\u00102\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018H\u0016J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH\u0016J'\u0010-\u001a\u0004\u0018\u0001H.\"\b\b\u0000\u0010.*\u00020,2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0016\u00a2\u0006\u0002\u00101R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\u0012038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0019\u00106\u001a\u000707\u00a2\u0006\u0002\b8X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020<X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>\u00a8\u0006@"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapter;", "rdMarkupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "<init>", "(Lcom/jetbrains/rd/ide/model/RdMarkupModel;Lcom/intellij/openapi/editor/ex/MarkupModelEx;Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;)V", "getIdeaMarkup$intellij_rd_client", "()Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "listeners", "", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "updateHighlighter", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "newElement", "Lcom/jetbrains/rd/ide/model/HighlighterElement;", "addHighlighter", "element", "getHighlighters", "", "offset", "", "changeAttributeAction", "Lkotlin/Function1;", "getHandler", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "newModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "getHandler$intellij_rd_client", "removeHighlighter", "bulkRemoveHighlighters", "highlighters", "bulkAddHighlighters", "elements", "addListener", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "listener", "extensions", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "getExtension", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "allHighlighters", "", "getAllHighlighters", "()[Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "daemonModel", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "getDaemonModel", "()Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendMarkupAdapterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMarkupAdapterImpl.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,147:1\n82#2,2:148\n67#2,4:150\n67#2,4:154\n84#2:158\n82#2,2:159\n67#2,4:161\n84#2:165\n82#2,2:166\n67#2,4:169\n84#2:173\n82#2,3:174\n82#2,3:191\n82#2,3:212\n13#2:215\n1#3:168\n1#3:188\n1#3:207\n1642#4,10:177\n1915#4:187\n1916#4:189\n1652#4:190\n296#4,2:194\n12033#5,10:196\n14060#5:206\n14061#5:208\n12043#5:209\n37#6,2:210\n*S KotlinDebug\n*F\n+ 1 FrontendMarkupAdapterImpl.kt\ncom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl\n*L\n38#1:148,2\n40#1:150,4\n44#1:154,4\n38#1:158\n57#1:159,2\n63#1:161,4\n57#1:165\n101#1:166,2\n103#1:169,4\n101#1:173\n111#1:174,3\n121#1:191,3\n82#1:212,3\n32#1:215\n119#1:188\n141#1:207\n119#1:177,10\n119#1:187\n119#1:189\n119#1:190\n137#1:194,2\n141#1:196,10\n141#1:206\n141#1:208\n141#1:209\n141#1:210,2\n*E\n"})
public class FrontendMarkupAdapterImpl
implements FrontendMarkupAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkupModelEx ideaMarkup;
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final List<FrontendMarkupAdapterListener> listeners;
    @NotNull
    private final List<MarkupModelExtension> extensions;
    @NotNull
    private final Document document;
    @NotNull
    private final RdDaemonModel daemonModel;
    @NotNull
    private static final Logger logger;

    public FrontendMarkupAdapterImpl(@NotNull RdMarkupModel rdMarkupModel, @NotNull MarkupModelEx ideaMarkup, @NotNull CompoundHighlighterModelsHandler compoundHandler) {
        Intrinsics.checkNotNullParameter((Object)rdMarkupModel, (String)"rdMarkupModel");
        Intrinsics.checkNotNullParameter((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        this.ideaMarkup = ideaMarkup;
        this.compoundHandler = compoundHandler;
        this.listeners = new ArrayList();
        this.extensions = rdMarkupModel.getExtensions();
        Document document = this.ideaMarkup.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.document = document;
        this.daemonModel = rdMarkupModel.getDaemon();
    }

    @NotNull
    public final MarkupModelEx getIdeaMarkup$intellij_rd_client() {
        return this.ideaMarkup;
    }

    @Override
    public void updateHighlighter(@NotNull RangeHighlighterEx highlighter, @NotNull HighlighterElement newElement) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            if (!highlighter.isValid()) {
                Logger $this$trace$iv = FrontendMarkupAdapterImpl.logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv;
                    boolean bl3 = false;
                    logger2.trace("Skipping update of invalid highlighter " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter));
                }
                return;
            }
            HighlighterModel newModel = newElement.getHighlighter();
            Logger $this$trace$iv = FrontendMarkupAdapterImpl.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger3 = $this$trace$iv;
                boolean bl4 = false;
                logger3.trace("Updating highlighter " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter));
            }
            this.ideaMarkup.changeAttributesInBatch(highlighter, arg_0 -> FrontendMarkupAdapterImpl.updateHighlighter$lambda$0$2(this.changeAttributeAction(newElement), arg_0));
            FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> FrontendMarkupAdapterImpl.updateHighlighter$lambda$0$4(arg_0 -> FrontendMarkupAdapterImpl.updateHighlighter$lambda$0$3(highlighter, newModel, newElement, arg_0), arg_0));
            for (FrontendMarkupAdapterListener listener2 : this.listeners) {
                listener2.afterUpdated(highlighter);
            }
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addHighlighter(@NotNull HighlighterElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            HighlighterModel model2 = element.getHighlighter();
            int start = model2.getStart();
            int end = model2.getEnd();
            int layer = model2.getLayer();
            HighlighterTargetArea targetArea = HighlightersUtilKt.toIdeaTargetArea(model2);
            Logger $this$trace$iv = FrontendMarkupAdapterImpl.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl3 = false;
                logger2.trace("Registering new highlighter '" + model2.getProperties().getAttributeId() + "', model: " + HighlightersUtilKt.prettyPrint(model2));
            }
            RangeHighlighterEx rangeHighlighterEx = this.ideaMarkup.addRangeHighlighterAndChangeAttributes(null, start, end, layer, targetArea, false, arg_0 -> FrontendMarkupAdapterImpl.addHighlighter$lambda$0$1(this.changeAttributeAction(element), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
            RangeHighlighterEx rangeHighlighter = rangeHighlighterEx;
            return rangeHighlighter;
        }
        catch (Throwable throwable) {
            return (RangeHighlighterEx)LoggerKt.getOrLogException((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)), (Logger)$this$runAndLogException$iv);
        }
    }

    @Override
    @NotNull
    public List<RangeHighlighterEx> getHighlighters(int offset) {
        List result2 = new ArrayList();
        this.ideaMarkup.processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> FrontendMarkupAdapterImpl.getHighlighters$lambda$1(arg_0 -> FrontendMarkupAdapterImpl.getHighlighters$lambda$0(result2, arg_0), arg_0));
        return result2;
    }

    private final Function1<RangeHighlighterEx, Unit> changeAttributeAction(HighlighterElement newElement) {
        return arg_0 -> FrontendMarkupAdapterImpl.changeAttributeAction$lambda$0(newElement, this, arg_0);
    }

    @NotNull
    public final IProtocolHighlighterModelHandler getHandler$intellij_rd_client(@NotNull HighlighterModel newModel) {
        Intrinsics.checkNotNullParameter((Object)newModel, (String)"newModel");
        return this.compoundHandler.getHandler(newModel);
    }

    @Override
    public void removeHighlighter(@NotNull RangeHighlighterEx highlighter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            boolean bl;
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = bl = HighlightersUtilKt.getBackendAttributeId((RangeHighlighter)highlighter) != null;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-FrontendMarkupAdapterImpl$removeHighlighter$1$22 = false;
                String $i$a$-assert-FrontendMarkupAdapterImpl$removeHighlighter$1$22 = "Removing highlighter hasn't been registered by markup adapter";
                throw new AssertionError((Object)$i$a$-assert-FrontendMarkupAdapterImpl$removeHighlighter$1$22);
            }
            Logger $this$trace$iv = FrontendMarkupAdapterImpl.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl5 = false;
                logger2.trace("Removed highlighter from markup: " + HighlightersUtilKt.prettyPrint((RangeHighlighter)highlighter));
            }
            Object object2 = UtilKt.getHandler((RangeHighlighter)((RangeHighlighter)highlighter));
            IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler = object2 instanceof IProtocolHighlighterModelHandler ? (IProtocolHighlighterModelHandler)object2 : null;
            if (iProtocolHighlighterModelHandler != null) {
                iProtocolHighlighterModelHandler.deinitialize((RangeHighlighter)highlighter);
            }
            this.ideaMarkup.removeHighlighter((RangeHighlighter)highlighter);
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    @Override
    public void bulkRemoveHighlighters(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        for (FrontendMarkupAdapterListener frontendMarkupAdapterListener : this.listeners) {
            Object object;
            Logger $this$runAndLogException$iv = logger;
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                frontendMarkupAdapterListener.beforeBulkRemove(highlighters);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
        for (RangeHighlighterEx rangeHighlighterEx : highlighters) {
            this.removeHighlighter(rangeHighlighterEx);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<RangeHighlighterEx> bulkAddHighlighters(@NotNull List<HighlighterElement> elements) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$mapNotNull$iv = elements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RangeHighlighterEx it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            HighlighterElement it = (HighlighterElement)element$iv$iv;
            boolean bl2 = false;
            if (this.addHighlighter(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List added = (List)destination$iv$iv;
        for (FrontendMarkupAdapterListener listener2 : this.listeners) {
            Object object;
            Logger $this$runAndLogException$iv = logger;
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl4 = false;
                listener2.afterBulkAdd(added);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
        return added;
    }

    @Override
    public void addListener(@NotNull Lifetime lifetime, @NotNull FrontendMarkupAdapterListener listener2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        CollectionExKt.addUnique((Collection)this.listeners, (Lifetime)lifetime, (Object)listener2);
        String string = Reflection.getOrCreateKotlinClass(FrontendMarkupAdapterListener.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)lifetime, (String)string);
        this.ideaMarkup.addMarkupModelListener(disposable, (MarkupModelListener)listener2);
    }

    @Override
    @Nullable
    public <T extends MarkupModelExtension> T getExtension(@NotNull Key<T> key) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Iterable $this$firstOrNull$iv = this.extensions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MarkupModelExtension it = (MarkupModelExtension)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKey(), (Object)key.toString())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Object var2_8 = v0;
        return (T)(var2_8 instanceof MarkupModelExtension ? (MarkupModelExtension)var2_8 : null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RangeHighlighterEx[] getAllHighlighters() {
        void $this$mapNotNullTo$iv$iv;
        RangeHighlighter[] rangeHighlighterArray = this.ideaMarkup.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$mapNotNull$iv = rangeHighlighterArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            RangeHighlighterEx it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if ((HighlightersUtilKt.isFromBackend(it) ? (it instanceof RangeHighlighterEx ? (RangeHighlighterEx)it : null) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new RangeHighlighterEx[0]);
    }

    @Override
    @NotNull
    public Document getDocument() {
        return this.document;
    }

    @Override
    @NotNull
    public RdDaemonModel getDaemonModel() {
        return this.daemonModel;
    }

    private static final void updateHighlighter$lambda$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit updateHighlighter$lambda$0$3(RangeHighlighterEx $highlighter, HighlighterModel $newModel, HighlighterElement $newElement, FrontendHighlighterExtensionHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.processExtension($highlighter, $newModel, $newElement.getExtensions());
        return Unit.INSTANCE;
    }

    private static final void updateHighlighter$lambda$0$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void addHighlighter$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean getHighlighters$lambda$0(List $result, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        if (HighlightersUtilKt.isFromBackend((RangeHighlighter)it)) {
            $result.add(it);
        }
        return true;
    }

    private static final boolean getHighlighters$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit changeAttributeAction$lambda$0$0$0(RangeHighlighterEx $highlighter, HighlighterModel $newModel, HighlighterElement $newElement, FrontendHighlighterExtensionHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.processExtension($highlighter, $newModel, $newElement.getExtensions());
        return Unit.INSTANCE;
    }

    private static final void changeAttributeAction$lambda$0$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit changeAttributeAction$lambda$0(HighlighterElement $newElement, FrontendMarkupAdapterImpl this$0, RangeHighlighterEx highlighter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            HighlighterModel newModel = $newElement.getHighlighter();
            highlighter.setGreedyToLeft(newModel.isGreedyToLeft());
            highlighter.setGreedyToRight(newModel.isGreedyToRight());
            highlighter.setThinErrorStripeMark(newModel.isThinErrorStripeMark());
            highlighter.setVisibleIfFolded(newModel.getProperties().isVisibleIfFolded());
            IProtocolHighlighterModelHandler handler = this$0.getHandler$intellij_rd_client(newModel);
            handler.initialize(newModel, (RangeHighlighter)highlighter);
            UtilKt.setExtendedBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter), (ExtendedBackendProperties)new ExtendedBackendProperties(newModel.getProperties(), newModel.getId(), (Object)handler, false, 8, null));
            FrontendHighlighterExtensionHandler.Companion.getEP_NAME().forEachExtensionSafe(arg_0 -> FrontendMarkupAdapterImpl.changeAttributeAction$lambda$0$0$1(arg_0 -> FrontendMarkupAdapterImpl.changeAttributeAction$lambda$0$0$0(highlighter, newModel, $newElement, arg_0), arg_0));
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendMarkupAdapterImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendMarkupAdapterImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

