/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.renderedDocs;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.MutableDocRenderItem;
import com.intellij.lang.documentation.ide.IdeDocumentationTargetProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.documentation.InlineDocumentation;
import com.intellij.psi.util.PsiEditorUtil;
import com.jetbrains.rdclient.daemon.highlighters.renderedDocs.FrontendDocRenderItemKt;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010)\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020+H\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0016J\n\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020+H\u0002J\u0010\u00104\u001a\u00020+2\u0006\u00105\u001a\u000206H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR(\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00067"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/renderedDocs/FrontendDocRenderItem;", "Lcom/intellij/codeInsight/documentation/render/DocRenderItem;", "Lcom/intellij/codeInsight/documentation/render/MutableDocRenderItem;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/openapi/editor/Editor;)V", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setHighlighter", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "textToRender", "", "getTextToRender", "()Ljava/lang/String;", "setTextToRender", "(Ljava/lang/String;)V", "regionBackendId", "", "getRegionBackendId", "()Ljava/lang/Long;", "setRegionBackendId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "value", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "foldRegion", "getFoldRegion", "()Lcom/intellij/openapi/editor/CustomFoldRegion;", "setFoldRegion", "(Lcom/intellij/openapi/editor/CustomFoldRegion;)V", "renderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "getRenderer", "()Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "setRenderer", "(Lcom/intellij/openapi/editor/markup/GutterIconRenderer;)V", "calcFoldingGutterIconRenderer", "setIconVisible", "", "visible", "", "toggle", "getInlineDocumentation", "Lcom/intellij/platform/backend/documentation/InlineDocumentation;", "getInlineDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "updateIcon", "repaintGutter", "startY", "", "intellij.rd.client"})
public final class FrontendDocRenderItem
implements DocRenderItem,
MutableDocRenderItem {
    @NotNull
    private RangeHighlighter highlighter;
    @NotNull
    private final Editor editor;
    @Nullable
    private String textToRender;
    @Nullable
    private Long regionBackendId;
    @Nullable
    private CustomFoldRegion foldRegion;
    @Nullable
    private GutterIconRenderer renderer;

    public FrontendDocRenderItem(@NotNull RangeHighlighter highlighter, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.highlighter = highlighter;
        this.editor = editor;
    }

    @NotNull
    public RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(@NotNull RangeHighlighter rangeHighlighter) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"<set-?>");
        this.highlighter = rangeHighlighter;
    }

    @NotNull
    public Editor getEditor() {
        return this.editor;
    }

    @Nullable
    public String getTextToRender() {
        return this.textToRender;
    }

    public void setTextToRender(@Nullable String string) {
        this.textToRender = string;
    }

    @Nullable
    public final Long getRegionBackendId() {
        return this.regionBackendId;
    }

    public final void setRegionBackendId(@Nullable Long l) {
        this.regionBackendId = l;
    }

    @Nullable
    public CustomFoldRegion getFoldRegion() {
        return this.foldRegion;
    }

    public void setFoldRegion(@Nullable CustomFoldRegion value) {
        if (value == null) {
            this.updateIcon();
            this.foldRegion = null;
        } else {
            this.foldRegion = value;
            this.updateIcon();
        }
    }

    @Nullable
    public final GutterIconRenderer getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@Nullable GutterIconRenderer gutterIconRenderer) {
        this.renderer = gutterIconRenderer;
    }

    @Nullable
    public GutterIconRenderer calcFoldingGutterIconRenderer() {
        return this.renderer;
    }

    public void setIconVisible(boolean visible) {
        CustomFoldRegion customFoldRegion = this.getFoldRegion();
        boolean bl = customFoldRegion != null ? customFoldRegion.isValid() : false;
        if (bl) {
            CustomFoldRegion customFoldRegion2 = this.getFoldRegion();
            Intrinsics.checkNotNull((Object)customFoldRegion2);
            GutterIconRenderer gutterIconRenderer = customFoldRegion2.getGutterIconRenderer();
            if (gutterIconRenderer == null) {
                return;
            }
            GutterIconRenderer iconRenderer = gutterIconRenderer;
            FrontendDocRenderItemKt.setVisible(iconRenderer, visible);
            Editor editor = this.getEditor();
            CustomFoldRegion customFoldRegion3 = this.getFoldRegion();
            Intrinsics.checkNotNull((Object)customFoldRegion3);
            this.repaintGutter(editor.offsetToXY((int)customFoldRegion3.getStartOffset()).y);
        } else {
            GutterIconRenderer gutterIconRenderer = this.getHighlighter().getGutterIconRenderer();
            if (gutterIconRenderer == null) {
                return;
            }
            GutterIconRenderer iconRenderer = gutterIconRenderer;
            FrontendDocRenderItemKt.setVisible(iconRenderer, visible);
            Editor editor = this.getEditor();
            Editor editor2 = this.getEditor();
            Intrinsics.checkNotNull((Object)editor2, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            int y = editor.visualLineToY(((EditorImpl)editor2).offsetToVisualLine(this.getHighlighter().getStartOffset()));
            this.repaintGutter(y);
        }
    }

    public void toggle() {
        block0: {
            GutterIconRenderer gutterIconRenderer = this.renderer;
            if (gutterIconRenderer == null || (gutterIconRenderer = gutterIconRenderer.getClickAction()) == null) break block0;
            gutterIconRenderer.actionPerformed(AnActionEvent.createFromDataContext((String)"", null, arg_0 -> FrontendDocRenderItem.toggle$lambda$0(this, arg_0)));
        }
    }

    @Nullable
    public InlineDocumentation getInlineDocumentation() {
        return null;
    }

    @Nullable
    public DocumentationTarget getInlineDocumentationTarget() {
        Project project = this.getEditor().getProject();
        if (project == null) {
            return null;
        }
        List list2 = IdeDocumentationTargetProvider.getInstance((Project)project).documentationTargets(this.getEditor(), PsiEditorUtil.getPsiFile((Editor)this.getEditor()), this.getHighlighter().getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"documentationTargets(...)");
        return (DocumentationTarget)CollectionsKt.firstOrNull((List)list2);
    }

    private final void updateIcon() {
        CustomFoldRegion customFoldRegion = this.getFoldRegion();
        boolean bl = customFoldRegion != null ? customFoldRegion.isValid() : false;
        if (bl) {
            boolean prevState;
            Object object = this.getHighlighter().getGutterIconRenderer();
            boolean bl2 = prevState = object != null && (object = FrontendDocRenderItemKt.isVisible((GutterIconRenderer)object)) != null ? (Boolean)object : false;
            CustomFoldRegion customFoldRegion2 = this.getFoldRegion();
            if (customFoldRegion2 == null || (customFoldRegion2 = customFoldRegion2.getGutterIconRenderer()) == null) {
                return;
            }
            CustomFoldRegion iconRenderer = customFoldRegion2;
            FrontendDocRenderItemKt.setVisible((GutterIconRenderer)iconRenderer, prevState);
        } else {
            Object object = this.getFoldRegion();
            boolean prevState = object != null && (object = object.getGutterIconRenderer()) != null && (object = FrontendDocRenderItemKt.isVisible((GutterIconRenderer)object)) != null ? (Boolean)object : false;
            GutterIconRenderer gutterIconRenderer = this.getHighlighter().getGutterIconRenderer();
            if (gutterIconRenderer == null) {
                return;
            }
            GutterIconRenderer iconRenderer = gutterIconRenderer;
            FrontendDocRenderItemKt.setVisible(iconRenderer, prevState);
        }
    }

    private final void repaintGutter(int startY) {
        EditorGutter editorGutter = this.getEditor().getGutter();
        Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type javax.swing.JComponent");
        JComponent gutter = (JComponent)editorGutter;
        gutter.repaint(0, startY, gutter.getWidth(), startY + this.getEditor().getLineHeight());
    }

    private static final Object toggle$lambda$0(FrontendDocRenderItem this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CommonDataKeys.PROJECT.is(it) ? (UserDataHolder)this$0.getEditor().getProject() : (CommonDataKeys.EDITOR.is(it) ? (UserDataHolder)this$0.getEditor() : null);
    }
}

