/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.oas;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.microservices.jvm.oas.OasTypeAndFormat;
import com.intellij.microservices.jvm.oas.v3.SwOperation;
import com.intellij.microservices.jvm.oas.v3.SwParameter;
import com.intellij.microservices.oas.OasProperty;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.analysis.UExpressionFact;
import org.jetbrains.uast.analysis.UNullability;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0082\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u0010\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u001a\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u000e\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a2\u0010\u0019\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u00162\b\b\u0002\u0010\u001d\u001a\u00020\r\u001a>\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0!2\b\b\u0002\u0010\u001d\u001a\u00020\rH\u0002\u001a4\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020#2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0!H\u0002\u001a4\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010%\u001a\u00020#2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0!H\u0002\u001a2\u0010&\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0!H\u0002\u001a4\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020)2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\n0!H\u0002\u001a\u000e\u0010*\u001a\u0004\u0018\u00010\u0001*\u00020+H\u0002\u001a\f\u0010,\u001a\u00020\r*\u00020+H\u0002\u001a\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020+0.2\u0006\u0010(\u001a\u00020)H\u0002\u001a\u001e\u0010/\u001a\u00020\r2\u0006\u00100\u001a\u00020+2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000102H\u0002\u001a\u001e\u00103\u001a\u00020\r2\u0006\u00100\u001a\u00020+2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000102H\u0002\u001a\u0012\u00104\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u0001022\u0006\u0010(\u001a\u00020)H\u0002\u001a\u001a\u00106\u001a\u00020\r2\u0006\u00107\u001a\u00020\u00012\b\u0010(\u001a\u0004\u0018\u00010)H\u0002\u001a\u0010\u00108\u001a\u00020\u00012\u0006\u00100\u001a\u00020+H\u0002\u001a\u0014\u00109\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010:\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020+H\u0002\u001a\u0012\u0010<\u001a\u0004\u0018\u00010;2\u0006\u00100\u001a\u00020+H\u0002\u001a\u0014\u0010=\u001a\u0004\u0018\u00010\n2\b\u0010>\u001a\u0004\u0018\u00010?H\u0002\u001a\u0012\u0010@\u001a\u0004\u0018\u00010\u00162\u0006\u0010A\u001a\u00020\u0016H\u0002\u001a\u0010\u0010B\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0002\u001a\u0010\u0010C\u001a\u00020\u00012\u0006\u0010D\u001a\u00020\u0001H\u0002\u001a\u0012\u0010E\u001a\u0004\u0018\u00010\n2\u0006\u0010(\u001a\u00020)H\u0002\u001a\f\u0010F\u001a\u00020\u0001*\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"JACKSON_JSON_IGNORE_PROPERTIES", "", "JACKSON_JSON_PROPERTY", "JACKSON_JSON_IGNORE", "KOTLINX_UUID", "KOTLINX_LOCAL_DATE", "KOTLINX_LOCAL_DATE_TIME", "KOTLINX_LOCAL_TIME", "KOTLINX_INSTANT", "EMPTY_OBJECT_OAS_SCHEMA", "Lcom/intellij/microservices/oas/OasSchema;", "EMPTY_ARRAY_OAS_SCHEMA", "isMappingHidden", "", "uDeclaration", "Lorg/jetbrains/uast/UDeclaration;", "isParameterHidden", "uParameter", "Lorg/jetbrains/uast/UParameter;", "getOasTypeAndFormat", "Lcom/intellij/microservices/jvm/oas/OasTypeAndFormat;", "type", "Lcom/intellij/psi/PsiType;", "getComponentNameByRef", "ref", "getOasSchemaForPsiType", "Lkotlin/Pair;", "", "psiType", "resolveGenerics", "visited", "", "schemas", "", "getOasSchemaForGenericType", "Lcom/intellij/psi/PsiClassType;", "getOasSchemaForObjectParameter", "parameterType", "getOasSchemaForArrayParameter", "getOasSchemaForClass", "uClass", "Lorg/jetbrains/uast/UClass;", "evaluateDefaultStringValue", "Lorg/jetbrains/uast/UField;", "isNullable", "collectFields", "", "isSuitableField", "uField", "ignoredFields", "", "isFieldIgnored", "isFieldIgnoredByDeclaration", "getIgnoredFields", "hasPublicGetter", "fieldName", "getFieldName", "getCustomFieldName", "findGetter", "Lorg/jetbrains/uast/UMethod;", "findSetter", "getEnumSchema", "psiClass", "Lcom/intellij/psi/PsiClass;", "getArrayItemType", "containerPsiType", "unwrapPsiType", "getComponentSchemaRef", "objectName", "getRefOasSchema", "capitalize", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmSwaggerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmSwaggerUtils.kt\ncom/intellij/microservices/jvm/oas/JvmSwaggerUtilsKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,384:1\n18#2:385\n18#2:441\n18#2:443\n18#2:455\n1642#3,10:386\n1915#3:396\n1916#3:398\n1652#3:399\n1642#3,10:400\n1915#3:410\n1916#3:412\n1652#3:413\n832#3:414\n862#3,2:415\n1586#3:417\n1661#3,3:418\n1642#3,10:425\n1915#3:435\n1916#3:437\n1652#3:438\n1#4:397\n1#4:411\n1#4:421\n1#4:436\n1#4:442\n1#4:456\n1#4:459\n3938#5:422\n4474#5,2:423\n13225#5,2:439\n12033#5,10:444\n14060#5:454\n14061#5:457\n12043#5:458\n*S KotlinDebug\n*F\n+ 1 JvmSwaggerUtils.kt\ncom/intellij/microservices/jvm/oas/JvmSwaggerUtilsKt\n*L\n37#1:385\n335#1:441\n341#1:443\n348#1:455\n162#1:386,10\n162#1:396\n162#1:398\n162#1:399\n238#1:400,10\n238#1:410\n238#1:412\n238#1:413\n246#1:414\n246#1:415,2\n246#1:417\n246#1:418,3\n299#1:425,10\n299#1:435\n299#1:437\n299#1:438\n162#1:397\n238#1:411\n299#1:436\n348#1:456\n267#1:422\n267#1:423,2\n314#1:439,2\n348#1:444,10\n348#1:454\n348#1:457\n348#1:458\n*E\n"})
public final class JvmSwaggerUtilsKt {
    @NotNull
    private static final String JACKSON_JSON_IGNORE_PROPERTIES = "com.fasterxml.jackson.annotation.JsonIgnoreProperties";
    @NotNull
    private static final String JACKSON_JSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";
    @NotNull
    private static final String JACKSON_JSON_IGNORE = "com.fasterxml.jackson.annotation.JsonIgnore";
    @NotNull
    private static final String KOTLINX_UUID = "kotlinx.uuid.Uuid";
    @NotNull
    private static final String KOTLINX_LOCAL_DATE = "kotlinx.datetime.LocalDate";
    @NotNull
    private static final String KOTLINX_LOCAL_DATE_TIME = "kotlinx.datetime.LocalDateTime";
    @NotNull
    private static final String KOTLINX_LOCAL_TIME = "kotlinx.datetime.LocalTime";
    @NotNull
    private static final String KOTLINX_INSTANT = "kotlinx.datetime.Instant";
    @NotNull
    private static final OasSchema EMPTY_OBJECT_OAS_SCHEMA = new OasSchema(OasSchemaType.OBJECT, null, null, null, null, null, null, null, false, false, 1020, null);
    @NotNull
    private static final OasSchema EMPTY_ARRAY_OAS_SCHEMA = new OasSchema(OasSchemaType.ARRAY, null, null, null, null, null, null, null, false, false, 1020, null);

    public static final boolean isMappingHidden(@Nullable UDeclaration uDeclaration) {
        UMethod uMethod;
        UDeclaration uDeclaration2 = uDeclaration;
        if ((uDeclaration2 != null ? uDeclaration2.findAnnotation("io.swagger.v3.oas.annotations.Hidden") : null) != null) {
            return true;
        }
        UDeclaration $this$asSafely$iv = uDeclaration;
        boolean $i$f$asSafely = false;
        UDeclaration uDeclaration3 = $this$asSafely$iv;
        if (!(uDeclaration3 instanceof UMethod)) {
            uDeclaration3 = null;
        }
        if ((uMethod = (UMethod)uDeclaration3) == null || (uMethod = uMethod.getJavaPsi()) == null) {
            return false;
        }
        UMethod psiMethod = uMethod;
        SwOperation swOperation = (SwOperation)SwOperation.META.getJamElement((PsiModifierListOwner)psiMethod);
        return swOperation != null ? swOperation.getHidden() : false;
    }

    public static final boolean isParameterHidden(@Nullable UParameter uParameter) {
        UParameter uParameter2 = uParameter;
        if ((uParameter2 != null ? uParameter2.findAnnotation("io.swagger.v3.oas.annotations.Hidden") : null) != null) {
            return true;
        }
        UParameter uParameter3 = uParameter;
        PsiElement psiElement = uParameter3 != null ? uParameter3.getJavaPsi() : null;
        PsiParameter psiParameter = psiElement instanceof PsiParameter ? (PsiParameter)psiElement : null;
        if (psiParameter == null) {
            return false;
        }
        PsiParameter psiParameter2 = psiParameter;
        SwParameter swParameter = (SwParameter)SwParameter.META.getJamElement((PsiModifierListOwner)psiParameter2);
        return swParameter != null ? swParameter.getHidden() : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final OasTypeAndFormat getOasTypeAndFormat(@NotNull PsiType type) {
        OasTypeAndFormat oasTypeAndFormat;
        block81: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (!(type instanceof PsiPrimitiveType)) break block81;
            String string = ((PsiPrimitiveType)type).getBoxedTypeName();
            if (string == null) return null;
            int n = -1;
            switch (string.hashCode()) {
                case -527879800: {
                    if (string.equals("java.lang.Float")) {
                        n = 1;
                    }
                    break;
                }
                case 155276373: {
                    if (string.equals("java.lang.Character")) {
                        n = 2;
                    }
                    break;
                }
                case 398795216: {
                    if (string.equals("java.lang.Long")) {
                        n = 3;
                    }
                    break;
                }
                case 761287205: {
                    if (string.equals("java.lang.Double")) {
                        n = 4;
                    }
                    break;
                }
                case -515992664: {
                    if (string.equals("java.lang.Short")) {
                        n = 5;
                    }
                    break;
                }
                case 344809556: {
                    if (string.equals("java.lang.Boolean")) {
                        n = 6;
                    }
                    break;
                }
                case 398507100: {
                    if (string.equals("java.lang.Byte")) {
                        n = 7;
                    }
                    break;
                }
                case -2056817302: {
                    if (string.equals("java.lang.Integer")) {
                        n = 8;
                    }
                    break;
                }
            }
            switch (n) {
                case 6: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.BOOLEAN, null, 2, null);
                    return oasTypeAndFormat2;
                }
                case 5: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.INTEGER, OasSchemaFormat.INT_32);
                    return oasTypeAndFormat2;
                }
                case 8: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.INTEGER, OasSchemaFormat.INT_32);
                    return oasTypeAndFormat2;
                }
                case 3: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.INTEGER, OasSchemaFormat.INT_64);
                    return oasTypeAndFormat2;
                }
                case 4: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.NUMBER, OasSchemaFormat.DOUBLE);
                    return oasTypeAndFormat2;
                }
                case 1: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.NUMBER, OasSchemaFormat.FLOAT);
                    return oasTypeAndFormat2;
                }
                case 7: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.BYTE);
                    return oasTypeAndFormat2;
                }
                case 2: {
                    OasTypeAndFormat oasTypeAndFormat2 = new OasTypeAndFormat(OasSchemaType.STRING, null, 2, null);
                    return oasTypeAndFormat2;
                }
                default: {
                    return null;
                }
            }
        }
        if (type.equalsToText("java.lang.Boolean")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.BOOLEAN, null, 2, null);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Short")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.INTEGER, OasSchemaFormat.INT_32);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Integer")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.INTEGER, OasSchemaFormat.INT_32);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Long")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.INTEGER, OasSchemaFormat.INT_64);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Double")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.NUMBER, OasSchemaFormat.DOUBLE);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Float")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.NUMBER, OasSchemaFormat.FLOAT);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Byte")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.BYTE);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.String")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, null, 2, null);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.lang.Character")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, null, 2, null);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.net.URI")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.URI);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.net.URL")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.URL);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.util.UUID")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.UUID);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.util.Date")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.time.LocalDate")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.time.LocalDateTime")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.time.LocalTime")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.PARTIAL_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.time.OffsetDateTime")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText("java.time.ZonedDateTime")) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText(KOTLINX_UUID)) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.UUID);
            return oasTypeAndFormat;
        } else if (type.equalsToText(KOTLINX_LOCAL_DATE)) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE);
            return oasTypeAndFormat;
        } else if (type.equalsToText(KOTLINX_LOCAL_DATE_TIME)) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText(KOTLINX_LOCAL_TIME)) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.PARTIAL_TIME);
            return oasTypeAndFormat;
        } else if (type.equalsToText(KOTLINX_INSTANT)) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.STRING, OasSchemaFormat.DATE_TIME);
            return oasTypeAndFormat;
        } else if (type instanceof PsiArrayType) {
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.ARRAY, null, 2, null);
            return oasTypeAndFormat;
        } else if (type instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            if (psiClass2.isEnum()) {
                return new OasTypeAndFormat(OasSchemaType.STRING, null);
            }
            String string = psiClass2.getQualifiedName();
            if (string == null) {
                return null;
            }
            String className = string;
            oasTypeAndFormat = Intrinsics.areEqual((Object)"java.util.Collection", (Object)className) ? new OasTypeAndFormat(OasSchemaType.ARRAY, null, 2, null) : (Intrinsics.areEqual((Object)"java.util.List", (Object)className) ? new OasTypeAndFormat(OasSchemaType.ARRAY, null, 2, null) : (Intrinsics.areEqual((Object)"java.util.Set", (Object)className) ? new OasTypeAndFormat(OasSchemaType.ARRAY, null, 2, null) : new OasTypeAndFormat(OasSchemaType.OBJECT, null, 2, null)));
            return oasTypeAndFormat;
        } else {
            if (!(type instanceof PsiWildcardType)) return null;
            oasTypeAndFormat = new OasTypeAndFormat(OasSchemaType.OBJECT, null, 2, null);
        }
        return oasTypeAndFormat;
    }

    @NotNull
    public static final String getComponentNameByRef(@NotNull String ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        String string = ref.substring(StringsKt.lastIndexOf$default((CharSequence)ref, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Nullable
    public static final Pair<OasSchema, Map<String, OasSchema>> getOasSchemaForPsiType(@NotNull PsiType psiType, boolean resolveGenerics) {
        Intrinsics.checkNotNullParameter((Object)psiType, (String)"psiType");
        Map schemas = new LinkedHashMap();
        OasSchema oasSchema = JvmSwaggerUtilsKt.getOasSchemaForPsiType(JvmSwaggerUtilsKt.unwrapPsiType(psiType), new LinkedHashSet(), schemas, resolveGenerics);
        if (oasSchema == null) {
            return null;
        }
        OasSchema schema = oasSchema;
        return TuplesKt.to((Object)schema, (Object)schemas);
    }

    public static /* synthetic */ Pair getOasSchemaForPsiType$default(PsiType psiType, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return JvmSwaggerUtilsKt.getOasSchemaForPsiType(psiType, bl);
    }

    private static final OasSchema getOasSchemaForPsiType(PsiType psiType, Set<String> visited, Map<String, OasSchema> schemas, boolean resolveGenerics) {
        OasSchema oasSchema;
        OasTypeAndFormat oasTypeAndFormat = JvmSwaggerUtilsKt.getOasTypeAndFormat(psiType);
        if (oasTypeAndFormat == null) {
            return null;
        }
        OasTypeAndFormat oasTypeAndFormat2 = oasTypeAndFormat;
        OasSchemaType oasType = oasTypeAndFormat2.component1();
        OasSchemaFormat oasFormat = oasTypeAndFormat2.component2();
        if (oasType == OasSchemaType.OBJECT && psiType instanceof PsiClassType) {
            PsiType[] psiTypeArray = ((PsiClassType)psiType).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
            boolean hasGeneric = !(((Object[])psiTypeArray).length == 0);
            if (hasGeneric && resolveGenerics) {
                oasSchema = JvmSwaggerUtilsKt.getOasSchemaForGenericType((PsiClassType)psiType, visited, schemas);
            } else if (hasGeneric) {
                PsiType[] psiTypeArray2 = ((PsiClassType)psiType).getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray2, (String)"getParameters(...)");
                Object object = ArraysKt.first((Object[])psiTypeArray2);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                oasSchema = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default((PsiType)object, visited, schemas, false, 8, null);
            } else {
                oasSchema = JvmSwaggerUtilsKt.getOasSchemaForObjectParameter((PsiClassType)psiType, visited, schemas);
            }
        } else if (oasType == OasSchemaType.ARRAY) {
            oasSchema = JvmSwaggerUtilsKt.getOasSchemaForArrayParameter(psiType, visited, schemas);
        } else {
            if (oasType == OasSchemaType.STRING && psiType instanceof PsiClassType) {
                OasSchema oasSchema2 = JvmSwaggerUtilsKt.getEnumSchema(((PsiClassType)psiType).resolve());
                if (oasSchema2 == null) {
                    oasSchema2 = new OasSchema(oasType, oasFormat, null, null, null, null, null, null, false, false, 1020, null);
                }
                return oasSchema2;
            }
            oasSchema = new OasSchema(oasType, oasFormat, null, null, null, null, null, null, false, false, 1020, null);
        }
        return oasSchema;
    }

    static /* synthetic */ OasSchema getOasSchemaForPsiType$default(PsiType psiType, Set set, Map map, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return JvmSwaggerUtilsKt.getOasSchemaForPsiType(psiType, set, map, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final OasSchema getOasSchemaForGenericType(PsiClassType psiType, Set<String> visited, Map<String, OasSchema> schemas) {
        OasSchema oasSchema;
        void $this$mapNotNullTo$iv$iv;
        PsiType[] psiTypeArray = psiType.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
        PsiType typeParam = (PsiType)ArraysKt.first((Object[])psiTypeArray);
        Intrinsics.checkNotNull((Object)typeParam);
        JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(typeParam, visited, schemas, false, 8, null);
        PsiClassType psiClassType = psiType.rawType();
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"rawType(...)");
        JvmSwaggerUtilsKt.getOasSchemaForPsiType$default((PsiType)psiClassType, visited, schemas, false, 8, null);
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)psiType.resolve()), UClass.class);
        if (uClass == null) {
            return EMPTY_OBJECT_OAS_SCHEMA;
        }
        UClass fieldUClass = uClass;
        Iterable $this$mapNotNull$iv = JvmSwaggerUtilsKt.collectFields(fieldUClass);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OasProperty oasProperty;
            OasSchema oasSchema2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UField uField = (UField)element$iv$iv;
            boolean bl2 = false;
            OasSchema schema = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(uField.getType(), visited, schemas, false, 8, null);
            if (schema == null) {
                oasSchema2 = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(typeParam, visited, schemas, false, 8, null);
            } else if (schema.getType() == OasSchemaType.ARRAY && schema.getItems() == null) {
                OasSchema oasSchema3 = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(typeParam, visited, schemas, false, 8, null);
                if (oasSchema3 == null) {
                    oasSchema3 = EMPTY_OBJECT_OAS_SCHEMA;
                }
                OasSchema itemsSchema = oasSchema3;
                oasSchema2 = OasSchema.copy$default((OasSchema)schema, null, null, null, (OasSchema)itemsSchema, null, null, null, null, (boolean)false, (boolean)false, (int)1015, null);
            } else {
                oasSchema2 = schema;
            }
            if (oasSchema2 == null) {
                oasProperty = null;
            } else {
                OasSchema fieldSchema = oasSchema2;
                oasProperty = new OasProperty(JvmSwaggerUtilsKt.getFieldName(uField), fieldSchema);
            }
            if (oasProperty == null) continue;
            OasProperty it$iv$iv = oasProperty;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        if (properties.isEmpty()) {
            oasSchema = JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(typeParam, visited, schemas, false, 8, null);
            if (oasSchema == null) {
                return EMPTY_OBJECT_OAS_SCHEMA;
            }
        } else {
            oasSchema = new OasSchema(OasSchemaType.OBJECT, null, null, null, properties, null, null, null, false, false, 1006, null);
        }
        OasSchema schema = oasSchema;
        String ref = fieldUClass.getName() + "_" + typeParam.getPresentableText();
        schemas.put(ref, schema);
        return new OasSchema(null, null, null, null, null, JvmSwaggerUtilsKt.getComponentSchemaRef(ref), null, null, false, false, 991, null);
    }

    private static final OasSchema getOasSchemaForObjectParameter(PsiClassType parameterType, Set<String> visited, Map<String, OasSchema> schemas) {
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)parameterType.resolve()), UClass.class);
        if (uClass == null) {
            return EMPTY_OBJECT_OAS_SCHEMA;
        }
        UClass fieldUClass = uClass;
        return JvmSwaggerUtilsKt.getOasSchemaForClass(fieldUClass, visited, schemas);
    }

    private static final OasSchema getOasSchemaForArrayParameter(PsiType parameterType, Set<String> visited, Map<String, OasSchema> schemas) {
        boolean bl;
        OasSchema itemSchema;
        PsiType psiType = JvmSwaggerUtilsKt.getArrayItemType(parameterType);
        if (psiType == null) {
            return EMPTY_ARRAY_OAS_SCHEMA;
        }
        PsiType itemType = psiType;
        OasTypeAndFormat oasTypeAndFormat = JvmSwaggerUtilsKt.getOasTypeAndFormat(itemType);
        if (oasTypeAndFormat == null) {
            return EMPTY_ARRAY_OAS_SCHEMA;
        }
        OasTypeAndFormat oasTypeAndFormat2 = oasTypeAndFormat;
        OasSchemaType itemOasType = oasTypeAndFormat2.component1();
        OasSchemaFormat itemOasFormat = oasTypeAndFormat2.component2();
        if (itemType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)itemType).resolve();
            if (psiClass == null) {
                return EMPTY_ARRAY_OAS_SCHEMA;
            }
            PsiClass itemPsiClass = psiClass;
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)itemPsiClass), UClass.class);
            if (uClass == null) {
                return EMPTY_ARRAY_OAS_SCHEMA;
            }
            UClass itemUClass = uClass;
            v4 = itemOasType == OasSchemaType.OBJECT ? JvmSwaggerUtilsKt.getOasSchemaForClass(itemUClass, visited, schemas) : (itemPsiClass.isEnum() ? JvmSwaggerUtilsKt.getEnumSchema(itemPsiClass) : new OasSchema(itemOasType, itemOasFormat, null, null, null, null, null, null, false, false, 1020, null));
        } else {
            v4 = itemSchema = new OasSchema(itemOasType, itemOasFormat, null, null, null, null, null, null, false, false, 1020, null);
        }
        if (parameterType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)parameterType).resolve();
            String className = psiClass != null ? psiClass.getQualifiedName() : null;
            bl = Intrinsics.areEqual((Object)className, (Object)"java.util.Set");
        } else {
            bl = false;
        }
        boolean isUniq = bl;
        return new OasSchema(OasSchemaType.ARRAY, null, null, itemSchema, null, null, null, null, false, isUniq, 502, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final OasSchema getOasSchemaForClass(UClass uClass, Set<String> visited, Map<String, OasSchema> schemas) {
        Collection collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        OasProperty it;
        void $this$filterNotTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        String string = uClass.getJavaPsi().getName();
        if (string == null) {
            return null;
        }
        String className = string;
        if (!visited.add(className)) {
            return JvmSwaggerUtilsKt.getRefOasSchema(uClass);
        }
        Collection<UField> fields = JvmSwaggerUtilsKt.collectFields(uClass);
        Iterable iterable = fields;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Iterable<OasProperty> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OasProperty oasProperty;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UField uField = (UField)element$iv$iv;
            boolean bl2 = false;
            if (JvmSwaggerUtilsKt.getOasSchemaForPsiType$default(uField.getType(), visited, schemas, false, 8, null) != null) {
                OasSchema fieldSchema;
                boolean bl3 = false;
                OasSchema updatedSchema = OasSchema.copy$default((OasSchema)fieldSchema, null, null, (String)JvmSwaggerUtilsKt.evaluateDefaultStringValue(uField), null, null, null, null, null, (boolean)JvmSwaggerUtilsKt.isNullable(uField), (boolean)false, (int)763, null);
                oasProperty = new OasProperty(JvmSwaggerUtilsKt.getFieldName(uField), updatedSchema);
            } else {
                oasProperty = null;
            }
            if (oasProperty == null) continue;
            OasProperty it$iv$iv = oasProperty;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = properties;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (OasProperty)element$iv$iv;
            boolean bl = false;
            if (it.getSchema().isNullable()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (OasProperty)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(p0.getName());
        }
        Collection collection3 = (List)destination$iv$iv2;
        if (collection3.isEmpty()) {
            boolean bl = false;
            collection = null;
        } else {
            collection = collection3;
        }
        List requiredProperties = (List)collection;
        schemas.put(className, new OasSchema(OasSchemaType.OBJECT, null, null, null, properties, null, null, requiredProperties, false, false, 878, null));
        return JvmSwaggerUtilsKt.getRefOasSchema(uClass);
    }

    private static final String evaluateDefaultStringValue(UField $this$evaluateDefaultStringValue) {
        UExpression uExpression = $this$evaluateDefaultStringValue.getUastInitializer();
        return uExpression != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
    }

    private static final boolean isNullable(UField $this$isNullable) {
        UastLanguagePlugin uastAnalysisPlugin;
        UastLanguagePlugin uastLanguagePlugin = UastFacade.INSTANCE.findPlugin($this$isNullable.getLang());
        if (uastLanguagePlugin == null || (uastLanguagePlugin = uastLanguagePlugin.getAnalysisPlugin()) == null) {
            return true;
        }
        UastLanguagePlugin $this$isNullable_u24lambda_u240 = uastAnalysisPlugin = uastLanguagePlugin;
        boolean bl = false;
        UTypeReferenceExpression uTypeReferenceExpression = $this$isNullable.getTypeReference();
        return (uTypeReferenceExpression != null ? (UNullability)$this$isNullable_u24lambda_u240.getExpressionFact((UExpression)uTypeReferenceExpression, (UExpressionFact)UExpressionFact.UNullabilityFact.INSTANCE) : null) != UNullability.NOT_NULL;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final Collection<UField> collectFields(UClass uClass) {
        fields = new ArrayList<E>();
        ignoredFields = JvmSwaggerUtilsKt.getIgnoredFields(uClass);
        var3_3 = fields;
        $this$filter$iv = uClass.getFields();
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var10_11 = ((void)$this$filterTo$iv$iv).length;
        for (var9_10 = 0; var9_10 < var10_11; ++var9_10) {
            it = element$iv$iv = $this$filterTo$iv$iv[var9_10];
            $i$a$-filter-JvmSwaggerUtilsKt$collectFields$1 = false;
            if (!JvmSwaggerUtilsKt.isSuitableField((UField)it, ignoredFields)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var4_4 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)var3_3, (Iterable)var4_4);
        var3_3 = fields;
        v0 /* !! */  = uClass.getJavaPsi().getSuperClass();
        if (v0 /* !! */  == null || (v0 /* !! */  = (UClass)UastContextKt.toUElement((PsiElement)((PsiElement)v0 /* !! */ ), UClass.class)) == null) ** GOTO lbl-1000
        it = v0 /* !! */ ;
        $i$a$-let-JvmSwaggerUtilsKt$collectFields$2 = false;
        v1 = JvmSwaggerUtilsKt.collectFields((UClass)it);
        v0 /* !! */  = v1;
        if (v1 != null) {
            v2 = (Iterable)v0 /* !! */ ;
        } else lbl-1000:
        // 2 sources

        {
            v2 = CollectionsKt.emptyList();
        }
        CollectionsKt.addAll((Collection)var3_3, (Iterable)v2);
        return fields;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSuitableField(UField uField, List<String> ignoredFields) {
        PsiElement psiElement = uField.getJavaPsi();
        if (!(psiElement instanceof PsiField)) return false;
        PsiField psiField = (PsiField)psiElement;
        if (psiField == null) {
            return false;
        }
        PsiField psiField2 = psiField;
        if (psiField2.hasModifier(JvmModifier.STATIC)) return false;
        if (psiField2.hasModifier(JvmModifier.TRANSIENT)) return false;
        if (!psiField2.hasModifier(JvmModifier.PUBLIC)) {
            String string = uField.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!JvmSwaggerUtilsKt.hasPublicGetter(string, UastUtils.getContainingUClass((UElement)((UElement)uField)))) return false;
        }
        if (JvmSwaggerUtilsKt.isFieldIgnored(uField, ignoredFields)) return false;
        return true;
    }

    private static final boolean isFieldIgnored(UField uField, List<String> ignoredFields) {
        return ignoredFields.contains(uField.getName()) || JvmSwaggerUtilsKt.isFieldIgnoredByDeclaration((UDeclaration)uField) || JvmSwaggerUtilsKt.isFieldIgnoredByDeclaration((UDeclaration)JvmSwaggerUtilsKt.findGetter(uField)) || JvmSwaggerUtilsKt.isFieldIgnoredByDeclaration((UDeclaration)JvmSwaggerUtilsKt.findSetter(uField));
    }

    private static final boolean isFieldIgnoredByDeclaration(UDeclaration uDeclaration) {
        UDeclaration uDeclaration2 = uDeclaration;
        if (uDeclaration2 == null || (uDeclaration2 = uDeclaration2.findAnnotation(JACKSON_JSON_IGNORE)) == null) {
            return false;
        }
        UDeclaration jsonIgnore = uDeclaration2;
        UExpression uExpression = jsonIgnore.findDeclaredAttributeValue("value");
        if (uExpression == null) {
            return true;
        }
        UExpression ignoreValue = uExpression;
        Object object = ignoreValue.evaluate();
        return Intrinsics.areEqual((Object)(object instanceof Boolean ? (Boolean)object : null), (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getIgnoredFields(UClass uClass) {
        Object object;
        block6: {
            block7: {
                block8: {
                    UExpression valueAttrExpression;
                    Iterable iterable;
                    block5: {
                        void $this$mapNotNullTo$iv$iv;
                        UAnnotation uAnno;
                        Object v0;
                        Object it;
                        block4: {
                            iterable = uClass.getUAnnotations();
                            for (Object t : iterable) {
                                it = (UAnnotation)t;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)JACKSON_JSON_IGNORE_PROPERTIES)) continue;
                                v0 = t;
                                break block4;
                            }
                            v0 = null;
                        }
                        UAnnotation uAnnotation = uAnno = (UAnnotation)v0;
                        valueAttrExpression = uAnnotation != null ? uAnnotation.findDeclaredAttributeValue("value") : null;
                        iterable = valueAttrExpression;
                        if (!(iterable instanceof UCallExpression)) break block5;
                        Iterable $this$mapNotNull$iv = ((UCallExpression)valueAttrExpression).getValueArguments();
                        boolean $i$f$mapNotNull = false;
                        it = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            String it$iv$iv;
                            Object element$iv$iv$iv;
                            Object element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            UExpression p0 = (UExpression)element$iv$iv;
                            boolean bl2 = false;
                            if (UastUtils.evaluateString((UExpression)p0) == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        object = (List)destination$iv$iv;
                        break block6;
                    }
                    if (!(iterable instanceof ULiteralExpression)) break block7;
                    object = UastUtils.evaluateString((UExpression)valueAttrExpression);
                    if (object == null) break block8;
                    Object it = object;
                    boolean bl = false;
                    List list = CollectionsKt.listOf((Object)it);
                    object = list;
                    if (list != null) break block6;
                }
                object = CollectionsKt.emptyList();
                break block6;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean hasPublicGetter(String fieldName, UClass uClass) {
        boolean bl;
        block2: {
            if (uClass == null) {
                return false;
            }
            String capitalizedFieldName = JvmSwaggerUtilsKt.capitalize(fieldName);
            String getGetter = "get" + capitalizedFieldName;
            Function1 isGetter = arg_0 -> JvmSwaggerUtilsKt.hasPublicGetter$lambda$0(capitalizedFieldName, fieldName, arg_0);
            boolean classIsJavaRecord = uClass.getJavaPsi().isRecord();
            UMethod[] $this$any$iv = uClass.getMethods();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                UMethod element$iv;
                UMethod uMethod = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                String name = uMethod.getName();
                if (!(uMethod.getJavaPsi().hasModifier(JvmModifier.PUBLIC) && (Intrinsics.areEqual((Object)name, (Object)getGetter) || (Boolean)isGetter.invoke((Object)name) != false || classIsJavaRecord && Intrinsics.areEqual((Object)name, (Object)fieldName)))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private static final String getFieldName(UField uField) {
        String string = JvmSwaggerUtilsKt.getCustomFieldName((UDeclaration)uField);
        if (string == null && (string = JvmSwaggerUtilsKt.getCustomFieldName((UDeclaration)JvmSwaggerUtilsKt.findGetter(uField))) == null && (string = JvmSwaggerUtilsKt.getCustomFieldName((UDeclaration)JvmSwaggerUtilsKt.findSetter(uField))) == null) {
            String string2 = uField.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    private static final String getCustomFieldName(UDeclaration uDeclaration) {
        UExpression uExpression;
        UAnnotation uAnnotation;
        return uDeclaration != null && (uAnnotation = uDeclaration.findAnnotation(JACKSON_JSON_PROPERTY)) != null && (uExpression = uAnnotation.findDeclaredAttributeValue("value")) != null ? UastUtils.evaluateString((UExpression)uExpression) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final UMethod findGetter(UField uField) {
        PsiField psiField;
        PsiElement $this$asSafely$iv = uField.getJavaPsi();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiField)) {
            psiElement = null;
        }
        if ((psiField = (PsiField)psiElement) == null) return null;
        PsiField it = psiField;
        boolean bl = false;
        PsiMethod psiMethod = PropertyUtilBase.findGetterForField((PsiField)it);
        if (psiMethod == null) return null;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod), UMethod.class);
        return uMethod;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final UMethod findSetter(UField uField) {
        PsiField psiField;
        PsiElement $this$asSafely$iv = uField.getJavaPsi();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiField)) {
            psiElement = null;
        }
        if ((psiField = (PsiField)psiElement) == null) return null;
        PsiField it = psiField;
        boolean bl = false;
        PsiMethod psiMethod = PropertyUtilBase.findSetterForField((PsiField)it);
        if (psiMethod == null) return null;
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)((PsiElement)psiMethod), UMethod.class);
        return uMethod;
    }

    /*
     * WARNING - void declaration
     */
    private static final OasSchema getEnumSchema(PsiClass psiClass) {
        void $this$mapNotNullTo$iv$iv;
        if (psiClass == null || !psiClass.isEnum()) {
            return null;
        }
        PsiField[] psiFieldArray = psiClass.getFields();
        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
        Object[] $this$mapNotNull$iv = psiFieldArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            PsiField it = (PsiField)element$iv$iv;
            boolean bl2 = false;
            PsiField $this$asSafely$iv = it;
            boolean $i$f$asSafely = false;
            PsiField psiField = $this$asSafely$iv;
            if (!(psiField instanceof PsiEnumConstant)) {
                psiField = null;
            }
            PsiEnumConstant psiEnumConstant = (PsiEnumConstant)psiField;
            if ((psiEnumConstant != null ? psiEnumConstant.getName() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List enumValues = (List)destination$iv$iv;
        return new OasSchema(OasSchemaType.STRING, null, null, null, null, null, enumValues, null, false, false, 958, null);
    }

    private static final PsiType getArrayItemType(PsiType containerPsiType) {
        PsiType psiType;
        PsiType psiType2 = containerPsiType;
        if (psiType2 instanceof PsiArrayType) {
            psiType = ((PsiArrayType)containerPsiType).getComponentType();
        } else if (psiType2 instanceof PsiClassType) {
            PsiType[] psiTypeArray = ((PsiClassType)containerPsiType).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
            psiType = (PsiType)ArraysKt.firstOrNull((Object[])psiTypeArray);
        } else {
            psiType = null;
        }
        PsiType itemType = psiType;
        return itemType instanceof PsiWildcardType ? ((PsiWildcardType)itemType).getBound() : itemType;
    }

    private static final PsiType unwrapPsiType(PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            String typeQualifiedName;
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            String string = typeQualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
            if (Intrinsics.areEqual((Object)"java.util.Optional", (Object)typeQualifiedName)) {
                PsiType[] psiTypeArray = ((PsiClassType)psiType).getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiTypeArray, (String)"getParameters(...)");
                Object object = ArraysKt.first((Object[])psiTypeArray);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                return (PsiType)object;
            }
        }
        return psiType;
    }

    private static final String getComponentSchemaRef(String objectName) {
        return "#/components/schemas/" + objectName;
    }

    private static final OasSchema getRefOasSchema(UClass uClass) {
        OasSchema oasSchema;
        String string = uClass.getJavaPsi().getName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            oasSchema = new OasSchema(null, null, null, null, null, JvmSwaggerUtilsKt.getComponentSchemaRef(it), null, null, false, false, 991, null);
        } else {
            oasSchema = null;
        }
        return oasSchema;
    }

    /*
     * WARNING - void declaration
     */
    private static final String capitalize(String $this$capitalize) {
        String string;
        String string2 = $this$capitalize;
        if (((CharSequence)string2).length() > 0) {
            String string3;
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (Character.isLowerCase((char)it)) {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                string3 = CharsKt.titlecase((char)it, (Locale)locale);
            } else {
                string3 = String.valueOf((char)it);
            }
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
            String string4 = string2;
            int n = 1;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            string = stringBuilder2.append(string5).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private static final boolean hasPublicGetter$lambda$0(String $capitalizedFieldName, String $fieldName, String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.areEqual((Object)name, (Object)("is" + $capitalizedFieldName)) || Intrinsics.areEqual((Object)name, (Object)$fieldName) && StringsKt.startsWith$default((String)$fieldName, (String)"is", (boolean)false, (int)2, null);
    }
}

