/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.pathvars;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.microservices.jvm.pathvars.PathVariableConsumerInfo;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u001c\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010\u0018\u001a\u00020\u0003J'\u0010!\u001a\r\u0012\t\u0012\u00070\u0003\u00a2\u0006\u0002\b#0\"2\u0006\u0010\u0017\u001a\u00020\u000f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\"J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0016\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020 2\u0006\u0010,\u001a\u00020\u0003J\u0018\u0010-\u001a\u00020\t2\u0006\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u0003H\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u000203H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00064"}, d2={"Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;", "", "pathVariableAnnotationFQN", "", "<init>", "(Ljava/lang/String;)V", "getPathVariableAnnotationFQN", "()Ljava/lang/String;", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getConsumedPathVariables", "", "Lcom/intellij/microservices/jvm/pathvars/PathVariableConsumerInfo;", "getUnconsumedPathVariablePsiElement", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "method", "pathVariableName", "extractPathVariableUsageFromParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "createPathVariable", "", "file", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/psi/PsiMethod;", "getOccupiedParameters", "", "Lcom/intellij/openapi/util/NlsSafe;", "unusedDeclarations", "createExpectedPathVariableParameter", "", "Lcom/intellij/lang/jvm/actions/ExpectedParameter;", "name", "context", "mayResolveToMethodBeanField", "psiMethod", "expectedName", "hasExpectedPathVariableName", "parameter", "Lcom/intellij/psi/PsiVariable;", "getExplicitPathVariableNameExpression", "Lorg/jetbrains/uast/UExpression;", "pathAnnotation", "Lorg/jetbrains/uast/UAnnotation;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPathVariableContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariableContext.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableContext\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n688#2:126\n719#2,4:127\n1#3:131\n13225#4:132\n13225#4:133\n13225#4,2:134\n13226#4:136\n13225#4,2:137\n13226#4:139\n171#5:140\n1807#6,3:141\n*S KotlinDebug\n*F\n+ 1 PathVariableContext.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableContext\n*L\n27#1:126\n27#1:127,4\n98#1:132\n102#1:133\n103#1:134,2\n102#1:136\n106#1:137,2\n98#1:139\n112#1:140\n72#1:141,3\n*E\n"})
public abstract class PathVariableContext {
    @NotNull
    private final String pathVariableAnnotationFQN;

    public PathVariableContext(@NotNull String pathVariableAnnotationFQN) {
        Intrinsics.checkNotNullParameter((Object)pathVariableAnnotationFQN, (String)"pathVariableAnnotationFQN");
        this.pathVariableAnnotationFQN = pathVariableAnnotationFQN;
    }

    @NotNull
    protected final String getPathVariableAnnotationFQN() {
        return this.pathVariableAnnotationFQN;
    }

    public abstract boolean isApplicable(@NotNull Module var1);

    @NotNull
    public abstract UrlPathContext getUrlPathContext(@NotNull UMethod var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<String, PathVariableConsumerInfo> getConsumedPathVariables(@NotNull UMethod uMethod) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Sequence $this$associateBy$iv = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)uMethod.getUastParameters()), (Function1)((Function1)new Function1<UParameter, PathVariableConsumerInfo>((Object)this){

            public final PathVariableConsumerInfo invoke(UParameter p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PathVariableContext)this.receiver).extractPathVariableUsageFromParameter(p0);
            }
        }));
        boolean $i$f$associateBy = false;
        Sequence sequence2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            PathVariableConsumerInfo pathVariableConsumerInfo = (PathVariableConsumerInfo)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        return destination$iv$iv;
    }

    @Nullable
    public Pair<PsiElement, TextRange> getUnconsumedPathVariablePsiElement(@NotNull UMethod method, @NotNull String pathVariableName) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        UElement uElement = method.getUastAnchor();
        if (uElement != null && (uElement = uElement.getSourcePsi()) != null) {
            UElement it = uElement;
            boolean bl = false;
            pair = TuplesKt.to((Object)it, null);
        } else {
            pair = null;
        }
        return pair;
    }

    @Nullable
    public PathVariableConsumerInfo extractPathVariableUsageFromParameter(@NotNull UParameter uParameter) {
        PathVariableConsumerInfo pathVariableConsumerInfo;
        Object v0;
        block6: {
            Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
            Iterable iterable = uParameter.getUAnnotations();
            for (Object t : iterable) {
                UAnnotation it = (UAnnotation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.pathVariableAnnotationFQN)) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        UAnnotation uAnnotation = v0;
        if (uAnnotation == null) {
            return null;
        }
        UAnnotation pathAnnotation = uAnnotation;
        UExpression explicitPathVariableNameExpression = this.getExplicitPathVariableNameExpression(pathAnnotation);
        if (explicitPathVariableNameExpression != null) {
            String string = UastUtils.evaluateString((UExpression)explicitPathVariableNameExpression);
            if (string != null) {
                String it = string;
                boolean bl = false;
                pathVariableConsumerInfo = new PathVariableConsumerInfo(it, explicitPathVariableNameExpression.getSourcePsi(), true);
            } else {
                pathVariableConsumerInfo = null;
            }
        } else {
            String string = uParameter.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            UElement uElement = uParameter.getUastAnchor();
            pathVariableConsumerInfo = new PathVariableConsumerInfo(string, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), true);
        }
        return pathVariableConsumerInfo;
    }

    public final void createPathVariable(@NotNull PsiFile file, @NotNull PsiMethod method, @NotNull String pathVariableName) {
        List<ExpectedParameter> paramsToAdd;
        IntentionAction intentionAction;
        Object object;
        block2: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
            JvmParameter[] jvmParameterArray = method.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
            for (Object object2 : (Object[])jvmParameterArray) {
                JvmParameter it = (JvmParameter)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)pathVariableName)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        JvmParameter existingParam = (JvmParameter)object;
        if (existingParam != null ? (intentionAction = (IntentionAction)CollectionsKt.firstOrNull((List)JvmElementActionFactories.createAddAnnotationActions((JvmModifiersOwner)((JvmModifiersOwner)existingParam), (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)this.pathVariableAnnotationFQN, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0])))) == null : (intentionAction = (IntentionAction)CollectionsKt.firstOrNull((List)JvmElementActionFactories.createChangeParametersActions((JvmMethod)((JvmMethod)method), (ChangeParametersRequest)MethodRequestsKt.updateMethodParametersRequest(() -> PathVariableContext.createPathVariable$lambda$1(method), arg_0 -> PathVariableContext.createPathVariable$lambda$2(paramsToAdd = this.createExpectedPathVariableParameter(pathVariableName, (PsiElement)method), arg_0))))) == null) {
            return;
        }
        IntentionAction fix = intentionAction;
        IntentionPreviewUtils.write(() -> PathVariableContext.createPathVariable$lambda$3(fix, method, file));
    }

    @NotNull
    public final Set<String> getOccupiedParameters(@NotNull UMethod method, @NotNull Set<String> unusedDeclarations) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(unusedDeclarations, (String)"unusedDeclarations");
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)method.getUastParameters()), arg_0 -> PathVariableContext.getOccupiedParameters$lambda$0(unusedDeclarations, this, arg_0)));
    }

    private final List<ExpectedParameter> createExpectedPathVariableParameter(String name, PsiElement context) {
        AnnotationAttributeRequest[] annotationAttributeRequestArray;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        boolean isValidIdentifier = PsiNameHelper.getInstance((Project)project2).isIdentifier(name, PsiUtil.getLanguageLevel((PsiElement)context));
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project2), (GlobalSearchScope)context.getResolveScope());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getJavaLangString(...)");
        JvmType jvmType = (JvmType)psiClassType;
        String string = isValidIdentifier ? name : "parameter";
        if (isValidIdentifier) {
            annotationAttributeRequestArray = new AnnotationAttributeRequest[]{};
        } else {
            AnnotationAttributeRequest[] annotationAttributeRequestArray2 = new AnnotationAttributeRequest[]{AnnotationAttributeValueRequestKt.stringAttribute((String)"value", (String)name)};
            annotationAttributeRequestArray = annotationAttributeRequestArray2;
        }
        AnnotationAttributeRequest[] annotationAttributeRequestArray3 = annotationAttributeRequestArray;
        return CollectionsKt.listOf((Object)ParametersKt.expectedParameter((JvmType)jvmType, (String)string, (Collection)CollectionsKt.listOf((Object)AnnotationRequestsKt.annotationRequest((String)this.pathVariableAnnotationFQN, (AnnotationAttributeRequest[])Arrays.copyOf(annotationAttributeRequestArray3, annotationAttributeRequestArray3.length)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean mayResolveToMethodBeanField(@NotNull PsiMethod psiMethod, @NotNull String expectedName) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        Intrinsics.checkNotNullParameter((Object)expectedName, (String)"expectedName");
        PsiParameter[] psiParameterArray = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] $this$any$iv = psiParameterArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            boolean bl;
            Object element$iv = $this$any$iv[n];
            PsiParameter psiParameter = (PsiParameter)element$iv;
            boolean bl2 = false;
            PsiType psiType = psiParameter.getType();
            PsiClassType psiClassType = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            if (psiClassType == null || (psiClassType = psiClassType.resolve()) == null) {
                bl = false;
            } else {
                PsiClassType psiClass = psiClassType;
                List list = PropertyUtil.getSetters((PsiClass)psiClass, (String)expectedName);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSetters(...)");
                if (!((Collection)list).isEmpty()) {
                    return true;
                }
                boolean bl3 = false;
                if (bl3) return true;
                PsiMethod[] psiMethodArray = psiClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getConstructors(...)");
                Object[] $this$any$iv2 = psiMethodArray;
                boolean $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    PsiMethod ctr = (PsiMethod)element$iv2;
                    boolean bl4 = false;
                    PsiParameter[] psiParameterArray2 = ctr.getParameterList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray2, (String)"getParameters(...)");
                    Object[] $this$any$iv3 = psiParameterArray2;
                    boolean $i$f$any3 = false;
                    for (Object element$iv3 : $this$any$iv3) {
                        PsiParameter parameter = (PsiParameter)element$iv3;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull((Object)parameter);
                        if (!this.hasExpectedPathVariableName((PsiVariable)parameter, expectedName)) continue;
                        return true;
                    }
                    boolean bl6 = false;
                    if (!bl6) continue;
                    return true;
                }
                boolean bl7 = false;
                if (bl7) return true;
                PsiField[] psiFieldArray = psiClass.getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                $this$any$iv2 = psiFieldArray;
                $i$f$any2 = false;
                for (Object element$iv2 : $this$any$iv2) {
                    PsiField it = (PsiField)element$iv2;
                    boolean bl8 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.hasExpectedPathVariableName((PsiVariable)it, expectedName)) continue;
                    return true;
                }
                boolean bl9 = false;
                if (bl9) {
                    return true;
                }
                bl = false;
            }
            if (bl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasExpectedPathVariableName(PsiVariable parameter, String expectedName) {
        block5: {
            if (Intrinsics.areEqual((Object)parameter.getName(), (Object)expectedName)) ** GOTO lbl-1000
            v0 = parameter.getAnnotations();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getAnnotations(...)");
            for (Object var8_7 : (PsiElement)v0) {
                it = (PsiAnnotation)var8_7;
                $i$a$-find-PathVariableContext$hasExpectedPathVariableName$1 = false;
                if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.pathVariableAnnotationFQN)) continue;
                v1 = var8_7;
                break block5;
            }
            v1 = null;
        }
        var3_11 = (PsiAnnotation)v1;
        if (var3_11 == null) ** GOTO lbl-1000
        var5_3 = (PsiElement)var3_11;
        $i$f$toUElementOfType = false;
        var4_12 = (UAnnotation)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UAnnotation.class);
        if (var4_12 == null) ** GOTO lbl-1000
        p0 = var4_12;
        $i$a$-let-PathVariableContext$hasExpectedPathVariableName$2 = false;
        var5_3 = this.getExplicitPathVariableNameExpression(p0);
        if (var5_3 != null) {
            v2 = UastUtils.evaluateString((UExpression)var5_3);
        } else lbl-1000:
        // 3 sources

        {
            v2 = null;
        }
        if (Intrinsics.areEqual(v2, (Object)expectedName)) lbl-1000:
        // 2 sources

        {
            v3 = true;
        } else {
            v3 = false;
        }
        return v3;
    }

    private final UExpression getExplicitPathVariableNameExpression(UAnnotation pathAnnotation) {
        Object[] objectArray = new String[]{"value", "name"};
        return (UExpression)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray), arg_0 -> PathVariableContext.getExplicitPathVariableNameExpression$lambda$0(pathAnnotation, arg_0)));
    }

    private static final JvmMethod createPathVariable$lambda$1(PsiMethod $method) {
        return (JvmMethod)$method;
    }

    private static final List createPathVariable$lambda$2(List $paramsToAdd, List existing) {
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        return ContainerUtil.concat((List)existing, (List)$paramsToAdd);
    }

    private static final void createPathVariable$lambda$3(IntentionAction $fix, PsiMethod $method, PsiFile $file) {
        $fix.invoke($method.getProject(), null, $file);
    }

    private static final String getOccupiedParameters$lambda$0(Set $unusedDeclarations, PathVariableContext this$0, UParameter uParam) {
        boolean bl;
        PsiParameter psiParameter;
        Object object;
        block5: {
            Intrinsics.checkNotNullParameter((Object)uParam, (String)"uParam");
            object = uParam.getJavaPsi();
            PsiParameter psiParameter2 = object instanceof PsiParameter ? (PsiParameter)object : null;
            if (psiParameter2 == null) {
                return null;
            }
            psiParameter = psiParameter2;
            if (!$unusedDeclarations.contains(psiParameter.getName())) {
                return null;
            }
            Iterable $this$any$iv = uParam.getUAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UAnnotation uAnno = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)uAnno.getQualifiedName(), (Object)this$0.pathVariableAnnotationFQN)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean hasPathVariableAnno = bl;
        Object it = object = psiParameter.getName();
        boolean bl3 = false;
        return hasPathVariableAnno ? object : null;
    }

    private static final UExpression getExplicitPathVariableNameExpression$lambda$0(UAnnotation $pathAnnotation, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $pathAnnotation.findDeclaredAttributeValue(it);
    }
}

