/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.pathvars;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.jvm.pathvars.PathVariableContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/microservices/jvm/pathvars/PathVariableQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pathVariableName", "", "pathVariableContext", "Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;", "<init>", "(Ljava/lang/String;Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPathVariableMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableQuickFix\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,137:1\n18#2:138\n*S KotlinDebug\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableQuickFix\n*L\n108#1:138\n*E\n"})
final class PathVariableQuickFix
implements LocalQuickFix {
    @NotNull
    private final String pathVariableName;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final PathVariableContext pathVariableContext;

    public PathVariableQuickFix(@NotNull String pathVariableName, @NotNull PathVariableContext pathVariableContext) {
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        Intrinsics.checkNotNullParameter((Object)pathVariableContext, (String)"pathVariableContext");
        this.pathVariableName = pathVariableName;
        this.pathVariableContext = pathVariableContext;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.pathVariableName};
        return MicroservicesBundle.message((String)"PathVariableInspection.quick.fix.create.param.name", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return MicroservicesBundle.message((String)"PathVariableInspection.quick.fix.create.param", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        UElement uElement;
        PsiElement element;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                element = psiElement;
                uElement = UastContextKt.getFirstUElement$default((PsiElement)element, (boolean)false, (int)2, null);
                if (uElement == null) break block4;
                UElement $this$getParentOfType_u24default$iv = uElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                uElement = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
                if (uElement != null && (uElement = uElement.getJavaPsi()) != null) break block5;
            }
            return;
        }
        UElement method = uElement;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        this.pathVariableContext.createPathVariable(psiFile, (PsiMethod)method, this.pathVariableName);
    }
}

