/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0000\u001a\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0011H\u0000\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0000\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\"\u0018\u0010\u000b\u001a\u00020\u0001*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0018\u0010\u0018\u001a\u00020\u0001*\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006\u001a"}, d2={"isCanonical", "", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "isAbstractOrSealed", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "getFunctionalInterfaceSlot", "", "iFace", "fitsLatin1", "", "getFitsLatin1", "(Ljava/lang/String;)Z", "buildUnreachableForVerifier", "", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "buildUnreachableAfterNothingType", "redefinitionError", "", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "info", "hasUnpairedSurrogates", "getHasUnpairedSurrogates", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/wasm/utils/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,65:1\n1786#2,3:66\n1807#2,3:71\n1088#3,2:69\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlin/backend/wasm/utils/UtilsKt\n*L\n30#1:66,3\n62#1:71,3\n42#1:69,2\n*E\n"})
public final class UtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCanonical(@NotNull IrTry $this$isCanonical, @NotNull WasmBackendContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isCanonical, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$isCanonical.getCatches().size() > 1) return false;
        Iterable $this$all$iv = $this$isCanonical.getCatches();
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                IrCatch it = (IrCatch)element$iv;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)it.getCatchParameter().getType(), (Object)context.getIrBuiltIns().getThrowableType())) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if ($this$isCanonical.getFinallyExpression() != null) return false;
        return true;
    }

    public static final boolean isAbstractOrSealed(@NotNull IrClass $this$isAbstractOrSealed) {
        Intrinsics.checkNotNullParameter((Object)$this$isAbstractOrSealed, (String)"<this>");
        return $this$isAbstractOrSealed.getModality() == Modality.ABSTRACT || $this$isAbstractOrSealed.getModality() == Modality.SEALED;
    }

    public static final int getFunctionalInterfaceSlot(@NotNull IrClass iFace) {
        Intrinsics.checkNotNullParameter((Object)iFace, (String)"iFace");
        if (!IrTypeUtilsKt.isFunction((IrClassifierSymbol)((IrClassifierSymbol)iFace.getSymbol()))) {
            throw new IllegalStateException("Check failed.");
        }
        if (IrTypeUtilsKt.isFunctionMarker((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)iFace)))) {
            return 0;
        }
        return iFace.getTypeParameters().size();
    }

    public static final boolean getFitsLatin1(@NotNull String $this$fitsLatin1) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$fitsLatin1, (String)"<this>");
            CharSequence $this$all$iv = $this$fitsLatin1;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                char c = it;
                if ('\u0000' <= c ? c < '\u0100' : false) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final void buildUnreachableForVerifier(@NotNull WasmExpressionBuilder $this$buildUnreachableForVerifier) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableForVerifier, (String)"<this>");
        $this$buildUnreachableForVerifier.buildUnreachable(SourceLocation.Companion.NoLocation("This instruction should never be reached, but required for wasm verifier"));
    }

    public static final void buildUnreachableAfterNothingType(@NotNull WasmExpressionBuilder $this$buildUnreachableAfterNothingType) {
        Intrinsics.checkNotNullParameter((Object)$this$buildUnreachableAfterNothingType, (String)"<this>");
        $this$buildUnreachableAfterNothingType.buildUnreachable(SourceLocation.Companion.NoLocation("The unreachable instruction after an expression with Nothing type to make sure that execution doesn't come here (or it fails fast if so). It also might be required for wasm verifier."));
    }

    @NotNull
    public static final Void redefinitionError(@NotNull IdSignature signature, @NotNull String info) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        throw new IllegalStateException(("Symbol " + signature + " cannot be redefined for " + info).toString());
    }

    public static final boolean getHasUnpairedSurrogates(@NotNull String $this$hasUnpairedSurrogates) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasUnpairedSurrogates, (String)"<this>");
            Iterable $this$any$iv = StringsKt.withIndex((CharSequence)$this$hasUnpairedSurrogates);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IndexedValue indexedValue = (IndexedValue)element$iv;
                    boolean bl2 = false;
                    int i = indexedValue.component1();
                    char c = ((Character)indexedValue.component2()).charValue();
                    if (!(Character.isLowSurrogate(c) && (i == 0 || !Character.isHighSurrogate($this$hasUnpairedSurrogates.charAt(i - 1))) || Character.isHighSurrogate(c) && (i == StringsKt.getLastIndex((CharSequence)$this$hasUnpairedSurrogates) || !Character.isLowSurrogate($this$hasUnpairedSurrogates.charAt(i + 1))))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

