/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.extension;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Predicates;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHandler;
import de.plushnikov.intellij.plugin.processor.handler.BuilderHelper;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LombokBuilderCompletionContributor
extends CompletionContributor {
    public LombokBuilderCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}), (CompletionProvider)new CompletionProvider<CompletionParameters>(this){

            private static void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                PsiElement psiElement;
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((psiElement = item.getPsiElement()) instanceof PsiModifierListOwner) {
                    PsiModifierListOwner psiModifierListOwner = (PsiModifierListOwner)psiElement;
                    PsiAnnotation psiAnnotation = BuilderHelper.getBuilderAnnotation(psiModifierListOwner);
                    if (null == psiAnnotation) {
                        return;
                    }
                    List<String> remainingBuilderMethods = BuilderHelper.getAllBuilderMethodNames(psiModifierListOwner, psiAnnotation, Predicates.alwaysTrue());
                    int contextStartOffset = context.getStartOffset();
                    PsiElement elementAtCaret = context.getFile().findElementAt(contextStartOffset);
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)elementAtCaret, PsiMethodCallExpression.class);
                    List<String> existingMethodCalls = BuilderHelper.getAllMethodsInChainFromMiddle(methodCallExpression);
                    remainingBuilderMethods.removeAll(existingMethodCalls);
                    if (remainingBuilderMethods.isEmpty()) {
                        String buildMethodName = BuilderHandler.getBuildMethodName(psiAnnotation);
                        context.getDocument().replaceString(contextStartOffset, context.getTailOffset(), (CharSequence)(buildMethodName + "()"));
                        return;
                    }
                    TemplateManager templateManager = TemplateManager.getInstance((Project)context.getProject());
                    Template template = templateManager.createTemplate("", "");
                    template.setToReformat(false);
                    int varIndex = 0;
                    for (String methodName : remainingBuilderMethods) {
                        template.addTextSegment(methodName + "(");
                        template.addVariable("param" + varIndex, "", "", true);
                        template.addVariableSegment("param" + varIndex);
                        ++varIndex;
                        template.addTextSegment(").");
                    }
                    template.addTextSegment(BuilderHandler.getBuildMethodName(psiAnnotation) + "()");
                    context.getDocument().replaceString(contextStartOffset, context.getTailOffset(), (CharSequence)"");
                    templateManager.startTemplate(context.getEditor(), template);
                }
            }

            public void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet resultSet) {
                Pair<PsiAnnotation, PsiNamedElement> elementPair;
                PsiMethod psiMethod;
                PsiMethodCallExpression methodCallExpression;
                if (parameters == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (resultSet == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (null != (methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getPrevSiblingOfType((PsiElement)parameters.getPosition(), PsiMethodCallExpression.class)) && (psiMethod = methodCallExpression.resolveMethod()) instanceof LombokLightMethodBuilder && null != (elementPair = BuilderHelper.findBuilderAnnotation(psiMethod))) {
                    List<String> allBuilderMethods = BuilderHelper.getAllBuilderMethodNames((PsiModifierListOwner)elementPair.getSecond(), (PsiAnnotation)elementPair.getFirst(), Predicates.alwaysTrue());
                    String chainedMethods = BuilderHelper.renderChainedMethods(allBuilderMethods, (PsiAnnotation)elementPair.getFirst());
                    LookupElementBuilder lookupElementBuilder = LookupElementBuilder.createWithIcon((PsiNamedElement)((PsiNamedElement)elementPair.getSecond())).withPresentableText(LombokBundle.message("complete.all.builder.methods.lombok.completion", new Object[0])).withBoldness(true).withTypeText(StringUtil.trimMiddle((String)chainedMethods, (int)50)).withInsertHandler((context1, item) -> 1.handleInsert(context1, item));
                    resultSet.addElement(lookupElementBuilder.withAutoCompletionPolicy(AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resultSet";
                        break;
                    }
                }
                objectArray2[1] = "de/plushnikov/intellij/plugin/extension/LombokBuilderCompletionContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleInsert";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCompletions";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

