/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.frontend;

import com.intellij.ide.ui.NavBarLocation;
import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.customization.CustomisedActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.platform.navbar.frontend.NavBarContainer;
import com.intellij.platform.navbar.frontend.NavBarServiceKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.hover.HoverListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001a\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002\u00a8\u0006\u001b"}, d2={"createNavBarPanel", "Lcom/intellij/platform/navbar/frontend/NavBarContainer;", "scrollPane", "Ljavax/swing/JScrollPane;", "navigationBar", "Ljavax/swing/JComponent;", "updateScrollBarFlippedState", "", "location", "Lcom/intellij/ide/ui/NavBarLocation;", "toggleScrollBar", "isOn", "", "isShowToolPanel", "uiSettings", "Lcom/intellij/ide/ui/UISettings;", "alignVertically", "container", "Ljava/awt/Container;", "isNeedGap", "group", "Lcom/intellij/openapi/actionSystem/AnAction;", "getFirstAction", "setStatusBarCentralWidget", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "component", "intellij.platform.navbar.frontend"})
public final class NavBarRootPaneExtensionKt {
    private static final NavBarContainer createNavBarPanel(JScrollPane scrollPane, JComponent navigationBar) {
        NavBarContainer navBarPanel = new NavBarContainer(new BorderLayout(), scrollPane, navigationBar);
        navBarPanel.add((Component)scrollPane, "Center");
        navBarPanel.setOpaque(!ExperimentalUI.Companion.isNewUI());
        navigationBar.setOpaque(!ExperimentalUI.Companion.isNewUI());
        navBarPanel.updateUI();
        if (ExperimentalUI.Companion.isNewNavbar()) {
            HoverListener hoverListener2 = new HoverListener(scrollPane){
                final /* synthetic */ JScrollPane $scrollPane;
                {
                    this.$scrollPane = $scrollPane;
                }

                public void mouseEntered(Component component2, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    NavBarRootPaneExtensionKt.access$toggleScrollBar(true, this.$scrollPane);
                }

                public void mouseMoved(Component component2, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                }

                public void mouseExited(Component component2) {
                    Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
                    NavBarRootPaneExtensionKt.access$toggleScrollBar(false, this.$scrollPane);
                }
            };
            hoverListener2.addTo((JComponent)navBarPanel);
        }
        return navBarPanel;
    }

    private static final void updateScrollBarFlippedState(NavBarLocation location, JScrollPane scrollPane) {
        if (ExperimentalUI.Companion.isNewNavbar()) {
            NavBarLocation effectiveLocation;
            NavBarLocation navBarLocation = location;
            if (navBarLocation == null) {
                navBarLocation = UISettings.Companion.getInstance().getNavBarLocation();
            }
            JBScrollPane.Flip flipState = (effectiveLocation = navBarLocation) == NavBarLocation.BOTTOM ? JBScrollPane.Flip.VERTICAL : JBScrollPane.Flip.NONE;
            scrollPane.putClientProperty(JBScrollPane.Flip.class, flipState);
        }
    }

    private static final void toggleScrollBar(boolean isOn, JScrollPane scrollPane) {
        JScrollBar scrollBar = scrollPane.getHorizontalScrollBar();
        if (scrollBar instanceof JBScrollBar) {
            ((JBScrollBar)scrollBar).toggle(isOn);
        }
    }

    private static final boolean isShowToolPanel(UISettings uiSettings) {
        if (!ExperimentalUI.Companion.isNewUI() && !uiSettings.getShowMainToolbar() && NavBarServiceKt.isNavbarShown(uiSettings)) {
            ToolbarSettings toolbarSettings = ToolbarSettings.Companion.getInstance();
            return !toolbarSettings.isVisible() || !toolbarSettings.isAvailable();
        }
        return false;
    }

    private static final void alignVertically(Container container) {
        if (container.getComponentCount() == 1) {
            Component c = container.getComponent(0);
            Insets insets = container.getInsets();
            Dimension d = c.getPreferredSize();
            Rectangle r = container.getBounds();
            c.setBounds(insets.left, (r.height - d.height - insets.top - insets.bottom) / 2 + insets.top, r.width - insets.left - insets.right, d.height);
        }
    }

    private static final boolean isNeedGap(AnAction group) {
        return NavBarRootPaneExtensionKt.getFirstAction(group) instanceof ComboBoxAction;
    }

    private static final AnAction getFirstAction(AnAction group) {
        AnAction anAction = group;
        AnAction[] actionsOrStubs = anAction instanceof DefaultActionGroup ? ((DefaultActionGroup)group).getChildActionsOrStubs() : (anAction instanceof CustomisedActionGroup ? ((CustomisedActionGroup)group).getDefaultChildrenOrStubs() : AnAction.EMPTY_ARRAY);
        AnAction firstAction = null;
        Intrinsics.checkNotNull((Object)actionsOrStubs);
        for (AnAction action : actionsOrStubs) {
            if (!(action instanceof DefaultActionGroup)) {
                if (action instanceof Separator || action instanceof ActionGroup) continue;
                firstAction = action;
                break;
            }
            firstAction = NavBarRootPaneExtensionKt.getFirstAction(action);
            if (firstAction != null) break;
        }
        return firstAction;
    }

    private static final void setStatusBarCentralWidget(StatusBar statusBar, JComponent component2) {
        block0: {
            IdeStatusBarImpl ideStatusBarImpl = statusBar instanceof IdeStatusBarImpl ? (IdeStatusBarImpl)statusBar : null;
            if (ideStatusBarImpl == null) break block0;
            ideStatusBarImpl.setCentralWidget("NavBar", component2);
        }
    }

    public static final /* synthetic */ void access$updateScrollBarFlippedState(NavBarLocation location, JScrollPane scrollPane) {
        NavBarRootPaneExtensionKt.updateScrollBarFlippedState(location, scrollPane);
    }

    public static final /* synthetic */ NavBarContainer access$createNavBarPanel(JScrollPane scrollPane, JComponent navigationBar) {
        return NavBarRootPaneExtensionKt.createNavBarPanel(scrollPane, navigationBar);
    }

    public static final /* synthetic */ boolean access$isShowToolPanel(UISettings uiSettings) {
        return NavBarRootPaneExtensionKt.isShowToolPanel(uiSettings);
    }

    public static final /* synthetic */ void access$alignVertically(Container container) {
        NavBarRootPaneExtensionKt.alignVertically(container);
    }

    public static final /* synthetic */ boolean access$isNeedGap(AnAction group) {
        return NavBarRootPaneExtensionKt.isNeedGap(group);
    }

    public static final /* synthetic */ void access$toggleScrollBar(boolean isOn, JScrollPane scrollPane) {
        NavBarRootPaneExtensionKt.toggleScrollBar(isOn, scrollPane);
    }

    public static final /* synthetic */ void access$setStatusBarCentralWidget(StatusBar statusBar, JComponent component2) {
        NavBarRootPaneExtensionKt.setStatusBarCentralWidget(statusBar, component2);
    }
}

